/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CMMBladeSystemPanel;
import IPMIView20.CMMDebug;
import IPMIView20.CMMKVMPanel;
import IPMIView20.CMMLoginPanel;
import IPMIView20.CMMSOLPanel;
import IPMIView20.CMMSessionPanel_jTabbedPane_changeAdapter;
import IPMIView20.DeviceFile;
import IPMIView20.Logger;
import IPMIView20.VirtualMedia;
import IPMIView20.blade.CMMConfigPanel;
import IPMIView20.blade.SELPanel;
import IPMIView20.blade.UserManagementPanel;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.DisconnectListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;

public class CMMSessionPanel
extends JPanel
implements Observer,
DisconnectListener {
    public boolean isDisconnect = false;
    String hostname;
    String ip;
    String description;
    String loginID;
    String loginPassword;
    JLabel xMessage;
    DeviceFile xDeviceFile;
    Icon alertIcon = new ImageIcon(this.getClass().getResource("/images/Trap-ani.gif"));
    Icon infoIcon = new ImageIcon(this.getClass().getResource("/images/excla_dim.gif"));
    Icon disconnectedIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_close_session.gif"));
    public BladeSystemEntity bladeSystemEntity = null;
    public IPMIInterfaceConfig ipmiInterfaceConfig = null;
    public CMMLoginPanel cmmLoginPanel = new CMMLoginPanel();
    public CMMBladeSystemPanel cmmBladeSystemPanel = null;
    public CMMSOLPanel cmmSOLPanel = null;
    public CMMKVMPanel cmmKVMPanel = null;
    public SELPanel selPanel = null;
    public UserManagementPanel userManagementPanel = null;
    public CMMConfigPanel cmmConfigPanel = null;
    public VirtualMedia virtualMediaPanel = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jSouthPanel = new JPanel();
    JPanel jCenterPanel = new JPanel();
    JPanel jWestPanel = new JPanel();
    JPanel jNorthPanel = new JPanel();
    JTabbedPane jTabbedPane = new JTabbedPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jEastPanel = new JPanel();
    JPanel jDisconnectPanel = new JPanel();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jRedundantPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jLabel2 = new JLabel();
    boolean virtualMediaPanelFirstPreset = false;
    JPanel jUnavailableConnectPanel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    boolean reInitalTabing = false;
    boolean tempIsMaster = false;
    boolean lastLogoutState = true;
    int count = 0;
    int disconnectCount = 0;
    boolean enterDisconnectPhase = false;

    public CMMSessionPanel(String hostname, String ip, String description, JLabel xMessage, DeviceFile xDeviceFile) {
        this.hostname = hostname;
        this.ip = ip;
        this.description = description;
        this.xMessage = xMessage;
        this.xDeviceFile = xDeviceFile;
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDisconnectPanelVisible(boolean isVisible) {
        if (isVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CMMSessionPanel.this.remove(CMMSessionPanel.this.jCenterPanel);
                    CMMSessionPanel.this.add((Component)CMMSessionPanel.this.jUnavailableConnectPanel, "Center");
                    CMMSessionPanel.this.jDisconnectPanel.setVisible(true);
                    CMMSessionPanel.this.cmmBladeSystemPanel.hideAllOutOfWindows();
                    CMMSessionPanel.this.invalidate();
                    CMMSessionPanel.this.validate();
                    CMMSessionPanel.this.jUnavailableConnectPanel.repaint();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CMMSessionPanel.this.remove(CMMSessionPanel.this.jUnavailableConnectPanel);
                    CMMSessionPanel.this.add((Component)CMMSessionPanel.this.jCenterPanel, "Center");
                    CMMSessionPanel.this.jDisconnectPanel.setVisible(false);
                    CMMSessionPanel.this.cmmBladeSystemPanel.showAllOutOfWindows();
                    CMMSessionPanel.this.invalidate();
                    CMMSessionPanel.this.validate();
                    CMMSessionPanel.this.jCenterPanel.repaint();
                }
            });
        }
    }

    public void setReduntantPanelVisible(boolean isVisible) {
        this.jRedundantPanel.setVisible(isVisible);
    }

    public void setReduntantPanelString(String message) {
        this.jLabel2.setText(message);
    }

    public void myInit() {
        this.jDisconnectPanel.setVisible(false);
        this.setReduntantPanelVisible(false);
        this.jTabbedPane.add((Component)this.cmmLoginPanel, "Authentication");
        this.cmmLoginPanel.cmmLoginUI.jSystemNameLabel.setText(this.hostname);
        this.cmmLoginPanel.cmmLoginUI.jIPAddressLabel.setText(this.ip);
        this.cmmLoginPanel.cmmLoginUI.jDescriptionLabel.setText(this.description);
        this.cmmLoginPanel.preset(this, this.xMessage);
    }

    public void reInitialTab() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CMMSessionPanel.this.helpCloseTab();
            }
        });
    }

    private void helpCloseTab() {
        this.reInitalTabing = true;
        int tabCount = this.jTabbedPane.getTabCount();
        this.jTabbedPane.setFocusable(false);
        for (int i = 1; i < tabCount; ++i) {
            this.jTabbedPane.removeTabAt(1);
        }
        this.reInitalTabing = false;
    }

    public void createAllPanel() {
        this.cmmBladeSystemPanel = new CMMBladeSystemPanel();
        this.cmmSOLPanel = new CMMSOLPanel();
        this.cmmKVMPanel = new CMMKVMPanel();
        this.selPanel = new SELPanel();
        this.userManagementPanel = new UserManagementPanel();
        this.cmmConfigPanel = new CMMConfigPanel();
        this.virtualMediaPanel = null;
        this.virtualMediaPanelFirstPreset = false;
    }

    public void showAllTab(boolean isMaster) {
        this.tempIsMaster = isMaster;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    CMMSessionPanel.this.helpShowAllTab();
                }
            });
        }
        catch (InvocationTargetException ex) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void helpShowAllTab() {
        this.cmmBladeSystemPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmBladeSystemPanel ok");
        }
        this.cmmSOLPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmSOLPanel ok");
        }
        this.cmmKVMPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmKVMPanel ok");
        }
        this.userManagementPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset userManagementPanel ok");
        }
        this.selPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset selPanel ok");
        }
        this.virtualMediaPanel = new VirtualMedia(this.ipmiInterfaceConfig.getIp(), this.ipmiInterfaceConfig.getUserName(), this.ipmiInterfaceConfig.getPassword(), 4);
        this.virtualMediaPanel.preset(null, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] new virtualMediaPanel ok");
        }
        this.cmmConfigPanel.preset(this, this.xMessage);
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] preset cmmConfigPanel ok");
        }
        this.jTabbedPane.setFocusable(false);
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmBladeSystemPanel, "Blade System");
        }
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmSOLPanel, "Text Console");
        }
        if (this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.cmmKVMPanel, "KVM Console");
        }
        this.jTabbedPane.add((Component)this.selPanel, "Event Log");
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, "Logon Management");
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4 && this.tempIsMaster) {
            this.jTabbedPane.add((Component)this.virtualMediaPanel, "Virtual Media");
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, "CMM Setting");
        }
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] add all tabs ok");
        }
        this.cmmBladeSystemPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmSOLPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmKVMPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.selPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.userManagementPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        this.cmmConfigPanel.setIPMIPrivilege(this.ipmiInterfaceConfig.getPrivilege());
        if (CMMDebug.showAllTabDebug) {
            Logger.printLog("[CMMSessionPanel] set privilege ok");
        }
        this.jTabbedPane.setSelectedIndex(1);
    }

    public void changeToSlaveUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CMMSessionPanel.this.helpCloseTab();
                CMMSessionPanel.this.helpChangeToSlaveTab();
            }
        });
    }

    private void helpChangeToSlaveTab() {
        this.jTabbedPane.add((Component)this.selPanel, "Event Log");
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, "Logon Management");
        }
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, "CMM Setting");
        }
        this.jTabbedPane.setSelectedIndex(1);
        this.setReduntantPanelVisible(true);
    }

    public void changeToMasterUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CMMSessionPanel.this.helpCloseTab();
                CMMSessionPanel.this.helpChangeToMasterTab();
            }
        });
    }

    private void helpChangeToMasterTab() {
        this.jTabbedPane.add((Component)this.cmmBladeSystemPanel, "Blade System");
        this.jTabbedPane.add((Component)this.cmmSOLPanel, "Text Console");
        this.jTabbedPane.add((Component)this.cmmKVMPanel, "KVM Console");
        this.jTabbedPane.add((Component)this.selPanel, "Event Log");
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.userManagementPanel, "Logon Management");
        }
        this.jTabbedPane.add((Component)this.virtualMediaPanel, "Virtual Media");
        if (this.ipmiInterfaceConfig.getPrivilege() == 4) {
            this.jTabbedPane.add((Component)this.cmmConfigPanel, "CMM Setting");
        }
        this.jTabbedPane.setSelectedIndex(1);
        this.setReduntantPanelVisible(false);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.jTabbedPane.addChangeListener(new CMMSessionPanel_jTabbedPane_changeAdapter(this));
        this.jLabel1.setForeground(Color.white);
        this.jLabel1.setToolTipText("");
        this.jLabel1.setIcon(this.alertIcon);
        this.jLabel1.setText("This device is unavailable currently. The network connection cannot be established.");
        this.jDisconnectPanel.setLayout(this.borderLayout3);
        this.jDisconnectPanel.setBackground(Color.red);
        this.jDisconnectPanel.setBorder(BorderFactory.createEtchedBorder());
        this.jRedundantPanel.setLayout(this.borderLayout4);
        this.jLabel2.setIcon(this.infoIcon);
        this.jLabel2.setText("This is a redundant CMM module. The management functions of redundant CMM module are limited.");
        this.jRedundantPanel.setBackground(Color.yellow);
        this.jUnavailableConnectPanel.setLayout(this.borderLayout5);
        this.jLabel3.setForeground(Color.gray);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setIcon(this.disconnectedIcon);
        this.jLabel3.setText("Unable to connect");
        this.add((Component)this.jCenterPanel, "Center");
        this.jDisconnectPanel.add((Component)this.jLabel1, "Center");
        this.add((Component)this.jRedundantPanel, "South");
        this.jRedundantPanel.add((Component)this.jLabel2, "Center");
        this.jCenterPanel.add((Component)this.jTabbedPane, "Center");
        this.add((Component)this.jDisconnectPanel, "North");
        this.jUnavailableConnectPanel.add((Component)this.jLabel3, "Center");
        this.jTabbedPane.setTabPlacement(3);
    }

    public void closeCMM() {
        this.jTabbedPane.setSelectedIndex(0);
        if (this.jTabbedPane.getTabCount() > 1) {
            this.cmmLoginPanel.cmmLoginUI.closeLoginUI();
        } else {
            this.cmmBladeSystemPanel = null;
            this.cmmSOLPanel = null;
            this.cmmKVMPanel = null;
            this.selPanel = null;
            this.userManagementPanel = null;
            this.cmmConfigPanel = null;
            this.virtualMediaPanel = null;
        }
        this.jTabbedPane.remove(0);
        this.cmmLoginPanel.closePanel();
        this.cmmLoginPanel = null;
    }

    public void returnTOLogin() {
        this.jTabbedPane.setSelectedIndex(0);
        if (this.jTabbedPane.getTabCount() > 1) {
            this.cmmLoginPanel.cmmLoginUI.closeLoginUI();
        }
    }

    public void setDefaultButton() {
        this.cmmLoginPanel.cmmLoginUI.setDefaultButton();
        this.cmmLoginPanel.cmmLoginUI.enableFocusOnLoginID();
    }

    public void jTabbedPane_stateChanged(ChangeEvent e) {
        if (this.reInitalTabing) {
            return;
        }
        int selectedIndex = this.jTabbedPane.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        String selectedTab = this.jTabbedPane.getTitleAt(selectedIndex);
        if (selectedTab.equals("Authentication")) {
            this.cmmLoginPanel.present();
        } else if (selectedTab.equals("Blade System")) {
            this.cmmBladeSystemPanel.present();
        } else if (selectedTab.equals("Text Console")) {
            this.cmmSOLPanel.present();
        } else if (selectedTab.equals("KVM Console")) {
            Thread thread = new Thread(){

                public void run() {
                    CMMSessionPanel.this.cmmKVMPanel.present();
                }
            };
            thread.start();
        } else if (selectedTab.equals("Event Log")) {
            this.selPanel.present();
        } else if (selectedTab.equals("Logon Management")) {
            this.userManagementPanel.present();
        } else if (selectedTab.equals("Virtual Media")) {
            this.virtualMediaPanel.present();
        }
    }

    public void getBladeSystemEntityData() {
        if (this.bladeSystemEntity == null) {
            this.bladeSystemEntity = new BladeSystemEntity(this.ipmiInterfaceConfig, 10, 2, 2, 2, 4);
            this.bladeSystemEntity.addDisconnectListener(this);
        }
        this.bladeSystemEntity.getData();
    }

    public void startPoolingData() {
        if (this.bladeSystemEntity == null) {
            this.bladeSystemEntity = new BladeSystemEntity(this.ipmiInterfaceConfig, 10, 2, 2, 2, 4);
            this.bladeSystemEntity.addDisconnectListener(this);
        }
        this.bladeSystemEntity.poolingData();
    }

    public void addCMMSessionPanelToObservable() {
        this.bladeSystemEntity.addObserver(this);
    }

    public void update(Observable o, Object obj) {
        this.isDisconnect = false;
        if (this.bladeSystemEntity.isLogoutSuccessful != this.lastLogoutState) {
            this.setDisconnectPanelVisible(false);
        }
        this.disconnectCount = 0;
        this.enterDisconnectPhase = false;
        this.lastLogoutState = true;
    }

    public void disconnect(Object o) {
        this.isDisconnect = true;
        BladeSystemEntity bladeSystemEntity = (BladeSystemEntity)o;
        if (bladeSystemEntity.isLogoutSuccessful != this.lastLogoutState) {
            this.setDisconnectPanelVisible(true);
        }
        ++this.disconnectCount;
        if (this.disconnectCount > 3) {
            if (this.enterDisconnectPhase) {
                return;
            }
            bladeSystemEntity.stopPooling();
            this.setDisconnectPanelVisible(false);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CMMSessionPanel.this.returnTOLogin();
                }
            });
            this.enterDisconnectPhase = true;
        }
        this.lastLogoutState = false;
    }
}

