/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.CipherSuite;
import IPMIView20.CipherSuitePanel_jButton1_actionAdapter;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.RMCP;
import IPMIView20.RMCPPlus;
import IPMIView20.UDPSocket;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class CipherSuitePanel
extends JPanel {
    JButton jButton1 = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable1 = new JTable();
    String IP = "";
    JLabel jLabel1 = new JLabel();

    public CipherSuitePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIP(String IP) {
        this.IP = IP;
        this.jLabel1.setText("Cipher Suite IDs provided from " + IP + ":");
    }

    void jbInit() throws Exception {
        this.jButton1.setBounds(new Rectangle(355, 8, 74, 25));
        this.jButton1.setText("Get");
        this.jButton1.addActionListener(new CipherSuitePanel_jButton1_actionAdapter(this));
        this.setLayout(null);
        this.jScrollPane1.setBounds(new Rectangle(10, 43, 418, 163));
        this.jTable1.setShowHorizontalLines(true);
        this.jTable1.setShowVerticalLines(true);
        this.setPreferredSize(new Dimension(437, 215));
        this.jLabel1.setText("jLabel1");
        this.jLabel1.setBounds(new Rectangle(10, 14, 261, 17));
        this.add((Component)this.jScrollPane1, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.jButton1, null);
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        this.jButton1.setVisible(false);
    }

    public void myInit() {
    }

    void jButton1_actionPerformed(ActionEvent e) {
        this.get();
    }

    public int getSelectID() {
        int row = this.jTable1.getSelectedRow();
        if (row == -1) {
            return -1;
        }
        String ID = (String)this.jTable1.getValueAt(row, 0);
        return Integer.parseInt(ID);
    }

    public boolean get() {
        int i;
        Object[] ColumnHead = new String[]{"ID", "Authentication", "Integrity", "Confidentiality"};
        Object[][] data = null;
        byte[] cipherSuitesRecord = new byte[256];
        for (byte i2 = 0; i2 < 16; i2 = (byte)(i2 + 1)) {
            byte[] result = new byte[16];
            if (!this.getCipherSuite(i2, result)) {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Can't get Cihper Suite IDs from " + this.IP);
                return false;
            }
            System.arraycopy(result, 0, cipherSuitesRecord, i2 * 16, 16);
        }
        Vector<Byte> supportedCipherSuite = new Vector<Byte>();
        for (i = 0; i < cipherSuitesRecord.length; ++i) {
            if (cipherSuitesRecord[i] != -64) continue;
            supportedCipherSuite.add(new Byte(cipherSuitesRecord[i + 1]));
            ++i;
        }
        data = new String[supportedCipherSuite.size()][4];
        for (i = 0; i < supportedCipherSuite.size(); ++i) {
            byte id = (Byte)supportedCipherSuite.get(i);
            data[i][0] = "" + id;
            data[i][1] = CipherSuite.AUTHENTICATION_ALGORITHMS[CipherSuite.CIPHER_SUITES[id][0]];
            data[i][2] = CipherSuite.INTEGIRTY_ALGORITHMS[CipherSuite.CIPHER_SUITES[id][1]];
            data[i][3] = CipherSuite.CONFIDENTICALITY_ALGORITHMS[CipherSuite.CIPHER_SUITES[id][2]];
        }
        DefaultTableModel dtm = new DefaultTableModel(data, ColumnHead);
        this.jTable1 = new JTable(dtm);
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.getViewport().add((Component)this.jTable1, null);
        return true;
    }

    public boolean getCipherSuite(byte index, byte[] result) {
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        RMCPPlus rmcpPacket = new RMCPPlus();
        CSession Session2 = new CSession();
        Session2.lockout();
        byte[] reqdata = new byte[]{1, 0, 0};
        reqdata[2] = (byte)(0xFFFFFF80 | index);
        UDPSocket udpSocket = new UDPSocket(2, 2);
        GlobalDefine gd = new GlobalDefine();
        Session2.SessionID[0] = 0;
        Session2.SessionID[1] = 0;
        Session2.SessionID[2] = 0;
        Session2.SessionID[3] = 0;
        Session2.SessionSeq[0] = 0;
        Session2.SessionSeq[1] = 0;
        Session2.SessionSeq[2] = 0;
        Session2.SessionSeq[3] = 0;
        Session2.cipherSuite.setAuthenticationAlgorithm((byte)0);
        Session2.cipherSuite.setIntegrityAlgorithm((byte)0);
        Session2.cipherSuite.setConfidentialityAlgorithm((byte)0);
        Para.addElement(AuthType);
        Para.addElement(Session2.SessionSeq);
        Para.addElement(Session2.SessionID);
        Para.addElement(reqdata);
        ((RMCP)rmcpPacket).RMCPSetup((byte)7, (byte)24, (byte)84, (byte)65, Para, Session2, rawdata, length);
        if (udpSocket.SendPacket(this.IP, 623, Session2.InboundSessionSeq, rawdata, length[0], true)) {
            ((RMCP)rmcpPacket).ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                System.arraycopy((byte[])rmcpPacket.retValue.get(1), 0, result, 0, 16);
                bResult = true;
            }
        }
        Session2.releaselock();
        return bResult;
    }
}

