/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.RMCP;
import IPMIView20.UDPSocket;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;

public class DeviceStatus {
    public static final int DEVICE_UNKNOWN = 0;
    public static final int DEVICE_OSA = 1;
    public static final int DEVICE_PEPPERCON_KVM = 2;
    public static final int DEVICE_PEPPERCON_NONE_KVM = 3;
    public static final int DEVICE_PEPPERCON_CMM = 4;
    public static final int DEVICE_BLADE_MODULE = 5;
    GlobalDefine gd = new GlobalDefine();
    SortedMap device;
    boolean isRun = true;
    Timer timer = null;
    Thread th;
    CSession xSession = new CSession();

    public DeviceStatus() {
        this.device = new TreeMap();
    }

    public void addDevice(Vector deviceIPs) {
        Iterator iter = deviceIPs.iterator();
        while (iter.hasNext()) {
            String ip = (String)iter.next();
            if (this.device.containsKey(ip)) continue;
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.deviceIP = ip;
            this.device.put(ip, deviceInfo);
        }
    }

    public DeviceInfo addDevice(String deviceIP) {
        if (!this.device.containsKey(deviceIP)) {
            DeviceInfo deviceInfo = new DeviceInfo();
            deviceInfo.deviceIP = deviceIP;
            this.device.put(deviceIP, deviceInfo);
        }
        return (DeviceInfo)this.device.get(deviceIP);
    }

    public boolean getStatus(String deviceIP) {
        if (deviceIP == null || !this.device.containsKey(deviceIP)) {
            return false;
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.isOn;
    }

    public int getDeviceType(String deviceIP) {
        if (!this.device.containsKey(deviceIP)) {
            return 0;
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.deviceType;
    }

    public String getVersionInfo(String deviceIP) {
        if (deviceIP == null || !this.device.containsKey(deviceIP)) {
            return "";
        }
        DeviceInfo b = (DeviceInfo)this.device.get(deviceIP);
        return b.version;
    }

    public void startMonitor_old() {
        this.isRun = true;
        this.th = new Thread(){

            public void run() {
                while (DeviceStatus.this.isRun) {
                    try {
                        DeviceStatus.this.monitorAllAtSameTime();
                        try {
                            Thread.sleep(20000L);
                        }
                        catch (InterruptedException ex) {
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.th.start();
    }

    public void startMonitor() {
        TimerTask timerTask = new TimerTask(){

            public void run() {
                DeviceStatus.this.monitorAllAtSameTime();
            }
        };
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate(timerTask, 0L, 20000L);
    }

    public void stopMonitor_old() {
        this.isRun = false;
        this.th.interrupt();
    }

    public void stopMonitor() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void monitorAllAtSameTime() {
        Object[] an_deviceInfos = this.device.values().toArray();
        for (int i = 0; i < an_deviceInfos.length; ++i) {
            MonitorStatus monitorStatus = new MonitorStatus((DeviceInfo)an_deviceInfos[i]);
            monitorStatus.start();
        }
    }

    public void monitor(String deviceIP) {
        DeviceInfo deviceInfo = this.addDevice(deviceIP);
        MonitorStatus monitorStatus = new MonitorStatus(deviceInfo);
        monitorStatus.start();
    }

    private void checkIsAlive(DeviceInfo deviceInfo) {
        byte[] guid = this.getSystemGUID(deviceInfo.deviceIP);
        if (guid != null) {
            if (DeviceStatus.isOSAGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SUPERO IPMI)";
                deviceInfo.deviceType = 1;
                deviceInfo.isOn = true;
            } else if (DeviceStatus.isPepperconGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIM IPMI+KVM)";
                deviceInfo.deviceType = 2;
                deviceInfo.isOn = true;
            } else if (DeviceStatus.isPepperconNoneKVMGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SIM IPMI)";
                deviceInfo.deviceType = 3;
                deviceInfo.isOn = true;
            } else if (DeviceStatus.isCMMGUID(guid)) {
                deviceInfo.version = "IPMI 2.0 (SuperBlade CMM)";
                deviceInfo.deviceType = 4;
                deviceInfo.isOn = true;
            } else if (DeviceStatus.isSIMBL(guid)) {
                deviceInfo.version = "IPMI 2.0 (Blade Module)";
                deviceInfo.deviceType = 5;
                deviceInfo.isOn = true;
            } else {
                int result = this.checkIPMIVersion(deviceInfo.deviceIP);
                if (result == 121) {
                    result = this.checkIPMIVersionOld(deviceInfo.deviceIP);
                }
                if (result == 0) {
                    deviceInfo.version = "IPMI 1.5";
                    deviceInfo.isOn = true;
                } else if (result == 1) {
                    deviceInfo.version = "IPMI 2.0";
                    deviceInfo.isOn = true;
                } else if (result == 2) {
                    deviceInfo.version = "IPMI 2.0+";
                    deviceInfo.isOn = true;
                } else {
                    deviceInfo.version = L.t("discover.Unknown");
                    deviceInfo.isOn = false;
                }
            }
        } else {
            deviceInfo.version = L.t("discover.Unknown");
            deviceInfo.isOn = false;
        }
    }

    private void checkIsAlive_old(DeviceInfo deviceInfo) {
        int result = this.checkIPMIVersion(deviceInfo.deviceIP);
        if (result == 121) {
            result = this.checkIPMIVersionOld(deviceInfo.deviceIP);
            if (result != 121) {
                int aResult = this.checkIPMIVersion(deviceInfo.deviceIP);
                if (aResult != 121) {
                    System.out.println("2nd Check [ Device Status Message ]");
                    result = aResult;
                }
            }
        }
        if (result == 0) {
            deviceInfo.version = "IPMI 1.5";
            deviceInfo.isOn = true;
        } else if (result == 1) {
            deviceInfo.version = "IPMI 2.0";
            byte[] guid = this.getSystemGUID(deviceInfo.deviceIP);
            if (guid != null && DeviceStatus.isOSAGUID(guid)) {
                deviceInfo.version = deviceInfo.version + " (SUPERO IPMI)";
            }
            deviceInfo.isOn = true;
        } else if (result == 2) {
            deviceInfo.version = "IPMI 2.0+";
            byte[] guid = this.getSystemGUID(deviceInfo.deviceIP);
            if (guid != null) {
                if (DeviceStatus.isOSAGUID(guid)) {
                    deviceInfo.version = deviceInfo.version + " (SUPERO IPMI)";
                    deviceInfo.deviceType = 1;
                } else if (DeviceStatus.isPepperconGUID(guid)) {
                    deviceInfo.version = deviceInfo.version + " (SIM IPMI+KVM)";
                    deviceInfo.deviceType = 2;
                } else if (DeviceStatus.isPepperconNoneKVMGUID(guid)) {
                    deviceInfo.version = deviceInfo.version + " (SIM IPMI)";
                    deviceInfo.deviceType = 3;
                } else if (DeviceStatus.isCMMGUID(guid)) {
                    deviceInfo.version = deviceInfo.version + " (SuperBlade CMM)";
                    deviceInfo.deviceType = 4;
                }
            }
            deviceInfo.isOn = true;
        } else {
            deviceInfo.version = L.t("discover.Unknown");
            deviceInfo.isOn = false;
        }
    }

    public int checkIPMIVersion(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(2, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        param[0] = -127;
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] byte3 = (byte[])rmcpPacket.retValue.get(1);
                byte[] byte4 = (byte[])rmcpPacket.retValue.get(2);
                byte[] byte5 = (byte[])rmcpPacket.retValue.get(3);
                byte[] byte6_8 = (byte[])rmcpPacket.retValue.get(4);
                byte[] byte9 = (byte[])rmcpPacket.retValue.get(5);
                byte ipmiVesion = byte5[0];
                if ((ipmiVesion & 2) == 2) {
                    if ((byte3[0] & 0x80) > 0) {
                        udpSocket.closeSocket();
                        return 2;
                    }
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                }
                return 0;
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public int checkIPMIVersionOld(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(2, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] temp = (byte[])rmcpPacket.retValue.get(3);
                byte ipmiVesion = temp[0];
                if ((ipmiVesion & 2) == 2) {
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                    return 0;
                }
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public byte[] getSystemGUID(String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(2, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)55, (byte)65, Para, this.xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, this.xSession.InboundSessionSeq, rawdata, length[0], true)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] bytes = (byte[])rmcpPacket.retValue.get(0);
                udpSocket.closeSocket();
                return bytes;
            }
        }
        udpSocket.closeSocket();
        return null;
    }

    public static boolean isOSAGUID(byte[] guid) {
        return guid[0] == 32 && guid[1] == 0 && guid[2] == 14 && guid[3] == 64 && guid[4] == 2 && guid[5] == 127 && guid[6] == 120 && guid[7] == 8;
    }

    public static boolean isPepperconGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 2 && guid[1] == 0 && guid[2] == 0 && guid[3] == -1 && guid[4] == -2 && guid[5] == 0 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isPepperconNoneKVMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public static boolean isSIMBL(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public static void main(String[] args) {
        IPMIView20 i;
        IPMIView20.instance = i = new IPMIView20();
        DeviceStatus ds = new DeviceStatus();
        ds.addDevice("192.168.1.111");
        ds.addDevice("192.168.1.115");
        ds.addDevice("192.168.1.118");
        ds.addDevice("192.168.10.240");
        ds.startMonitor();
        try {
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ds.stopMonitor();
        System.out.println("stop monitor");
    }

    class DeviceInfo {
        String deviceIP;
        String version = "";
        boolean isOn = false;
        int deviceType = 0;
        boolean isPassLogin = false;
        String id;
        String pw;

        DeviceInfo() {
        }

        public String toString() {
            return "IP:" + this.deviceIP + ", " + (this.isOn ? "On" : "Off") + "," + this.version;
        }
    }

    class MonitorStatus
    extends Thread {
        DeviceInfo deviceInfo;

        public MonitorStatus(DeviceInfo deviceInfo) {
            this.deviceInfo = deviceInfo;
        }

        public void run() {
            DeviceStatus.this.checkIsAlive(this.deviceInfo);
            if (IPMIView20.getInstance() != null) {
                IPMIView20.getInstance().deviceList.repaint();
                IPMIView20.getInstance().domainTree.repaint();
            }
        }
    }
}

