/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.DeviceFile;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import IPMIView20.reStartTftpdIFace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Discover
extends JDialog {
    reStartTftpdIFace iface = null;
    InetAddress saddress;
    InetAddress eaddress;
    InetAddress emask;
    GlobalDefine gd = new GlobalDefine();
    Vector serviceThreadList = new Vector(10);
    JTable jTable = null;
    DefaultTableModel dm;
    boolean bcreated = false;
    String[] xRecord = new String[3];
    DeviceFile xDeviceFile;
    private ButtonGroup buttonGroup1;
    private JCheckBox jIPMI20CheckBox;
    private JCheckBox jIPMI15CheckBox;
    private JTextField jEIP;
    private JButton jExit;
    private JLabel jFoundnumber;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField jNMASK;
    private JLabel jOverall;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jPrefix;
    private JProgressBar jProgressBar1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JTextField jSIP;
    private JButton jSave;
    private JScrollPane jScrollPane1;
    private JButton jStart;
    private JButton jfindLocal;
    public static final int RUNNING = 1;
    public static final int DONE_NOTFOUND = 2;
    public static final int DONE_GOT = 3;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public Discover(reStartTftpdIFace pface, boolean modal, DeviceFile xd) {
        this.setModal(modal);
        this.setTitle(L.t("discover.IPMI_Device_Discovering"));
        this.initComponents();
        this.jProgressBar1.setVisible(false);
        this.jSave.setVisible(false);
        this.jLabel6.setVisible(false);
        this.jPrefix.setVisible(false);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setVisible(false);
        this.jRadioButton2.setVisible(false);
        this.jRadioButton3.setVisible(false);
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
        this.buttonGroup1.add(this.jRadioButton3);
        this.jLabel5.setVisible(true);
        this.xDeviceFile = xd;
        this.iface = pface;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSIP = new JTextField();
        this.jEIP = new JTextField();
        this.jNMASK = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jStart = new JButton();
        this.jfindLocal = new JButton();
        this.jExit = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jOverall = new JLabel();
        this.jProgressBar1 = new JProgressBar();
        this.jSave = new JButton();
        this.jFoundnumber = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jPrefix = new JTextField();
        this.jLabel6 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jIPMI20CheckBox = new JCheckBox();
        this.jIPMI15CheckBox = new JCheckBox();
        this.getContentPane().setLayout((LayoutManager)new AbsoluteLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Discover.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder(""));
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(L.t("discover.Network_IP"));
        this.jPanel1.add((Component)this.jLabel1, new AbsoluteConstraints(20, 30, 70, -1));
        this.jSIP.setText("0.0.0.0");
        this.jSIP.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Discover.this.jSIPFocusGained(evt);
            }
        });
        this.jPanel1.add((Component)this.jSIP, new AbsoluteConstraints(140, 30, 130, -1));
        this.jEIP.setText("0.0.0.0");
        this.jEIP.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Discover.this.jEIPFocusGained(evt);
            }
        });
        this.jPanel1.add((Component)this.jEIP, new AbsoluteConstraints(140, 60, 130, -1));
        this.jNMASK.setText("0.0.0.0");
        this.jNMASK.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Discover.this.jNMASKFocusGained(evt);
            }
        });
        this.jPanel1.add((Component)this.jNMASK, new AbsoluteConstraints(140, 90, 130, -1));
        this.jLabel3.setForeground(Color.blue);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(L.t("discover.From"));
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(90, 30, 40, -1));
        this.jLabel4.setText(L.t("discover.To"));
        this.jLabel4.setForeground(Color.blue);
        this.jLabel4.setHorizontalAlignment(4);
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(90, 60, 40, -1));
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(L.t("discover.Network_Mask"));
        this.jPanel1.add((Component)this.jLabel2, new AbsoluteConstraints(20, 90, 110, -1));
        this.jStart.setText(L.t("discover.Start"));
        this.jStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Discover.this.jStartActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jStart, new AbsoluteConstraints(115, 190, 70, -1));
        this.jfindLocal.setText(L.t("discover.Detect"));
        this.jfindLocal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Discover.this.jfindLocalActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jfindLocal, new AbsoluteConstraints(280, 89, 75, -1));
        this.jExit.setText(L.t("discover.Exit"));
        this.jExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Discover.this.jExitActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jExit, new AbsoluteConstraints(200, 190, 70, -1));
        this.jLabel5.setHorizontalAlignment(0);
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(280, 40, 64, 32));
        this.jPanel1.add((Component)this.jScrollPane1, new AbsoluteConstraints(10, 300, 340, 100));
        this.jOverall.setForeground(Color.blue);
        this.jOverall.setHorizontalAlignment(2);
        this.jPanel1.add((Component)this.jOverall, new AbsoluteConstraints(160, 200, 50, 16));
        this.jPanel1.add((Component)this.jProgressBar1, new AbsoluteConstraints(10, 200, 340, -1));
        this.jSave.setText(L.t("discover.Save"));
        this.jSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Discover.this.jSaveActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jSave, new AbsoluteConstraints(15, 260, 70, -1));
        this.jFoundnumber.setHorizontalAlignment(2);
        this.jPanel1.add((Component)this.jFoundnumber, new AbsoluteConstraints(90, 270, 90, 16));
        this.jRadioButton1.setText(L.t("discover.Host_Name"));
        this.jRadioButton1.setOpaque(false);
        this.jPanel1.add((Component)this.jRadioButton1, new AbsoluteConstraints(180, 220, -1, -1));
        this.jRadioButton2.setText(L.t("discover.Host_IP"));
        this.jRadioButton2.setOpaque(false);
        this.jPanel1.add((Component)this.jRadioButton2, new AbsoluteConstraints(180, 240, -1, -1));
        this.jRadioButton3.setText(L.t("discover.Prefix"));
        this.jRadioButton3.setOpaque(false);
        this.jPanel1.add((Component)this.jRadioButton3, new AbsoluteConstraints(180, 260, -1, -1));
        this.jPrefix.setText(L.t("discover.New_System"));
        this.jPanel1.add((Component)this.jPrefix, new AbsoluteConstraints(240, 260, 110, -1));
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(L.t("discover.Create_System_Name_from_colon"));
        this.jPanel1.add((Component)this.jLabel6, new AbsoluteConstraints(10, 230, 160, -1));
        this.jPanel2.setBorder(new TitledBorder(L.t("discover.Search_Option")));
        this.jIPMI20CheckBox.setSelected(true);
        this.jIPMI20CheckBox.setText("IPMI 2.0");
        this.jPanel2.add(this.jIPMI20CheckBox);
        this.jIPMI15CheckBox.setText("IPMI 1.5");
        this.jPanel2.add(this.jIPMI15CheckBox);
        this.jPanel1.add((Component)this.jPanel2, new AbsoluteConstraints(30, 121, 240, 60));
        this.getContentPane().add((Component)this.jPanel1, new AbsoluteConstraints(0, 0, 360, 430));
        this.pack();
    }

    private void jSaveActionPerformed(ActionEvent evt) {
        int ix = 0;
        for (int i = 0; i < this.dm.getRowCount(); ++i) {
            Vector xV = this.xDeviceFile.getDeviceVector("IPMI Domain");
            if (this.jTable.isRowSelected(i)) {
                String sx;
                int jx = 0;
                String namex = this.jRadioButton1.isSelected() ? (String)this.jTable.getValueAt(i, 1) : (this.jRadioButton2.isSelected() ? (String)this.jTable.getValueAt(i, 0) : this.jPrefix.getText());
                while (jx < xV.size()) {
                    sx = (String)xV.get(jx);
                    if (ix == 0) {
                        if (sx.compareToIgnoreCase(namex) == 0) {
                            ++ix;
                            jx = 0;
                            continue;
                        }
                    } else if (sx.compareToIgnoreCase(namex + "-" + ix) == 0) {
                        ++ix;
                        jx = 0;
                        continue;
                    }
                    ++jx;
                }
                sx = ix == 0 ? namex : namex + "-" + ix;
                this.xDeviceFile.addDevice(sx, (String)this.jTable.getValueAt(i, 0), (String)this.jTable.getValueAt(i, 1));
                IPMIView20.getInstance().deviceStatus.monitor((String)this.jTable.getValueAt(i, 0));
                this.iface.refreshList();
            }
            xV.removeAllElements();
            xV = null;
        }
    }

    private void jNMASKFocusGained(FocusEvent evt) {
        int i;
        byte[] bs = new byte[4];
        byte[] be = new byte[4];
        byte[] bm = new byte[4];
        byte[] br = new byte[4];
        try {
            this.IntToByte(bs, 0, InetAddress.getByName(this.jSIP.getText()).hashCode());
            this.IntToByte(be, 0, InetAddress.getByName(this.jEIP.getText()).hashCode());
        }
        catch (UnknownHostException ue) {
            JOptionPane msgBox = new JOptionPane();
            JOptionPane.showMessageDialog(this, L.t("discover.Data_incorrect_please_check"), L.t("discover.Error"), 2);
            this.jSIP.grabFocus();
            return;
        }
        for (i = 0; i < 4; ++i) {
            bm[i] = (byte)(~((bs[i] ^ be[i]) & 0xFF));
            br[i] = 0;
        }
        boolean clearrest = false;
        for (i = 3; i >= 0 && !clearrest; --i) {
            for (int j = 7; j >= 0 && !clearrest; --j) {
                if (clearrest) continue;
                if ((bm[i] & ((byte)Math.pow(2.0, j) & 0xFF)) == 0) {
                    clearrest = true;
                    continue;
                }
                byte bt = (byte)Math.pow(2.0, j);
                br[i] = (byte)(br[i] | bt);
            }
        }
        this.jNMASK.setText(this.ByteToIP(br, 0, 4));
        this.jNMASK.selectAll();
    }

    private void jEIPFocusGained(FocusEvent evt) {
        this.jEIP.setText(this.jSIP.getText());
        this.jEIP.selectAll();
    }

    private void jSIPFocusGained(FocusEvent evt) {
        this.jSIP.selectAll();
    }

    private void jStartActionPerformed(ActionEvent evt) {
        if (this.dm != null) {
            while (this.dm.getRowCount() > 0) {
                this.dm.removeRow(0);
            }
        }
        this.jSave.setVisible(false);
        this.jLabel6.setVisible(false);
        this.jPrefix.setVisible(false);
        this.jRadioButton1.setVisible(false);
        this.jRadioButton2.setVisible(false);
        this.jRadioButton3.setVisible(false);
        try {
            this.saddress = InetAddress.getByName(this.jSIP.getText());
            this.eaddress = InetAddress.getByName(this.jEIP.getText());
            this.emask = InetAddress.getByName(this.jNMASK.getText());
        }
        catch (UnknownHostException ue) {
            JOptionPane msgBox = new JOptionPane();
            JOptionPane.showMessageDialog(this, L.t("discover.Data_incorrect_please_check"), L.t("discover.Error"), 2);
            this.jSIP.grabFocus();
            return;
        }
        if ((this.saddress.hashCode() & this.emask.hashCode()) != (this.eaddress.hashCode() & this.emask.hashCode())) {
            JOptionPane msgBox = new JOptionPane();
            JOptionPane.showMessageDialog(this, L.t("discover.Start_IP_and_End_IP_must_locate_within_same_network_segment"), L.t("discover.Error"), 2);
            this.jSIP.grabFocus();
            return;
        }
        Thread th = new Thread(){
            boolean finished;
            int xstep;
            int sint;
            int eint;
            int icount;
            int iseq;
            int ifound;

            public void run() {
                DiscoverThread dt;
                this.sint = Discover.this.saddress.hashCode();
                this.eint = Discover.this.eaddress.hashCode();
                this.iseq = 0;
                Cursor csrTemp = new Cursor(3);
                Discover.this.setCursor(csrTemp);
                Discover.this.jStart.setEnabled(false);
                Discover.this.jStart.setVisible(false);
                Discover.this.jfindLocal.setEnabled(false);
                Discover.this.jfindLocal.setVisible(false);
                Discover.this.jExit.setVisible(false);
                ImageIcon img = new ImageIcon(this.getClass().getResource("/images/search.gif"));
                Discover.this.jLabel5.setIcon(img);
                Discover.this.jLabel5.setVisible(true);
                Discover.this.jProgressBar1.setMaximum(this.eint - this.sint);
                Discover.this.jProgressBar1.setMinimum(0);
                Discover.this.jProgressBar1.setValue(0);
                Discover.this.jProgressBar1.setVisible(true);
                Discover.this.jOverall.setText("0/" + (this.eint - this.sint + 1));
                Discover.this.jOverall.setVisible(true);
                Discover.this.jFoundnumber.setVisible(false);
                this.xstep = this.sint;
                while (this.xstep <= this.eint) {
                    DiscoverThread dThread = new DiscoverThread(this.iseq, Discover.this.IntToIP(this.xstep));
                    Discover.this.serviceThreadList.addElement(dThread);
                    dThread.start();
                    ++this.iseq;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    ++this.xstep;
                }
                this.finished = false;
                this.ifound = 0;
                while (!this.finished) {
                    this.finished = true;
                    this.icount = 0;
                    this.xstep = 0;
                    while (this.xstep < this.eint - this.sint + 1) {
                        dt = (DiscoverThread)Discover.this.serviceThreadList.get(this.xstep);
                        switch (dt.status) {
                            case 1: {
                                this.finished = false;
                                break;
                            }
                            case 3: {
                                if (!dt.checked) {
                                    Discover.this.xRecord[0] = dt.destIP;
                                    Discover.this.xRecord[2] = dt.type;
                                    try {
                                        Discover.this.xRecord[1] = InetAddress.getByName(dt.destIP).getHostName();
                                    }
                                    catch (UnknownHostException ue) {
                                        Discover.this.xRecord[1] = dt.destIP;
                                    }
                                    dt.checked = true;
                                    ++this.ifound;
                                    if (!Discover.this.bcreated) {
                                        Discover.this.bcreated = true;
                                        Discover.this.dm = new DefaultTableModel(){

                                            public Class getColumnClass(int col) {
                                                switch (col) {
                                                    case 0: {
                                                        return class$java$lang$String == null ? (class$java$lang$String = Discover.class$("java.lang.String")) : class$java$lang$String;
                                                    }
                                                    case 1: {
                                                        return class$java$lang$String == null ? (class$java$lang$String = Discover.class$("java.lang.String")) : class$java$lang$String;
                                                    }
                                                    case 2: {
                                                        return class$java$lang$String == null ? (class$java$lang$String = Discover.class$("java.lang.String")) : class$java$lang$String;
                                                    }
                                                }
                                                return class$java$lang$Object == null ? (class$java$lang$Object = Discover.class$("java.lang.Object")) : class$java$lang$Object;
                                            }

                                            public boolean isCellEditable(int row, int col) {
                                                return false;
                                            }

                                            public void setValueAt(Object obj, int row, int col) {
                                                super.setValueAt(obj, row, col);
                                            }
                                        };
                                        String[] ColumnHead = new String[]{L.t("discover.IP"), L.t("discover.Name"), L.t("discover.Version")};
                                        Discover.this.dm.setDataVector(new Object[][]{{Discover.this.xRecord[0], Discover.this.xRecord[1], Discover.this.xRecord[2]}}, ColumnHead);
                                        Discover.this.jTable = new JTable(Discover.this.dm);
                                        Discover.this.jTable.setAutoResizeMode(4);
                                        Discover.this.jScrollPane1.setViewportView(Discover.this.jTable);
                                        Discover.this.jTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                                            public void valueChanged(ListSelectionEvent e) {
                                                if (e.getValueIsAdjusting()) {
                                                    return;
                                                }
                                                if ((this).Discover.this.jTable.getSelectedRowCount() > 0) {
                                                    Discover.this.jSave.setEnabled(true);
                                                    Discover.this.jLabel6.setVisible(true);
                                                    Discover.this.jPrefix.setVisible(true);
                                                    Discover.this.jRadioButton1.setVisible(true);
                                                    Discover.this.jRadioButton2.setVisible(true);
                                                    Discover.this.jRadioButton3.setVisible(true);
                                                }
                                            }
                                        });
                                        TableColumn tc = Discover.this.jTable.getColumn(L.t("discover.IP"));
                                        tc.setPreferredWidth(40);
                                        tc = Discover.this.jTable.getColumn(L.t("discover.Name"));
                                        tc.setPreferredWidth(40);
                                        tc = Discover.this.jTable.getColumn(L.t("discover.Version"));
                                        tc.setPreferredWidth(120);
                                    } else {
                                        Discover.this.dm.addRow(Discover.this.xRecord);
                                    }
                                    Discover.this.jSave.setVisible(true);
                                    Discover.this.jSave.setEnabled(false);
                                }
                            }
                            case 2: {
                                ++this.icount;
                            }
                        }
                        ++this.xstep;
                    }
                    Discover.this.jProgressBar1.setValue(this.icount);
                    Discover.this.jOverall.setText("" + this.icount + "/" + (this.eint - this.sint + 1));
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {}
                }
                Discover.this.jProgressBar1.setVisible(false);
                Discover.this.jOverall.setVisible(false);
                Discover.this.jFoundnumber.setText(L.t("discover.Found") + this.ifound);
                Discover.this.jFoundnumber.setVisible(true);
                this.xstep = 0;
                while (this.xstep < this.eint - this.sint + 1) {
                    dt = (DiscoverThread)Discover.this.serviceThreadList.get(this.xstep);
                    Object var3_3 = null;
                    ++this.xstep;
                }
                Discover.this.serviceThreadList.removeAllElements();
                Discover.this.jLabel5.setVisible(false);
                Discover.this.jStart.setEnabled(true);
                Discover.this.jStart.setVisible(true);
                Discover.this.jfindLocal.setEnabled(true);
                Discover.this.jfindLocal.setVisible(true);
                Discover.this.jExit.setVisible(true);
                csrTemp = new Cursor(0);
                Discover.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jfindLocalActionPerformed(ActionEvent evt) {
        String localIP = "";
        String fromIP = "";
        String toIP = "";
        String netMask = "255.255.255.0";
        InetAddress[] ia = null;
        Vector<String> allyourIP = new Vector<String>();
        try {
            ia = Discover.getAllLocalUsingNetworkInterface();
        }
        catch (UnknownHostException e) {
            System.out.println(e);
            return;
        }
        for (int i = 0; i < ia.length; ++i) {
            if (ia[i].getHostAddress().equals("127.0.0.1")) continue;
            allyourIP.add(ia[i].getHostAddress());
        }
        if (allyourIP.size() == 0) {
            JOptionPane.showMessageDialog(this, L.t("discover.No_local_IP_found_colon"), L.t("discover.Error"), 0);
        } else if (allyourIP.size() == 1) {
            localIP = (String)allyourIP.get(0);
        } else {
            String msg = L.t("discover.Please_select_your_IP_colon");
            JComboBox comboBox = new JComboBox(allyourIP);
            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(1, 2));
            p1.add(new JLabel(msg));
            p1.add(comboBox);
            int result = JOptionPane.showOptionDialog(this, p1, "", 2, 3, null, null, null);
            if (result == 0) {
                localIP = (String)comboBox.getSelectedItem();
            } else {
                return;
            }
        }
        fromIP = localIP.substring(0, localIP.lastIndexOf(".")) + ".1";
        toIP = localIP.substring(0, localIP.lastIndexOf(".")) + ".254";
        this.jSIP.setText(fromIP);
        this.jEIP.setText(toIP);
        this.jNMASK.setText(netMask);
        this.jStartActionPerformed(null);
    }

    private static InetAddress[] getAllLocalUsingNetworkInterface() throws UnknownHostException {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> e = null;
        try {
            e = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            throw new UnknownHostException("127.0.0.1");
        }
        while (e.hasMoreElements()) {
            NetworkInterface ni = e.nextElement();
            Enumeration<InetAddress> e2 = ni.getInetAddresses();
            while (e2.hasMoreElements()) {
                addresses.add(e2.nextElement());
            }
        }
        InetAddress[] iAddresses = new InetAddress[addresses.size()];
        for (int i = 0; i < iAddresses.length; ++i) {
            iAddresses[i] = (InetAddress)addresses.get(i);
        }
        return iAddresses;
    }

    private void jExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private boolean getFWInfo(CSession xSession, String SIP, String Keyword, String[] RetString) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<Object> Para = new Vector<Object>(1);
        Object sResult = null;
        boolean bResult = false;
        RMCP rmcpPacket = RMCPFactory.getInstance().createRMCP(xSession);
        UDPSocket udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.initSession(xSession);
        xSession.lockout();
        Para.addElement(AuthType);
        Para.addElement(xSession.SessionSeq);
        Para.addElement(xSession.SessionID);
        Para.addElement(Keyword);
        rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)49, (byte)0, Para, xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, xSession.InboundSessionSeq, rawdata, length[0], true)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                xSession.IncreaseSessionSeq();
                RetString[0] = ((String)rmcpPacket.retValue.get(0)).length() > 0 ? (String)rmcpPacket.retValue.get(0) : "";
                bResult = true;
            } else {
                RetString[0] = "failed";
            }
        } else {
            RetString[0] = "<unavailable>";
        }
        xSession.releaselock();
        return bResult;
    }

    public int checkIPMIVersionOld(CSession xSession, String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, 1);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] temp = (byte[])rmcpPacket.retValue.get(3);
                byte ipmiVesion = temp[0];
                if ((ipmiVesion & 2) == 2) {
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                    return 0;
                }
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public int checkIPMIVersion(CSession xSession, String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        param[0] = -127;
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, xSession.InboundSessionSeq, rawdata, length[0], false)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] byte3 = (byte[])rmcpPacket.retValue.get(1);
                byte[] byte4 = (byte[])rmcpPacket.retValue.get(2);
                byte[] byte5 = (byte[])rmcpPacket.retValue.get(3);
                byte[] byte6_8 = (byte[])rmcpPacket.retValue.get(4);
                byte[] byte9 = (byte[])rmcpPacket.retValue.get(5);
                byte ipmiVesion = byte5[0];
                if ((ipmiVesion & 2) == 2) {
                    if ((byte3[0] & 0x80) > 0) {
                        udpSocket.closeSocket();
                        return 2;
                    }
                    udpSocket.closeSocket();
                    return 1;
                }
                if (ipmiVesion == 0) {
                    udpSocket.closeSocket();
                }
                return 0;
            }
        }
        udpSocket.closeSocket();
        return 121;
    }

    public static byte[] getSystemGUID(CSession xSession, String SIP) {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = new RMCP();
        UDPSocket udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, 0);
        udpSocket.setRetry(false);
        udpSocket.setTimeoutCounter(false);
        udpSocket.setIgnoreIOException(true);
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)55, (byte)65, Para, xSession, rawdata, length);
        if (udpSocket.SendPacket(SIP, 623, xSession.InboundSessionSeq, rawdata, length[0], true)) {
            rmcpPacket.ResolvePacket(udpSocket.recvBuf, 0, udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                byte[] bytes = (byte[])rmcpPacket.retValue.get(0);
                udpSocket.closeSocket();
                return bytes;
            }
        }
        udpSocket.closeSocket();
        return null;
    }

    public static boolean isOSAGUID(byte[] guid) {
        return guid[0] == 32 && guid[1] == 0 && guid[2] == 14 && guid[3] == 64 && guid[4] == 2 && guid[5] == 127 && guid[6] == 120 && guid[7] == 8;
    }

    public static boolean isPepperconGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 2 && guid[1] == 0 && guid[2] == 0 && guid[3] == -1 && guid[4] == -2 && guid[5] == 0 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isPepperconNoneKVMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public static boolean isSIMBL(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    private String ByteToIP(byte[] bytesrc, int offset, int len) {
        String x = new String();
        x = "";
        for (int i = len - 1; i >= 0; --i) {
            x = x + (bytesrc[offset + i] & 0xFF);
            if (i == 0) break;
            x = x + ".";
        }
        return x;
    }

    private String IntToIP(int intsrc) {
        String x = new String();
        x = "" + ((byte)(intsrc >> 24) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 16) & 0xFF);
        x = x + "." + ((byte)(intsrc >> 8) & 0xFF);
        x = x + "." + ((byte)intsrc & 0xFF);
        return x;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    public class DiscoverThread
    extends Thread {
        CSession Session = new CSession();
        String CardName;
        String[] sResult = new String[1];
        String destIP;
        boolean checked = false;
        int status = 1;
        int id;
        String type = "";

        public DiscoverThread(int id, String destIP) {
            this.destIP = destIP;
            this.id = id;
        }

        public void run() {
            int result = Discover.this.checkIPMIVersion(this.Session, this.destIP);
            GlobalDefine cfr_ignored_0 = Discover.this.gd;
            if (result == 121) {
                result = Discover.this.checkIPMIVersionOld(this.Session, this.destIP);
            }
            if (result == 0 && Discover.this.jIPMI15CheckBox.isSelected()) {
                this.status = 3;
                this.type = "IPMI 1.5";
            } else if (result == 1 && Discover.this.jIPMI20CheckBox.isSelected()) {
                this.status = 3;
                this.type = "IPMI 2.0";
                byte[] guid = Discover.getSystemGUID(this.Session, this.destIP);
                if (guid != null && Discover.isOSAGUID(guid)) {
                    this.type = this.type + " (SUPERO IPMI)";
                }
            } else if (result == 2 && Discover.this.jIPMI20CheckBox.isSelected()) {
                this.status = 3;
                this.type = "IPMI 2.0+";
                byte[] guid = Discover.getSystemGUID(this.Session, this.destIP);
                if (guid != null) {
                    if (Discover.isOSAGUID(guid)) {
                        this.type = this.type + " (SUPERO IPMI)";
                    } else if (Discover.isPepperconGUID(guid)) {
                        this.type = this.type + " (SIM IPMI+KVM)";
                    } else if (Discover.isPepperconNoneKVMGUID(guid)) {
                        this.type = this.type + " (SIM IPMI)";
                    } else if (Discover.isCMMGUID(guid)) {
                        this.type = this.type + " (SuperBlade CMM)";
                    } else if (Discover.isSIMBL(guid)) {
                        this.type = this.type + " (Blade Module)";
                    }
                }
            } else {
                this.status = 2;
                this.type = L.t("discover.Unknown");
            }
        }
    }
}

