/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.TCR;
import IPMIView20.UDPSocket;
import IPMIView20.UOLPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class IPMDevice20
extends JPanel {
    boolean enableUOL = false;
    boolean bLoaded = false;
    boolean checkFlag = false;
    boolean delayCheckACPIStatus = false;
    boolean isBlinkLED = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    TCR TCRPane;
    CSession Session;
    UDPSocket udpSocket;
    JLabel Message;
    int TabId;
    public boolean isPowerOn = false;
    Timer timer;
    Timer acpiTimer;
    ImageIcon gshutdownup = new ImageIcon(this.getClass().getResource("/images/gshutdownup.gif"));
    ImageIcon gshutdowndn = new ImageIcon(this.getClass().getResource("/images/gshutdowndn.gif"));
    ImageIcon grebootup = new ImageIcon(this.getClass().getResource("/images/grebootup.gif"));
    ImageIcon grebootdn = new ImageIcon(this.getClass().getResource("/images/grebootdn.gif"));
    ImageIcon gpowercycleup = new ImageIcon(this.getClass().getResource("/images/gpowercycleup.gif"));
    ImageIcon gpowercycledn = new ImageIcon(this.getClass().getResource("/images/gpowercycledn.gif"));
    ImageIcon resetup = new ImageIcon(this.getClass().getResource("/images/resetup.gif"));
    ImageIcon resetdn = new ImageIcon(this.getClass().getResource("/images/resetdn.gif"));
    ImageIcon powerdownup = new ImageIcon(this.getClass().getResource("/images/powerdownup.gif"));
    ImageIcon powerdowndn = new ImageIcon(this.getClass().getResource("/images/powerdowndn.gif"));
    ImageIcon powerupup = new ImageIcon(this.getClass().getResource("/images/powerupup.gif"));
    ImageIcon powerupdn = new ImageIcon(this.getClass().getResource("/images/powerupdn.gif"));
    ImageIcon powercycleup = new ImageIcon(this.getClass().getResource("/images/powercycleup.gif"));
    ImageIcon powercycledn = new ImageIcon(this.getClass().getResource("/images/powercycledn.gif"));
    int acpiCallCount = 0;
    int tempcount = 0;
    private JLabel FirmwareRevision;
    private JLabel IPMIRevision;
    private JLabel PowerLED;
    private JLabel SystemPowerState;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jBlinkLEDButton;
    private JButton jGPowercycle;
    private JButton jGReboot;
    private JButton jGShutdown;
    private JButton jHardReset;
    private JLabel jLabel35;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jBlinkLEDPanel;
    private JButton jPowerCycle;
    private JButton jPowerDown;
    private JButton jPowerUp;
    private JButton jRefresh;
    public UOLPanel uolPanel;
    int a_seconds = 0;

    public IPMDevice20() {
        this.initComponents();
        this.timer = new Timer();
        this.acpiTimer = new Timer();
        this.jGShutdown.setIcon(this.gshutdownup);
        this.jGReboot.setIcon(this.grebootup);
        this.jGPowercycle.setIcon(this.gpowercycleup);
        this.jHardReset.setIcon(this.resetup);
        this.jPowerDown.setIcon(this.powerdownup);
        this.jPowerUp.setIcon(this.powerupup);
        this.jPowerCycle.setIcon(this.powercycleup);
        this.jPanel5.setVisible(false);
        this.jPanel2.setVisible(false);
        this.jGShutdown.setVisible(false);
        this.jGReboot.setVisible(false);
        this.jGPowercycle.setVisible(false);
        this.jHardReset.setVisible(false);
        this.jPowerDown.setVisible(false);
        this.jPowerUp.setVisible(false);
        this.jPowerCycle.setVisible(false);
        this.jPanel1.setVisible(false);
        this.jPanel4.setVisible(false);
        this.jButton1.setVisible(false);
        this.jButton2.setVisible(false);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage, TCR xTCRPane) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.TCRPane = xTCRPane;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.Session.isPeppercon) {
            if (!this.isUIDPresent()) {
                this.jBlinkLEDPanel.setVisible(false);
            }
        } else {
            this.jBlinkLEDPanel.setVisible(false);
        }
        if (IPMIView20.instance.DEBUG) {
            this.jBlinkLEDPanel.setVisible(true);
        }
        if (this.Session.MaxLevel[0] >= 3) {
            this.jPanel5.setVisible(true);
            this.jPanel2.setVisible(true);
            this.jGShutdown.setVisible(true);
            if (this.Session.isPeppercon) {
                this.jGReboot.setVisible(false);
                this.jGPowercycle.setVisible(false);
            } else {
                this.jGReboot.setVisible(true);
                this.jGPowercycle.setVisible(true);
            }
            this.jHardReset.setVisible(true);
            this.jPowerDown.setVisible(true);
            this.jPowerUp.setVisible(true);
            this.jPowerCycle.setVisible(true);
            this.uolPanel.setVisible(true);
            if (this.Session.MaxLevel[0] >= 4) {
                this.jPanel1.setVisible(true);
                this.jButton1.setVisible(true);
            } else {
                this.jPanel1.setVisible(false);
                this.jButton1.setVisible(false);
            }
        } else {
            this.jPanel5.setVisible(false);
            this.jPanel2.setVisible(false);
            this.jGShutdown.setVisible(false);
            this.jGReboot.setVisible(false);
            this.jGPowercycle.setVisible(false);
            this.jHardReset.setVisible(false);
            this.jPowerDown.setVisible(false);
            this.jPowerUp.setVisible(false);
            this.jPowerCycle.setVisible(false);
            this.jPanel1.setVisible(false);
            this.jButton1.setVisible(false);
            this.uolPanel.setVisible(false);
        }
        this.jButton2.setVisible(false);
        this.jRefresh.grabFocus();
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = iSession.Loading;
        this.GetDeviceID();
        this.GetACPIPowerState();
        this.bLoaded = true;
        this.Session.Loading = -1;
        TimerTask t = new TimerTask(){
            int powerContorlWaitingCount = 0;

            public void run() {
                if (!IPMDevice20.this.checkFlag) {
                    return;
                }
                if (IPMDevice20.this.uolPanel.isConnecting()) {
                    return;
                }
                IPMDevice20.this.Session.Loading = IPMDevice20.this.TabId;
                IPMDevice20.this.GetACPIPowerState();
                IPMDevice20.this.Session.Loading = -1;
            }
        };
        this.acpiTimer = new Timer();
        this.acpiTimer.schedule(t, 0L, 5000L);
        this.uolPanel.setIp(xSocket.saddress.getHostAddress());
        this.uolPanel.ipmiSession = this.Session.ipmiSession;
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void setCheckFlag(boolean xFlag) {
        this.checkFlag = xFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetDeviceID() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        ImageIcon checkedIcon = new ImageIcon(this.getClass().getResource("/images/checkbox_checked.gif"));
        ImageIcon uncheckedIcon = new ImageIcon(this.getClass().getResource("/images/checkbox_uncheck.gif"));
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("device.Getting_Device_ID"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)1, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("device.Get_Device_ID_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    bytex = (byte[])this.rmcpPacket.retValue.get(2);
                    byte[] bytey = (byte[])this.rmcpPacket.retValue.get(3);
                    this.FirmwareRevision.setText(Integer.toHexString((bytex[0] & 0x70) >> 4) + "" + Integer.toHexString(bytex[0] & 0xF) + "." + Integer.toHexString((bytey[0] & 0xF0) >> 4) + "" + Integer.toHexString(bytey[0] & 0xF));
                    bytex = (byte[])this.rmcpPacket.retValue.get(4);
                    this.IPMIRevision.setText((bytex[0] & 0xF) + "." + ((bytex[0] & 0xF0) >> 4));
                    bytex = (byte[])this.rmcpPacket.retValue.get(6);
                    bytex = (byte[])this.rmcpPacket.retValue.get(7);
                    bytex = (byte[])this.rmcpPacket.retValue.get(5);
                    bResult = true;
                } else {
                    this.Message.setText(L.t("device.Get_Device_ID_failed"));
                }
            } else {
                this.Message.setText(L.t("device.Get_Device_ID_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ColdReset() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)2, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean WarmReset() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)3, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetACPIPowerState() {
        Logger.writeLog("Call GetACPIPowerState()");
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        ImageIcon LEDOnimg = new ImageIcon(this.getClass().getResource("/images/gledon.gif"));
        ImageIcon LEDOffimg = new ImageIcon(this.getClass().getResource("/images/gledoff.gif"));
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("device.Getting_ACPI_Power_State"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)7, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("device.Get_ACPI_Power_State_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    switch (bytex[0]) {
                        case 0: {
                            this.SystemPowerState.setText("S0/G0");
                            this.PowerLED.setIcon(LEDOnimg);
                            this.PowerLED.setText("On");
                            this.isPowerOn = true;
                            break;
                        }
                        case 1: {
                            this.SystemPowerState.setText("S1");
                            this.PowerLED.setIcon(LEDOnimg);
                            this.PowerLED.setText("On");
                            this.isPowerOn = true;
                            break;
                        }
                        case 2: {
                            this.SystemPowerState.setText("S2");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 3: {
                            this.SystemPowerState.setText("S3");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 4: {
                            this.SystemPowerState.setText("S4");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 5: {
                            this.SystemPowerState.setText("S5/G2");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 6: {
                            this.SystemPowerState.setText("S4/S5");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 7: {
                            this.SystemPowerState.setText("G3");
                            break;
                        }
                        case 8: {
                            this.SystemPowerState.setText("sleeping");
                            break;
                        }
                        case 9: {
                            this.SystemPowerState.setText("G1 sleeping");
                            break;
                        }
                        case 10: {
                            this.SystemPowerState.setText("Override");
                            break;
                        }
                        case 32: {
                            this.SystemPowerState.setText("Legacy On");
                            this.PowerLED.setIcon(LEDOnimg);
                            this.PowerLED.setText("On");
                            this.isPowerOn = true;
                            break;
                        }
                        case 33: {
                            this.SystemPowerState.setText("Legacy Off");
                            this.PowerLED.setIcon(LEDOffimg);
                            this.PowerLED.setText("Off");
                            this.isPowerOn = false;
                            break;
                        }
                        case 42: {
                            this.SystemPowerState.setText("unknown");
                            break;
                        }
                        default: {
                            this.SystemPowerState.setText("undefined");
                        }
                    }
                    bResult = true;
                } else {
                    this.Message.setText(L.t("device.Get_ACPI_Power_State_failed"));
                }
            } else {
                this.Message.setText(L.t("device.Get_ACPI_Power_State_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LongAsciiCmd(String Keyword) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        int stroutlen = Keyword.length();
        byte[] cmddata = new byte[stroutlen + 2];
        cmddata[0] = (byte)(stroutlen >> 8 & 0xFFF);
        cmddata[0] = (byte)(cmddata[0] | 0xFFFFFFC0);
        cmddata[1] = (byte)(stroutlen & 0xFFFFFFFF);
        System.arraycopy(Keyword.getBytes(), 0, cmddata, 2, stroutlen);
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(cmddata);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean LongAsciiCmdGo() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] cmddata = new byte[]{0, 0};
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(cmddata);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)0, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private void initComponents() {
        Font borderFont = new Font("default", 0, 11);
        this.jPanel3 = new JPanel();
        this.jLabel5 = new JLabel();
        this.FirmwareRevision = new JLabel();
        this.jLabel7 = new JLabel();
        this.IPMIRevision = new JLabel();
        this.jLabel35 = new JLabel();
        this.SystemPowerState = new JLabel();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jPanel5 = new JPanel();
        this.jBlinkLEDPanel = new JPanel();
        this.jGShutdown = new JButton();
        this.jGReboot = new JButton();
        this.jGPowercycle = new JButton();
        this.jRefresh = new JButton();
        this.PowerLED = new JLabel();
        this.PowerLED.setVerticalTextPosition(3);
        this.PowerLED.setHorizontalTextPosition(0);
        this.PowerLED.setForeground(Color.BLUE);
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.jPowerDown = new JButton();
        this.jPowerUp = new JButton();
        this.jPowerCycle = new JButton();
        this.jHardReset = new JButton();
        this.jPanel4 = new JPanel();
        this.jButton3 = new JButton();
        this.jBlinkLEDButton = new JButton(L.t("device.Blink_UID_LED"));
        this.uolPanel = new UOLPanel();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel3.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel3.setBorder(new TitledBorder(null, L.t("device.Device_Information"), 0, 2, borderFont, Color.BLUE));
        this.jLabel5.setText(L.t("device.Firmware_Revision"));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setPreferredSize(new Dimension(105, 25));
        this.jPanel3.add((Component)this.jLabel5, new AbsoluteConstraints(5, 20, 120, 20));
        this.FirmwareRevision.setForeground(Color.blue);
        this.FirmwareRevision.setPreferredSize(new Dimension(41, 25));
        this.jPanel3.add((Component)this.FirmwareRevision, new AbsoluteConstraints(130, 20, 90, 20));
        this.jLabel7.setText(L.t("device.IPMI_Revision"));
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setPreferredSize(new Dimension(75, 25));
        this.jPanel3.add((Component)this.jLabel7, new AbsoluteConstraints(5, 40, 120, 20));
        this.IPMIRevision.setForeground(Color.blue);
        this.IPMIRevision.setPreferredSize(new Dimension(41, 25));
        this.jPanel3.add((Component)this.IPMIRevision, new AbsoluteConstraints(130, 40, 90, 20));
        this.add((Component)this.jPanel3, new AbsoluteConstraints(10, 20, 230, 70));
        this.jLabel35.setText(L.t("device.ACPI_System_Power_State"));
        this.jLabel35.setHorizontalAlignment(4);
        this.add((Component)this.jLabel35, new AbsoluteConstraints(250, 50, 160, -1));
        this.SystemPowerState.setForeground(Color.blue);
        this.SystemPowerState.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.SystemPowerState, new AbsoluteConstraints(420, 50, 80, -1));
        this.jPanel1.setBorder(new TitledBorder(null, "BMC", 0, 2, borderFont, Color.BLUE));
        this.jButton1.setForeground(Color.red);
        this.jButton1.setText(L.t("device.Cold_Reset"));
        this.jButton1.setBackground(Color.black);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.add((Component)this.jPanel1, new AbsoluteConstraints(10, 310, 140, 70));
        this.jBlinkLEDPanel.setBorder(new TitledBorder(null, L.t("device.UID_LED"), 0, 2, borderFont, Color.BLUE));
        this.jBlinkLEDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jBlinkLEDButton1ActionPerformed(evt);
            }
        });
        this.jBlinkLEDPanel.add(this.jBlinkLEDButton);
        this.add((Component)this.jBlinkLEDPanel, new AbsoluteConstraints(155, 310, 180, 70));
        this.jPanel5.setBorder(new TitledBorder(null, L.t("device.Graceful_Power_Control"), 0, 2, borderFont, Color.BLUE));
        this.jGShutdown.setPreferredSize(new Dimension(162, 29));
        this.jGShutdown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jGShutdownActionPerformed(evt);
            }
        });
        this.jGShutdown.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jGShutdownMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jGShutdownMouseReleased(evt);
            }
        });
        this.jPanel5.add(this.jGShutdown);
        this.jGReboot.setPreferredSize(new Dimension(162, 29));
        this.jGReboot.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jGRebootActionPerformed(evt);
            }
        });
        this.jGReboot.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jGRebootMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jGRebootMouseReleased(evt);
            }
        });
        this.jPanel5.add(this.jGReboot);
        this.jGPowercycle.setPreferredSize(new Dimension(162, 29));
        this.jGPowercycle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jGPowercycleActionPerformed(evt);
            }
        });
        this.jGPowercycle.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jGPowercycleMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jGPowercycleMouseReleased(evt);
            }
        });
        this.jPanel5.add(this.jGPowercycle);
        this.add((Component)this.jPanel5, new AbsoluteConstraints(10, 110, 550, 70));
        this.jRefresh.setText(L.t("device.Refresh"));
        this.jRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jRefreshActionPerformed(evt);
            }
        });
        this.add((Component)this.jRefresh, new AbsoluteConstraints(240, 480, -1, -1));
        this.add((Component)this.PowerLED, new AbsoluteConstraints(480, 40, 70, 70));
        this.jButton2.setForeground(Color.red);
        this.jButton2.setText("Warm Reset");
        this.jButton2.setBackground(Color.black);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jButton2ActionPerformed(evt);
            }
        });
        this.add((Component)this.jButton2, new AbsoluteConstraints(450, 280, -1, -1));
        this.jPanel2.setBorder(new TitledBorder(null, L.t("device.Chassis_Power_Control"), 0, 2, borderFont, Color.BLUE));
        this.jPowerDown.setPreferredSize(new Dimension(123, 29));
        this.jPowerDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jPowerDownActionPerformed(evt);
            }
        });
        this.jPowerDown.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jPowerDownMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jPowerDownMouseReleased(evt);
            }
        });
        this.jPanel2.add(this.jPowerDown);
        this.jPowerUp.setPreferredSize(new Dimension(123, 29));
        this.jPowerUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jPowerUpActionPerformed(evt);
            }
        });
        this.jPowerUp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jPowerUpMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jPowerUpMouseReleased(evt);
            }
        });
        this.jPanel2.add(this.jPowerUp);
        this.jPowerCycle.setPreferredSize(new Dimension(123, 29));
        this.jPowerCycle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jPowerCycleActionPerformed(evt);
            }
        });
        this.jPowerCycle.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jPowerCycleMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jPowerCycleMouseReleased(evt);
            }
        });
        this.jPanel2.add(this.jPowerCycle);
        this.jHardReset.setPreferredSize(new Dimension(123, 29));
        this.jHardReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jHardResetActionPerformed(evt);
            }
        });
        this.jHardReset.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                IPMDevice20.this.jHardResetMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                IPMDevice20.this.jHardResetMouseReleased(evt);
            }
        });
        this.jPanel2.add(this.jHardReset);
        this.add((Component)this.jPanel2, new AbsoluteConstraints(10, 210, 550, 70));
        this.jPanel4.setBorder(new TitledBorder("BIOS (Serverboard) or Firmware (BMC)"));
        this.jButton3.setForeground(Color.white);
        this.jButton3.setText("Remote Flash");
        this.jButton3.setBackground(Color.black);
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMDevice20.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton3);
        this.add((Component)this.jPanel4, new AbsoluteConstraints(150, 310, 210, 70));
        JPanel p = new JPanel();
        p.setSize(new Dimension(550, 130));
        JToolBar toolbar = new JToolBar();
        toolbar.setPreferredSize(new Dimension(550, 125));
        toolbar.add(this.uolPanel);
        p.add(toolbar);
        if (this.enableUOL) {
            this.add((Component)p, new AbsoluteConstraints(10, 380, 550, 130));
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
    }

    private void jGRebootMouseReleased(MouseEvent evt) {
        this.jGReboot.setIcon(this.grebootup);
    }

    private void jGRebootMousePressed(MouseEvent evt) {
        this.jGReboot.setIcon(this.grebootdn);
    }

    private void jGPowercycleMouseReleased(MouseEvent evt) {
        this.jGPowercycle.setIcon(this.gpowercycleup);
    }

    private void jGPowercycleMousePressed(MouseEvent evt) {
        this.jGPowercycle.setIcon(this.gpowercycledn);
    }

    private void jHardResetMouseReleased(MouseEvent evt) {
        this.jHardReset.setIcon(this.resetup);
    }

    private void jHardResetMousePressed(MouseEvent evt) {
        this.jHardReset.setIcon(this.resetdn);
    }

    private void jPowerDownMouseReleased(MouseEvent evt) {
        this.jPowerDown.setIcon(this.powerdownup);
    }

    private void jPowerDownMousePressed(MouseEvent evt) {
        this.jPowerDown.setIcon(this.powerdowndn);
    }

    private void jPowerUpMouseReleased(MouseEvent evt) {
        this.jPowerUp.setIcon(this.powerupup);
    }

    private void jPowerUpMousePressed(MouseEvent evt) {
        this.jPowerUp.setIcon(this.powerupdn);
    }

    private void jPowerCycleMouseReleased(MouseEvent evt) {
        this.jPowerCycle.setIcon(this.powercycleup);
    }

    private void jPowerCycleMousePressed(MouseEvent evt) {
        this.jPowerCycle.setIcon(this.powercycledn);
    }

    private void jGShutdownMouseReleased(MouseEvent evt) {
        this.jGShutdown.setIcon(this.gshutdownup);
    }

    private void jGShutdownMousePressed(MouseEvent evt) {
        this.jGShutdown.setIcon(this.gshutdowndn);
    }

    public void delayedStartTimerForACPI(int delayTime) {
        try {
            Thread.sleep(delayTime * 1000);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        TimerTask t = new TimerTask(){
            int powerContorlWaitingCount = 0;

            public void run() {
                if (!IPMDevice20.this.checkFlag) {
                    return;
                }
                if (IPMDevice20.this.uolPanel.isConnecting()) {
                    return;
                }
                IPMDevice20.this.Session.Loading = IPMDevice20.this.TabId;
                IPMDevice20.this.GetACPIPowerState();
                IPMDevice20.this.Session.Loading = -1;
            }
        };
        this.acpiTimer = new Timer();
        this.acpiTimer.schedule(t, 0L, 5000L);
        this.Message.setText(L.t("device.re-enable_ACPI_polling"));
    }

    public void jRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                IPMDevice20.this.setCursor(csrTemp);
                IPMDevice20.this.Session.Loading = IPMDevice20.this.TabId;
                IPMDevice20.this.GetDeviceID();
                IPMDevice20.this.GetACPIPowerState();
                IPMDevice20.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                IPMDevice20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jPowerCycleActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handlePowerCycle();
                IPMDevice20.this.checkTCRIsRunningAndDiableStopButtom();
            }
        };
        t.start();
    }

    private void handlePowerCycle() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_that_you_want_to_reboot_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.acpiTimer.cancel();
            this.Message.setText(L.t("device.sending_the_power-cycle_command"));
            Cursor csrTemp = new Cursor(3);
            this.delayCheckACPIStatus(40);
            this.sendPowerCycle();
            this.Session.RebootFlag = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Message.setText(L.t("device.power-cycle_command_was_sent"));
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
            this.delayedStartTimerForACPI(20);
        }
    }

    private void jGPowercycleActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handleGracefulPowerCycle();
                IPMDevice20.this.checkTCRIsRunningAndDiableStopButtom();
            }
        };
        t.start();
    }

    private void handleGracefulPowerCycle() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_that_you_want_to_reboot_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.Message.setText(L.t("device.sending_the_graceful_power-cycle_command"));
            Cursor csrTemp = new Cursor(3);
            this.setCursor(csrTemp);
            byte result = this.sendGracePowerCycle();
            boolean resolveResult = this.resolveGracefulCommand(result);
            this.Session.RebootFlag = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            if (resolveResult) {
                this.Message.setText(L.t("device.graceful_power-cycle_command_was_sent"));
            }
        }
    }

    private void jHardResetActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handleHardReset();
                IPMDevice20.this.checkTCRIsRunningAndDiableStopButtom();
            }
        };
        t.start();
    }

    private void handleHardReset() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_to_reset_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.acpiTimer.cancel();
            this.Message.setText(L.t("device.sending_the_reset_command"));
            Cursor csrTemp = new Cursor(3);
            this.delayCheckACPIStatus();
            this.sendHardReset();
            this.Session.RebootFlag = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Message.setText(L.t("device.reset_command_was_sent"));
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
            this.delayedStartTimerForACPI(15);
        }
    }

    private void jPowerUpActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handlePowerUp();
            }
        };
        t.start();
    }

    private void handlePowerUp() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_to_power_up_the_system"), L.t("deviceRequest_Confirmation"), 0);
        if (ret == 0) {
            this.acpiTimer.cancel();
            this.Message.setText(L.t("device.sending_the_power-up_command"));
            Cursor csrTemp = new Cursor(3);
            this.delayCheckACPIStatus();
            this.sendPowerUp();
            this.Session.RebootFlag = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Message.setText(L.t("device.power-up_command_was_sent"));
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
            this.delayedStartTimerForACPI(15);
        }
    }

    private void jPowerDownActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.delayCheckACPIStatus();
                IPMDevice20.this.handlePowerDown();
            }
        };
        t.start();
    }

    private void handlePowerDown() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_to_power_down_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.acpiTimer.cancel();
            this.Message.setText(L.t("device.sending_the_power-down_command"));
            Cursor csrTemp = new Cursor(3);
            this.sendPowerDown();
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Message.setText(L.t("device.power-down_command_was_sent"));
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Please_wait_for_a_moment_before_using_IPMIView_after_ACPI_System_Status_has_changed"));
            this.delayedStartTimerForACPI(15);
        }
    }

    private void jGRebootActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handleGracefulReboot();
                IPMDevice20.this.checkTCRIsRunningAndDiableStopButtom();
            }
        };
        t.start();
    }

    private void handleGracefulReboot() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_that_you_want_to_reboot_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.Message.setText(L.t("device.sending_the_graceful_reboot_command"));
            Cursor csrTemp = new Cursor(3);
            this.setCursor(csrTemp);
            byte result = this.sendGraceReboot();
            boolean resolveResult = this.resolveGracefulCommand(result);
            this.Session.RebootFlag = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            if (resolveResult) {
                this.Message.setText(L.t("device.graceful_reboot_command_was_sent"));
            }
        }
    }

    private void jGShutdownActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                IPMDevice20.this.handleGracefulShutdown();
            }
        };
        t.start();
    }

    private void handleGracefulShutdown() throws HeadlessException {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_to_shutdown_the_system"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            this.Message.setText(L.t("device.sending_the_graceful_shutdown_command"));
            Cursor csrTemp = new Cursor(3);
            this.setCursor(csrTemp);
            byte result = this.Session.isPeppercon ? this.sendSoftShutdown() : this.sendGraceShutdown();
            boolean resolveResult = this.resolveGracefulCommand(result);
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            if (resolveResult) {
                this.Message.setText(L.t("device.graceful_shutdown_command_was_sent"));
                if (this.Session.isPeppercon) {
                    this.Message.setText(L.t("device.graceful_shutdown_(soft-shutdown)_command_was_sent"));
                }
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), "Are you sure to reset the device?", "Request Confirmation", 0);
        if (ret == 0) {
            this.WarmReset();
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JOptionPane MBox = new JOptionPane();
        int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("device.Are_you_sure_that_you_want_to_cold_reset_the_BMC_This_session_will_be_terminated"), L.t("device.Request_Confirmation"), 0);
        if (ret == 0) {
            if (this.Session.ipmiSession.SOLPane20.isSOLRunning()) {
                this.Session.ipmiSession.SOLPane20.stopSOL();
            }
            this.ColdReset();
            IPMIView20.getInstance().closeActivatelySession();
        }
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    private String ToGUID(byte[] bytesrc, int length) {
        String sRet = "";
        for (int i = length - 1; i >= 0; --i) {
            sRet = sRet + Integer.toHexString(bytesrc[i]);
        }
        return sRet;
    }

    public byte sendGracePowerCycle() {
        byte[] param = new byte[]{3};
        return this.sendCommand((byte)-64, (byte)4, param);
    }

    public byte sendGraceReboot() {
        byte[] param = new byte[]{2};
        return this.sendCommand((byte)-64, (byte)4, param);
    }

    public byte sendGraceShutdown() {
        byte[] param = new byte[]{1};
        return this.sendCommand((byte)-64, (byte)4, param);
    }

    public byte sendPowerDown() {
        byte[] param = new byte[]{0};
        return this.sendCommand((byte)0, (byte)2, param);
    }

    public byte sendPowerUp() {
        byte[] param = new byte[]{1};
        return this.sendCommand((byte)0, (byte)2, param);
    }

    public byte sendPowerCycle() {
        byte[] param = new byte[]{2};
        return this.sendCommand((byte)0, (byte)2, param);
    }

    public byte sendSoftShutdown() {
        byte[] param = new byte[]{5};
        return this.sendCommand((byte)0, (byte)2, param);
    }

    public byte sendHardReset() {
        byte[] param = new byte[]{3};
        return this.sendCommand((byte)0, (byte)2, param);
    }

    private byte sendClearChassisIntrusion() {
        byte[] param = new byte[]{};
        return this.sendCommand((byte)-64, (byte)3, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte sendCommand(byte netFn, byte appCommand, byte[] param) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            if (param != null && param.length > 0) {
                Para.addElement(param);
            }
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, netFn, appCommand, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return this.rmcpPacket.compeletecode;
    }

    public boolean resolveGracefulCommand(byte compeletecode) {
        if (compeletecode == 0) {
            return true;
        }
        if (compeletecode == -45) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Dest_unavailable"));
            return false;
        }
        if (compeletecode == -128) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Sel_operation_unsupported"));
            return false;
        }
        if (compeletecode == -127) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Sel_erase_in_progress"));
            return false;
        }
        if (compeletecode == -60) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("device.Out_of_space_Please_clear_all_SEL_entries_in_the_tab_of_Event_Log"));
            return false;
        }
        JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Error(" + compeletecode + ")");
        return false;
    }

    public void stopACPITimer() {
        if (this.acpiTimer != null) {
            this.acpiTimer.cancel();
        }
        if (this.uolPanel.isConnecting()) {
            this.uolPanel.disconnectButton_actionPerformed(null);
        }
    }

    public void checkTCRIsRunningAndDiableStopButtom() {
        Thread th = new Thread(){

            public void run() {
                if (IPMDevice20.this.Session.ipmiSession.SOLPane20.isSOLRunning()) {
                    IPMDevice20.this.Session.ipmiSession.SOLPane20.Stop.setEnabled(false);
                    IPMDevice20.this.Session.ipmiSession.SOLPane20.bootingDisable = true;
                }
            }
        };
        th.start();
    }

    private void delayCheckACPIStatus() {
        this.delayCheckACPIStatus(20);
    }

    private void delayCheckACPIStatus(int seconds) {
        this.a_seconds = seconds;
        this.delayCheckACPIStatus = true;
        Logger.writeLog("set Delay Check ACPI Status = true (delay " + this.a_seconds + " seconds)");
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(IPMDevice20.this.a_seconds * 1000);
                    IPMDevice20.this.delayCheckACPIStatus = false;
                    Logger.writeLog("set Delay Check ACPI Status = false (delay " + IPMDevice20.this.a_seconds + " seconds)");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        th.start();
    }

    public static void main(String[] args) {
        System.out.println("-60");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setEnableUID(boolean isEnable) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object result = null;
        byte cmd = isEnable ? (byte)13 : 14;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)-64, cmd, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(isEnable ? L.t("device.blink_the_UID_LED") : L.t("device.stop_blinking_UID_LED"));
                } else {
                    this.Message.setText(isEnable ? L.t("device.This_device_does_not_support_blinking_UID_LED") : L.t("device.Stop_blinking_UID_LED_failed"));
                    Logger.writeLog((isEnable ? "Blink" : "Stop blinking") + " UID LED failed. , complete code =" + this.rmcpPacket.compeletecode);
                }
            } else {
                this.Message.setText((isEnable ? L.t("device.Blink") : L.t("device.Stop_blinking")) + L.t("deivce.UID_LED_failed"));
            }
            this.Session.releaselock();
        }
        return this.rmcpPacket.compeletecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUIDPresent() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object result = null;
        boolean isUIDPresent = false;
        byte cmd = 16;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            String SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)-64, cmd, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                byte[] bytex;
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0 && (bytex = (byte[])this.rmcpPacket.retValue.get(0))[0] == 1) {
                    isUIDPresent = true;
                }
            }
            this.Session.releaselock();
        }
        return isUIDPresent;
    }

    private void jBlinkLEDButton1ActionPerformed(ActionEvent evt) {
        if (!this.isBlinkLED) {
            int result = this.setEnableUID(true);
            if (result == 0) {
                this.jBlinkLEDButton.setText(L.t("device.Stop_Blinking_UID_LED"));
                this.isBlinkLED = true;
            }
        } else {
            int result = this.setEnableUID(false);
            if (result == 0) {
                this.jBlinkLEDButton.setText(L.t("device.Blink_UID_LED"));
                this.isBlinkLED = false;
            }
        }
    }
}

