/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.BMC_Manage;
import IPMIView20.BMC_Manage20;
import IPMIView20.CSession;
import IPMIView20.ConfigAccessor;
import IPMIView20.DeviceFile;
import IPMIView20.DeviceNameAccount;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMDevice;
import IPMIView20.IPMDevice20;
import IPMIView20.IPMIView20;
import IPMIView20.KVMPanel;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RAKPTalker;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.RMCPPlus;
import IPMIView20.SELDevice;
import IPMIView20.SELDevice20;
import IPMIView20.SOL20;
import IPMIView20.Sensors;
import IPMIView20.Sensors20;
import IPMIView20.TCR;
import IPMIView20.UDPSocket;
import IPMIView20.Users;
import IPMIView20.Users20;
import IPMIView20.VirtualMedia;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class IPMISession
extends JPanel {
    boolean debugmode = false;
    boolean isFirstShowFrame = true;
    GlobalDefine gd = new GlobalDefine();
    String SIP;
    CSession Session = new CSession();
    final JLabel xMessage;
    RMCP rmcpPacket = new RMCP();
    RMCPPlus rmcpPlusPacket = new RMCPPlus();
    UDPSocket udpSocket;
    String CardName;
    DeviceFile xDeviceFile;
    Timer keepSessionTimer;
    SELDevice SELPane;
    IPMDevice IPMDevicePane;
    Sensors SensorsPane;
    BMC_Manage BMCPane;
    Users UsersPane;
    TCR TCRPane;
    SELDevice20 SELPane20;
    IPMDevice20 IPMDevicePane20;
    Sensors20 SensorsPane20;
    BMC_Manage20 BMCPane20;
    Users20 UsersPane20;
    SOL20 SOLPane20;
    KVMPanel kvmPanel;
    VirtualMedia virtualMedia;
    RAKPTalker rakpTalker;
    boolean isEnableSOL;
    public JPasswordField Password;
    private JLabel SystemDescription;
    private JLabel SystemIP;
    private JLabel Systemname;
    public JTextField UserID;
    private JLabel jClock;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JButton jLogin;
    private JButton jLogout;
    private JButton jAutoLogin;
    private JPanel jPanel1;
    private JPanel jPanel2;
    public JCheckBox jSaveAccount;
    public JTabbedPane jTabbedPane1;
    JLabel label;
    JLabel cipherLabel;

    public IPMISession(String Hostname, String IP, String Description, JLabel Message2, DeviceFile xDeviceFile) {
        this.udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, IPMIView20.getInstance().retryTime);
        this.SELPane = new SELDevice();
        this.IPMDevicePane = new IPMDevice();
        this.SensorsPane = new Sensors();
        this.BMCPane = new BMC_Manage();
        this.UsersPane = new Users();
        this.TCRPane = new TCR();
        this.SELPane20 = new SELDevice20();
        this.IPMDevicePane20 = new IPMDevice20();
        this.SensorsPane20 = new Sensors20();
        this.BMCPane20 = new BMC_Manage20();
        this.UsersPane20 = new Users20();
        this.SOLPane20 = new SOL20();
        this.rakpTalker = null;
        this.isEnableSOL = false;
        this.label = new JLabel();
        this.cipherLabel = new JLabel();
        this.initComponents();
        this.keepSessionTimer = new Timer();
        this.SIP = IP;
        this.xMessage = Message2;
        this.Systemname.setText(Hostname);
        this.SystemIP.setText(this.SIP);
        this.SystemDescription.setText(Description);
        this.xDeviceFile = xDeviceFile;
        this.Session.hostName = Hostname;
        this.udpSocket.initSession(this.Session);
        this.Session.ipmiSession = this;
        this.Session.SIP = IP;
        Thread th = new Thread(){

            public void run() {
                IPMISession.this.preload();
            }
        };
        th.start();
    }

    public void preload() {
        String[] sResult = new String[1];
        Thread th = new Thread(){

            public void run() {
                String[] cmd = new String[]{"ping", IPMISession.this.SIP};
                try {
                    String line;
                    Process Proc = Runtime.getRuntime().exec(cmd);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Proc.getInputStream()));
                    while ((line = reader.readLine()) != null) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        th.start();
        this.xMessage.setText(L.t("login.Ready"));
        this.UserID.grabFocus();
    }

    public void setDefaultButton() {
        this.jLogin.setEnabled(true);
        this.getRootPane().setDefaultButton(this.jLogin);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                IPMISession.this.UserID.requestFocusInWindow();
            }
        });
    }

    private boolean getFWInfo(String Keyword, String[] RetString) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<Object> Para = new Vector<Object>(1);
        Object sResult = null;
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(Keyword);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)49, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                RetString[0] = ((String)this.rmcpPacket.retValue.get(0)).length() > 0 ? (String)this.rmcpPacket.retValue.get(0) : "";
                bResult = true;
            } else {
                RetString[0] = "failed";
            }
        } else {
            RetString[0] = "<unavailable>";
        }
        this.Session.releaselock();
        return bResult;
    }

    private void getDummyFWInfo(String Keyword) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<Object> Para = new Vector<Object>(1);
        Object sResult = null;
        if (this.Session.checkbusy()) {
            return;
        }
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(Keyword);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)49, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
            }
        }
        this.Session.releaselock();
    }

    public void DropSession() {
        this.Session.Loading = -1;
        this.keepSessionTimer.cancel();
        this.IPMDevicePane.stopACPITimer();
        this.IPMDevicePane20.stopACPITimer();
        this.SensorsPane.timer.cancel();
        this.SensorsPane20.timer.cancel();
        this.SensorsPane.bLoaded = false;
        this.SensorsPane20.bLoaded = false;
        this.IPMDevicePane.bLoaded = false;
        this.IPMDevicePane20.bLoaded = false;
        this.SELPane.bLoaded = false;
        this.SELPane20.bLoaded = false;
        this.BMCPane.bLoaded = false;
        this.BMCPane20.bLoaded = false;
        this.UsersPane.bLoaded = false;
        this.UsersPane20.bLoaded = false;
        this.TCRPane.closeTCR();
        if (this.SOLPane20.isSOLRunning()) {
            this.SOLPane20.stopSOL();
        }
        this.kvmPanel.close();
        this.jTabbedPane1.setSelectedIndex(0);
        while (this.jTabbedPane1.getComponentCount() > 1) {
            this.jTabbedPane1.remove(1);
        }
        ImageIcon gshutdownup = new ImageIcon(this.getClass().getResource("/images/disconnect.gif"));
        this.jClock.setIcon(gshutdownup);
        this.jClock.setVisible(true);
        this.jLogin.setEnabled(false);
        this.jLogout.setEnabled(false);
        if (this.udpSocket.noResponseCount == 0) {
            this.CloseSession();
        }
        this.Session.SessionActivated = false;
        if (IPMIView20.getInstance().isProxyEnabled) {
            this.closeProxyConnection();
        }
    }

    private void CloseSession() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = RMCPFactory.getInstance().createRMCP(this.Session);
        AuthType[0] = this.Session.IPMIVersion == 0 ? 0 : 2;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(this.Session.SessionID);
        rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)60, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                Logger.writeLog("Close Session OK");
            } else {
                Logger.writeLog("Close Session Failed");
            }
        }
        this.Session.releaselock();
    }

    private boolean GetSessionChallenge(String sUserID) {
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] AuthType1 = new byte[]{0};
        byte[] UserName = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        this.Session.SessionID[0] = 0;
        this.Session.SessionID[1] = 0;
        this.Session.SessionID[2] = 0;
        this.Session.SessionID[3] = 0;
        this.Session.SessionSeq[0] = 0;
        this.Session.SessionSeq[1] = 0;
        this.Session.SessionSeq[2] = 0;
        this.Session.SessionSeq[3] = 0;
        System.arraycopy(sUserID.getBytes(), 0, UserName, 0, sUserID.length());
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        AuthType1[0] = this.Session.IPMIVersion == 0 ? 5 : 2;
        Para.addElement(AuthType1);
        Para.addElement(UserName);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)57, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(0), 0, this.Session.SessionID, 0, 4);
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(1), 0, this.Session.ChallengeStringData, 0, 16);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean ActivateSessionByDiffLevel() {
        byte[] level = new byte[]{2, 3, 4};
        String[] strLevel = new String[]{"User", "Operator", "Administrator"};
        byte maxLevel = 0;
        for (int i = 0; i < level.length; ++i) {
            Logger.writeLog("try level =" + strLevel[level[i] - 2]);
            boolean result = this.ActivateSessionPrivilegeLevel(level[i]);
            if (!result) continue;
            if (i == 2) {
                Logger.writeLog("Administrator level test OK.");
                return true;
            }
            this.CloseSession();
            this.udpSocket = new UDPSocket(IPMIView20.getInstance().socketTimeout, IPMIView20.getInstance().retryTime);
            this.udpSocket.initSession(this.Session);
            Logger.writeLog("renew a UDP socket");
            this.GetSessionChallenge(this.UserID.getText());
            maxLevel = level[i];
        }
        if (maxLevel >= 2) {
            this.GetSessionChallenge(this.UserID.getText());
            Logger.writeLog("final login:" + strLevel[maxLevel - 2]);
            this.ActivateSessionPrivilegeLevel(maxLevel);
            Logger.writeLog("User:" + this.Session.userID + " has logined , Max User Level :" + strLevel[maxLevel - 2]);
            return true;
        }
        return false;
    }

    private boolean ActivateSessionPrivilegeLevel(byte level) {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] AuthType1 = new byte[]{0};
        byte[] MaxLevel = new byte[1];
        byte[] IniOutbSeq = new byte[]{1, 0, 0, 0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (this.Session.IPMIVersion == 0) {
            AuthType[0] = 5;
            AuthType1[0] = 5;
        } else {
            AuthType[0] = 2;
            AuthType1[0] = 2;
        }
        MaxLevel[0] = level;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(AuthType1);
        Para.addElement(MaxLevel);
        Para.addElement(this.Session.ChallengeStringData);
        Para.addElement(IniOutbSeq);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)58, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(1), 0, this.Session.SessionID, 0, 4);
                this.Session.IncreaseSessionSeq();
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(3), 0, this.Session.MaxLevel, 0, 1);
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(4), 0, this.Session.InboundSessionSeq, 0, 4);
                retResult = true;
            } else {
                Logger.writeLog("Activate Session Error :" + this.rmcpPacket.compeletecode);
            }
        }
        this.Session.releaselock();
        return retResult;
    }

    private boolean ActivateSessionByCallbackFirst() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSessionInfoPlus(byte[] retData) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 0, 0, 0, 0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bReturn = false;
        RMCPPlus rmcpPacket = new RMCPPlus();
        reqdata[0] = -1;
        for (int i = 0; i < 4; ++i) {
            reqdata[1 + i] = this.Session.SessionID[i];
        }
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            ((RMCP)rmcpPacket).RMCPSetup((byte)7, (byte)24, (byte)61, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                ((RMCP)rmcpPacket).ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (rmcpPacket.compeletecode == 0) {
                    byte[] xxbyte = (byte[])rmcpPacket.retValue.get(0);
                    System.arraycopy(xxbyte, 0, retData, 0, xxbyte.length);
                    bReturn = true;
                }
            }
            this.Session.releaselock();
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSessionInfo(byte[] retData) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 0, 0, 0, 0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bReturn = false;
        reqdata[0] = -1;
        for (int i = 0; i < 4; ++i) {
            reqdata[1 + i] = this.Session.SessionID[i];
        }
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)61, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] xxbyte = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(xxbyte, 0, retData, 0, xxbyte.length);
                    bReturn = true;
                }
            }
            this.Session.releaselock();
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetUserAccess(int UserID, byte[] retData) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{1, 0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bReturn = false;
        reqdata[1] = (byte)(UserID & 0x3F);
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)68, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] xxbyte = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(xxbyte, 0, retData, 0, xxbyte.length);
                    bReturn = true;
                }
            }
            this.Session.releaselock();
        }
        return bReturn;
    }

    private boolean ActivateSession() {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] AuthType1 = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{1, 0, 0, 0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (this.Session.IPMIVersion == 0) {
            AuthType[0] = 5;
            AuthType1[0] = 5;
        } else {
            AuthType[0] = 2;
            AuthType1[0] = 2;
        }
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(AuthType1);
        Para.addElement(MaxLevel);
        Para.addElement(this.Session.ChallengeStringData);
        Para.addElement(IniOutbSeq);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)58, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(1), 0, this.Session.SessionID, 0, 4);
                this.Session.IncreaseSessionSeq();
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(3), 0, this.Session.MaxLevel, 0, 1);
                System.arraycopy((byte[])this.rmcpPacket.retValue.get(4), 0, this.Session.InboundSessionSeq, 0, 4);
                retResult = true;
            }
        }
        this.Session.releaselock();
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetSessionPrivilegePlus() {
        RMCPPlus rmcpPacket = new RMCPPlus();
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        MaxLevel = this.Session.MaxLevel;
        AuthType[0] = this.Session.IPMIVersion == 0 ? 0 : 2;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(MaxLevel);
            rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)59, (byte)-62, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
                if (rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    byte[] maxLevel = (byte[])rmcpPacket.retValue.get(0);
                    if (maxLevel != null && maxLevel.length != 0) {
                        System.arraycopy(maxLevel, 0, this.Session.MaxLevel, 0, 1);
                        retResult = true;
                    }
                } else {
                    Logger.writeLog("SetSessionPrivilege completecode =" + rmcpPacket.compeletecode);
                }
            }
            this.Session.releaselock();
        }
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetSessionPrivilege() {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        MaxLevel = this.Session.MaxLevel;
        AuthType[0] = this.Session.IPMIVersion == 0 ? 0 : 2;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(MaxLevel);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)59, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Session.IncreaseSessionSeq();
                    System.arraycopy((byte[])this.rmcpPacket.retValue.get(0), 0, this.Session.MaxLevel, 0, 1);
                    retResult = true;
                } else {
                    Logger.writeLog("SetSessionPrivilege completecode =" + this.rmcpPacket.compeletecode);
                }
            }
            this.Session.releaselock();
        }
        return retResult;
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel2 = new JPanel();
        this.UserID = new JTextField();
        this.Password = new JPasswordField();
        this.jLogin = new JButton();
        this.jLogout = new JButton();
        this.jSaveAccount = new JCheckBox();
        this.jAutoLogin = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.SystemIP = new JLabel();
        this.Systemname = new JLabel();
        this.jLabel5 = new JLabel();
        this.SystemDescription = new JLabel();
        this.jClock = new JLabel();
        this.setLayout(new BorderLayout());
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                IPMISession.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jPanel2.setLayout((LayoutManager)new AbsoluteLayout());
        this.UserID.setColumns(10);
        this.UserID.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                IPMISession.this.UserIDCaretUpdate(evt);
            }
        });
        this.UserID.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                IPMISession.this.UserIDFocusGained(evt);
            }
        });
        this.jPanel2.add((Component)this.UserID, new AbsoluteConstraints(270, 180, 140, 20));
        this.Password.setColumns(10);
        this.Password.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent evt) {
                IPMISession.this.PasswordCaretUpdate(evt);
            }
        });
        this.Password.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                IPMISession.this.PasswordFocusGained(evt);
            }
        });
        this.jPanel2.add((Component)this.Password, new AbsoluteConstraints(270, 210, 140, 20));
        this.jLogin.setText(L.t("login.Login"));
        this.jLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMISession.this.jLoginActionPerformed(evt);
            }
        });
        this.jAutoLogin.setText("Auto");
        this.jAutoLogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMISession.this.jAutoLoginActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jLogin, new AbsoluteConstraints(210, 280, 80, 30));
        this.jLogout.setText(L.t("login.Logout"));
        this.jLogout.setEnabled(false);
        this.jLogout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                IPMISession.this.jLogoutActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.jLogout, new AbsoluteConstraints(300, 280, 80, 30));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText(L.t("login.Login_ID"));
        this.jPanel2.add((Component)this.jLabel1, new AbsoluteConstraints(170, 180, 90, 20));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(L.t("login.Password"));
        this.jPanel2.add((Component)this.jLabel2, new AbsoluteConstraints(150, 210, 110, 20));
        this.jSaveAccount.setText(L.t("login.save_ID_and_Password"));
        this.jPanel2.add((Component)this.jSaveAccount, new AbsoluteConstraints(210, 240, 330, 20));
        this.jPanel1.setLayout((LayoutManager)new AbsoluteLayout());
        this.jPanel1.setBorder(new EtchedBorder());
        this.jLabel3.setText(L.t("login.System_Name"));
        this.jLabel3.setHorizontalAlignment(4);
        this.jPanel1.add((Component)this.jLabel3, new AbsoluteConstraints(110, 10, 110, 20));
        this.jLabel4.setText(L.t("login.IP_Address"));
        this.jLabel4.setHorizontalAlignment(4);
        this.jPanel1.add((Component)this.jLabel4, new AbsoluteConstraints(110, 50, 110, 20));
        this.SystemIP.setForeground(Color.blue);
        this.SystemIP.setPreferredSize(new Dimension(41, 17));
        this.jPanel1.add((Component)this.SystemIP, new AbsoluteConstraints(230, 50, 220, 20));
        this.Systemname.setForeground(Color.blue);
        this.Systemname.setPreferredSize(new Dimension(41, 17));
        this.jPanel1.add((Component)this.Systemname, new AbsoluteConstraints(230, 10, 220, 20));
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText(L.t("login.Description"));
        this.jPanel1.add((Component)this.jLabel5, new AbsoluteConstraints(110, 90, 110, 20));
        this.SystemDescription.setForeground(Color.blue);
        this.jPanel1.add((Component)this.SystemDescription, new AbsoluteConstraints(230, 90, 220, 20));
        this.jPanel2.add((Component)this.jPanel1, new AbsoluteConstraints(70, 40, 460, 120));
        this.jClock.setHorizontalAlignment(0);
        this.jPanel2.add((Component)this.jClock, new AbsoluteConstraints(160, 340, 290, 70));
        this.jTabbedPane1.addTab(L.t("login.Login"), this.jPanel2);
        this.jTabbedPane1.setForeground(Color.blue);
        this.jTabbedPane1.setTabPlacement(3);
        this.add((Component)this.jTabbedPane1, "Center");
        this.jPanel1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                IPMISession.this.ConsoleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                IPMISession.this.ConsoleKeyReleased(evt);
            }

            public void keyTyped(KeyEvent evt) {
                IPMISession.this.ConsoleKeyTyped(evt);
            }
        });
    }

    public void ConsoleKeyPressed(KeyEvent evt) {
        System.out.println("call ConsoleKeyPressed");
    }

    public void ConsoleKeyReleased(KeyEvent evt) {
        System.out.println("call ConsoleKeyReleased");
    }

    public void ConsoleKeyTyped(KeyEvent evt) {
        System.out.println("call ConsoleKeyTyped");
        char xc = evt.getKeyChar();
        System.out.println(xc);
    }

    private void jLogoutActionPerformed(ActionEvent evt) {
        this.keepSessionTimer.cancel();
        this.IPMDevicePane.stopACPITimer();
        this.IPMDevicePane20.stopACPITimer();
        this.SensorsPane.timer.cancel();
        this.SensorsPane20.timer.cancel();
        this.SensorsPane.bLoaded = false;
        this.SensorsPane20.bLoaded = false;
        this.IPMDevicePane.bLoaded = false;
        this.IPMDevicePane20.bLoaded = false;
        this.SELPane.bLoaded = false;
        this.SELPane20.bLoaded = false;
        this.BMCPane.bLoaded = false;
        this.BMCPane20.bLoaded = false;
        this.UsersPane.bLoaded = false;
        this.UsersPane20.bLoaded = false;
        this.TCRPane.closeTCR();
        if (this.SOLPane20.isSOLRunning()) {
            this.SOLPane20.stopSOL();
        }
        while (this.jTabbedPane1.getComponentCount() > 1) {
            this.jTabbedPane1.remove(1);
        }
        this.jLogin.setEnabled(true);
        this.jLogout.setEnabled(false);
        this.CloseSession();
        this.Session.SessionActivated = false;
        this.jClock.setVisible(false);
        this.hideVersionMessageOnLoginScreen();
        if (IPMIView20.getInstance().isProxyEnabled) {
            this.closeProxyConnection();
        }
        this.virtualMedia.stop();
        this.xMessage.setText(L.t("login.Logout_successful"));
    }

    public void changeTabtoSOL() {
        this.SOLPane20.preset(this.udpSocket, this.Session, this.xMessage);
    }

    public void jTabbedPane1StateChanged(ChangeEvent evt) {
        String SelectedTab = this.jTabbedPane1.getTitleAt(this.jTabbedPane1.getSelectedIndex());
        this.jTabbedPane1.grabFocus();
        if (this.Session.Loading != -1) {
            this.jTabbedPane1.setSelectedIndex(this.Session.Loading);
            return;
        }
        this.Session.Loading = this.jTabbedPane1.getSelectedIndex();
        this.SensorsPane.setRefreshFlag(false);
        this.IPMDevicePane.setCheckFlag(false);
        this.SensorsPane20.setRefreshFlag(false);
        this.IPMDevicePane20.setCheckFlag(false);
        if (SelectedTab.equals(L.t("login.Login"))) {
            this.Session.Loading = -1;
        } else if (SelectedTab.equals(L.t("login.IPM_Device"))) {
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.IPMDevicePane.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage, IPMISession.this.TCRPane);
                        IPMISession.this.IPMDevicePane.setCheckFlag(true);
                    } else {
                        IPMISession.this.IPMDevicePane20.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage, IPMISession.this.TCRPane);
                        IPMISession.this.IPMDevicePane20.setCheckFlag(true);
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.Event_Log"))) {
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.SELPane.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    } else {
                        IPMISession.this.SELPane20.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.Text_Console"))) {
            this.Session.Loading = -1;
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.TCRPane.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    } else {
                        IPMISession.this.SOLPane20.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                        IPMISession.this.SOLPane20.requestFocusForConsole();
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.Sensors"))) {
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.SensorsPane.preset(IPMISession.this.Systemname.getText(), IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage, IPMISession.this.xDeviceFile);
                        IPMISession.this.SensorsPane.GetSensors();
                        IPMISession.this.SensorsPane.setRefreshFlag(true);
                        if (IPMISession.this.isFirstShowFrame) {
                            IPMISession.this.SensorsPane.showFrame();
                            IPMISession.this.isFirstShowFrame = false;
                        }
                        IPMISession.this.SensorsPane.RefreshSensors();
                    } else {
                        IPMISession.this.SensorsPane20.preset(IPMISession.this.Systemname.getText(), IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage, IPMISession.this.xDeviceFile);
                        IPMISession.this.SensorsPane20.GetSensors();
                        IPMISession.this.SensorsPane20.setRefreshFlag(true);
                        if (IPMISession.this.isFirstShowFrame) {
                            IPMISession.this.SensorsPane20.showFrame();
                            IPMISession.this.isFirstShowFrame = false;
                        } else {
                            IPMISession.this.SensorsPane20.jAutoTimerItemStateChanged(null);
                        }
                        IPMISession.this.SensorsPane20.RefreshSensors();
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.BMC_Setting"))) {
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.BMCPane.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    } else {
                        IPMISession.this.BMCPane20.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.Users"))) {
            Thread th = new Thread(){

                public void run() {
                    GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion == 0) {
                        IPMISession.this.UsersPane.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    } else {
                        IPMISession.this.UsersPane20.preset(IPMISession.this.udpSocket, IPMISession.this.Session, IPMISession.this.xMessage);
                    }
                }
            };
            th.start();
        } else if (SelectedTab.equals(L.t("login.Video_Console"))) {
            if (!this.kvmPanel.isCreateUI) {
                this.Session.Loading = this.jTabbedPane1.getSelectedIndex();
                Thread th1 = new Thread(){

                    public void run() {
                        IPMISession.this.xMessage.setText(L.t("login.Loading_Video_Interface"));
                    }
                };
                th1.start();
                Thread th2 = new Thread(){

                    public void run() {
                        IPMISession.this.kvmPanel.createUI();
                        IPMISession.this.xMessage.setText(L.t("login.Video_Interface_loaded"));
                        IPMISession.this.Session.Loading = -1;
                    }
                };
                th2.start();
            } else {
                this.kvmPanel.requestFocusForKVMConsole();
                this.Session.Loading = -1;
            }
        } else if (SelectedTab.equals(L.t("login.Virtual_Media"))) {
            this.virtualMedia.preset(this.Session, this.xMessage);
            this.virtualMedia.present();
            this.Session.Loading = -1;
        }
    }

    private void PasswordCaretUpdate(CaretEvent evt) {
        String xString = new String(this.Password.getPassword());
        if (xString.length() > 20) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("login.The_maximum_length_of_Password"));
        }
    }

    private void PasswordFocusGained(FocusEvent evt) {
        String xString = new String(this.Password.getPassword());
        if (xString.length() > 16) {
            this.Password.setText(xString.substring(0, 16));
        }
        this.Password.selectAll();
    }

    private void UserIDFocusGained(FocusEvent evt) {
        if (this.UserID.getText().length() > 16) {
            this.UserID.setText(this.UserID.getText().substring(0, 16));
        }
        this.UserID.selectAll();
    }

    private void UserIDCaretUpdate(CaretEvent evt) {
        if (this.UserID.getText().length() > 16) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("login.The_maximum_length_of_User_ID"));
        }
    }

    public void jLoginActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                IPMISession.this.LoginButton();
            }
        };
        th.start();
    }

    private boolean initialProxyConnection() {
        String temp;
        String proxyIP = IPMIView20.getInstance().proxyIP;
        int proxyPort = IPMIView20.getInstance().proxyPort;
        String command = "1," + this.SIP + "," + 623;
        byte[] result = this.udpSocket.sendData(proxyIP, proxyPort, command.getBytes());
        return result != null && (temp = new String(result)).equals("0");
    }

    private boolean closeProxyConnection() {
        String proxyIP = IPMIView20.getInstance().proxyIP;
        int proxyPort = IPMIView20.getInstance().proxyPort;
        String command = "0";
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(proxyIP);
        }
        catch (UnknownHostException ex) {
            ex.toString();
            return false;
        }
        DatagramPacket dp = new DatagramPacket(command.getBytes(), command.getBytes().length, ia, proxyPort);
        try {
            this.udpSocket.socket.send(dp);
        }
        catch (IOException ex1) {
            ex1.toString();
            return false;
        }
        return true;
    }

    private void LoginButton() {
        if (this.UserID.getText().length() == 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("login.The_Login_ID_cannot_be_empty"));
            return;
        }
        if (IPMIView20.getInstance().isProxyEnabled) {
            this.xMessage.setText("Initialize connection to Proxy ...");
            boolean result = this.initialProxyConnection();
            this.xMessage.setText("Initialize connection to Proxy finished");
            if (!result) {
                this.xMessage.setText("Initialize connection to Proxy failed");
            }
        }
        String[] sResult = new String[1];
        byte[] zero = new byte[]{0, 0, 0, 0};
        byte[] pppwd = new byte[16];
        sResult[0] = null;
        this.jLogout.setEnabled(false);
        this.jLogin.setEnabled(false);
        this.udpSocket.setRetry(false);
        this.udpSocket.setTimeoutCounter(false);
        this.udpSocket.setResponseCount(false);
        ImageIcon gshutdownup = new ImageIcon(this.getClass().getResource("/images/connect2.gif"));
        this.jClock.setIcon(gshutdownup);
        this.jClock.setVisible(true);
        int ipmiVersion = this.checkIPMIVersion();
        if (ipmiVersion == 121) {
            ipmiVersion = this.checkIPMIVersionOld();
            if (ipmiVersion != 121) {
                int ipmiVersionAgain = this.checkIPMIVersion();
                if (ipmiVersionAgain != 121) {
                    ipmiVersion = ipmiVersionAgain;
                }
            }
        }
        Logger.writeLog("Checked IPMI Vesrion =" + ipmiVersion);
        String strIPMIVersion = "";
        if (ipmiVersion == 0) {
            strIPMIVersion = "1.5";
        } else if (ipmiVersion == 1) {
            strIPMIVersion = "2.0";
        } else if (ipmiVersion == 2) {
            strIPMIVersion = "2.0+";
        } else if (ipmiVersion == 121) {
            strIPMIVersion = "unknown";
        }
        Logger.writeLog("IPMIVersion = " + strIPMIVersion);
        if (ipmiVersion == 0) {
            if (this.CardName == null || this.CardName.compareTo("<unavailable>") == 0) {
                this.xMessage.setText(L.t("login.Try_to_communicate_with") + " " + this.SIP);
                this.getFWInfo("CARD_NAME", sResult);
                this.CardName = sResult[0];
            }
            this.Session.IPMIVersion = this.CardName.compareTo("SMC002") == 0 || this.CardName.compareTo("SMC003") == 0 ? 0 : 1;
        } else if (ipmiVersion == 1) {
            if (!this.RMCPPing()) {
                this.xMessage.setText(L.t("login.Cannot_communicate_with") + " " + this.SIP);
                gshutdownup = new ImageIcon(this.getClass().getResource("/images/link_break.gif"));
                this.jClock.setIcon(gshutdownup);
                this.jClock.setVisible(true);
                this.jLogout.setEnabled(false);
                this.jLogin.setEnabled(true);
                return;
            }
            this.Session.IPMIVersion = 1;
        } else if (ipmiVersion == 2) {
            this.Session.IPMIVersion = 2;
        } else {
            this.xMessage.setText(L.t("login.Cannot_communicate_with") + " " + this.SIP);
            gshutdownup = new ImageIcon(this.getClass().getResource("/images/link_break.gif"));
            this.jClock.setIcon(gshutdownup);
            this.jClock.setVisible(true);
            this.jLogout.setEnabled(false);
            this.jLogin.setEnabled(true);
            return;
        }
        String xS = new String(this.Password.getPassword());
        xS = xS.trim();
        pppwd = xS.getBytes();
        this.Session.UserPassword = new byte[16];
        System.arraycopy(pppwd, 0, this.Session.UserPassword, 0, pppwd.length);
        this.Session.PasswordLength = pppwd.length;
        this.Session.userID = this.UserID.getText();
        this.Session.SessionActivated = true;
        System.arraycopy(zero, 0, this.Session.SessionSeq, 0, 4);
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        this.setUserPreferenceIPMIVersion();
        Logger.writeLog("Final Login IPMI Version =" + this.Session.IPMIVersion);
        if (this.Session.IPMIVersion == 2) {
            Logger.writeLog(this.Session.cipherSuite.toString());
            this.rakpTalker = new RAKPTalker(this.Session, this.udpSocket);
            byte maxPrivilege = this.rakpTalker.testUserPrivilegeByLogin(this.UserID.getText(), this.Session.UserPassword, this.xMessage);
            if (maxPrivilege == 0) {
                // empty if block
            }
            if (maxPrivilege != 0 && this.rakpTalker.openSession(this.UserID.getText(), this.Session.UserPassword, this.xMessage, maxPrivilege)) {
                this.Session.MaxLevel[0] = maxPrivilege;
                if (this.SetSessionPrivilegePlus()) {
                    this.preparePanelsForTab();
                    this.xMessage.setText(L.t("login.RMCP+_Open_Session_successful"));
                    this.showVersionMessageOnLoginScreen();
                    this.checkSupermicroBMC();
                    this.checkBIOS();
                    this.getManufacturerID();
                    this.getProductID();
                    this.udpSocket.setResponseCount(true);
                    if (this.jSaveAccount.isSelected()) {
                        DeviceNameAccount.save(this.Session.hostName, this.Session.userID, xS);
                    } else {
                        DeviceNameAccount.remove(this.Session.hostName);
                    }
                    return;
                }
                this.xMessage.setText(L.t("login.Unable_to_raise_a_session_privilege"));
            }
        } else {
            this.xMessage.setText(L.t("login.Activating_Session"));
            if (this.GetSessionChallenge(this.UserID.getText())) {
                if (this.ActivateSessionByDiffLevel()) {
                    switch (this.rmcpPacket.compeletecode) {
                        case 0: {
                            this.xMessage.setText(L.t("login.Activate_session_successful"));
                            if (this.SetSessionPrivilege()) {
                                this.preparePanelsForTab();
                                this.showVersionMessageOnLoginScreen();
                                this.udpSocket.setResponseCount(true);
                                if (this.jSaveAccount.isSelected()) {
                                    DeviceNameAccount.save(this.SIP, this.Session.userID, xS);
                                } else {
                                    DeviceNameAccount.remove(this.Session.hostName);
                                }
                                return;
                            }
                            this.xMessage.setText(L.t("login.Unable_to_raise_a_session_privilege"));
                            this.CloseSession();
                            break;
                        }
                        case -127: {
                            this.xMessage.setText(L.t("login.No_session_slot_available"));
                            break;
                        }
                        case -126: {
                            this.xMessage.setText(L.t("login.No_slot_available_for_given_user"));
                            break;
                        }
                        case -125: {
                            this.xMessage.setText(L.t("login.No_slot_available_to_support_user_due_to_maximum_privilege_capability"));
                            break;
                        }
                        case -124: {
                            this.xMessage.setText(L.t("login.Session_sequence_number_out-of-range"));
                            break;
                        }
                        case -123: {
                            this.xMessage.setText(L.t("login.Invalid_session_ID_in_request"));
                            break;
                        }
                        case -122: {
                            this.xMessage.setText(L.t("login.requested_maximum_privilege_level_exceeds_Invalid_session_ID_in_request"));
                            break;
                        }
                        default: {
                            this.xMessage.setText(L.t("login.undefined_session_error"));
                            break;
                        }
                    }
                } else {
                    this.xMessage.setText(L.t("login.Unable_to_activate_a_session_please_check_ID_and_Password"));
                }
            } else {
                this.xMessage.setText(L.t("login.User_ID_not_found"));
            }
        }
        gshutdownup = new ImageIcon(this.getClass().getResource("/images/link_break.gif"));
        this.jClock.setIcon(gshutdownup);
        this.jClock.setVisible(true);
        this.jLogout.setEnabled(false);
        this.jLogin.setEnabled(true);
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        this.udpSocket.setRetry(true);
        this.udpSocket.setTimeoutCounter(true);
        this.udpSocket.setResponseCount(true);
        this.Session.SessionActivated = false;
    }

    private void setUserPreferenceIPMIVersion() {
        ConfigAccessor config = ConfigAccessor.getInstance(".\\", "version.properties");
        String setting = config.getProperty(this.Session.hostName);
        if (setting != null && setting.length() > 0) {
            Logger.writeLog("Connection Setting = " + setting);
            StringTokenizer st = new StringTokenizer(setting, "|");
            String version = st.nextToken();
            String defaultLogin = st.nextToken();
            switch (Integer.parseInt(version)) {
                case 0: {
                    this.Session.IPMIVersion = 0;
                    break;
                }
                case 1: {
                    this.Session.IPMIVersion = 1;
                    break;
                }
                case 2: {
                    this.Session.IPMIVersion = 2;
                }
            }
            if (defaultLogin.equals("1")) {
                // empty if block
            }
            if (version.equals("2")) {
                String cipherSuite = st.nextToken();
                st = new StringTokenizer(cipherSuite, ",");
                String auth = st.nextToken();
                String integrity = st.nextToken();
                String conf = st.nextToken();
                this.Session.cipherSuite.setAuthenticationAlgorithm(Byte.parseByte(auth));
                this.Session.cipherSuite.setIntegrityAlgorithm(Byte.parseByte(integrity));
                this.Session.cipherSuite.setConfidentialityAlgorithm(Byte.parseByte(conf));
            }
        }
    }

    private void preparePanelsForTab() {
        switch (this.rmcpPacket.compeletecode) {
            case 0: {
                this.xMessage.setText(L.t("login.Rise_privilege_successful"));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IPMISession.this.preparePanelsByIPMIVersion();
                    }
                });
                return;
            }
            case -128: {
                this.xMessage.setText(L.t("login.Requested_level_not_available_for_this_user"));
                break;
            }
            case -127: {
                this.xMessage.setText(L.t("login.Requested_level_exceeds_Channel_Privilege_Limit"));
                break;
            }
            case -126: {
                this.xMessage.setText(L.t("login.Cannot_disable_User_Level_authentication"));
                break;
            }
            default: {
                this.xMessage.setText(L.t("login.undefined_privilege_error"));
            }
        }
    }

    private void preparePanelsByIPMIVersion() {
        block19: {
            boolean showVM;
            block21: {
                block20: {
                    String[] sResult = new String[]{null};
                    if (this.Session.IPMIVersion == 0) {
                        this.jTabbedPane1.addTab(L.t("login.Event_Log"), this.SELPane);
                        this.jTabbedPane1.addTab(L.t("login.Sensors"), this.SensorsPane);
                        this.jTabbedPane1.addTab(L.t("login.IPM_Device"), this.IPMDevicePane);
                    } else {
                        this.jTabbedPane1.addTab(L.t("login.Event_Log"), this.SELPane20);
                        this.jTabbedPane1.addTab(L.t("login.Sensors"), this.SensorsPane20);
                        this.jTabbedPane1.addTab(L.t("login.IPM_Device"), this.IPMDevicePane20);
                    }
                    if (this.Session.MaxLevel[0] >= 4) {
                        if (this.Session.IPMIVersion == 0) {
                            this.jTabbedPane1.addTab(L.t("login.BMC_Setting"), this.BMCPane);
                            this.jTabbedPane1.addTab(L.t("login.Users"), this.UsersPane);
                        } else {
                            this.jTabbedPane1.addTab(L.t("login.BMC_Setting"), this.BMCPane20);
                            this.jTabbedPane1.addTab(L.t("login.Users"), this.UsersPane20);
                        }
                    }
                    if (this.Session.IPMIVersion == 0) {
                        if (this.CardName == null || this.CardName.compareTo("<unavailable>") == 0) {
                            this.xMessage.setText(L.t("login.Try_to_communicate_with") + " " + this.SIP);
                            this.getFWInfo("CARD_NAME", sResult);
                            this.CardName = sResult[0];
                        }
                        if (this.CardName.compareTo("SMC003") != 0 && this.Session.IPMIVersion == 0) {
                            this.jTabbedPane1.addTab(L.t("login.Text_Console"), this.TCRPane);
                        }
                    } else {
                        this.jTabbedPane1.addTab(L.t("login.Text_Console"), this.SOLPane20);
                    }
                    if (this.Session.IPMIVersion == 2) {
                        byte[] manufacturerID = this.getManufacturerID();
                        if (manufacturerID != null && manufacturerID[0] == -59 && manufacturerID[1] == 40 && manufacturerID[2] == 0) {
                            this.Session.isPeppercon = true;
                        }
                        this.Session.productID = this.getProductID();
                    }
                    if (!this.Session.isPeppercon && !IPMIView20.getInstance().DEBUG) break block19;
                    boolean showKVM = true;
                    if (this.Session.productID != null && this.Session.productID[0] == 19 && this.Session.productID[1] == 17) {
                        showKVM = false;
                    }
                    if (IPMIView20.getInstance().deviceStatus.getDeviceType(this.Session.SIP) == 3) {
                        showKVM = false;
                    }
                    if (showKVM) {
                        this.kvmPanel = new KVMPanel(this.Session.userID, new String(this.Session.UserPassword), this.Session.SIP);
                        this.jTabbedPane1.addTab(L.t("login.Video_Console"), this.kvmPanel);
                    }
                    showVM = true;
                    if (this.Session.MaxLevel[0] == 2) break block20;
                    if (this.Session.MaxLevel[0] == 5) break block20;
                    if (this.Session.MaxLevel[0] != 1) break block21;
                }
                showVM = false;
            }
            if (showVM) {
                this.virtualMedia = new VirtualMedia(this.SIP, this.UserID.getText(), new String(this.Password.getPassword()), this.Session.MaxLevel[0]);
                this.jTabbedPane1.addTab(L.t("login.Virtual_Media"), this.virtualMedia);
            }
        }
        TimerTask t = new TimerTask(){
            int count = 0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                block2: {
                    block4: {
                        block3: {
                            Logger.writeLog("Session.inUse = " + IPMISession.this.Session.inUse);
                            if (IPMISession.this.Session.inUse) break block2;
                            Logger.writeLog("keep Session Activate :" + this.count++);
                            GlobalDefine cfr_ignored_0 = IPMISession.this.gd;
                            if (IPMISession.this.Session.IPMIVersion == 0) break block3;
                            GlobalDefine cfr_ignored_1 = IPMISession.this.gd;
                            if (IPMISession.this.Session.IPMIVersion != 1) break block4;
                        }
                        IPMISession.this.SetSessionPrivilege();
                        return;
                    }
                    GlobalDefine cfr_ignored_2 = IPMISession.this.gd;
                    if (IPMISession.this.Session.IPMIVersion != 2) return;
                    Logger.writeLog("call GetSelInfo as keep Session");
                    int count = 0;
                    while (!IPMISession.this.GetSelInfo()) {
                        if (count++ != 10) continue;
                        this.cancel();
                        return;
                    }
                    return;
                }
                Logger.writeLog("Session.inUse = true , don't need keep session,count =" + this.count);
            }
        };
        this.keepSessionTimer = new Timer();
        this.keepSessionTimer.schedule(t, 0L, 15000L);
        ImageIcon gshutdownup = new ImageIcon(this.getClass().getResource("/images/link_good.gif"));
        this.jClock.setIcon(gshutdownup);
        this.jClock.setVisible(true);
        this.jLogout.setEnabled(true);
        this.jLogin.setEnabled(false);
        Cursor csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        this.Session.SIP = this.SIP;
        this.jLogout.setEnabled(true);
        this.jLogin.setEnabled(false);
        this.udpSocket.setIgnoreIOException(false);
        this.udpSocket.setRetry(true);
    }

    private boolean RMCPPing() {
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<Object> Para = new Vector<Object>(1);
        Object sResult = null;
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(null);
        this.rmcpPacket.RMCPSetup((byte)6, (byte)0, (byte)0, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.RMCPPong(this.udpSocket.recvBuf);
            if (this.rmcpPacket.compeletecode == -127) {
                this.Session.IncreaseSessionSeq();
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    private void sendDummyCommand() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        if (this.Session.checkbusy()) {
            return;
        }
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)47, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
            }
        }
        this.Session.releaselock();
    }

    public int checkIPMIVersion() {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        param[0] = -127;
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                byte[] byte3 = (byte[])this.rmcpPacket.retValue.get(1);
                byte[] byte4 = (byte[])this.rmcpPacket.retValue.get(2);
                byte[] byte5 = (byte[])this.rmcpPacket.retValue.get(3);
                byte[] byte6_8 = (byte[])this.rmcpPacket.retValue.get(4);
                byte[] byte9 = (byte[])this.rmcpPacket.retValue.get(5);
                byte ipmiVesion = byte5[0];
                if ((ipmiVesion & 2) == 2) {
                    if ((byte3[0] & 0x80) > 0) {
                        return 2;
                    }
                    return 1;
                }
                if (ipmiVesion == 0) {
                    return 0;
                }
            }
        }
        return 121;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSelInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)40, (byte)64, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSupermicroBMC() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)-64, (byte)11, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    this.Session.bmcManufactory = 1;
                    Logger.writeLog("BMC Card Manufactory = SUPERMICRO");
                    bResult = true;
                } else {
                    Logger.writeLog("BMC Card Manufactory = unknown");
                }
            } else {
                Logger.writeLog("BMC Card Manufactory = unknown");
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBIOS() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)-64, (byte)12, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    byte[] byte1 = (byte[])this.rmcpPlusPacket.retValue.get(0);
                    byte[] byte2 = (byte[])this.rmcpPlusPacket.retValue.get(1);
                    this.Session.bios = byte1[0];
                    this.Session.nic = byte2[0];
                    switch (this.Session.bios) {
                        case 2: {
                            Logger.writeLog("BIOS type = AMI");
                            break;
                        }
                        case 0: {
                            Logger.writeLog("BIOS type = Award");
                            break;
                        }
                        case 1: {
                            Logger.writeLog("BIOS type = Phoenix");
                        }
                    }
                    switch (this.Session.nic) {
                        case 1: {
                            Logger.writeLog("NIC type =  B5704");
                            break;
                        }
                        case 0: {
                            Logger.writeLog("NIC type = B5721");
                            break;
                        }
                        case 3: {
                            Logger.writeLog("NIC type = I82541");
                            break;
                        }
                        case 2: {
                            Logger.writeLog("NIC type = I82546");
                            break;
                        }
                        case 4: {
                            Logger.writeLog("NIC type = I82573");
                        }
                    }
                    bResult = true;
                } else {
                    Logger.writeLog("BIOS TYPE = unknown");
                    Logger.writeLog("NIC type = unknown");
                }
            } else {
                Logger.writeLog("BIOS TYPE = unknown");
                Logger.writeLog("NIC type = unknown");
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    public int checkIPMIVersionOld() {
        byte[] AuthType = new byte[]{0};
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[]{1, 1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        Para.addElement(AuthType);
        Para.addElement(SessionSeq);
        Para.addElement(SessionID);
        Para.addElement(param);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)56, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                byte[] temp = (byte[])this.rmcpPacket.retValue.get(3);
                byte ipmiVesion = temp[0];
                if ((ipmiVesion & 2) == 2) {
                    return 1;
                }
                if (ipmiVesion == 0) {
                    return 0;
                }
            }
        }
        return 121;
    }

    public void autoLogin() {
        int version = this.checkIPMIVersion();
        if (version == 1) {
            this.UserID.setText("ADMIN");
            this.Password.setText("ADMIN");
        } else {
            this.UserID.setText("ADMIN");
            this.Password.setText("ADMIN");
        }
        this.LoginButton();
    }

    private void jAutoLoginActionPerformed(ActionEvent evt) {
        this.autoLogin();
    }

    public void hideVersionMessageOnLoginScreen() {
        this.label.setVisible(false);
        this.cipherLabel.setVisible(false);
    }

    public void showVersionMessageOnLoginScreen() {
        String[] IPMIVersion2 = new String[]{"IPMI 1.5 (SUPERO BMCB)", "IPMI 2.0 non-RMCP+", "IPMI 2.0 RMCP+"};
        String[] authAlgorithm = new String[]{"RAKP-none", "RAKP-HMAC-SHA1", "RAKP-HMAC-MD5"};
        String[] integrityAlgorithm = new String[]{"None", "HMAC-SHA1-96", "HMAC-MD5-128", "MD5-128"};
        String[] confAlgorithm = new String[]{"None", "AES-CBC-128", "xRC4-128", "xRC4-40"};
        String message = L.t("login.Version") + " : ";
        String cipherMessage = L.t("login.Cipher_Suite") + " : ";
        message = message + IPMIVersion2[this.Session.IPMIVersion];
        if (this.Session.IPMIVersion == 2) {
            cipherMessage = cipherMessage + authAlgorithm[this.Session.cipherSuite.getAuthenticationAlgorithm()] + ", " + integrityAlgorithm[this.Session.cipherSuite.getIntegrityAlgorithm()] + ", " + confAlgorithm[this.Session.cipherSuite.getConfidentialityAlgorithm()];
        }
        this.label = new JLabel(message);
        this.label.setForeground(Color.blue);
        if (this.Session.IPMIVersion == 2) {
            this.cipherLabel = new JLabel(cipherMessage);
            this.cipherLabel.setForeground(Color.blue);
            this.jPanel2.add((Component)this.label, new AbsoluteConstraints(150, 400, 500, 70));
            this.jPanel2.add((Component)this.cipherLabel, new AbsoluteConstraints(150, 418, 500, 70));
        } else {
            this.jPanel2.add((Component)this.label, new AbsoluteConstraints(150, 400, 500, 70));
        }
        this.validate();
        this.invalidate();
        IPMIView20.getInstance().invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getManufacturerID() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        byte[] bytex = null;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)24, (byte)1, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    bytex = (byte[])this.rmcpPlusPacket.retValue.get(6);
                } else {
                    this.xMessage.setText(L.t("login.Get_Device_ID_failed"));
                }
            } else {
                this.xMessage.setText(L.t("login.Get_Device_ID_failed"));
            }
            this.Session.releaselock();
        }
        return bytex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getProductID() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        byte[] bytex = null;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)-64, (byte)33, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    bytex = (byte[])this.rmcpPlusPacket.retValue.get(0);
                }
            }
            this.Session.releaselock();
        }
        return bytex;
    }

    private byte findUserID(String username) {
        for (byte i = 2; i <= 10; i = (byte)(i + 1)) {
            String name = this.GetUserName(i);
            if (!username.equals(name)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String GetUserName(int UserID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        String xString = null;
        reqdata[0] = (byte)(UserID & 0x3F);
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            this.SIP = this.Session.SIP;
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)24, (byte)70, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    byte[] retData = (byte[])this.rmcpPlusPacket.retValue.get(0);
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    out.write(retData, 0, 16);
                    xString = out.toString().trim();
                }
            }
            this.Session.releaselock();
        }
        return xString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getUserPayloadAccess(byte userID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bReturn = false;
        byte[] reqdata = new byte[]{1, userID};
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(reqdata);
            this.SIP = this.Session.SIP;
            this.rmcpPlusPacket.RMCPSetup((byte)7, (byte)24, (byte)77, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPlusPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPlusPacket.compeletecode == 0) {
                    byte[] byte2 = (byte[])this.rmcpPlusPacket.retValue.get(0);
                    bReturn = (byte2[0] & 2) == 2;
                }
            }
            this.Session.releaselock();
        }
        return bReturn;
    }

    public static void main(String[] args) {
        IPMIView20.showLogo = false;
        IPMIView20 ipmiView20 = new IPMIView20();
        IPMIView20.instance = ipmiView20;
        IPMISession session = new IPMISession("test", "192.168.1.200", "description", null, null);
        int version = session.checkIPMIVersion();
        System.out.println("version =" + version);
    }
}

