/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.DeviceFile;
import IPMIView20.GlobalDefine;
import IPMIView20.JFanPanel;
import IPMIView20.JSensorPanel;
import IPMIView20.JTempPanel;
import IPMIView20.JVolPanel;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class Sensors
extends JPanel {
    boolean bLoaded = false;
    boolean refreshFlag = false;
    boolean priorDone = true;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    String hostname;
    JLabel Message;
    CSession Session;
    DeviceFile Devicefile;
    int TabId;
    UDPSocket udpSocket;
    int TotalEntries = 0;
    Timer timer;
    Vector sRecords = new Vector(10);
    JFanPanel[] FanPanel = new JFanPanel[20];
    JVolPanel[] VolPanel = new JVolPanel[20];
    JTempPanel[] TempPanel = new JTempPanel[20];
    JSensorPanel[] SensorPanel = new JSensorPanel[6];
    private JDesktopPane jDesktopPane1;
    private JInternalFrame FANFrame;
    private JPanel FANGroup;
    private JInternalFrame VOLFrame;
    private JPanel VOLGroup;
    private JInternalFrame SENSORFrame;
    private JPanel SENSORGroup;
    private JInternalFrame TEMPFrame;
    private JPanel TEMPGroup;
    private JPanel jPanel8;
    private JPanel jPanel1;
    private JLabel jRefreshLabel;
    private JComboBox jAutoTimer;
    private JLabel jTimerLabel;
    private JButton jManuRefresh;
    private JButton jSaveLayout;
    private JCheckBox jHideItem;
    private JCheckBox jHistoryItem;

    public Sensors() {
        this.initComponents();
        this.timer = new Timer();
        this.FANFrame.setVisible(false);
        this.VOLFrame.setVisible(false);
        this.TEMPFrame.setVisible(false);
        this.SENSORFrame.setVisible(false);
        this.FANFrame.setFrameIcon(null);
        this.VOLFrame.setFrameIcon(null);
        this.TEMPFrame.setFrameIcon(null);
        this.SENSORFrame.setFrameIcon(null);
        TimerTask t = new TimerTask(){

            public void run() {
                Thread th = new Thread(){

                    public void run() {
                        Sensors.this.jManuRefresh.setEnabled(false);
                        Sensors.this.RefreshSensors();
                        Sensors.this.jManuRefresh.setEnabled(true);
                    }
                };
                th.start();
            }
        };
        this.timer = new Timer();
        this.timer.schedule(t, 60000L, 60000L);
        this.jAutoTimer.addItem("10");
        this.jAutoTimer.addItem("20");
        this.jAutoTimer.addItem("30");
        this.jAutoTimer.addItem("45");
        this.jAutoTimer.addItem("60");
        this.jAutoTimer.addItem("90");
        this.jAutoTimer.addItem("120");
        this.jAutoTimer.setSelectedIndex(4);
    }

    public void preset(String Hostname, UDPSocket xSocket, CSession iSession, JLabel xMessage, DeviceFile xDevicefile) {
        this.hostname = Hostname;
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.Devicefile = xDevicefile;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void setRefreshFlag(boolean xFlag) {
        this.refreshFlag = xFlag;
    }

    public void showFrame() {
        Rectangle rPos = new Rectangle();
        String layposition = "";
        try {
            layposition = (String)this.Devicefile.getDevice(this.hostname).get(3);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            // empty catch block
        }
        if (layposition.length() > 0) {
            int x = layposition.indexOf(44);
            rPos.x = Integer.parseInt(layposition.substring(0, x));
            int y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.FANFrame.setBounds(rPos);
            String xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.FANFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.FANFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.FANFrame.setMaximum(false);
                    this.FANFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.VOLFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.VOLFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.VOLFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.VOLFrame.setMaximum(false);
                    this.VOLFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(124, x + 1);
            this.TEMPFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, y);
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.TEMPFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.TEMPFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.TEMPFrame.setMaximum(false);
                    this.TEMPFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.x = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.y = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.height = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            y = layposition.indexOf(44, x + 1);
            rPos.width = Integer.parseInt(layposition.substring(x + 1, y));
            x = y;
            this.SENSORFrame.setBounds(rPos);
            xtmp = layposition.substring(x + 1, layposition.length());
            if (xtmp.compareTo("1") == 0) {
                try {
                    this.SENSORFrame.setIcon(true);
                }
                catch (PropertyVetoException pe) {}
            } else if (xtmp.compareTo("2") == 0) {
                try {
                    this.SENSORFrame.setMaximum(true);
                }
                catch (PropertyVetoException pe) {}
            } else {
                try {
                    this.SENSORFrame.setMaximum(false);
                    this.SENSORFrame.setIcon(false);
                }
                catch (PropertyVetoException pe) {
                    // empty catch block
                }
            }
        }
        this.repaint();
    }

    private boolean GetSDRRepoInfo() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SDR Repository Info");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)32, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SDR Repository Info succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(1);
                this.TotalEntries = this.ByteToInt(bytex, 0, 2);
                bResult = true;
            } else {
                this.Message.setText("Get SDR Repository Info failed");
            }
        } else {
            this.Message.setText("Get SDR Repository Info failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    public void GetSensors() {
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = this.Session.Loading;
        this.GetSDRRepoInfo();
        if (this.TotalEntries > 0) {
            int i;
            this.sRecords.removeAllElements();
            while (!this.GetSDRRecords()) {
                this.sRecords.removeAllElements();
            }
            int VolIndex = 0;
            int FanIndex = 0;
            int TempIndex = 0;
            int SensorIndex = 0;
            this.TEMPGroup.removeAll();
            this.VOLGroup.removeAll();
            this.FANGroup.removeAll();
            this.SENSORGroup.removeAll();
            for (i = 0; i < this.sRecords.size(); ++i) {
                SensorRecord Sensor = (SensorRecord)this.sRecords.get(i);
                if (Sensor.SensorType == 1) {
                    this.TempPanel[TempIndex] = new JTempPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp);
                    this.TempPanel[TempIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Maximum, Sensor.valueString, Sensor.MaxString);
                    this.TEMPGroup.add(this.TempPanel[TempIndex]);
                    ++TempIndex;
                }
                if (Sensor.SensorType == 2) {
                    this.VolPanel[VolIndex] = new JVolPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp);
                    if (Sensor.Reading == 0) {
                        Sensor.valueString = new String("N/A");
                    }
                    this.VolPanel[VolIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Maximum, Sensor.Minimum, Sensor.valueString, Sensor.MaxString, Sensor.MinString);
                    this.VOLGroup.add(this.VolPanel[VolIndex]);
                    ++VolIndex;
                }
                if (Sensor.SensorType == 4) {
                    this.FanPanel[FanIndex] = new JFanPanel(Sensor.SensorNumber, Sensor.M, Sensor.B, Sensor.RExp, Sensor.BExp, Sensor.Linearization, this.Session);
                    if (Sensor.Reading == 0) {
                        Sensor.Reading = (byte)-1;
                    }
                    if (Sensor.Reading == -1) {
                        Sensor.valueString = new String("N/A");
                    }
                    this.FanPanel[FanIndex].init(Sensor.SensorName, Sensor.Reading, Sensor.Minimum, Sensor.valueString, Sensor.MinString);
                    this.FANGroup.add(this.FanPanel[FanIndex]);
                    ++FanIndex;
                }
                if (Sensor.SensorType != 5 && Sensor.SensorType != 8) continue;
                this.SensorPanel[SensorIndex] = new JSensorPanel(Sensor.SensorNumber, Sensor.SensorType);
                this.SensorPanel[SensorIndex].init(this.udpSocket, this.Session, this.Message, Sensor.Reading);
                this.SENSORGroup.add(this.SensorPanel[SensorIndex]);
                ++SensorIndex;
            }
            this.repaint();
            this.grabFocus();
            if (this.jHideItem.isSelected()) {
                for (i = 0; i < 20 && this.TempPanel[i] != null; ++i) {
                    if (this.TempPanel[i].tempMeter.m_ShowString.compareTo("0.0") != 0) continue;
                    this.TempPanel[i].setVisible(false);
                }
                for (i = 0; i < 20 && this.FanPanel[i] != null; ++i) {
                    if (this.FanPanel[i].fanMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.FanPanel[i].setVisible(false);
                }
                for (i = 0; i < 20 && this.VolPanel[i] != null; ++i) {
                    if (this.VolPanel[i].volMeter.m_ShowString.compareTo("N/A") != 0) continue;
                    this.VolPanel[i].setVisible(false);
                }
            } else {
                for (i = 0; i < 20 && this.TempPanel[i] != null; ++i) {
                    this.TempPanel[i].setVisible(true);
                }
                for (i = 0; i < 20 && this.FanPanel[i] != null; ++i) {
                    this.FanPanel[i].setVisible(true);
                }
                for (i = 0; i < 20 && this.VolPanel[i] != null; ++i) {
                    this.VolPanel[i].setVisible(true);
                }
            }
            this.FANFrame.setVisible(true);
            this.VOLFrame.setVisible(true);
            this.TEMPFrame.setVisible(true);
            if (SensorIndex > 0) {
                this.SENSORFrame.setVisible(true);
            } else {
                this.SENSORFrame.setVisible(false);
            }
            this.jRefreshLabel.setEnabled(true);
            this.jTimerLabel.setEnabled(true);
            this.jAutoTimer.setEnabled(true);
            this.jManuRefresh.setEnabled(true);
            this.jSaveLayout.setEnabled(true);
        }
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void RefreshSensors() {
        String valueString;
        int Value;
        int X;
        int BExp;
        int RExp;
        int B;
        int M;
        int i;
        byte[] bytey = new byte[256];
        if (!this.refreshFlag) {
            return;
        }
        if (!this.priorDone) {
            return;
        }
        this.Session.Loading = this.TabId;
        this.priorDone = false;
        this.Message.setText("Refreshing sensors' status");
        for (i = 0; i < 20 && this.FanPanel[i] != null; ++i) {
            this.GetSensor(this.FanPanel[i].SensorNumber, bytey);
            M = this.FanPanel[i].M;
            B = this.FanPanel[i].B;
            RExp = this.FanPanel[i].RExp;
            BExp = this.FanPanel[i].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            double rawx = ((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
            Value = this.FanPanel[i].Linearization == 7 ? (int)(1.0 / rawx) : (int)rawx;
            valueString = new String(Value + "");
            if (bytey[0] == 0) {
                bytey[0] = -1;
            }
            if (bytey[0] == -1) {
                valueString = "N/A";
            }
            this.FanPanel[i].updateValue(bytey[0], valueString);
        }
        for (i = 0; i < 20 && this.VolPanel[i] != null; ++i) {
            this.GetSensor(this.VolPanel[i].SensorNumber, bytey);
            M = this.VolPanel[i].M;
            B = this.VolPanel[i].B;
            RExp = this.VolPanel[i].RExp;
            BExp = this.VolPanel[i].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
            if (X == 0 || X == 255) {
                valueString = new String("N/A");
                bytey[0] = 0;
            } else {
                valueString = new String((double)Value / 100.0 + "");
            }
            this.VolPanel[i].updateValue(bytey[0], valueString);
        }
        for (i = 0; i < 20 && this.TempPanel[i] != null; ++i) {
            this.GetSensor(this.TempPanel[i].SensorNumber, bytey);
            M = this.TempPanel[i].M;
            B = this.TempPanel[i].B;
            RExp = this.TempPanel[i].RExp;
            BExp = this.TempPanel[i].BExp;
            X = this.ByteToInt(bytey, 0, 1);
            Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
            valueString = new String((double)Value / 100.0 + "");
            this.TempPanel[i].updateValue(bytey[0], valueString);
        }
        for (i = 0; i < 6 && this.SensorPanel[i] != null; ++i) {
            this.GetSensor(this.SensorPanel[i].SensorNumber, bytey);
            this.SensorPanel[i].updateValue(bytey[2]);
        }
        this.Message.setText("Refreshing sensors' status completed ");
        this.priorDone = true;
        this.Session.Loading = -1;
        this.repaint();
    }

    private boolean GetSensor(int SensorNum, byte[] byteResult) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] SNum = new byte[1];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        SNum[0] = (byte)SensorNum;
        Para.addElement(SNum);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting status of sensor number: " + SensorNum);
        this.rmcpPacket.RMCPSetup((byte)7, (byte)16, (byte)45, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecord(byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength) {
        byte[] AuthType = new byte[]{0};
        byte[] ByteToRead = new byte[]{-1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReserveID);
        Para.addElement(RecordID);
        Para.addElement(Offset);
        Para.addElement(ByteToRead);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)35, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, NextRecordID, 0, 2);
                bytex = (byte[])this.rmcpPacket.retValue.get(1);
                System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                retlength[0] = bytex.length;
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean ReserveSDR(byte[] ReserveID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.removeAllElements();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)34, (byte)0, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, ReserveID, 0, 2);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecords() {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        boolean EndE = false;
        int ArrayNum = 9;
        Vector Para = new Vector(1);
        boolean bResult = false;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        StartE = 0;
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(ReserveID)) {
            int i = StartE;
            do {
                bResult = false;
                this.Message.setText("Getting SDR Record: " + i);
                Offset[0] = 0;
                if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx)) {
                    SensorRecord sensorR = new SensorRecord();
                    this.Message.setText("Get SDR Record: " + i + " succeeded");
                    if (bytex[3] == 1) {
                        int Value;
                        int BExp;
                        int RExp;
                        int B;
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        this.GetSensor(sensorR.SensorNumber, bytey);
                        int X = this.ByteToInt(bytey, 0, 1);
                        sensorR.Reading = sensorR.SensorType == 5 || sensorR.SensorType == 8 ? bytey[2] : bytey[0];
                        for (int totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText("Get SDR Record: " + i + " failed");
                            break;
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        strout.write(bytex, 48, bytex[47] & 0x1F);
                        sensorR.SensorName = strout.toString();
                        sensorR.Maximum = bytex[32];
                        sensorR.Minimum = bytex[33];
                        int Linear = bytex[23] & 0x7F;
                        int M = (bytex[25] & 0xC0) * 4 + (bytex[24] & 0xFF);
                        if (M >= 512) {
                            M = -(512 - (M & 0x1FF));
                        }
                        if ((B = (bytex[27] & 0xC0) * 4 + (bytex[26] & 0xFF)) >= 512) {
                            B = -(512 - (B & 0x1FF));
                        }
                        if ((RExp = (bytex[29] & 0xF0) >> 4) >= 8) {
                            RExp = -(8 - (RExp & 7));
                        }
                        if ((BExp = bytex[29] & 0xF) >= 8) {
                            BExp = -(8 - (BExp & 7));
                        }
                        if (sensorR.SensorType == 4) {
                            if (Linear == 7) {
                                double rawx = ((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.valueString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 32, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MaxString = new String(Value + "");
                                rawx = ((double)(M * this.ByteToInt(bytex, 33, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp);
                                Value = (int)(1.0 / rawx);
                                sensorR.MinString = new String(Value + "");
                            } else {
                                Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.valueString = new String(Value + "");
                                Value = (int)(((double)(M * this.ByteToInt(bytex, 32, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MaxString = new String(Value + "");
                                Value = (int)(((double)(M * this.ByteToInt(bytex, 33, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp));
                                sensorR.MinString = new String(Value + "");
                            }
                        } else {
                            Value = (int)(((double)(M * X) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.valueString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M * this.ByteToInt(bytex, 32, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MaxString = new String((double)Value / 100.0 + "");
                            Value = (int)(((double)(M * this.ByteToInt(bytex, 33, 1)) + (double)B * Math.pow(10.0, BExp)) * Math.pow(10.0, RExp) * 100.0);
                            sensorR.MinString = new String((double)Value / 100.0 + "");
                        }
                        sensorR.Linearization = Linear;
                        sensorR.M = M;
                        sensorR.B = B;
                        sensorR.RExp = RExp;
                        sensorR.BExp = BExp;
                        this.sRecords.addElement(sensorR);
                    }
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText("Get SDR Record: " + i + " failed");
            } while (bResult && this.ByteToInt(RecordID, 0, 2) != 65535 && ++i < this.TotalEntries);
        }
        if (this.ByteToInt(RecordID, 0, 2) == 65535) {
            this.Message.setText("Get SDR Record is successful");
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            return bResult;
        }
        this.Message.setText("Get SDR Record is failed");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return bResult;
    }

    private void initComponents() {
        this.jDesktopPane1 = new JDesktopPane();
        this.FANFrame = new JInternalFrame();
        this.FANGroup = new JPanel();
        this.VOLFrame = new JInternalFrame();
        this.VOLGroup = new JPanel();
        this.SENSORFrame = new JInternalFrame();
        this.SENSORGroup = new JPanel();
        this.TEMPFrame = new JInternalFrame();
        this.TEMPGroup = new JPanel();
        this.jPanel8 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jRefreshLabel = new JLabel();
        this.jAutoTimer = new JComboBox();
        this.jTimerLabel = new JLabel();
        this.jManuRefresh = new JButton();
        this.jSaveLayout = new JButton();
        this.jHideItem = new JCheckBox();
        this.jHistoryItem = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.jDesktopPane1.setBorder(new EtchedBorder());
        this.FANFrame.setMaximizable(true);
        this.FANFrame.setTitle("Fans");
        this.FANFrame.setIconifiable(true);
        this.FANFrame.setForeground(Color.black);
        this.FANFrame.setResizable(true);
        this.FANFrame.setVisible(true);
        this.FANFrame.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sensors.this.FANFrameFocusGained(evt);
            }
        });
        this.FANFrame.getContentPane().add((Component)this.FANGroup, "Center");
        this.jDesktopPane1.add((Component)this.FANFrame, JLayeredPane.DEFAULT_LAYER);
        this.FANFrame.setBounds(0, 0, 380, 190);
        this.VOLFrame.setMaximizable(true);
        this.VOLFrame.setTitle("Voltages");
        this.VOLFrame.setIconifiable(true);
        this.VOLFrame.setForeground(Color.black);
        this.VOLFrame.setResizable(true);
        this.VOLFrame.setVisible(true);
        this.VOLFrame.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sensors.this.VOLFrameFocusGained(evt);
            }
        });
        this.VOLFrame.getContentPane().add((Component)this.VOLGroup, "Center");
        this.jDesktopPane1.add((Component)this.VOLFrame, JLayeredPane.DEFAULT_LAYER);
        this.VOLFrame.setBounds(380, 0, 250, 240);
        this.SENSORFrame.setMaximizable(true);
        this.SENSORFrame.setTitle("Sensors");
        this.SENSORFrame.setIconifiable(true);
        this.SENSORFrame.setResizable(true);
        this.SENSORFrame.setVisible(true);
        this.SENSORFrame.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sensors.this.SENSORFrameFocusGained(evt);
            }
        });
        this.SENSORFrame.getContentPane().add((Component)this.SENSORGroup, "Center");
        this.jDesktopPane1.add((Component)this.SENSORFrame, JLayeredPane.DEFAULT_LAYER);
        this.SENSORFrame.setBounds(370, 250, 260, 150);
        this.TEMPFrame.setMaximizable(true);
        this.TEMPFrame.setTitle("Temperatures");
        this.TEMPFrame.setIconifiable(true);
        this.TEMPFrame.setResizable(true);
        this.TEMPFrame.setVisible(true);
        this.TEMPFrame.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                Sensors.this.TEMPFrameFocusGained(evt);
            }
        });
        this.TEMPFrame.getContentPane().add((Component)this.TEMPGroup, "Center");
        this.jDesktopPane1.add((Component)this.TEMPFrame, JLayeredPane.DEFAULT_LAYER);
        this.TEMPFrame.setBounds(0, 190, 260, 210);
        this.add((Component)this.jDesktopPane1, "Center");
        this.jPanel8.setEnabled(false);
        this.jPanel1.setBorder(new EtchedBorder());
        this.jRefreshLabel.setText("Refresh every");
        this.jRefreshLabel.setForeground(Color.black);
        this.jRefreshLabel.setEnabled(false);
        this.jPanel1.add(this.jRefreshLabel);
        this.jAutoTimer.setPreferredSize(new Dimension(50, 26));
        this.jAutoTimer.setEnabled(false);
        this.jAutoTimer.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sensors.this.jAutoTimerItemStateChanged(evt);
            }
        });
        this.jPanel1.add(this.jAutoTimer);
        this.jTimerLabel.setText("seconds");
        this.jTimerLabel.setForeground(Color.black);
        this.jTimerLabel.setEnabled(false);
        this.jPanel1.add(this.jTimerLabel);
        this.jManuRefresh.setText("Refresh Now");
        this.jManuRefresh.setEnabled(false);
        this.jManuRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sensors.this.jManuRefreshActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jManuRefresh);
        this.jPanel8.add(this.jPanel1);
        this.jSaveLayout.setText("Save Layout");
        this.jSaveLayout.setEnabled(false);
        this.jSaveLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Sensors.this.jSaveLayoutActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jSaveLayout);
        this.jHideItem.setSelected(true);
        this.jHideItem.setText("Hide inactive item");
        this.jHideItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sensors.this.jHideItemItemStateChanged(evt);
            }
        });
        this.jHistoryItem.setSelected(false);
        this.jHistoryItem.setText("Show History");
        this.jHistoryItem.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                Sensors.this.jHistoryItemItemStateChanged(evt);
            }
        });
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayout(2, 1));
        jPanel9.add(this.jHideItem);
        jPanel9.add(this.jHistoryItem);
        this.jPanel8.add(jPanel9);
        this.add((Component)this.jPanel8, "South");
    }

    private void SENSORFrameFocusGained(FocusEvent evt) {
        this.SENSORFrame.moveToFront();
    }

    private void TEMPFrameFocusGained(FocusEvent evt) {
        this.TEMPFrame.moveToFront();
    }

    private void VOLFrameFocusGained(FocusEvent evt) {
        this.VOLFrame.moveToFront();
    }

    private void FANFrameFocusGained(FocusEvent evt) {
        this.FANFrame.moveToFront();
    }

    private void jSaveLayoutActionPerformed(ActionEvent evt) {
        String xstr;
        Rectangle FANp = this.FANFrame.getNormalBounds();
        String ystr = this.FANFrame.isMaximum() ? "2" : (this.FANFrame.isIcon() ? "1" : "0");
        String totalstr = xstr = FANp.x + "," + FANp.y + "," + FANp.height + "," + FANp.width + "," + ystr;
        Rectangle VOLp = this.VOLFrame.getNormalBounds();
        ystr = this.VOLFrame.isMaximum() ? "2" : (this.VOLFrame.isIcon() ? "1" : "0");
        xstr = VOLp.x + "," + VOLp.y + "," + VOLp.height + "," + VOLp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle TEMPp = this.TEMPFrame.getNormalBounds();
        ystr = this.TEMPFrame.isMaximum() ? "2" : (this.TEMPFrame.isIcon() ? "1" : "0");
        xstr = TEMPp.x + "," + TEMPp.y + "," + TEMPp.height + "," + TEMPp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        Rectangle SNRp = this.SENSORFrame.getNormalBounds();
        ystr = this.SENSORFrame.isMaximum() ? "2" : (this.SENSORFrame.isIcon() ? "1" : "0");
        xstr = SNRp.x + "," + SNRp.y + "," + SNRp.height + "," + SNRp.width + "," + ystr;
        totalstr = totalstr + "|" + xstr;
        this.Devicefile.SaveLayoutToFile("IPMIView", this.hostname, totalstr);
        this.Message.setText("Configuration saved");
    }

    private void jHideItemItemStateChanged(ItemEvent evt) {
        if (this.jHideItem.isSelected()) {
            int i;
            for (i = 0; i < 20; ++i) {
                if (this.TempPanel[i] == null) continue;
                if (this.TempPanel[i].tempMeter.m_ShowString.compareTo("0.0") == 0) {
                    this.TempPanel[i].setVisible(false);
                    continue;
                }
                this.TempPanel[i].setVisible(true);
            }
            for (i = 0; i < 20; ++i) {
                if (this.FanPanel[i] == null) continue;
                if (this.FanPanel[i].fanMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.FanPanel[i].setVisible(false);
                    continue;
                }
                this.FanPanel[i].setVisible(true);
            }
            for (i = 0; i < 20; ++i) {
                if (this.VolPanel[i] == null) continue;
                if (this.VolPanel[i].volMeter.m_ShowString.compareTo("N/A") == 0) {
                    this.VolPanel[i].setVisible(false);
                    continue;
                }
                this.VolPanel[i].setVisible(true);
            }
        } else {
            int i;
            for (i = 0; i < 20; ++i) {
                if (this.TempPanel[i] == null || this.TempPanel[i].isVisible()) continue;
                this.TempPanel[i].setVisible(true);
            }
            for (i = 0; i < 20; ++i) {
                if (this.FanPanel[i] == null || this.FanPanel[i].isVisible()) continue;
                this.FanPanel[i].setVisible(true);
            }
            for (i = 0; i < 20; ++i) {
                if (this.VolPanel[i] == null || this.VolPanel[i].isVisible()) continue;
                this.VolPanel[i].setVisible(true);
            }
        }
    }

    private void jHistoryItemItemStateChanged(ItemEvent evt) {
        if (this.jHistoryItem.isSelected()) {
            int i;
            for (i = 0; i < 20; ++i) {
                if (this.FanPanel[i] == null) continue;
                this.FanPanel[i].showHistory();
                this.FanPanel[i].invalidate();
            }
            for (i = 0; i < 20; ++i) {
                if (this.VolPanel[i] == null) continue;
                this.VolPanel[i].showHistory();
                this.VolPanel[i].invalidate();
            }
            for (i = 0; i < 20; ++i) {
                if (this.TempPanel[i] == null) continue;
                this.TempPanel[i].showHistory();
                this.TempPanel[i].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x + 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x + 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x + 1, p.y);
        } else {
            int i;
            for (i = 0; i < 20; ++i) {
                if (this.FanPanel[i] == null) continue;
                this.FanPanel[i].showMeter();
                this.FanPanel[i].invalidate();
            }
            for (i = 0; i < 20; ++i) {
                if (this.VolPanel[i] == null) continue;
                this.VolPanel[i].showMeter();
                this.VolPanel[i].invalidate();
            }
            for (i = 0; i < 20; ++i) {
                if (this.TempPanel[i] == null) continue;
                this.TempPanel[i].showMeter();
                this.TempPanel[i].invalidate();
            }
            Point p = this.FANFrame.getLocation();
            this.FANFrame.setLocation(p.x - 1, p.y);
            p = this.VOLFrame.getLocation();
            this.VOLFrame.setLocation(p.x - 1, p.y);
            p = this.TEMPFrame.getLocation();
            this.TEMPFrame.setLocation(p.x - 1, p.y);
        }
        this.validate();
        this.invalidate();
    }

    private void jAutoTimerItemStateChanged(ItemEvent evt) {
        if (this.refreshFlag) {
            String x = (String)this.jAutoTimer.getSelectedItem();
            int xx = Integer.parseInt(x);
            TimerTask t = new TimerTask(){

                public void run() {
                    Thread th = new Thread(){

                        public void run() {
                            Sensors.this.jManuRefresh.setEnabled(false);
                            Sensors.this.RefreshSensors();
                            Sensors.this.jManuRefresh.setEnabled(true);
                        }
                    };
                    th.start();
                }
            };
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule(t, xx * 1000, (long)(xx * 1000));
        }
    }

    private void jManuRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                Sensors.this.setCursor(csrTemp);
                Sensors.this.jManuRefresh.setEnabled(false);
                Sensors.this.RefreshSensors();
                Sensors.this.jManuRefresh.setEnabled(true);
                csrTemp = new Cursor(0);
                Sensors.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    class SensorRecord {
        int SensorNumber;
        int SensorType;
        byte Reading;
        byte Maximum;
        byte Minimum;
        String valueString;
        String MaxString;
        String MinString;
        String SensorName;
        byte UpperLimit;
        byte LowerLimit;
        int Linearization;
        int M;
        int B;
        int RExp;
        int BExp;

        SensorRecord() {
        }
    }
}

