/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.Logger;
import IPMIView20.UOLDebug;
import IPMIView20.UOLImageFile;
import IPMIView20.UOLMessage;
import IPMIView20.UOLOutputInterface;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPSocket;
import IPMIView20.UOL_UFIMessageHandler;
import IPMIView20.uol.UOLPacketSender;
import IPMIView20.uol.UOLStorage;

public class UOLMessageHandler {
    UOLSession session;
    UOLUDPSocket udpSocket;
    UOL_UFIMessageHandler ufiMessageHandler;
    UOLOutputInterface output = null;
    UOLImageFile file;
    UOLStorage uolStorage;
    UOLPacketSender uolPacketSender;
    UOLMessage sentUOLMessage = null;

    public UOLMessageHandler(UOLSession session, UOLUDPSocket udpSocket, UOLImageFile file, UOLOutputInterface output, UOLStorage uolStorage, UOLPacketSender uolPacketSender) {
        this.session = session;
        this.udpSocket = udpSocket;
        this.file = file;
        this.output = output;
        this.uolStorage = uolStorage;
        this.uolPacketSender = uolPacketSender;
        this.ufiMessageHandler = new UOL_UFIMessageHandler(session, udpSocket, file, output, uolStorage);
    }

    public void processReply(UOLMessage message) {
        Logger.writeLog("Reply Seq =" + UOL_UFIMessageHandler.byteToString(message.getPacketSequenceNumber()));
        if (this.uolStorage.getCurrentPacketSequence() == message.getPacketSequenceNumber()) {
            this.uolStorage.allowGet();
        }
        if ((message.getState() & 0xF0) == 32) {
            this.ufiMessageHandler.processReply(message);
        } else {
            this.unCheckNeedResend();
        }
    }

    public void process(UOLMessage message) {
        String stateStr = "";
        int aMessageType = message.getState() & 0xF0;
        int aState = message.getState() & 0xF;
        if (aMessageType == 16) {
            switch (message.getData()[0]) {
                case 1: {
                    this.UOLCommandGetDescriptor(message);
                    break;
                }
                case 2: {
                    this.UOLCommandGetStringDescriptor(message);
                    break;
                }
                case 3: {
                    this.UOLCommandDescriptionNotification(message);
                    break;
                }
                case 4: {
                    this.UOLCommandSetupSession(message);
                    break;
                }
                case 5: {
                    this.UOLCommandKeepConnection(message);
                    break;
                }
                case 10: {
                    this.UOLCommandSendDefaultControlPipeData(message);
                }
            }
        } else {
            this.replyACK(message);
        }
    }

    public void UOLCommandGetDescriptor(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{1, -1, 0, 18, 1, 2, 0, 0, 0, 0, 8, -18, 3, 1, 105, 0, 1, 1, 2, 0, 1, 9, 2, 39, 0, 1, 1, 0, -128, -6, 9, 4, 0, 0, 3, 8, 4, 0, 0, 7, 5, -127, 2, 64, 0, 0, 1, 1, 7, 5, 2, 2, 64, 0, 0, 1, 1, 7, 5, -125, 3, 2, 0, -1, 1, 1};
        message.setData(data);
        message.setDataSize(data.length);
        this.udpSocket.sendPacket(message.toByteArray());
        this.checkNeedResend(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UOLCommandGetStringDescriptor(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{2, -1, 0, 4, 3, 9, 4, 16, 3, 79, 0, 83, 0, 65, 0, 32, 0, 85, 0, 79, 0, 76, 0, 30, 3, 86, 0, 105, 0, 114, 0, 116, 0, 117, 0, 97, 0, 108, 0, 32, 0, 70, 0, 108, 0, 111, 0, 112, 0, 112, 0, 121, 0, 16, 3, 79, 0, 83, 0, 65, 0, 32, 0, 85, 0, 79, 0, 76, 0};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            this.session.incSequence();
            message.setPacketSequenceNumber(this.session.getPacketSequence());
            message.setData(data);
            message.setDataSize(data.length);
            this.udpSocket.sendPacket(message.toByteArray());
        }
        this.checkNeedResend(message);
    }

    public void UOLCommandDescriptionNotification(UOLMessage message) {
        this.replyACK(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void UOLCommandSetupSession(UOLMessage message) {
        this.replyACK(message);
        byte[] data = new byte[]{4, -1, 0};
        UOLSession uOLSession = this.session;
        synchronized (uOLSession) {
            this.session.incSequence();
            message.setPacketSequenceNumber(this.session.getPacketSequence());
            message.setData(data);
            message.setDataSize(data.length);
            this.udpSocket.sendPacket(message.toByteArray());
            this.session.setState((byte)2);
            if (this.output != null) {
                this.output.outputLog("Connect Successful ");
                Thread th = new Thread(){

                    public void run() {
                        UOLMessageHandler.this.output.connectSuccessful();
                    }
                };
                th.start();
            }
        }
        this.checkNeedResend(message);
    }

    public void UOLCommandKeepConnection(UOLMessage message) {
        this.replyACK(message);
        if (this.session.isSendKeepSession()) {
            byte seq = 0;
            seq = this.session.getKeepSessionPacketSequence() == -1 ? this.session.incSequence() : this.session.incKeepSessionSequence();
            this.session.setSendKeepSession(false);
            if (UOLDebug.debugLevel == 1) {
                Logger.writeLog("Keep Session Command Reply. We can inc Seq to " + Integer.toHexString(seq));
            }
        } else if (UOLDebug.debugLevel == 1) {
            Logger.writeLog("A Keep Session Command Singlely from BMC. Just ACK it");
        }
    }

    public void UOLCommandSendDefaultControlPipeData(UOLMessage message) {
        this.ufiMessageHandler.process(message);
    }

    public void unCheckNeedResend() {
        this.sentUOLMessage = null;
    }

    public void checkNeedResend(UOLMessage uolMessage) {
        this.sentUOLMessage = uolMessage;
        Thread th = new Thread(){

            public void run() {
                UOLMessage storedUOLMessage = UOLMessageHandler.this.sentUOLMessage;
                int count = 0;
                while (storedUOLMessage == UOLMessageHandler.this.sentUOLMessage) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (storedUOLMessage == UOLMessageHandler.this.sentUOLMessage) {
                        Logger.writeLog("Timeout(UOLMessageHandler). resend it");
                        if (storedUOLMessage != null) {
                            UOLMessageHandler.this.udpSocket.sendPacket(storedUOLMessage.toByteArray());
                        }
                    }
                    if (count++ != 3) continue;
                    break;
                }
            }
        };
        th.start();
    }

    public void replyACK(UOLMessage message) {
        UOLMessage reply = message.replyACKOnlyMessage();
        reply.setState((byte)((byte)(reply.getState() & 0xF0) | this.session.getState()));
        this.udpSocket.sendPacket(reply.toByteArray());
    }
}

