/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ExampleFileFilter;
import IPMIView20.IPMISession;
import IPMIView20.UOLFrame;
import IPMIView20.UOLImageFile;
import IPMIView20.UOLMessage;
import IPMIView20.UOLMessageFactory;
import IPMIView20.UOLOutputInterface;
import IPMIView20.UOLOutputPanel;
import IPMIView20.UOLPanel_disconnectButton_actionAdapter;
import IPMIView20.UOLPanel_helpButton_actionAdapter;
import IPMIView20.UOLSession;
import IPMIView20.UOLUDPHandler;
import IPMIView20.UOLUDPSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class UOLPanel
extends JPanel
implements UOLOutputInterface {
    TitledBorder titledBorder1;
    JLabel jLabel1 = new JLabel();
    JTextField imageFileNameTextField = new JTextField();
    JButton loadButton = new JButton();
    JButton connectButton = new JButton();
    JButton disconnectButton = new JButton();
    JTextField uolTextField = new JTextField();
    JLabel jLabel2 = new JLabel();
    private boolean isConnecting = false;
    private boolean isConnectSuccessful = false;
    private boolean isGracefulPowerControlSuccessful = false;
    JTextField ipTextField = new JTextField();
    JLabel ipLabel = new JLabel();
    private boolean standAlone;
    JButton helpButton = new JButton();
    JFileChooser chooser;
    String ip;
    String imageFile;
    IPMISession ipmiSession;
    UOLUDPHandler handler = null;
    JRadioButton gracefulPowerCycleRadioButton = new JRadioButton("Graceful Power Cycle");
    JRadioButton gracefulResetRadioButton = new JRadioButton("Graceful Reboot");
    JRadioButton powerCycleRadioButton = new JRadioButton("Power Cycle");
    JRadioButton resetRadioButton = new JRadioButton("Reset");
    JRadioButton powerUpRadioButton = new JRadioButton("Power Up");
    ButtonGroup bg = new ButtonGroup();
    JCheckBox check1 = new JCheckBox("If Graceful Reset or Graceful Power Cycle were failed, Use Power Reset instead");
    JCheckBox check2 = new JCheckBox("Go to Text Console when the managed system is booting");
    JCheckBox check3 = new JCheckBox("Show UOL status message on Text Console page");
    boolean isStopPressed = false;
    UOLOutputPanel outputPanel = new UOLOutputPanel();

    public UOLPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public UOLPanel(String ip) {
        this.ip = ip;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jbInit() throws Exception {
        this.chooser = new JFileChooser();
        this.titledBorder1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Remote Boot (USB Over LAN)", 0, 2, new Font("default", 0, 11), Color.BLUE);
        this.jLabel1.setRequestFocusEnabled(true);
        this.jLabel1.setVerifyInputWhenFocusTarget(true);
        this.jLabel1.setText("Bootable Image File Name:");
        this.jLabel1.setBounds(new Rectangle(13, 19, 193, 17));
        this.setFont(new Font("Microsoft Sans Serif", 0, 10));
        this.setForeground(Color.black);
        this.setBorder(this.titledBorder1);
        this.setLayout(null);
        this.imageFileNameTextField.setEnabled(true);
        this.imageFileNameTextField.setAlignmentY(0.5f);
        this.imageFileNameTextField.setEditable(false);
        this.imageFileNameTextField.setText("");
        this.imageFileNameTextField.setBounds(new Rectangle(14, 37, 237, 24));
        this.loadButton.setBounds(new Rectangle(260, 36, 60, 25));
        this.loadButton.setVerifyInputWhenFocusTarget(true);
        this.loadButton.setMargin(new Insets(1, 1, 1, 1));
        this.loadButton.setText("Load");
        this.loadButton.addActionListener(new UOLPanel_loadButton_actionAdapter(this));
        this.connectButton.setBounds(new Rectangle(371, 36, 77, 25));
        this.connectButton.setEnabled(false);
        this.connectButton.setVerifyInputWhenFocusTarget(true);
        this.connectButton.setMargin(new Insets(1, 1, 1, 1));
        this.connectButton.setText("Remote Boot");
        this.connectButton.addActionListener(new UOLPanel_connectButton_actionAdapter(this));
        this.disconnectButton.setBounds(new Rectangle(449, 36, 82, 25));
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.setVerifyInputWhenFocusTarget(true);
        this.disconnectButton.setMargin(new Insets(1, 1, 1, 1));
        this.disconnectButton.setText("Stop");
        this.disconnectButton.addActionListener(new UOLPanel_disconnectButton_actionAdapter(this));
        this.uolTextField.setEditable(false);
        this.uolTextField.setText("");
        this.uolTextField.setBounds(new Rectangle(12, 85, 518, 22));
        this.jLabel2.setText("Status:");
        this.jLabel2.setBounds(new Rectangle(12, 67, 34, 17));
        this.ipTextField.setText("");
        this.ipTextField.setBounds(new Rectangle(435, 13, 94, 19));
        this.ipLabel.setToolTipText("");
        this.ipLabel.setText("IP Address:");
        this.ipLabel.setBounds(new Rectangle(372, 15, 65, 17));
        this.helpButton.setBounds(new Rectangle(450, 61, 80, 23));
        this.helpButton.setText("Help");
        this.helpButton.addActionListener(new UOLPanel_helpButton_actionAdapter(this));
        this.add((Component)this.imageFileNameTextField, null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.uolTextField, null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.loadButton, null);
        this.add((Component)this.disconnectButton, null);
        this.add((Component)this.connectButton, null);
        this.add((Component)this.ipTextField, null);
        this.add((Component)this.ipLabel, null);
        this.add((Component)this.helpButton, null);
        this.ipLabel.setVisible(false);
        this.ipTextField.setVisible(false);
    }

    public void connectButton_actionPerformed(ActionEvent e) {
        Thread th = new Thread(){

            public void run() {
                UOLPanel.this.connectButton();
            }
        };
        th.start();
    }

    private void connectButton() {
        int dialogResult = 0;
        this.isConnecting = true;
        if (!this.standAlone) {
            this.ipmiSession.IPMDevicePane20.jRefreshActionPerformed(null);
            dialogResult = this.remoteBootDialog();
            if (dialogResult != 0) {
                return;
            }
        }
        this.connect();
        this.checkConnectTimeout();
    }

    private void checkConnectTimeout() {
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(15000L);
                    if (!UOLPanel.this.isConnectSuccessful && UOLPanel.this.isConnecting) {
                        UOLPanel.this.showConnectTimeout();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        th.start();
    }

    private void checkGracefulPowerControlTimeout() {
        Thread th = new Thread(){

            public void run() {
                try {
                    Thread.sleep(120000L);
                    if (UOLPanel.this.isConnectSuccessful && !UOLPanel.this.isGracefulPowerControlSuccessful) {
                        UOLPanel.this.showConnectTimeout();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        th.start();
    }

    public void showConnectTimeout() {
        JOptionPane.showMessageDialog(this, "Connect timeout", "Timeout", 0);
        this.disconnectButton_actionPerformed(null);
    }

    public int remoteBootDialog() {
        Object[] message = new Object[12];
        String[] options = new String[]{"Yes", "No"};
        this.bg.add(this.gracefulPowerCycleRadioButton);
        this.bg.add(this.gracefulResetRadioButton);
        this.bg.add(this.powerCycleRadioButton);
        this.bg.add(this.resetRadioButton);
        this.bg.add(this.powerUpRadioButton);
        if (this.ipmiSession.IPMDevicePane20.isPowerOn) {
            this.resetRadioButton.setSelected(true);
            this.gracefulPowerCycleRadioButton.setEnabled(true);
            this.gracefulResetRadioButton.setEnabled(true);
            this.powerCycleRadioButton.setEnabled(true);
            this.resetRadioButton.setEnabled(true);
            this.powerUpRadioButton.setEnabled(false);
        } else {
            this.powerUpRadioButton.setSelected(true);
            this.gracefulPowerCycleRadioButton.setEnabled(false);
            this.gracefulResetRadioButton.setEnabled(false);
            this.powerCycleRadioButton.setEnabled(false);
            this.resetRadioButton.setEnabled(false);
            this.powerUpRadioButton.setEnabled(true);
        }
        this.check1.setSelected(false);
        this.check1.setEnabled(false);
        this.check2.setSelected(true);
        this.check3.setSelected(true);
        message[0] = "The managed system is power " + (this.ipmiSession.IPMDevicePane20.isPowerOn ? "on" : "off") + " now." + "\nRemote Boot is going to reboot the managed system. Which power control would you like to do?";
        message[1] = this.gracefulPowerCycleRadioButton;
        message[2] = this.gracefulResetRadioButton;
        message[3] = this.powerCycleRadioButton;
        message[4] = this.resetRadioButton;
        message[5] = this.powerUpRadioButton;
        message[6] = " ";
        message[7] = " ";
        message[8] = "Additional Option:";
        message[9] = this.check2;
        message[10] = this.check3;
        message[11] = "The managed system will boot from your \"" + this.imageFileNameTextField.getText() + "\" image file. Press Yes to start";
        int result = JOptionPane.showOptionDialog(this, message, "Remote Boot", 0, 1, null, null, null);
        return result;
    }

    public void changeToSOL() {
        int tabIndex = this.ipmiSession.jTabbedPane1.indexOfTab("Text Console");
        this.ipmiSession.jTabbedPane1.setSelectedIndex(tabIndex);
        this.ipmiSession.changeTabtoSOL();
        if (!this.ipmiSession.SOLPane20.TCRunning) {
            this.ipmiSession.SOLPane20.startSOL();
        }
    }

    private void connect() {
        if (this.standAlone) {
            this.ip = this.ipTextField.getText();
            if (this.ip == null || this.ip.length() == 0) {
                JOptionPane.showMessageDialog(this, "Please input IP address of remote managed system");
                return;
            }
        }
        this.isConnectSuccessful = false;
        this.isGracefulPowerControlSuccessful = false;
        UOLSession uolSession = new UOLSession();
        UOLMessage uolMessage = UOLMessageFactory.establishConnectionMessage();
        UOLUDPSocket udp = new UOLUDPSocket(this.ip);
        if (!udp.isInitialize) {
            JOptionPane.showMessageDialog(this, "IP address Invalid");
            return;
        }
        UOLImageFile file = new UOLImageFile();
        file.load(this.imageFile);
        try {
            this.handler = new UOLUDPHandler(this.ip, 664, udp, uolSession, file, this);
            this.handler.start();
            this.outputLog("Connect to " + this.ip + " ...");
            boolean result = udp.sendPacket(uolMessage.toByteArray());
        }
        catch (Exception ex) {
            this.outputLog("Can't connect to " + this.ip);
            this.handler.stopHandler();
            udp.socket.disconnect();
            udp.socket.close();
            return;
        }
        this.connectButton.setEnabled(false);
        this.loadButton.setEnabled(false);
        this.disconnectButton.setEnabled(true);
    }

    void disconnectButton_actionPerformed(ActionEvent e) {
        this.handler.stopUOL();
        this.isConnecting = false;
        this.isConnectSuccessful = false;
        this.connectButton.setEnabled(true);
        this.loadButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
    }

    void loadButton_actionPerformed(ActionEvent e) {
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("img");
        filter.setDescription("1.44M Disk Image file");
        this.chooser.setFileFilter(filter);
        int returnVal = this.chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.imageFileNameTextField.setText(this.chooser.getSelectedFile().getName());
            this.connectButton.setEnabled(true);
            this.disconnectButton.setEnabled(false);
            Thread th = new Thread(){

                public void run() {
                    UOLPanel.this.imageFile = UOLPanel.this.chooser.getSelectedFile().getPath();
                }
            };
            th.start();
        }
    }

    public void outputLog(String log) {
        if (log.length() <= 2) {
            this.uolTextField.setText(this.uolTextField.getText() + log);
        } else {
            this.uolTextField.setText(log);
        }
    }

    public void connectSuccessful() {
        if (!this.standAlone) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.gracefulPowerCycleRadioButton.isSelected()) {
                if (!this.standAlone) {
                    this.outputLog("IPMIView is trying to graceful power cycle the managed system, please wait...");
                }
                this.ipmiSession.IPMDevicePane20.sendGracePowerCycle();
                this.checkGracefulPowerControlTimeout();
            } else if (this.gracefulResetRadioButton.isSelected()) {
                if (!this.standAlone) {
                    this.outputLog("IPMIView is trying to graceful reset the managed system, please wait...");
                }
                this.ipmiSession.IPMDevicePane20.sendGraceReboot();
                this.checkGracefulPowerControlTimeout();
            } else if (this.powerCycleRadioButton.isSelected()) {
                if (!this.standAlone) {
                    this.outputLog("IPMIView is trying to power cycle the the managed system, please wait...");
                }
                this.ipmiSession.IPMDevicePane20.sendPowerCycle();
            } else if (this.resetRadioButton.isSelected()) {
                if (!this.standAlone) {
                    this.outputLog("IPMIView is trying to reset the managed system, please wait...");
                }
                this.ipmiSession.IPMDevicePane20.sendHardReset();
            } else if (this.powerUpRadioButton.isSelected()) {
                if (!this.standAlone) {
                    this.outputLog("IPMIView is trying to power up the managed system, please wait...");
                }
                this.ipmiSession.IPMDevicePane20.sendPowerUp();
            }
        }
        this.isConnectSuccessful = true;
    }

    public void booting() {
        this.isGracefulPowerControlSuccessful = true;
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!this.standAlone && this.check3.isSelected()) {
            this.ipmiSession.SOLPane20.add((Component)this.outputPanel, "North");
            this.outputPanel.outputLog("Ready");
            this.handler.setUOLOutputInterface(this.outputPanel);
        } else {
            this.ipmiSession.SOLPane20.remove(this.outputPanel);
        }
        if (!this.standAlone && this.check2.isSelected()) {
            for (int i = 5; i > 0; --i) {
                this.outputLog("IPMIView will switch to Text Console after " + i + " second");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.changeToSOL();
        }
        if (!this.standAlone && this.check3.isSelected()) {
            this.outputLog("(UOL Status message has been moved to Text Console page)");
        }
        this.isConnecting = false;
    }

    public void help() {
        String helpStr = "Steps:\n1.Press \"Load\" button to load 1.44MB Disk Image file\n2.Press \"Remote Boot\" button to remote boot the managed system\n3.Remote managed system will boot from local image file\n4.Press \"Stop\" to close the remote boot feature";
        JOptionPane.showMessageDialog(this, helpStr);
    }

    public void setStandAlone() {
        this.ipTextField.setVisible(true);
        this.ipLabel.setVisible(true);
        this.ipLabel.requestFocus(true);
        this.connectButton.setText("Connect");
        this.disconnectButton.setText("Disconnect");
        this.standAlone = true;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UOLPanel uolPanel = new UOLPanel("192.168.10.245");
        uolPanel.setStandAlone();
        UOLFrame frame = new UOLFrame(uolPanel);
        frame.setTitle("UOL (Build:050107) - Super Micro computer, Inc.");
        frame.setSize(new Dimension(550, 150));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        frame.setContentPane(uolPanel);
        frame.show();
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean isConnecting() {
        return this.isConnecting;
    }

    public void setIsConnecting(boolean isConnect) {
        this.isConnecting = isConnect;
    }

    public boolean isStandAlone() {
        return this.standAlone;
    }

    public void setStandAlone(boolean standAlone) {
        this.standAlone = standAlone;
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.help();
    }

    public boolean isConnectSuccessful() {
        return this.isConnectSuccessful;
    }

    class UOLPanel_loadButton_actionAdapter
    implements ActionListener {
        UOLPanel adaptee;

        UOLPanel_loadButton_actionAdapter(UOLPanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.loadButton_actionPerformed(e);
        }
    }

    class UOLPanel_connectButton_actionAdapter
    implements ActionListener {
        UOLPanel adaptee;

        UOLPanel_connectButton_actionAdapter(UOLPanel adaptee) {
            this.adaptee = adaptee;
        }

        public void actionPerformed(ActionEvent e) {
            this.adaptee.connectButton_actionPerformed(e);
        }
    }
}

