/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.util.Observable;
import javax.swing.ImageIcon;

public class LabelBlade
extends LabelBladeComponent {
    ImageIcon labelBlade = new ImageIcon(this.getClass().getResource("/images/labelBlade.jpg"));
    ImageIcon kvmIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentKVM.gif"));
    ImageIcon managementIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentManagement.gif"));
    int kvmIconX = 0;
    int kvmIconY = 0;
    int managementIconX = 0;
    int managementIconY = 0;

    public LabelBlade() {
        this.setIcon(this.labelBlade);
        this.setSize(this.labelBlade.getIconWidth(), this.labelBlade.getIconHeight());
        this.powerIconX = 5;
        this.powerIconY = 16;
        this.uidIconX = 5;
        this.uidIconY = 26;
        this.kvmIconX = 5;
        this.kvmIconY = 36;
        this.managementIconX = 5;
        this.managementIconY = 46;
        this.alertIconX = 5;
        this.alertIconY = 56;
        this.icons = new ImageIcon[2];
        this.iconsX = new int[2];
        this.iconsY = new int[2];
        this.iconsVisible = new boolean[2];
        this.icons[0] = this.kvmIcon;
        this.icons[1] = this.managementIcon;
        this.iconsX[0] = this.kvmIconX;
        this.iconsY[0] = this.kvmIconY;
        this.iconsX[1] = this.managementIconX;
        this.iconsY[1] = this.managementIconY;
        this.iconsVisible[0] = false;
        this.iconsVisible[1] = false;
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("Blade");
    }

    public void setKVMVisible(boolean kvmVisible) {
        this.iconsVisible[0] = kvmVisible;
    }

    public void setManagementVisible(boolean managementVisible) {
        this.iconsVisible[1] = managementVisible;
    }

    public boolean getKVMVisible() {
        return this.iconsVisible[0];
    }

    public void setNetworkVisible(boolean networkVisible) {
        this.iconsVisible[1] = networkVisible;
    }

    public boolean getNetworkVisible() {
        return this.iconsVisible[1];
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelBlade] [Notify]");
        }
        BladeSystemEntity bladeSystemEntity = (BladeSystemEntity)o;
        BladeEntity blade = bladeSystemEntity.getBlades()[this.number - 1];
        boolean powerSupply = true;
        if (blade.isV12vEnable() && blade.isV3_3v() && powerSupply) {
            this.setPowerStatus(0);
        } else if (!blade.isV12vEnable() && !blade.isV3_3v()) {
            this.setPowerStatus(1);
        } else if (blade.isV12vEnable() && !blade.isV3_3v() && powerSupply) {
            this.setPowerStatus(1);
        } else if (!powerSupply) {
            this.setPowerStatus(1);
        }
        this.setPowerVisible(true);
        if (blade.getKvmEnable() > 0) {
            this.setKVMVisible(true);
        } else {
            this.setKVMVisible(false);
        }
        if (blade.isSimCardDetectPin()) {
            this.setManagementVisible(true);
        } else {
            this.setManagementVisible(false);
        }
        if (blade.getUidEnable() > 0) {
            this.setUidVisible(true);
        } else {
            this.setUidVisible(false);
        }
        if (blade.isError1LED()) {
            this.setAlertVisible(true);
        } else {
            this.setAlertVisible(false);
        }
        if (blade.getPresent() == 0) {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        } else {
            this.setVisible(true);
        }
        this.repaint();
    }
}

