/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import java.util.Observable;
import javax.swing.ImageIcon;

public class LabelPowerSupply
extends LabelBladeComponent {
    ImageIcon labelPowerSupply = new ImageIcon(this.getClass().getResource("/images/labelPowerSupply.jpg"));
    ImageIcon labelPowerSupplyFlip = new ImageIcon(this.getClass().getResource("/images/labelPowerSupplyFlip.jpg"));

    public LabelPowerSupply() {
        this.setIcon(this.labelPowerSupply);
        this.setSize(this.labelPowerSupply.getIconWidth(), this.labelPowerSupply.getIconHeight());
        this.powerIconX = 50;
        this.powerIconY = 16;
        this.alertIconX = 50;
        this.alertIconY = 26;
        this.uidIconX = 50;
        this.uidIconY = 36;
        this.setPowerStatus(1);
        this.setPowerVisible(true);
        this.setModuleName("Power Supply");
    }

    public void setNumber(int number) {
        super.setNumber(number);
        if (number == 1 || number == 2) {
            this.setIcon(this.labelPowerSupplyFlip);
        }
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelPowerSupply] [Notify]");
        }
        BladeSystemEntity bladeSystemEntity = (BladeSystemEntity)o;
        PowerSupplyEntity powerSupply = bladeSystemEntity.getPowerSupplies()[this.number - 1];
        int status = 0;
        switch (powerSupply.getStatus()) {
            case 0: {
                status = 1;
                break;
            }
            case 1: {
                status = 0;
                break;
            }
            case 2: {
                status = 2;
                break;
            }
            default: {
                status = 1;
            }
        }
        this.setPowerStatus(status);
        if (powerSupply.getStatus() == 2) {
            this.setAlertVisible(true);
        } else {
            this.setAlertVisible(false);
        }
        if (powerSupply.getPresent() == 0) {
            this.setVisible(false);
            if (this.labelBladeGroup.labelBladeComponentIndicatorOn == this) {
                this.labelBladeGroup.labelBladeComponentIndicatorOn = null;
            }
        } else {
            this.setVisible(true);
        }
    }
}

