/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.JFanPanel;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.SummaryAbstractPanel;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;

public class SummaryPower2FansPanel
extends SummaryAbstractPanel {
    public static int FAN_FULL_SPEED_RPM = 15000;
    public static int TEMPERATURE_FULL_SCALE = 100;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    JLabel p1PowerStatusLabel = new JLabel("");
    JLabel p2PowerStatusLabel = new JLabel("");
    JLabel p3PowerStatusLabel = new JLabel("");
    JLabel p4PowerStatusLabel = new JLabel("");
    JFanPanel p1Fan1Panel = new JFanPanel();
    JFanPanel p1Fan2Panel = new JFanPanel();
    JTempPanel p1TempPanel = new JTempPanel();
    JFanPanel p2Fan1Panel = new JFanPanel();
    JFanPanel p2Fan2Panel = new JFanPanel();
    JTempPanel p2TempPanel = new JTempPanel();
    JFanPanel p3Fan1Panel = new JFanPanel();
    JFanPanel p3Fan2Panel = new JFanPanel();
    JTempPanel p3TempPanel = new JTempPanel();
    JFanPanel p4Fan1Panel = new JFanPanel();
    JFanPanel p4Fan2Panel = new JFanPanel();
    JTempPanel p4TempPanel = new JTempPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    JPanel jPowerFanPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPowerSupplyTemperaturePanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder4 = new TitledBorder("");
    BorderLayout borderLayout2 = new BorderLayout();
    boolean initPower1Sensors = false;
    boolean initPower2Sensors = false;
    boolean initPower3Sensors = false;
    boolean initPower4Sensors = false;
    JPanel jP4Panel = new JPanel();
    JPanel jP3Panel = new JPanel();
    JPanel jP2Panel = new JPanel();
    JPanel jP1Panel = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jT4Panel = new JPanel();
    JPanel jT3Panel = new JPanel();
    JPanel jT2Panel = new JPanel();
    JPanel jT1Panel = new JPanel();
    TitledBorder titledBorder5 = new TitledBorder("");
    TitledBorder titledBorder6 = new TitledBorder("");
    TitledBorder titledBorder7 = new TitledBorder("");
    TitledBorder titledBorder8 = new TitledBorder("");
    TitledBorder titledBorder9 = new TitledBorder("");
    JPanel jTempAndPowerConsumePanel = new JPanel();
    JPanel jPowerConsumePanel1 = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    TitledBorder titledBorder10 = new TitledBorder("");
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jConsumeDetailPanel = new JPanel();
    JPanel jConsumeUIPanel = new JPanel();
    GridLayout gridLayout4 = new GridLayout();
    JLabel jTotalPowerStringLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel jAvailablePercentLabel = new JLabel();
    JLabel jNoOfBladeCanPowerOnLabel = new JLabel();
    JLabel jAvailableLabel = new JLabel();
    JLabel jAvailableStringLabel = new JLabel();
    JLabel jNoOfBladePowerOnLabel = new JLabel();
    JLabel jUsedLabel = new JLabel();
    JProgressBar jPowerBarProgressBar = new JProgressBar();
    BorderLayout borderLayout4 = new BorderLayout();
    JLabel jUsedStringLabel = new JLabel();
    JLabel jNoOfPowerLabel = new JLabel();
    JLabel jTotalPowerLabel = new JLabel();

    public SummaryPower2FansPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() throws Exception {
        this.p1Fan1Panel.init("Fan 1", (byte)0, (byte)0, "", "");
        this.p1Fan2Panel.init("Fan 2", (byte)0, (byte)0, "", "");
        this.p1TempPanel.init("Power 1 Temperature", (byte)0, (byte)0, "", "");
        this.p2Fan1Panel.init("Fan 1", (byte)0, (byte)0, "", "");
        this.p2Fan2Panel.init("Fan 2", (byte)0, (byte)0, "", "");
        this.p2TempPanel.init("Power 2 Temperature", (byte)0, (byte)0, "", "");
        this.p3Fan1Panel.init("Fan 1", (byte)0, (byte)0, "", "");
        this.p3Fan2Panel.init("Fan 2", (byte)0, (byte)0, "", "");
        this.p3TempPanel.init("Power 3 Temperature", (byte)0, (byte)0, "", "");
        this.p4Fan1Panel.init("Fan 1", (byte)0, (byte)0, "", "");
        this.p4Fan2Panel.init("Fan 2", (byte)0, (byte)0, "", "");
        this.p4TempPanel.init("Power 4 Temperature", (byte)0, (byte)0, "", "");
        Dimension tempDimension = new Dimension(110, 28);
        Dimension fanDimension = new Dimension(80, 80);
        this.p1Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p1TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p2Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p2TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p3Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p3TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.p4Fan1Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4Fan2Panel.fanMeter.setPreferredSize(fanDimension);
        this.p4TempPanel.tempMeter.setPreferredSize(tempDimension);
        this.jP1Panel.add(this.p1Fan1Panel);
        this.jP1Panel.add(this.p1Fan2Panel);
        this.jP2Panel.add(this.p2Fan1Panel);
        this.jP2Panel.add(this.p2Fan2Panel);
        this.jP3Panel.add(this.p3Fan1Panel);
        this.jP3Panel.add(this.p3Fan2Panel);
        this.jP4Panel.add(this.p4Fan1Panel);
        this.jP4Panel.add(this.p4Fan2Panel);
        this.jT1Panel.add(this.p1TempPanel);
        this.jT2Panel.add(this.p2TempPanel);
        this.jT3Panel.add(this.p3TempPanel);
        this.jT4Panel.add(this.p4TempPanel);
    }

    private void jbInit() throws Exception {
        this.titledBorder10 = new TitledBorder("Power Consumption");
        this.titledBorder9 = new TitledBorder("Power Supply 2");
        this.titledBorder8 = new TitledBorder("Power Supply 4");
        this.titledBorder7 = new TitledBorder("Power Supply 1");
        this.titledBorder6 = new TitledBorder("Power Supply 3");
        this.titledBorder5 = new TitledBorder("Fan");
        this.titledBorder4 = new TitledBorder("Power Supply 4");
        this.titledBorder3 = new TitledBorder("Power Supply 3");
        this.titledBorder2 = new TitledBorder("Power Temperatures");
        this.titledBorder1 = new TitledBorder("Power Supply Fans");
        this.setLayout(this.borderLayout1);
        this.jPowerFanPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setRows(2);
        this.jPowerSupplyTemperaturePanel.setBorder(this.titledBorder2);
        this.jPowerSupplyTemperaturePanel.setLayout(this.gridLayout2);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setRows(2);
        this.jP3Panel.setBorder(this.titledBorder6);
        this.jP1Panel.setBorder(this.titledBorder7);
        this.jP4Panel.setBorder(this.titledBorder8);
        this.jP2Panel.setBorder(this.titledBorder9);
        this.jPowerFanPanel.setBorder(null);
        this.jTempAndPowerConsumePanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(2);
        this.jPowerConsumePanel1.setLayout(this.borderLayout3);
        this.jPowerConsumePanel1.setBorder(this.titledBorder10);
        this.jConsumeDetailPanel.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(3);
        this.gridLayout4.setRows(4);
        this.jTotalPowerStringLabel.setForeground(Color.blue);
        this.jTotalPowerStringLabel.setText("Total Power:");
        this.jAvailableStringLabel.setForeground(Color.blue);
        this.jAvailableStringLabel.setText("Available:");
        this.jConsumeUIPanel.setLayout(this.borderLayout4);
        this.jUsedStringLabel.setForeground(Color.blue);
        this.jUsedStringLabel.setToolTipText("");
        this.jUsedStringLabel.setText("Power Reserved:");
        this.jUsedLabel.setToolTipText("");
        this.jAvailablePercentLabel.setForeground(Color.blue);
        this.jAvailablePercentLabel.setText("Available %");
        this.add((Component)this.jCenterPanel, "Center");
        this.jPowerFanPanel.add(this.jP1Panel);
        this.jPowerFanPanel.add(this.jP2Panel);
        this.jPowerFanPanel.add(this.jP3Panel);
        this.jPowerFanPanel.add(this.jP4Panel);
        this.jCenterPanel.add((Component)this.jPowerFanPanel, "Center");
        this.jPowerSupplyTemperaturePanel.add(this.jT1Panel);
        this.jPowerSupplyTemperaturePanel.add(this.jT2Panel);
        this.jPowerSupplyTemperaturePanel.add(this.jT3Panel);
        this.jPowerSupplyTemperaturePanel.add(this.jT4Panel);
        this.jCenterPanel.add((Component)this.jTempAndPowerConsumePanel, "East");
        this.jTempAndPowerConsumePanel.add(this.jPowerConsumePanel1);
        this.jTempAndPowerConsumePanel.add(this.jPowerSupplyTemperaturePanel);
        this.jPowerConsumePanel1.add((Component)this.jConsumeDetailPanel, "Center");
        this.jConsumeDetailPanel.add(this.jTotalPowerStringLabel);
        this.jConsumeDetailPanel.add(this.jTotalPowerLabel);
        this.jConsumeDetailPanel.add(this.jNoOfPowerLabel);
        this.jConsumeDetailPanel.add(this.jUsedStringLabel);
        this.jConsumeDetailPanel.add(this.jUsedLabel);
        this.jConsumeDetailPanel.add(this.jNoOfBladePowerOnLabel);
        this.jConsumeDetailPanel.add(this.jAvailableStringLabel);
        this.jConsumeDetailPanel.add(this.jAvailableLabel);
        this.jConsumeDetailPanel.add(this.jNoOfBladeCanPowerOnLabel);
        this.jConsumeDetailPanel.add(this.jAvailablePercentLabel);
        this.jConsumeDetailPanel.add(this.jLabel3);
        this.jConsumeDetailPanel.add(this.jLabel2);
        this.jConsumeUIPanel.add((Component)this.jPowerBarProgressBar, "Center");
        this.jPowerConsumePanel1.add((Component)this.jConsumeUIPanel, "South");
    }

    public void update(Observable o, Object obj) {
        int i;
        byte tempLimit;
        byte temp;
        byte fan4LimitRatio;
        byte fan4Ratio;
        byte fan3LimitRatio;
        byte fan3Ratio;
        byte fan2LimitRatio;
        byte fan2Ratio;
        byte fan1LimitRatio;
        byte fan1Ratio;
        int fan4RPMLimit;
        int fan4RPM;
        int fan3RPMLimit;
        int fan3RPM;
        int fan2RPMLimit;
        int fan2RPM;
        int fan1RPMLimit;
        int fan1RPM;
        BladeSystemEntity bladeSystemEntity;
        PowerSupplyEntity powerSupply;
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SummaryPower2FansPanel] [Notify]");
        }
        if ((powerSupply = (bladeSystemEntity = (BladeSystemEntity)o).getPowerSupplies()[0]).getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p1PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p1PowerStatusLabel.setText("Off");
                    this.p1Fan1Panel.setNA();
                    this.p1Fan2Panel.setNA();
                    break;
                }
                case 1: {
                    this.p1PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p1PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p1PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p1PowerStatusLabel.setText("Failure");
                    this.p1TempPanel.setNA();
                    this.p1Fan1Panel.setNA();
                    this.p1Fan2Panel.setNA();
                    break;
                }
                default: {
                    this.p1PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p1PowerStatusLabel.setText("Off");
                    this.p1TempPanel.setNA();
                    this.p1Fan1Panel.setNA();
                    this.p1Fan2Panel.setNA();
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower1Sensors) {
                this.p1Fan1Panel.init("Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p1Fan2Panel.init("Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p1TempPanel.init("Power 1 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower1Sensors = true;
            }
            if (fan1RPM != 0 || fan2RPM != 0) {
                this.p1Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
                this.p1Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            }
            this.p1TempPanel.updateValue(temp, "" + temp);
        } else {
            this.p1Fan1Panel.setNA();
            this.p1Fan2Panel.setNA();
            this.p1TempPanel.setNA();
        }
        powerSupply = bladeSystemEntity.getPowerSupplies()[1];
        if (powerSupply.getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p2PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p2PowerStatusLabel.setText("Off");
                    this.p2Fan1Panel.setNA();
                    this.p2Fan2Panel.setNA();
                    break;
                }
                case 1: {
                    this.p2PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p2PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p2PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p2PowerStatusLabel.setText("Failure");
                    this.p2Fan1Panel.setNA();
                    this.p2Fan2Panel.setNA();
                    this.p2TempPanel.setNA();
                    break;
                }
                default: {
                    this.p2PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p2PowerStatusLabel.setText("Off");
                    this.p2Fan1Panel.setNA();
                    this.p2Fan2Panel.setNA();
                    this.p2TempPanel.setNA();
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower2Sensors) {
                this.p2Fan1Panel.init("Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p2Fan2Panel.init("Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p2TempPanel.init("Power 2 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower2Sensors = true;
            }
            if (fan1RPM != 0 || fan2RPM != 0) {
                this.p2Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
                this.p2Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            }
            this.p2TempPanel.updateValue(temp, "" + temp);
        } else {
            this.p2Fan1Panel.setNA();
            this.p2Fan2Panel.setNA();
            this.p2TempPanel.setNA();
        }
        powerSupply = bladeSystemEntity.getPowerSupplies()[2];
        if (powerSupply.getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p3PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p3PowerStatusLabel.setText("Off");
                    this.p3Fan1Panel.setNA();
                    this.p3Fan2Panel.setNA();
                    break;
                }
                case 1: {
                    this.p3PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p3PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p3PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p3PowerStatusLabel.setText("Failure");
                    this.p3TempPanel.setNA();
                    this.p3Fan1Panel.setNA();
                    this.p3Fan2Panel.setNA();
                    break;
                }
                default: {
                    this.p3PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p3PowerStatusLabel.setText("Off");
                    this.p3TempPanel.setNA();
                    this.p3Fan1Panel.setNA();
                    this.p3Fan2Panel.setNA();
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower3Sensors) {
                this.p3Fan1Panel.init("Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p3Fan2Panel.init("Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p3TempPanel.init("Power 3 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower3Sensors = true;
            }
            if (fan1RPM != 0 || fan2RPM != 0) {
                this.p3Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
                this.p3Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            }
            this.p3TempPanel.updateValue(temp, "" + temp);
        } else {
            this.p3Fan1Panel.setNA();
            this.p3Fan2Panel.setNA();
            this.p3TempPanel.setNA();
        }
        powerSupply = bladeSystemEntity.getPowerSupplies()[3];
        if (powerSupply.getPresent() > 0) {
            switch (powerSupply.getStatus()) {
                case 0: {
                    this.p4PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p4PowerStatusLabel.setText("Off");
                    this.p4Fan1Panel.setNA();
                    this.p4Fan2Panel.setNA();
                    break;
                }
                case 1: {
                    this.p4PowerStatusLabel.setIcon(this.powerOnIcon);
                    this.p4PowerStatusLabel.setText("On");
                    break;
                }
                case 2: {
                    this.p4PowerStatusLabel.setIcon(this.powerFailureIcon);
                    this.p4PowerStatusLabel.setText("Failure");
                    this.p4TempPanel.setNA();
                    this.p4Fan1Panel.setNA();
                    this.p4Fan2Panel.setNA();
                    break;
                }
                default: {
                    this.p4PowerStatusLabel.setIcon(this.powerOffIcon);
                    this.p4PowerStatusLabel.setText("Off");
                    this.p4TempPanel.setNA();
                    this.p4Fan1Panel.setNA();
                    this.p4Fan2Panel.setNA();
                }
            }
            fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
            fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
            fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
            fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
            fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
            fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
            fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed());
            fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit());
            fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
            fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
            fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
            fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
            fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
            temp = powerSupply.getTemperature();
            tempLimit = powerSupply.getTemperatureHighLimit();
            if (!this.initPower4Sensors) {
                this.p4Fan1Panel.init("Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
                this.p4Fan2Panel.init("Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
                this.p4TempPanel.init("Power 4 Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
                this.initPower4Sensors = true;
            }
            if (fan1RPM != 0 || fan2RPM != 0) {
                this.p4Fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
                this.p4Fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            }
            this.p4TempPanel.updateValue(temp, "" + temp);
        } else {
            this.p4Fan1Panel.setNA();
            this.p4Fan2Panel.setNA();
            this.p4TempPanel.setNA();
        }
        double totalWatts = 0.0;
        double totalBladeConsume = 0.0;
        int sizeOfPowerSupply = 0;
        int sizeOfBlade = 0;
        for (i = 0; i < bladeSystemEntity.getPowerSupplies().length; ++i) {
            PowerSupplyEntity p = bladeSystemEntity.getPowerSupplies()[i];
            if (p.getPresent() != 1 || p.getStatus() != 1) continue;
            totalWatts += p.getWatt();
            ++sizeOfPowerSupply;
        }
        for (i = 0; i < bladeSystemEntity.getBlades().length; ++i) {
            BladeEntity b = bladeSystemEntity.getBlades()[i];
            if (b.getPresent() != 1 || !b.isV12vEnable() || !b.isV3_3v()) continue;
            ++sizeOfBlade;
            if (b.getWattByFormula() == 0) {
                totalBladeConsume += 300.0;
                continue;
            }
            totalBladeConsume += (double)b.getWattByFormula();
        }
        this.jTotalPowerLabel.setText("" + (int)totalWatts + "(W)");
        this.jUsedLabel.setText("" + (int)totalBladeConsume + "(W)");
        this.jAvailableLabel.setText("" + (int)(totalWatts - totalBladeConsume) + "(W)");
        if (sizeOfPowerSupply <= 1) {
            this.jNoOfPowerLabel.setText("( " + sizeOfPowerSupply + " Power )");
        } else {
            this.jNoOfPowerLabel.setText("( " + sizeOfPowerSupply + " Powers )");
        }
        if (sizeOfBlade <= 1) {
            this.jNoOfBladePowerOnLabel.setText("( " + sizeOfBlade + " Blade )");
        } else {
            this.jNoOfBladePowerOnLabel.setText("( " + sizeOfBlade + " Blades )");
        }
        int NoOfBladeCanPowerOn = (int)((totalWatts - totalBladeConsume) / 300.0);
        if (NoOfBladeCanPowerOn + sizeOfBlade > bladeSystemEntity.getBlades().length) {
            this.jNoOfBladeCanPowerOnLabel.setText("( " + (bladeSystemEntity.getBlades().length - sizeOfBlade) + " Blades )");
        } else {
            this.jNoOfBladeCanPowerOnLabel.setText("( " + NoOfBladeCanPowerOn + " Blades )");
        }
        this.jAvailablePercentLabel.setText("Available " + (int)((totalWatts - totalBladeConsume) / totalWatts * 100.0) + "%");
        this.jPowerBarProgressBar.setMaximum((int)totalWatts);
        this.jPowerBarProgressBar.setMinimum(0);
        this.jPowerBarProgressBar.setValue((int)(totalWatts - totalBladeConsume));
    }
}

