/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.group;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.group.ACPIIcon_CellColorRenderer;
import IPMIView20.group.ACPIPanel_jClearButton_actionAdapter;
import IPMIView20.group.ACPIPanel_jSaveButton_actionAdapter;
import IPMIView20.group.ACPI_JCheckBox1_actionAdapter;
import IPMIView20.group.ACPI_JComboBox1_itemAdapter;
import IPMIView20.group.ACPI_JQueryButton_actionAdapter;
import IPMIView20.group.PPanel;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.group.CommandForGettingACPIState;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class ACPIPanel
extends PPanel
implements Observer {
    Timer timer;
    TableSorter ts;
    DefaultTableModel dtm;
    CommandForGettingACPIState commandForGettingACPIState;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    ImageIcon LEDOnimg = new ImageIcon(this.getClass().getResource("/images/gledon.gif"));
    ImageIcon LEDOffimg = new ImageIcon(this.getClass().getResource("/images/gledoff.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton jQueryButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JTable jTable = new JTable();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jPanel3 = new JPanel();
    JComboBox jComboBox1 = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JCheckBox jCheckBox1 = new JCheckBox();
    JPanel jPanel5 = new JPanel();
    JLabel jLastUpdateLabel = new JLabel();
    Host host = null;
    Result result = null;
    static boolean isRunning = false;
    JToolBar jToolBar1 = new JToolBar();
    BorderLayout borderLayout4 = new BorderLayout();
    JButton jSaveButton = new JButton();
    JButton jClearButton = new JButton();
    String pathName;

    public ACPIPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(L.t("group.acpi.ACPI"));
        this.setLayout(this.borderLayout1);
        this.jQueryButton.setToolTipText(L.t("group.table.toolbar.Get"));
        this.jQueryButton.setIcon(this.listIcon);
        this.jQueryButton.addActionListener(new ACPI_JQueryButton_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jLabel2.setText(L.t("group.acpi.seconds"));
        this.jPanel4.setLayout(this.borderLayout3);
        this.jCheckBox1.setText(L.t("group.acpi.Refresh_every"));
        this.jCheckBox1.addActionListener(new ACPI_JCheckBox1_actionAdapter(this));
        this.jComboBox1.addItemListener(new ACPI_JComboBox1_itemAdapter(this));
        this.jTable.setAutoResizeMode(0);
        this.jPanel2.setLayout(this.borderLayout4);
        this.jToolBar1.setFloatable(false);
        this.jSaveButton.setToolTipText(L.t("group.table.toolbar.Save"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.addActionListener(new ACPIPanel_jSaveButton_actionAdapter(this));
        this.jClearButton.setToolTipText(L.t("group.table.toolbar.Clear"));
        this.jClearButton.setIcon(this.deleteIcon);
        this.jClearButton.addActionListener(new ACPIPanel_jClearButton_actionAdapter(this));
        this.add((Component)this.jPanel1, "Center");
        this.jToolBar1.add(this.jQueryButton);
        this.jToolBar1.add(this.jClearButton);
        this.jToolBar1.add(this.jSaveButton);
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add(this.jCheckBox1);
        this.jPanel3.add(this.jComboBox1);
        this.jPanel3.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel5.add(this.jLastUpdateLabel);
        this.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jToolBar1, "Center");
    }

    private void myInit() {
        this.jComboBox1.addItem("10");
        this.jComboBox1.addItem("20");
        this.jComboBox1.addItem("30");
        this.jComboBox1.addItem("45");
        this.jComboBox1.addItem("60");
        this.jComboBox1.addItem("90");
        this.jComboBox1.addItem("120");
        this.jComboBox1.setSelectedIndex(4);
        this.showHeader();
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("group.acpi.Host") + "  ");
        headerList.add(L.t("group.acpi.IP") + "  ");
        headerList.add(L.t("group.acpi.ACPI_State"));
        headerList.add(L.t("group.acpi.Description") + "  ");
        headerList.add(L.t("group.acpi.On_slash_Off") + "  ");
        return headerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        if (!this.isShowMeNow()) {
            return;
        }
        this.jQueryButton.setEnabled(false);
        this.jClearButton.setEnabled(false);
        this.jSaveButton.setEnabled(false);
        if (!this.initialData()) {
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            return;
        }
        if (this.ts == null) {
            ArrayList headerList = this.getHeader();
            this.dtm = new DefaultTableModel(headerList.toArray(), 0);
            this.ts = new TableSorter(this.dtm);
        } else {
            int rowCount = this.ts.getTableModel().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
            }
        }
        this.hostManager.addObserver(this);
        this.commandForGettingACPIState = new CommandForGettingACPIState();
        try {
            this.hostManager.run(this.commandForGettingACPIState);
            this.queryResult = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.queryResult = false;
            }
            catch (Throwable throwable) {
                this.hostManager.deleteObserver(this);
                this.jQueryButton.setEnabled(true);
                this.jClearButton.setEnabled(true);
                this.jSaveButton.setEnabled(true);
                this.setLastUpdate();
                this.xMessage.setText(this.queryResult ? L.t("group.acpi.Finish") : L.t("group.acpi.Error_occured"));
                throw throwable;
            }
            this.hostManager.deleteObserver(this);
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            this.setLastUpdate();
            this.xMessage.setText(this.queryResult ? L.t("group.acpi.Finish") : L.t("group.acpi.Error_occured"));
        }
        this.hostManager.deleteObserver(this);
        this.jQueryButton.setEnabled(true);
        this.jClearButton.setEnabled(true);
        this.jSaveButton.setEnabled(true);
        this.setLastUpdate();
        this.xMessage.setText(this.queryResult ? L.t("group.acpi.Finish") : L.t("group.acpi.Error_occured"));
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Host) {
            this.host = (Host)arg;
            this.xMessage.setText(L.t("group.acpi.Getting_ACPI_state_from") + " " + this.host.getIp() + " ...");
            return;
        }
        if (arg instanceof Result) {
            this.result = (Result)arg;
            if (this.result.booleanResult) {
                ArrayList raw = this.makeFormatedData(this.host, this.result);
                ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
                this.jTable.setModel(this.ts);
                this.ts.setTableHeader(this.jTable.getTableHeader());
                ACPIIcon_CellColorRenderer acpiIcon_CellColorRenderer = new ACPIIcon_CellColorRenderer();
                this.jTable.setRowHeight(this.LEDOnimg.getIconHeight() + 4);
                this.jTable.getColumnModel().getColumn(0).setPreferredWidth(100);
                this.jTable.getColumnModel().getColumn(1).setPreferredWidth(100);
                this.jTable.getColumnModel().getColumn(4).setCellRenderer(acpiIcon_CellColorRenderer);
                this.jTable.invalidate();
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), this.result.description + "\n" + this.result.host.getIp());
            }
        }
    }

    public ArrayList makeFormatedData(Host host, Result result) {
        ArrayList<Object> raw = new ArrayList<Object>();
        raw.add(host.getHostname());
        raw.add(host.getIp());
        ACPIInfo acpiInfo = (ACPIInfo)result.getSingleData("ACPI_INFO");
        raw.add(acpiInfo.getSystemStateInfo());
        raw.add(acpiInfo.getSystemStateDescription());
        if (acpiInfo.getSystemState() == 0 || acpiInfo.getSystemState() == 1 || acpiInfo.getSystemState() == 32) {
            raw.add(this.LEDOnimg);
        } else if (acpiInfo.getSystemState() == 2 || acpiInfo.getSystemState() == 3 || acpiInfo.getSystemState() == 4 || acpiInfo.getSystemState() == 5 || acpiInfo.getSystemState() == 6 || acpiInfo.getSystemState() == 33) {
            raw.add(this.LEDOffimg);
        }
        return raw;
    }

    public void jQueryButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                ACPIPanel.this.doQuery();
            }
        };
        thread.start();
    }

    public void jCheckBox1_actionPerformed(ActionEvent e) {
        this.setReflashTimer();
    }

    private void setReflashTimer() throws NumberFormatException {
        String flashRateStr = (String)this.jComboBox1.getSelectedItem();
        int flashRate = Integer.parseInt(flashRateStr);
        if (this.jCheckBox1.isSelected()) {
            TimerTask tt = new TimerTask(){

                public void run() {
                    Thread th = new Thread(){

                        public void run() {
                            if ((this).ACPIPanel.this.loginID == null || (this).ACPIPanel.this.loginID.length() == 0 || (this).ACPIPanel.this.loginPassword == null || (this).ACPIPanel.this.loginPassword.length() == 0) {
                                return;
                            }
                            if (isRunning) {
                                return;
                            }
                            isRunning = true;
                            ACPIPanel.this.doQuery();
                            isRunning = false;
                        }
                    };
                    th.start();
                }
            };
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer();
            this.timer.schedule(tt, flashRate * 1000, (long)(flashRate * 1000));
        } else {
            this.timer.cancel();
        }
    }

    public void setLastUpdate() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.jLastUpdateLabel.setText(L.t("group.acpi.last_update_colon") + f.format(Calendar.getInstance().getTime()) + " (" + this.ts.getTableModel().getRowCount() + ")");
    }

    public void jComboBox1_itemStateChanged(ItemEvent e) {
        if (this.jCheckBox1.isSelected()) {
            this.setReflashTimer();
        }
    }

    public void jClearButton_actionPerformed(ActionEvent e) {
        int rowCount = this.ts.getTableModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
        }
    }

    public void jSaveButton_actionPerformed(ActionEvent e) {
        int rowCount = this.jTable.getModel().getRowCount();
        if (rowCount == 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.No_data"));
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        boolean save = false;
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Do_you_want_to_overwrite_it"), L.t("group.table.toolbar.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i;
                StringBuffer sb = new StringBuffer();
                ArrayList list = ACPIPanel.this.getHeader();
                for (i = 0; i < list.size() - 1; ++i) {
                    sb.append(list.get(i));
                    if (i == list.size() - 2) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i = 0; i < ACPIPanel.this.jTable.getRowCount(); ++i) {
                    for (int j = 0; j < ACPIPanel.this.jTable.getColumnCount() - 1; ++j) {
                        sb.append((String)((TableSorter)ACPIPanel.this.jTable.getModel()).getValueAt(i, j));
                        if (j == ACPIPanel.this.jTable.getColumnCount() - 2) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    FileWriter fout = new FileWriter(ACPIPanel.this.pathName);
                    PrintWriter pw = new PrintWriter(fout);
                    pw.println(sb.toString());
                    fout.close();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.save_to") + " " + ACPIPanel.this.pathName + " " + L.t("group.table.toolbar.completed"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("group.table.toolbar.Warning"), 0);
                }
            }
        };
        thread.start();
    }
}

