/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.group;

import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.group.PPanel;
import IPMIView20.group.TableSorter;
import IPMIView20.group.TemperatureMessageCenterObserver;
import IPMIView20.group.TemperaturePanel_jClearButton_actionAdapter;
import IPMIView20.group.TemperaturePanel_jSaveButton_actionAdapter;
import IPMIView20.group.Temperature_CellColorRenderer;
import IPMIView20.group.Temperature_JCheckBox1_actionAdapter;
import IPMIView20.group.Temperature_JComboBox1_itemAdapter;
import IPMIView20.group.Temperature_JQueryButton_actionAdapter;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.group.CommandForReadingTemperature;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class TemperaturePanel
extends PPanel
implements Observer {
    Timer timer;
    TableSorter ts;
    DefaultTableModel dtm;
    CommandForReadingTemperature commandForReadingTemperature;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon deleteIcon = new ImageIcon(this.getClass().getResource("/images/delete.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JButton jQueryButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    JTable jTable = new JTable();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jPanel3 = new JPanel();
    JComboBox jComboBox1 = new JComboBox();
    JLabel jLabel2 = new JLabel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JCheckBox jCheckBox1 = new JCheckBox();
    JPanel jPanel5 = new JPanel();
    JLabel jLastUpdateLabel = new JLabel();
    Host host = null;
    Result result = null;
    static boolean isRunning = false;
    JToolBar jToolBar1 = new JToolBar();
    BorderLayout borderLayout4 = new BorderLayout();
    JButton jClearButton = new JButton();
    JButton jSaveButton = new JButton();
    String pathName;

    public TemperaturePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder(L.t("group.temp.Temperature"));
        this.setLayout(this.borderLayout1);
        this.jQueryButton.setToolTipText(L.t("group.table.toolbar.Get"));
        this.jQueryButton.setIcon(this.listIcon);
        this.jQueryButton.addActionListener(new Temperature_JQueryButton_actionAdapter(this));
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(this.titledBorder1);
        this.jLabel2.setText(L.t("group.temp.seconds"));
        this.jPanel4.setLayout(this.borderLayout3);
        this.jCheckBox1.setText(L.t("group.temp.Refresh_every"));
        this.jCheckBox1.addActionListener(new Temperature_JCheckBox1_actionAdapter(this));
        this.jComboBox1.addItemListener(new Temperature_JComboBox1_itemAdapter(this));
        this.jPanel2.setLayout(this.borderLayout4);
        this.jClearButton.setToolTipText(L.t("group.table.toolbar.Clear"));
        this.jClearButton.setIcon(this.deleteIcon);
        this.jClearButton.addActionListener(new TemperaturePanel_jClearButton_actionAdapter(this));
        this.jSaveButton.setToolTipText(L.t("group.table.toolbar.Save"));
        this.jSaveButton.setIcon(this.saveIcon);
        this.jSaveButton.addActionListener(new TemperaturePanel_jSaveButton_actionAdapter(this));
        this.jToolBar1.setFloatable(false);
        this.add((Component)this.jPanel1, "Center");
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel3.add(this.jCheckBox1);
        this.jPanel3.add(this.jComboBox1);
        this.jPanel3.add(this.jLabel2);
        this.jPanel1.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jPanel3, "West");
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.jPanel5.add(this.jLastUpdateLabel);
        this.jPanel2.add((Component)this.jToolBar1, "Center");
        this.jToolBar1.add(this.jQueryButton);
        this.jToolBar1.add(this.jClearButton);
        this.jToolBar1.add(this.jSaveButton);
        this.add((Component)this.jPanel2, "North");
    }

    private void myInit() {
        this.jComboBox1.addItem("10");
        this.jComboBox1.addItem("20");
        this.jComboBox1.addItem("30");
        this.jComboBox1.addItem("45");
        this.jComboBox1.addItem("60");
        this.jComboBox1.addItem("90");
        this.jComboBox1.addItem("120");
        this.jComboBox1.setSelectedIndex(4);
        this.showHeader();
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("group.temp.Host") + "  ");
        headerList.add(L.t("group.temp.IP") + "  ");
        headerList.add(L.t("group.temp.Sensor_Name"));
        headerList.add(L.t("group.temp.Reading") + "  ");
        headerList.add(L.t("group.temp.Unit") + "  ");
        headerList.add(L.t("group.temp.High_Limit"));
        return headerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQuery() {
        if (!this.isShowMeNow()) {
            return;
        }
        this.jQueryButton.setEnabled(false);
        this.jClearButton.setEnabled(false);
        this.jSaveButton.setEnabled(false);
        if (!this.initialData()) {
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            return;
        }
        if (this.ts == null) {
            ArrayList headerList = this.getHeader();
            this.dtm = new DefaultTableModel(headerList.toArray(), 0);
            this.ts = new TableSorter(this.dtm);
        } else {
            int rowCount = this.ts.getTableModel().getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
            }
        }
        TemperatureMessageCenterObserver temperatureMessageCenterObserver = new TemperatureMessageCenterObserver(this);
        MessageCenter.getInstance().addObserver(temperatureMessageCenterObserver);
        this.hostManager.addObserver(this);
        this.commandForReadingTemperature = new CommandForReadingTemperature();
        try {
            this.hostManager.run(this.commandForReadingTemperature);
            this.queryResult = true;
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.queryResult = false;
            }
            catch (Throwable throwable) {
                MessageCenter.getInstance().deleteObserver(temperatureMessageCenterObserver);
                this.hostManager.deleteObserver(this);
                this.jQueryButton.setEnabled(true);
                this.jClearButton.setEnabled(true);
                this.jSaveButton.setEnabled(true);
                this.setLastUpdate();
                this.xMessage.setText(this.queryResult ? L.t("group.temp.Finish") : L.t("group.temp.Error_occured"));
                throw throwable;
            }
            MessageCenter.getInstance().deleteObserver(temperatureMessageCenterObserver);
            this.hostManager.deleteObserver(this);
            this.jQueryButton.setEnabled(true);
            this.jClearButton.setEnabled(true);
            this.jSaveButton.setEnabled(true);
            this.setLastUpdate();
            this.xMessage.setText(this.queryResult ? L.t("group.temp.Finish") : L.t("group.temp.Error_occured"));
        }
        MessageCenter.getInstance().deleteObserver(temperatureMessageCenterObserver);
        this.hostManager.deleteObserver(this);
        this.jQueryButton.setEnabled(true);
        this.jClearButton.setEnabled(true);
        this.jSaveButton.setEnabled(true);
        this.setLastUpdate();
        this.xMessage.setText(this.queryResult ? L.t("group.temp.Finish") : L.t("group.temp.Error_occured"));
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Host) {
            this.host = (Host)arg;
            this.xMessage.setText(L.t("group.temp.Getting_temperature_data_from") + " " + this.host.getIp() + " ...");
            return;
        }
        if (arg instanceof Result) {
            this.result = (Result)arg;
            if (this.result.booleanResult) {
                for (int i = 0; i < this.host.sdrRecords.size(); ++i) {
                    if (((SDRRecord)this.host.sdrRecords.get(i)).getSensorType() != SDRRecord.SENSOR_TYPE_TEMPERATURE) continue;
                    ArrayList raw = this.makeFormatedData(this.host, (SDRRecord)this.host.sdrRecords.get(i));
                    ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
                }
                this.jTable.setModel(this.ts);
                Temperature_CellColorRenderer m_CellColorRenderer = new Temperature_CellColorRenderer(Color.red);
                for (int i = 0; i < this.jTable.getColumnCount(); ++i) {
                    this.jTable.getColumnModel().getColumn(2).setCellRenderer(m_CellColorRenderer);
                    this.jTable.getColumnModel().getColumn(3).setCellRenderer(m_CellColorRenderer);
                }
                this.ts.setTableHeader(this.jTable.getTableHeader());
                this.jTable.invalidate();
            } else {
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), this.result.description + "\n" + this.result.host.getIp());
            }
        }
    }

    public ArrayList makeFormatedData(Host host, SDRRecord sdrRecord) {
        ArrayList<String> raw = new ArrayList<String>();
        raw.add(host.getHostname());
        raw.add(host.getIp());
        raw.add(sdrRecord.getSensorName());
        if (sdrRecord.isIsValueAvailable()) {
            raw.add("" + sdrRecord.getCurrentReading());
        } else {
            raw.add("?");
        }
        raw.add(sdrRecord.getUnit());
        raw.add(sdrRecord.doubleToString(sdrRecord.getHiLimit()));
        return raw;
    }

    public void jQueryButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                TemperaturePanel.this.doQuery();
            }
        };
        thread.start();
    }

    public void jCheckBox1_actionPerformed(ActionEvent e) {
        this.setReflashTimer();
    }

    private void setReflashTimer() throws NumberFormatException {
        String flashRateStr = (String)this.jComboBox1.getSelectedItem();
        int flashRate = Integer.parseInt(flashRateStr);
        if (this.jCheckBox1.isSelected()) {
            TimerTask tt = new TimerTask(){

                public void run() {
                    Thread th = new Thread(){

                        public void run() {
                            if ((this).TemperaturePanel.this.loginID == null || (this).TemperaturePanel.this.loginID.length() == 0 || (this).TemperaturePanel.this.loginPassword == null || (this).TemperaturePanel.this.loginPassword.length() == 0) {
                                return;
                            }
                            if (isRunning) {
                                return;
                            }
                            isRunning = true;
                            TemperaturePanel.this.doQuery();
                            isRunning = false;
                        }
                    };
                    th.start();
                }
            };
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.timer = new Timer();
            this.timer.schedule(tt, flashRate * 1000, (long)(flashRate * 1000));
        } else {
            this.timer.cancel();
        }
    }

    public void setLastUpdate() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        this.jLastUpdateLabel.setText(L.t("group.temp.last_update_colon") + f.format(Calendar.getInstance().getTime()) + " (" + this.ts.getTableModel().getRowCount() + ")");
    }

    public void jComboBox1_itemStateChanged(ItemEvent e) {
        if (this.jCheckBox1.isSelected()) {
            this.setReflashTimer();
        }
    }

    public void handleMessageCenterObserver(Observable o, Object arg) {
        MessageCenter.ClassMessage classMessage = (MessageCenter.ClassMessage)arg;
        if (classMessage.from.equals("com.supermicro.ipmi.IPMISELCommand") || classMessage.from.equals("com.supermicro.ipmi.IPMISDRCommand")) {
            this.xMessage.setText(classMessage.content);
        }
    }

    public void jClearButton_actionPerformed(ActionEvent e) {
        int rowCount = this.ts.getTableModel().getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ((DefaultTableModel)this.ts.getTableModel()).removeRow(0);
        }
    }

    public void jSaveButton_actionPerformed(ActionEvent e) {
        int rowCount = this.jTable.getModel().getRowCount();
        if (rowCount == 0) {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.No_data"));
            return;
        }
        JFileChooser fileChooser = new JFileChooser();
        boolean save = false;
        if (fileChooser.showSaveDialog(null) == 0) {
            this.pathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.pathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Do_you_want_to_overwrite_it"), L.t("group.table.toolbar.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (!save) {
            return;
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int i;
                StringBuffer sb = new StringBuffer();
                ArrayList list = TemperaturePanel.this.getHeader();
                for (i = 0; i < list.size(); ++i) {
                    sb.append(list.get(i));
                    if (i == list.size() - 1) continue;
                    sb.append(",");
                }
                sb.append("\n");
                for (i = 0; i < TemperaturePanel.this.jTable.getRowCount(); ++i) {
                    for (int j = 0; j < TemperaturePanel.this.jTable.getColumnCount(); ++j) {
                        sb.append((String)((TableSorter)TemperaturePanel.this.jTable.getModel()).getValueAt(i, j));
                        if (j == TemperaturePanel.this.jTable.getColumnCount() - 1) continue;
                        sb.append(",");
                    }
                    sb.append("\n");
                }
                try {
                    FileWriter fout = new FileWriter(TemperaturePanel.this.pathName);
                    PrintWriter pw = new PrintWriter(fout);
                    pw.println(sb.toString());
                    fout.close();
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.save_to") + " " + TemperaturePanel.this.pathName + " " + L.t("group.table.toolbar.completed"));
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("group.table.toolbar.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("group.table.toolbar.Warning"), 0);
                }
            }
        };
        thread.start();
    }
}

