/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.trap;

import IPMIView20.L;
import IPMIView20.trap.FilterCondition;
import IPMIView20.trap.Receiver;
import IPMIView20.trap.SplashWindow;
import IPMIView20.trap.TableSorter;
import IPMIView20.trap.Trap;
import IPMIView20.trap.TrapChart;
import IPMIView20.trap.TrapCollector;
import IPMIView20.trap.TrapTree;
import IPMIView20.trap.TrapViewFrame;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TrapViewController
implements Observer {
    TrapViewFrame trapViewFrame;
    public Receiver receiver;
    TrapChart trapChart;
    boolean enableShowAlertWindows = true;
    FilterCondition senderCondition = new FilterCondition();
    FilterCondition communityCondition = new FilterCondition();
    FilterCondition sensorCondition = new FilterCondition();
    String fileVersion = "supermicro-trap-v1";
    SplashWindow sw = null;

    public TrapViewController(TrapViewFrame trapViewFrame) {
        this.trapViewFrame = trapViewFrame;
        this.receiver = new Receiver();
        this.receiver.getTrapCollector().addObserver(this);
        this.initialUI();
    }

    public void initialUI() {
        this.receiver.getTrapCollector().clear();
        this.initialTable();
        this.initialFilterTree();
        this.initialTrapTree();
        this.initialTableFilterCondition();
    }

    public boolean startReceiver() {
        return this.receiver.startReceiver();
    }

    public void stopreceiver() {
        this.receiver.stopReceiver();
    }

    public void cancelFilter() {
        TableSorter ts = (TableSorter)this.trapViewFrame.jTrapTable.getModel();
        ts.cancelFilter();
    }

    public void update(Observable o, Object arg) {
        if (arg instanceof Trap) {
            this.updateTable((TrapCollector)o, (Trap)arg);
            this.updateTree((TrapCollector)o, (Trap)arg);
            if (!this.trapViewFrame.isLoading) {
                this.updateStatusBar((TrapCollector)o, (Trap)arg);
                this.updateInfoDialog((TrapCollector)o, (Trap)arg);
                this.trapViewFrame.trapEmail.sendToQueue((Trap)arg);
            }
        }
    }

    public void initialTable() {
        Object[] columns = new Object[]{L.t("trap.control.Num"), L.t("trap.control.Sender"), L.t("trap.control.Community"), L.t("trap.control.Sensor"), L.t("trap.control.Description"), L.t("trap.control.LocalTimeStamp")};
        DefaultTableModel dtm = new DefaultTableModel(columns, 0);
        TableSorter ts = new TableSorter(dtm);
        this.trapViewFrame.jTrapTable.setModel(ts);
        ts.setTableHeader(this.trapViewFrame.jTrapTable.getTableHeader());
        this.trapViewFrame.jTrapTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.trapViewFrame.jTrapTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.trapViewFrame.jTrapTable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.trapViewFrame.jTrapTable.getColumnModel().getColumn(3).setPreferredWidth(10);
    }

    public void initialTableFilterCondition() {
        this.senderCondition = new FilterCondition();
        this.communityCondition = new FilterCondition();
        this.sensorCondition = new FilterCondition();
        this.senderCondition.filterOperator = 0;
        this.communityCondition.filterOperator = 0;
        this.sensorCondition.filterOperator = 0;
        this.senderCondition.filterColumnIndex = 1;
        this.communityCondition.filterColumnIndex = 2;
        this.sensorCondition.filterColumnIndex = 3;
        this.senderCondition.filterValue = "*";
        this.communityCondition.filterValue = "*";
        this.sensorCondition.filterValue = "*";
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).addFilterCondition(this.senderCondition);
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).addFilterCondition(this.communityCondition);
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).addFilterCondition(this.sensorCondition);
    }

    public void setSenderCondition(Object o) {
        this.senderCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void setCommunityCondition(Object o) {
        this.communityCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void setSensorCondition(Object o) {
        this.sensorCondition.filterValue = o;
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).filter();
        this.updateFilterConditionMessage();
    }

    public void updateFilterConditionMessage() {
        String message = "";
        message = message + L.t("trap.control.Sender") + " = " + this.senderCondition.filterValue;
        message = message + " , " + L.t("trap.control.Community") + " = " + this.communityCondition.filterValue;
        message = message + " , " + L.t("trap.control.Sensor") + " = " + this.sensorCondition.filterValue;
        this.trapViewFrame.jFilterLabel.setText(message);
    }

    public void updateTable(TrapCollector trapCollector, Trap trap) {
        Object[] row = new String[]{"" + trap.getNum(), trap.getIp(), trap.getCommunity(), trap.getSensor(), trap.getDescription(), trap.getTime()};
        TableSorter ts = (TableSorter)this.trapViewFrame.jTrapTable.getModel();
        DefaultTableModel dtm = (DefaultTableModel)ts.getTableModel();
        dtm.addRow(row);
        ((TableSorter)this.trapViewFrame.jTrapTable.getModel()).filter();
        this.trapViewFrame.jclear2Button.setEnabled(true);
        this.trapViewFrame.jSaveButton.setEnabled(true);
    }

    public void initialFilterTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jSenderTree.setModel(treeModel);
        this.trapViewFrame.jSenderTree.setSelectionPath(new TreePath(rootNode));
        rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jCommunityTree.setModel(treeModel);
        this.trapViewFrame.jCommunityTree.setSelectionPath(new TreePath(rootNode));
        rootNode = new DefaultMutableTreeNode(L.t("trap.control.All"));
        treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jSensorTree.setModel(treeModel);
        this.trapViewFrame.jSensorTree.setSelectionPath(new TreePath(rootNode));
    }

    public void initialTrapTree() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(L.t("trap.control.Trap"));
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.trapViewFrame.jTrapTree.setModel(treeModel);
        this.trapViewFrame.jTrapTree.setSelectionPath(new TreePath(rootNode));
    }

    public void updateTree(TrapCollector trapCollector, Trap trap) {
        TreeNode node;
        int i;
        boolean find = false;
        DefaultTreeModel treeModel = (DefaultTreeModel)this.trapViewFrame.jSenderTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode child = null;
        find = false;
        for (i = 0; i < root.getChildCount(); ++i) {
            node = root.getChildAt(i);
            if (!node.toString().equals(trap.getIp())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trap.getIp());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jSenderTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jCommunityTree.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i = 0; i < root.getChildCount(); ++i) {
            node = root.getChildAt(i);
            if (!node.toString().equals(trap.getCommunity())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trap.getCommunity());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jCommunityTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
        treeModel = (DefaultTreeModel)this.trapViewFrame.jSensorTree.getModel();
        root = (DefaultMutableTreeNode)treeModel.getRoot();
        find = false;
        for (i = 0; i < root.getChildCount(); ++i) {
            node = root.getChildAt(i);
            if (!node.toString().equals(trap.getSensor())) continue;
            find = true;
        }
        if (!find) {
            child = new DefaultMutableTreeNode(trap.getSensor());
            treeModel.insertNodeInto(child, root, root.getChildCount());
            this.trapViewFrame.jSensorTree.scrollPathToVisible(new TreePath(child.getPath()));
        }
    }

    public void showTrapTree(int index) {
        Trap t = (Trap)this.receiver.getTrapCollector().getTraps().get(index);
        this.showTrapTree(t);
    }

    private void showTrapTree(Trap trap) {
        if (trap.getUiObject1() == null) {
            TrapTree tt = new TrapTree();
            tt.decodeTrap(trap.getDataBuff(), trap.getDataLength());
            trap.setUiObject1(tt);
        }
        ((DefaultTreeModel)this.trapViewFrame.jTrapTree.getModel()).setRoot(((TrapTree)trap.getUiObject1()).rootNode);
        for (int i = 0; i < this.trapViewFrame.jTrapTree.getRowCount(); ++i) {
            this.trapViewFrame.jTrapTree.expandRow(i);
        }
    }

    public boolean save(String filename) {
        File f = new File(filename);
        FileOutputStream fos = null;
        DataOutputStream dos = null;
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        dos = new DataOutputStream(fos);
        try {
            dos.writeBytes(this.fileVersion);
            for (int i = 0; i < this.receiver.getTrapCollector().getTraps().size(); ++i) {
                Trap trap = (Trap)this.receiver.getTrapCollector().getTraps().get(i);
                dos.writeByte(trap.getDataLength());
                dos.write(trap.getDataBuff(), 0, trap.getDataLength());
            }
        }
        catch (IOException ex1) {
            // empty catch block
        }
        return true;
    }

    public boolean load(String filename) {
        File f = new File(filename);
        FileInputStream fis = null;
        DataInputStream dis = null;
        try {
            fis = new FileInputStream(f);
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        dis = new DataInputStream(fis);
        int length = 0;
        byte[] buff = null;
        boolean eof = false;
        byte[] fileVersionBytes = new byte[this.fileVersion.length()];
        try {
            dis.read(fileVersionBytes);
        }
        catch (IOException ex1) {
            this.trapViewFrame.statusBar.setText(L.t("trap.control.file_error"));
            return false;
        }
        if (!this.fileVersion.equals(new String(fileVersionBytes))) {
            this.trapViewFrame.statusBar.setText(L.t("trap.control.file") + " \"" + filename + "\" " + L.t("trap.control.format_error"));
            return false;
        }
        do {
            try {
                length = dis.readByte() & 0xFF;
                buff = new byte[length];
                dis.read(buff);
                Trap trap = this.receiver.decodeTrap(buff, length);
                this.receiver.getTrapCollector().put(trap);
            }
            catch (IOException ex2) {
                eof = true;
            }
        } while (!eof);
        return true;
    }

    public void updateStatusBar(TrapCollector o, Trap trap) {
        String msg = L.t("trap.control.sender") + " IP =" + trap.getIp() + ", " + L.t("trap.control.content") + " = [ " + trap.getSensor() + " ]" + trap.getDescription();
        this.trapViewFrame.statusBar.setText(L.t("trap.control.a_trap_received") + ": " + msg);
    }

    public void updateInfoDialog(TrapCollector o, Trap trap) {
        String os = System.getProperties().get("os.name").toString();
        if (os.indexOf("Window") == -1) {
            return;
        }
        if (!this.enableShowAlertWindows) {
            return;
        }
        if (this.sw == null) {
            this.sw = new SplashWindow(this.trapViewFrame, L.t("trap.control.a_trap_received"), L.t("trap.control.Sender") + ": " + trap.getIp(), L.t("trap.control.Content") + ": [ " + trap.getSensor() + " ] " + trap.getDescription());
        } else {
            this.sw.setMessage(L.t("trap.control.a_trap_received"), L.t("trap.control.Sender") + ": " + trap.getIp(), L.t("trap.control.Content") + ": [ " + trap.getSensor() + " ] " + trap.getDescription());
        }
        this.sw.repaint();
        this.sw.show();
        this.sw.setWatchDogTime(10);
    }

    public void updateChart() {
        this.trapViewFrame.jChart1Panel.removeAll();
        JPanel chart = null;
        switch (this.trapViewFrame.jChartComboBox.getSelectedIndex()) {
            case 0: {
                chart = this.trapChart.createSNMPtoSenderBarChart();
                break;
            }
            case 1: {
                chart = this.trapChart.createSNMPtoSenderPieChart();
            }
        }
        chart.setPreferredSize(new Dimension(this.trapViewFrame.jChart1Panel.getWidth(), this.trapViewFrame.jChart1Panel.getHeight()));
        this.trapViewFrame.jChart1Panel.add(chart);
        this.trapViewFrame.jChart1Panel.updateUI();
    }
}

