/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.KeyBoardMouseSetting;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.StringTokenizer;

public class IPMICMMOEMCommand
extends IPMICommand {
    public static final byte CMM_TIME_MODE_LOCAL_TIME = 0;
    public static final byte CMM_TIME_MODE_NTP = 1;
    public static final byte FAN_CONTROL_MODE_AUTOMATIC = 0;
    public static final byte FAN_CONTROL_MODE_MANUAL = 1;

    public IPMICMMOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage detectSIMCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage is3VPowerGoodCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableP12VCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerRequestCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearPowerRequestCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{5, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKVMRequestCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearKVMRequestCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableM1KVMCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{8, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableM2KVMCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        data[0] = 10;
        data[1] = bladeIndex;
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isPowerSupplyOnForBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getOverheatCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBladeUIDCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage requestRemoteKVMCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3];
        data[0] = 14;
        data[1] = bladeIndex;
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkIfEnoughPowerForBladesCommand(byte[] bladeBits) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{19, bladeBits[0], bladeBits[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage detectPowerSupplyCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerSupplyStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerSupplyFanSpeedCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testPowerSupplyFanSpeedCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enablePowerSupplyCommand(byte powerIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, powerIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getTotalRemainingPowerCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setAllPowerSupplyFanSpeedCommand(byte speed) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{7, speed};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setFanControlModeCommand(byte mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, mode};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFanControlModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10};
        ipmiMessage.setCommandAndData((byte)-64, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableInfiniBandPowerCommand(byte bandIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, bandIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetInfiniBandCommand(byte bandIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, bandIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getInfiniBandPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getInfiniBandAllSensorsCommand(byte bandIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{4, bandIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage resetGigabitSwitchCommand(byte switchIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, switchIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableGigabitSwitchPowerCommand(byte switchIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, switchIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGigabitSwitchStatusCommand(byte switchIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3, switchIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInfoCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[2];
        data[0] = param;
        ipmiMessage.setCommandAndData((byte)-64, (byte)54, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testBladeErrorLEDCommand(byte bladeIndex, byte action) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, bladeIndex, action};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMSlotCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage SetCMMTimeCommand(byte year, byte month, byte date, byte day, byte hr, byte min, byte sec) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{2, sec, min, hr, day, date, month, year};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMTimeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{3};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBIPCommand(byte gbIndex, byte[] ip) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 5;
        data[1] = gbIndex;
        System.arraycopy(ip, 0, data, 2, ip.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBNetMaskCommand(byte gbIndex, byte[] netMask) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 6;
        data[1] = gbIndex;
        System.arraycopy(netMask, 0, data, 2, netMask.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBGateWayCommand(byte gbIndex, byte[] gateWay) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        data[0] = 7;
        data[1] = gbIndex;
        System.arraycopy(gateWay, 0, data, 2, gateWay.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBUsernameCommand(byte gbIndex, byte[] username) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + username.length];
        data[0] = 8;
        data[1] = gbIndex;
        data[2] = (byte)username.length;
        System.arraycopy(username, 0, data, 3, username.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBPasswordCommand(byte gbIndex, byte[] password) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + password.length];
        data[0] = 9;
        data[1] = gbIndex;
        data[2] = (byte)password.length;
        System.arraycopy(password, 0, data, 3, password.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBTimeCommand(byte gbIndex, byte sec, byte min, byte hour, byte day, byte date, byte month, byte year, byte century) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10, gbIndex, sec, min, hour, day, date, month, year, century};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setGBCommitCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBIPCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{11, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBNetMaskCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBGatewayCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{13, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBUsernameCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{14, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBPasswordCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{15, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getGBTimeCommand(byte gbIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, gbIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getOtherCMMIPCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{6};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getCMMTimeSyncModeCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isCMMSupportIPMBCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{10};
        ipmiMessage.setCommandAndData((byte)-64, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage gracefulPowerDownBladeCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, bladeIndex};
        ipmiMessage.setCommandAndData((byte)-64, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage testReplyCommand(byte[] bytes) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + bytes.length];
        data[0] = 8;
        System.arraycopy(bytes, 0, data, 1, bytes.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA955InfoCommand(byte bladeIndex) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{9, bladeIndex, 64, 0, 8};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPCA955StatisticCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{12};
        ipmiMessage.setCommandAndData((byte)-64, (byte)55, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getKeyboardMouseSettingCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setKeyboardMouseSettingCommand(byte[] setting) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[setting.length + 1];
        data[0] = 2;
        System.arraycopy(setting, 0, data, 1, setting.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)56, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public byte[] detectSIM() throws IPMIException {
        IPMIMessage resMessage = this.detectSIMCommand();
        if (resMessage == null) {
            throw new IPMIException("call detectSIMCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] sim = new byte[4];
            System.arraycopy(resMessage.data, 0, sim, 0, sim.length);
            return sim;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte[] is3VPowerGood() throws IPMIException {
        IPMIMessage resMessage = this.is3VPowerGoodCommand();
        if (resMessage == null) {
            throw new IPMIException("call is3VPowerGoodCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] sim = new byte[4];
            System.arraycopy(resMessage.data, 0, sim, 0, sim.length);
            return sim;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public int enableP12V(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableP12VCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableP12VCommand failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data[0] == 0) {
                return 0;
            }
            if (resMessage.data[0] == 1) {
                return 1;
            }
            return 99;
        }
        return 99;
    }

    public byte getPowerRequest(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getPowerRequestCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getPowerRequestCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean clearPowerRequest(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.clearPowerRequestCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call clearPowerRequestCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getKVMRequest(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getKVMRequestCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getKVMRequestCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean clearKVMRequest(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.clearKVMRequestCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call clearKVMRequestCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableM1KVM(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableM1KVMCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableM1KVMCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableM2KVM(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableM2KVMCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableM2KVMCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean resetBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetBladeCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean requestKVM(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.requestRemoteKVMCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call requestKVM failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte isPowerSupplyOnForBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.isPowerSupplyOnForBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call isPowerSupplyOnForBladeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte getOverheat(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.getOverheatCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call getOverheatCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean setBladeUID(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.setBladeUIDCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setBladeUIDCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte detectPowerSupply() throws IPMIException {
        IPMIMessage resMessage = this.detectPowerSupplyCommand();
        if (resMessage == null) {
            throw new IPMIException("call detectPowerSupplyCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte getPowerSupplyStatus() throws IPMIException {
        IPMIMessage resMessage = this.getPowerSupplyStatusCommand();
        if (resMessage == null) {
            throw new IPMIException("call getPowerSupplyStatusCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean setPowerSupplyFanSpeed(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.setPowerSupplyFanSpeedCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setPowerSupplyFanSpeedCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean testPowerSupplyFanSpeed(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.testPowerSupplyFanSpeedCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setPowerSupplyFanSpeedCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enablePowerSupply(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enablePowerSupplyCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enablePowerSupplyCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public int getTotalRemainingPower() throws IPMIException {
        IPMIMessage resMessage = this.getTotalRemainingPowerCommand();
        if (resMessage == null) {
            throw new IPMIException("call getTotalRemainingPowerCommand failed");
        }
        if (resMessage.completionCode == 0) {
            int remainingPower = ByteUtility.twoBytesToIntMSB(resMessage.data);
            return remainingPower;
        }
        throw new IPMIException("call getTotalRemainingPowerCommand failed");
    }

    public boolean setAllPowerSupplyFanSpeed(byte speed) throws IPMIException {
        IPMIMessage resMessage = this.setAllPowerSupplyFanSpeedCommand(speed);
        if (resMessage == null) {
            throw new IPMIException("call setAllPowerSupplyFanSpeedCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setAllPowerSupplyFanSpeedCommand failed");
    }

    public boolean enableInfinibandPower(byte bandIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableInfiniBandPowerCommand(bandIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call setInfiniBandPowerCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean resetInfiniband(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetInfiniBandCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetInfiniBandCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getInfinibandPresent() throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandPresentCommand();
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandPresentCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public byte[] getInfinibandAllSensors(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandAllSensorsCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandAllSensorsCommand failed");
        }
        if (resMessage.completionCode == 0) {
            byte[] byte6 = new byte[6];
            System.arraycopy(resMessage.data, 0, byte6, 0, byte6.length);
            return byte6;
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean resetGigabitSwitch(byte switchIndex) throws IPMIException {
        IPMIMessage resMessage = this.resetGigabitSwitchCommand(switchIndex);
        if (resMessage == null) {
            throw new IPMIException("call resetGigabitSwitchCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean enableGigabitSwitchPower(byte switchIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.enableGigabitSwitchPowerCommand(switchIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call enableGigabitSwitchPower failed");
        }
        return resMessage.completionCode == 0;
    }

    public byte getGigabitSwitchStatus(byte switchIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGigabitSwitchStatusCommand(switchIndex);
        if (resMessage == null) {
            throw new IPMIException("call getGigabitSwitchStatusCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public InfiniBandSensors getInfiniBandSensors(byte bandIndex) throws IPMIException {
        IPMIMessage resMessage = this.getInfiniBandAllSensorsCommand(bandIndex);
        if (resMessage == null) {
            throw new IPMIException("call getInfiniBandAllSensorsCommand failed");
        }
        if (resMessage.completionCode == 0) {
            InfiniBandSensors infiniBandSensors = new InfiniBandSensors();
            if (infiniBandSensors.fromRaw(resMessage.data)) {
                return infiniBandSensors;
            }
            throw new IPMIException("Raw data error");
        }
        throw new IPMIException(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
    }

    public boolean testBladeErrorLED(byte bladeIndex, byte action) throws IPMIException {
        IPMIMessage resMessage = this.testBladeErrorLEDCommand(bladeIndex, action);
        if (resMessage == null) {
            throw new IPMIException("call testBladeErrorLEDCommand failed");
        }
        return resMessage.completionCode == 0;
    }

    public int getCMMSlot() throws IPMIException {
        IPMIMessage resMessage = this.getCMMSlotCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMSlot failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("return a error data from getCMMSlot");
    }

    public String getCMMTime() throws IPMIException {
        IPMIMessage resMessage = this.getCMMTimeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMTime failed");
        }
        if (resMessage.completionCode == 0) {
            int sec = ByteUtility.bcdToInt(resMessage.data[0]);
            int min = ByteUtility.bcdToInt(resMessage.data[1]);
            int hr = ByteUtility.bcdToInt(resMessage.data[2]);
            int day = ByteUtility.bcdToInt(resMessage.data[3]);
            int date = ByteUtility.bcdToInt(resMessage.data[4]);
            int month = ByteUtility.bcdToInt(resMessage.data[5]) - 1;
            int year = ByteUtility.bcdToInt(resMessage.data[6]);
            Calendar c = Calendar.getInstance();
            c.set(2000 + year, month, date, hr, min, sec);
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            String dateStr = f.format(c.getTime());
            return dateStr;
        }
        throw new IPMIException("return a error data from getCMMSlot");
    }

    public boolean setCMMTime(Calendar c) throws IPMIException {
        c.get(1);
        byte sec = ByteUtility.intToBCD(c.get(13));
        byte min = ByteUtility.intToBCD(c.get(12));
        byte hr = ByteUtility.intToBCD(c.get(11));
        byte day = ByteUtility.intToBCD(c.get(7));
        byte date = ByteUtility.intToBCD(c.get(5));
        byte month = (byte)(ByteUtility.intToBCD(c.get(2)) + 1);
        byte year = ByteUtility.intToBCD(c.get(1) - 2000);
        IPMIMessage resMessage = this.SetCMMTimeCommand(year, month, date, day, hr, min, sec);
        if (resMessage == null) {
            throw new IPMIException("call setCMMTime failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("return a error data from getCMMSlot");
    }

    public boolean setGBIP(byte gbIndex, String ip) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(ip)) {
            throw new IPMIException("IP format error!");
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("IP format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBIPCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB IP failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBNetMask(byte gbIndex, String netMask) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(netMask)) {
            throw new IPMIException("netmask format error!");
        }
        StringTokenizer st = new StringTokenizer(netMask, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("netmask format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBNetMaskCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB Netmask failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBGateway(byte gbIndex, String gateway) throws IPMIException {
        byte[] data = new byte[4];
        if (!IPMILanCommand.isIPAddress(gateway)) {
            throw new IPMIException("gateway format error!");
        }
        StringTokenizer st = new StringTokenizer(gateway, ".");
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IPMIException("gateway format error!");
            }
            data[i] = (byte)Integer.parseInt(st.nextToken());
        }
        IPMIMessage resMessage = this.setGBGateWayCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB gateway failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBUsername(byte gbIndex, String username) throws IPMIException {
        byte[] data = username.getBytes();
        IPMIMessage resMessage = this.setGBUsernameCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB username failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBPassword(byte gbIndex, String password) throws IPMIException {
        byte[] data = password.getBytes();
        IPMIMessage resMessage = this.setGBPasswordCommand(gbIndex, data);
        if (resMessage == null) {
            throw new IPMIException("call Set GB password failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBTime(byte gbIndex, Calendar c) throws IPMIException {
        byte sec = (byte)c.get(13);
        byte min = (byte)c.get(12);
        byte hour = (byte)c.get(11);
        byte day = (byte)c.get(7);
        byte date = (byte)c.get(5);
        byte month = (byte)(c.get(2) + 1);
        int yyyy = c.get(1);
        byte year = 0;
        byte centry = 0;
        if (yyyy >= 2000) {
            centry = 20;
            year = (byte)(yyyy - 2000);
        } else {
            centry = 19;
            year = (byte)(yyyy - 1900);
        }
        IPMIMessage resMessage = this.setGBTimeCommand(gbIndex, sec, min, hour, day, date, month, year, centry);
        if (resMessage == null) {
            throw new IPMIException("call Set GB time failed");
        }
        return resMessage.completionCode == 0;
    }

    public boolean setGBCommit(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.setGBCommitCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call set GB Commit failed");
        }
        return resMessage.completionCode == 0;
    }

    public String getGBIP(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBIPCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB IP failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB IP failed");
    }

    public String getGBNetMask(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBNetMaskCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB NetMask failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB NetMask failed");
    }

    public String getGBGateway(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBGatewayCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB Gateway failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            int p1 = resMessage.data[1] & 0xFF;
            int p2 = resMessage.data[2] & 0xFF;
            int p3 = resMessage.data[3] & 0xFF;
            int p4 = resMessage.data[4] & 0xFF;
            String ip = "" + p1 + "." + p2 + "." + p3 + "." + p4;
            return ip;
        }
        throw new IPMIException("call get GB Gateway failed");
    }

    public String getGBUsername(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBUsernameCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB username failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            byte[] data = new byte[length];
            System.arraycopy(resMessage.data, 1, data, 0, data.length);
            return new String(data);
        }
        throw new IPMIException("call get GB username failed");
    }

    public String getGBPassword(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBPasswordCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB password failed");
        }
        if (resMessage.completionCode == 0) {
            byte length = resMessage.data[0];
            byte[] data = new byte[length];
            System.arraycopy(resMessage.data, 1, data, 0, data.length);
            return new String(data);
        }
        throw new IPMIException("call get GB password failed");
    }

    public Calendar getGBTime(byte gbIndex) throws IPMIException {
        IPMIMessage resMessage = this.getGBTimeCommand(gbIndex);
        if (resMessage == null) {
            throw new IPMIException("call get GB time failed");
        }
        if (resMessage.completionCode == 0) {
            if (resMessage.data.length == 0) {
                throw new IPMIException("GB Time data error. Length = 0");
            }
            byte length = resMessage.data[0];
            byte sec = resMessage.data[1];
            byte min = resMessage.data[2];
            byte hour = resMessage.data[3];
            byte day = resMessage.data[4];
            byte date = resMessage.data[5];
            byte month = resMessage.data[6];
            byte year = resMessage.data[7];
            byte century = resMessage.data[8];
            Calendar c = Calendar.getInstance();
            c.set(century * 100 + year, month - 1, date, hour, min, sec);
            return c;
        }
        throw new IPMIException("call get GB time failed");
    }

    public String getCMMOtherIP() throws IPMIException {
        IPMIMessage resMessage = this.getOtherCMMIPCommand();
        if (resMessage == null) {
            throw new IPMIException("call get CMM other IP failed");
        }
        if (resMessage.completionCode == 0) {
            String ip = (resMessage.data[0] & 0xFF) + "." + (resMessage.data[1] & 0xFF) + "." + (resMessage.data[2] & 0xFF) + "." + (resMessage.data[3] & 0xFF);
            return ip;
        }
        throw new IPMIException("call get CMM other IP failed");
    }

    public boolean gracefulPowerDownBlade(byte bladeIndex) throws IPMIException {
        IPMIMessage resMessage = this.gracefulPowerDownBladeCommand(bladeIndex);
        if (resMessage == null) {
            throw new IPMIException("call graceful shutdown failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call graceful shutdown failed");
    }

    public boolean setFanControlMode(byte mode) throws IPMIException {
        IPMIMessage resMessage = this.setFanControlModeCommand(mode);
        if (resMessage == null) {
            throw new IPMIException("call set Fan Control Mode failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call set Fan Control Mode failed");
    }

    public byte getFanControlMode() throws IPMIException {
        IPMIMessage resMessage = this.getFanControlModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call get Fan Control Mode failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call get Fan Control Mode failed");
    }

    public byte getCMMTimeSyncMode() throws IPMIException {
        IPMIMessage resMessage = this.getCMMTimeSyncModeCommand();
        if (resMessage == null) {
            throw new IPMIException("call getCMMTimeSyncModeCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0];
        }
        throw new IPMIException("call getCMMTimeSyncModeCommand failed");
    }

    public boolean isCMMSupportIPMB() throws IPMIException {
        IPMIMessage resMessage = this.isCMMSupportIPMBCommand();
        if (resMessage == null) {
            throw new IPMIException("call isCMMSupportIPMB failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        throw new IPMIException("call isCMMSupportIPMB failed");
    }

    public boolean checkIfEnoughPowerForBlades(byte[] bladeBits) throws IPMIException {
        IPMIMessage resMessage = this.checkIfEnoughPowerForBladesCommand(bladeBits);
        if (resMessage == null) {
            throw new IPMIException("call checkIfEnoughPowerForBlades failed");
        }
        if (resMessage.completionCode == 0) {
            return resMessage.data[0] == 1;
        }
        throw new IPMIException("call checkIfEnoughPowerForBlades failed");
    }

    public KeyBoardMouseSetting getKeyBoardMouseSetting() throws IPMIException {
        KeyBoardMouseSetting km;
        boolean result;
        IPMIMessage resMessage = this.getKeyboardMouseSettingCommand();
        if (resMessage == null) {
            throw new IPMIException("call getKeyboardMouseSettingCommand failed");
        }
        if (resMessage.completionCode == 0 && (result = (km = new KeyBoardMouseSetting()).fromRaw(resMessage.data))) {
            return km;
        }
        throw new IPMIException("call getKeyboardMouseSettingCommand failed");
    }

    public boolean setKeyBoardMouseSetting(KeyBoardMouseSetting km) throws IPMIException {
        IPMIMessage resMessage = this.setKeyboardMouseSettingCommand(km.toRaw());
        if (resMessage == null) {
            throw new IPMIException("call setKeyboardMouseSettingCommand failed");
        }
        if (resMessage.completionCode == 0) {
            return true;
        }
        throw new IPMIException("call setKeyboardMouseSettingCommand failed");
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.118");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiCMMOEMCommand.setIPMIInterface(rmcp);
        try {
            KeyBoardMouseSetting km = ipmiCMMOEMCommand.getKeyBoardMouseSetting();
            System.out.println(ByteUtility.bytesToHex(km.toRaw()));
        }
        catch (IPMIException ex) {
            // empty catch block
        }
        boolean result = sessionController.closeSession();
        if (result) {
            System.out.println("logout ok");
        } else {
            System.out.println("logout failed");
        }
    }

    public static void main_fanCtrl(String[] args) throws Exception {
        String ip = "";
        String u = "";
        String p = "";
        int n = 0;
        int s = 0;
        if (args.length == 10) {
            for (int i = 0; i < args.length; i += 2) {
                if (args[i].equals("-ip")) {
                    ip = args[i + 1];
                    continue;
                }
                if (args[i].equals("-u")) {
                    u = args[i + 1];
                    continue;
                }
                if (args[i].equals("-p")) {
                    p = args[i + 1];
                    continue;
                }
                if (args[i].equals("-n")) {
                    n = Integer.parseInt(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-s")) {
                    if (args[i + 1].length() == 4) {
                        s = new BigInteger(args[i + 1].substring(2), 16).intValue();
                        continue;
                    }
                    System.out.println("Incorrect fan speed value (0x00 -- 0xFF)!");
                    System.exit(0);
                    continue;
                }
                System.out.println("Unknown command: " + args[i]);
                IPMICMMOEMCommand.usage();
                System.exit(0);
            }
        } else {
            IPMICMMOEMCommand.usage();
            System.exit(0);
        }
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(u);
        config.setPassword(p);
        config.setPrivilege((byte)4);
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiCMMOEMCommand);
        if (sessionController == null) {
            return;
        }
        IPMIMessage resMessage = ipmiCMMOEMCommand.testPowerSupplyFanSpeedCommand((byte)n, (byte)s);
        if (resMessage == null) {
            System.out.println("Set power supply fan speed command failed!");
        }
        sessionController.closeSession();
    }

    private static void usage() {
        System.out.println("Usage: PSFANCTRL -ip 192.168.1.115 -u ADMIN -p ADMIN -n 1 -s 0x05");
        System.out.println("-ip\tThe IP address of a CMM to connect.");
        System.out.println("-u\tA valid username which has the administration privilege.");
        System.out.println("-p\tPassword.");
        System.out.println("-n\tThe Power Supply number.");
        System.out.println("-s\tThe fan speed value (0x00 -- 0xFF).");
    }

    class InfiniBandSensors {
        byte[] raw;
        public double vvdd;
        public double v3_3v_AUX;
        public double v1_8v;
        public double v3_3v;
        public double v1_2v;
        public double temperature;

        public boolean fromRaw(byte[] raw) {
            if (raw.length != 6) {
                return false;
            }
            this.raw = raw;
            this.vvdd = (double)raw[0] * 3.333 / 256.0;
            this.v3_3v_AUX = (double)raw[1] * 3.333 / 256.0;
            this.v1_8v = (double)raw[2] * 6.66 / 256.0;
            this.v3_3v = raw[3] * 16 / 256;
            this.v1_2v = (double)raw[4] * 3.6 / 256.0;
            this.temperature = raw[5];
            return true;
        }
    }
}

