/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMIChassisCommand
extends IPMICommand {
    public IPMIChassisCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getChassisStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)0, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage chassisControlCommand(byte parameter) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{parameter};
        ipmiMessage.setCommandAndData((byte)0, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean powerDown() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean powerUp() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean powerCycle() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)2);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean reset() {
        IPMIMessage resMessage = this.chassisControlCommand((byte)3);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Chassis controls");
        return false;
    }

    public boolean softShutdown() {
        byte command = 5;
        IPMIMessage resMessage = this.chassisControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute soft shut down");
        return false;
    }

    public static void main(String[] args) {
        boolean result;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.249");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiChassisCommand.setIPMIInterface(rmcp);
        IPMIMessage resMessage = ipmiChassisCommand.getChassisStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            MessageCenter.getInstance().put(ByteUtility.bytesToHex(resMessage.data));
        }
        if (result = ipmiChassisCommand.softShutdown()) {
            MessageCenter.getInstance().put("ok");
        } else {
            MessageCenter.getInstance().put("failed");
        }
        sessionController.closeSession();
    }
}

