/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ASFMessage;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCP;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionInfo;
import java.util.ArrayList;
import java.util.TreeMap;

public class IPMIMessagingCommand
extends IPMICommand {
    TreeMap userIDtoName = new TreeMap();

    public IPMIMessagingCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public ASFMessage asfPing() {
        ASFMessage asfPingMessage = new ASFMessage();
        ASFMessage asfPongMessage = ((RMCP)this.ipmiInterface).sendASFMessage(asfPingMessage);
        return asfPongMessage;
    }

    public IPMIMessage GetSystemGUIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        ipmiMessage.setCommandAndData((byte)24, (byte)55, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetChannelAuthenticationCapabilitiesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1, 4};
        ipmiMessage.setCommandAndData((byte)24, (byte)56, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetChannelAuthenticationCapabilitiesCommandForPlus() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{-127, 4};
        ipmiMessage.setCommandAndData((byte)24, (byte)56, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage GetSessionChallengeCommand(String userName) {
        IPMIMessage resMessage;
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[18];
        data[0] = 2;
        System.arraycopy(userName.getBytes(), 0, data, 1, userName.length());
        ipmiMessage.setCommandAndData((byte)24, (byte)57, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        if ((resMessage = this.ipmiInterface.send(ipmiMessage)) != null && resMessage.completionCode == 0) {
            System.arraycopy(resMessage.data, 0, ((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, 4);
        }
        return resMessage;
    }

    public IPMIMessage activateSessionCommand(byte authType, byte maxPrivilege, byte[] challengeString) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[22];
        data[0] = authType;
        data[1] = maxPrivilege;
        System.arraycopy(challengeString, 0, data, 2, 16);
        System.arraycopy(((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, data, 18, 4);
        ipmiMessage.setCommandAndData((byte)24, (byte)58, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = 0;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setSessionPrivilegeLevelCommand(byte privilegeLevel) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{privilegeLevel};
        ipmiMessage.setCommandAndData((byte)24, (byte)59, data);
        if (this.ipmiInterface instanceof RMCP) {
            ((RMCP)this.ipmiInterface).rmcpSession.authType = (byte)2;
        }
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage closeSessionCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        if (this.ipmiInterface instanceof RMCPPlus) {
            System.arraycopy(((RMCPPlus)this.ipmiInterface).rmcpPlusSession.sessionID, 0, data, 0, 4);
        } else if (this.ipmiInterface instanceof RMCP) {
            System.arraycopy(((RMCP)this.ipmiInterface).rmcpSession.sessionID, 0, data, 0, 4);
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage closeSessionCommand(byte[] sessionID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(sessionID, 0, data, 0, data.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)60, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSessionInfoCommand(byte sessionIndex, byte sessionHandle, byte[] sessionID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        if (sessionIndex == -2) {
            data = new byte[2];
            data[1] = sessionHandle;
        } else if (sessionIndex == -1) {
            data = new byte[5];
            System.arraycopy(sessionID, 0, data, 1, 4);
        } else {
            data = new byte[]{sessionIndex};
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)61, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserAccessCommand(byte data1, byte userID, byte userLimit, byte userSessionLimit) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{data1, userID, userLimit, userSessionLimit};
        ipmiMessage.setCommandAndData((byte)24, (byte)67, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUserAccessCommand(byte channelNumber, byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channelNumber, userID};
        ipmiMessage.setCommandAndData((byte)24, (byte)68, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserNameCommand(byte userID, String userName) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[17];
        data[0] = userID;
        System.arraycopy(userName.getBytes(), 0, data, 1, userName.length());
        ipmiMessage.setCommandAndData((byte)24, (byte)69, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getUserNameCommand(byte userID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{userID};
        ipmiMessage.setCommandAndData((byte)24, (byte)70, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setUserPasswordCommand(byte userID, byte operation, String password) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = null;
        if (this.ipmiInterface instanceof RMCP) {
            data = new byte[18];
            data[0] = userID;
            data[1] = operation;
            System.arraycopy(password.getBytes(), 0, data, 2, password.getBytes().length);
        } else if (this.ipmiInterface instanceof RMCPPlus) {
            data = new byte[22];
            data[0] = (byte)(userID & 0xBF);
            data[1] = operation;
            System.arraycopy(password.getBytes(), 0, data, 2, password.getBytes().length);
        }
        ipmiMessage.setCommandAndData((byte)24, (byte)71, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBMCGlobalEnablesCommand(byte setting) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{setting};
        ipmiMessage.setCommandAndData((byte)24, (byte)46, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBMCGlobalEnablesCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)47, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearMessageFlagsCommand(byte flags) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{flags};
        ipmiMessage.setCommandAndData((byte)24, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMessageFlagsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableMessageChannelReceiveCommand(byte channel, byte channelState) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{channel, channelState};
        ipmiMessage.setCommandAndData((byte)24, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMessageCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage sendMessageCommand(byte channel, byte[] messageData) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[1 + messageData.length];
        data[0] = channel;
        data[0] = (byte)(data[0] | 0x80);
        System.arraycopy(messageData, 0, data, 1, messageData.length);
        ipmiMessage.setCommandAndData((byte)24, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        resMessage = this.ipmiInterface.receive();
        return resMessage;
    }

    public IPMIMessage readEventMessageBufferCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)24, (byte)53, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSystemInterfaceCapabilitiesCommand(byte type) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{type};
        ipmiMessage.setCommandAndData((byte)24, (byte)87, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public int getNumberOfAvailableUser() {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0x3F & resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return -1;
    }

    public int getCountOfCurrentEnabledUser() {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, (byte)1);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return 0x3F & resMessage.data[1];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return -1;
    }

    public String getUserNameByID(byte userID) {
        IPMIMessage resMessage = this.getUserNameCommand(userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return new String(resMessage.data).trim();
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User Name");
        return null;
    }

    public byte getUserIDByName(String userName) {
        for (byte i = 2; i <= 10; i = (byte)(i + 1)) {
            String tempUserName = this.getUserNameByID(i);
            if (!tempUserName.equals(userName)) continue;
            return i;
        }
        return -1;
    }

    public boolean setUserNameByID(byte userID, String username) {
        IPMIMessage resMessage = this.setUserNameCommand(userID, username);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User name successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User name");
        return false;
    }

    public boolean setUserPasswordByID(byte userID, String password) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)2, password);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User password successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public boolean setEnableUserByID(byte userID) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)1, "");
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable password successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public boolean setEnableUserPlusByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-79, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable user (plus) successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set enable User (Plus)");
        return false;
    }

    public boolean setDisableUserPlusByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-127, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set enable user (plus) successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set enable User (Plus)");
        return false;
    }

    public boolean setDisableUserByID(byte userID) {
        IPMIMessage resMessage = this.setUserPasswordCommand(userID, (byte)0, "");
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set disable user successful");
                return true;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Password size correct, but password data does not match stored value.");
                    break;
                }
                case -127: {
                    MessageCenter.getInstance().put(this, (Object)"(mandatory) password test failed. Wrong password size was used");
                    break;
                }
                default: {
                    MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                }
            }
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User password");
        return false;
    }

    public byte getUserPrivilegeByID(byte userID) {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (byte)(resMessage.data[3] & 0xF);
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User Access");
        return -1;
    }

    public boolean setUserPrivilegeByID(byte userID, byte privilege) {
        IPMIMessage resMessage = this.setUserAccessCommand((byte)-79, userID, privilege, (byte)0);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                MessageCenter.getInstance().put(this, (Object)"Set User privilege successful");
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Set User Access");
        return false;
    }

    public boolean isEnableUser(byte userID) {
        IPMIMessage resMessage = this.getUserAccessCommand((byte)1, userID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[3] & 0x30) > 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        return false;
    }

    public void createUserID2Name() {
        this.userIDtoName.clear();
        int number = this.getNumberOfAvailableUser();
        for (int i = 1; i <= number; ++i) {
            String name = this.getUserNameByID((byte)i);
            this.userIDtoName.put("" + i, name);
        }
    }

    public SessionInfo getCurrentlySessionInfo(byte[] sessionID) {
        IPMIMessage resMessage = this.getSessionInfoCommand((byte)-1, (byte)0, sessionID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                SessionInfo sessionInfo = SessionInfo.fromRaw(resMessage.data);
                return sessionInfo;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Session Info");
        return null;
    }

    public ArrayList getAllCurrentlySessionInfo(byte numberOfSessions) {
        ArrayList<SessionInfo> al = new ArrayList<SessionInfo>();
        for (int i = 1; i < numberOfSessions + 1; ++i) {
            IPMIMessage resMessage = this.getSessionInfoCommand((byte)i, (byte)0, null);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    SessionInfo sessionInfo = SessionInfo.fromRaw(resMessage.data);
                    al.add(sessionInfo);
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get User access");
        }
        return al;
    }

    public byte[] getSystemGUID() {
        IPMIMessage resMessage = this.GetSystemGUIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            return null;
        }
        return null;
    }

    public static byte[] getSystemGUIDByIP(String ip) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setRetry(1);
        config.setIp(ip);
        RMCP rmcp = new RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        rmcp.closeSocket();
        return guid;
    }

    public static boolean isPepperconGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 2 && guid[1] == 0 && guid[2] == 0 && guid[3] == -1 && guid[4] == -2 && guid[5] == 0 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isPepperconNoneKVMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 48 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0 && guid[8] == 8 && guid[9] == 9 && guid[10] == 10 && guid[11] == 11 && guid[12] == 12 && guid[13] == 13 && guid[14] == 14 && guid[15] == 15;
    }

    public static boolean isCMMGUID(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 49 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public static boolean isSIMBL(byte[] guid) {
        if (guid == null || guid.length == 0) {
            return false;
        }
        return guid[0] == 50 && guid[1] == 48 && guid[2] == 48 && guid[3] == 49 && guid[4] == 77 && guid[5] == 83 && guid[6] == 0 && guid[7] == 0;
    }

    public boolean clearReceiveMessageQueue() {
        IPMIMessage resMessage = this.clearMessageFlagsCommand((byte)1);
        if (resMessage != null) {
            return resMessage.completionCode == 0;
        }
        return false;
    }

    public static void main_sessionTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.9");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        ipmiMessageingCommand.createUserID2Name();
        System.out.println(ipmiMessageingCommand.userIDtoName.toString());
        SessionInfo sessionInfo = ipmiMessageingCommand.getCurrentlySessionInfo(((RMCPPlus)rmcp).rmcpPlusSession.sessionID);
        ArrayList al = ipmiMessageingCommand.getAllCurrentlySessionInfo(sessionInfo.getNumberOfCurrentlyActiveSession());
        System.out.println("SessionID = " + ByteUtility.bytesToHex(((RMCPPlus)rmcp).rmcpPlusSession.sessionID));
        for (SessionInfo aSessionInfo : al) {
            if (aSessionInfo != null) {
                System.out.println(aSessionInfo.toString());
                System.out.println(" User Name = " + ipmiMessageingCommand.userIDtoName.get("" + aSessionInfo.getUserID()));
            }
            if (aSessionInfo.getSessionHandle() == sessionInfo.getSessionHandle()) continue;
            System.out.println("sessionHandle =" + aSessionInfo.getSessionHandle());
            byte[] sessionID = new byte[4];
            sessionID[0] = aSessionInfo.getSessionHandle();
            System.out.println(" SessionID be to closed =" + ByteUtility.bytesToHex(sessionID));
            IPMIMessage resMessage = ipmiMessageingCommand.closeSessionCommand(sessionID);
            if (resMessage == null) continue;
            System.out.println(" Close session result = " + GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        sessionController.closeSession();
    }

    public static void main______(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        RMCP rmcp = new RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(rmcp);
        IPMIMessage resMessage = ipmiMessageingCommand.GetSystemGUIDCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
    }

    public static void main___ipmb(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.240");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        IPMIMessage resMessage = ipmiMessageingCommand.getBMCGlobalEnablesCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        resMessage = ipmiMessageingCommand.getMessageFlagsCommand();
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        resMessage = ipmiMessageingCommand.getSystemInterfaceCapabilitiesCommand((byte)1);
        System.out.println(ByteUtility.bytesToHex(resMessage.data));
        byte[] a = new byte[10];
        resMessage = ipmiMessageingCommand.sendMessageCommand((byte)0, a);
        System.out.println(ByteUtility.byteToHex(resMessage.completionCode));
        resMessage = ipmiMessageingCommand.getMessageCommand();
        System.out.println(ByteUtility.byteToHex(resMessage.completionCode));
        sessionController.closeSession();
    }

    public static void main_old(String[] args) {
        int i;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.1.117");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        int number = ipmiMessageingCommand.getNumberOfAvailableUser();
        System.out.println("number of available number =" + number);
        number = ipmiMessageingCommand.getCountOfCurrentEnabledUser();
        System.out.println("current enabled user =" + number);
        for (i = 1; i <= 10; ++i) {
            String name = ipmiMessageingCommand.getUserNameByID((byte)i);
            System.out.println(i + ": " + name);
        }
        for (i = 1; i <= 10; ++i) {
            boolean isEnable = ipmiMessageingCommand.isEnableUser((byte)i);
            System.out.println(i + ": " + (isEnable ? "enable" : "disable"));
        }
        boolean result = ipmiMessageingCommand.setUserNameByID((byte)1, "nulluser");
        System.out.println("result =" + result);
        result = ipmiMessageingCommand.setEnableUserByID((byte)1);
        System.out.println("result =" + result);
        for (i = 4; i <= 10; ++i) {
            ipmiMessageingCommand.setDisableUserByID((byte)i);
        }
        result = ipmiMessageingCommand.setUserNameByID((byte)10, "test");
        result = ipmiMessageingCommand.setUserPasswordByID((byte)10, "test");
        result = ipmiMessageingCommand.setEnableUserByID((byte)10);
        result = ipmiMessageingCommand.setUserPrivilegeByID((byte)10, (byte)4);
        System.out.println(ipmiMessageingCommand.getUserNameByID((byte)10));
        System.out.println(ipmiMessageingCommand.isEnableUser((byte)10));
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        String ip = "192.168.1.112";
        for (int i = 0; i < 100; ++i) {
            System.out.println("test start " + i);
            IPMIMessagingCommand.getSystemGUIDByIP(ip);
            System.out.println("test 1 end " + i);
        }
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(ip);
        System.out.println(ByteUtility.bytesToHex(guid));
        System.out.println(new String(guid));
        System.out.println(IPMIMessagingCommand.isCMMGUID(guid));
        System.out.println(IPMIMessagingCommand.isPepperconGUID(guid));
        System.out.println(IPMIMessagingCommand.isPepperconNoneKVMGUID(guid));
    }

    public static void main___(String[] args) {
        int i;
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        int number = ipmiMessageingCommand.getNumberOfAvailableUser();
        System.out.println("number of available User =" + number);
        number = ipmiMessageingCommand.getCountOfCurrentEnabledUser();
        System.out.println("current enabled user =" + number);
        for (i = 1; i <= 10; ++i) {
            String name = ipmiMessageingCommand.getUserNameByID((byte)i);
            System.out.println(i + ": " + name);
        }
        for (i = 1; i <= 10; ++i) {
            boolean isEnable = ipmiMessageingCommand.isEnableUser((byte)i);
            System.out.println(i + ": " + (isEnable ? "enable" : "disable"));
        }
        boolean result = ipmiMessageingCommand.setUserNameByID((byte)10, "test");
        result = ipmiMessageingCommand.setUserPasswordByID((byte)10, "test");
        result = ipmiMessageingCommand.setEnableUserByID((byte)10);
        result = ipmiMessageingCommand.setUserPrivilegeByID((byte)10, (byte)4);
        System.out.println(ipmiMessageingCommand.getUserNameByID((byte)10));
        System.out.println(ipmiMessageingCommand.isEnableUser((byte)10));
        sessionController.closeSession();
    }

    public static void main__(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIMessagingCommand ipmiMessageingCommand = new IPMIMessagingCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiMessageingCommand.setIPMIInterface(rmcp);
        for (int j = 0; j < 1000; ++j) {
            for (int i = 1; i <= 10; ++i) {
                String name = ipmiMessageingCommand.getUserNameByID((byte)i);
                System.out.println(i + ": " + name);
                byte b = ipmiMessageingCommand.getUserPrivilegeByID((byte)i);
            }
        }
        sessionController.closeSession();
    }
}

