/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;

public class IPMIOEMCommand
extends IPMICommand {
    public String[][] idToBoard = new String[][]{{"80", "80", "X7DB8"}, {"81", "80", "X7DA8"}, {"83", "80", "X7DBP-X"}, {"84", "80", "X7DBR-8+"}, {"11", "11", "H8DCR-3"}, {"85", "80", "PDSML"}, {"12", "11", "H8DC8"}, {"86", "80", "X7DVL"}, {"87", "80", "PDSBA"}, {"88", "80", "X7DBX"}, {"89", "80", "X7DBP-8"}, {"90", "80", "X7DB8-X"}, {"91", "80", "PDSME+"}, {"92", "80", "X7DBR-3"}, {"93", "80", "PDSLM"}, {"94", "80", "X7DAL-E"}, {"13", "11", "H8QM8-2"}};

    public IPMIOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage gracefulPowerControlCommand(byte param) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{param};
        ipmiMessage.setCommandAndData((byte)-64, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage isUIDPresentCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage enableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)13, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage disableUIDLEDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)14, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)17, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getProductIDCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public boolean gracefulPowerCycle() {
        byte command = 3;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerCycle");
        return false;
    }

    public boolean gracefulPowerReset() {
        byte command = 2;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerReset");
        return false;
    }

    public boolean gracefulPowerShutDown() {
        byte command = 1;
        IPMIMessage resMessage = this.gracefulPowerControlCommand(command);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute gracefulPowerShutDown");
        return false;
    }

    public boolean enableUIDLED() {
        IPMIMessage resMessage = this.enableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute enable UID LED");
        return false;
    }

    public boolean disableUIDLED() {
        IPMIMessage resMessage = this.disableUIDLEDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute disable UID LED");
        return false;
    }

    public boolean isUIDPresent() {
        IPMIMessage resMessage = this.isUIDPresentCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute isUIDPresent");
        return false;
    }

    public byte[] getProductID() {
        IPMIMessage resMessage = this.getProductIDCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[]{resMessage.data[0], resMessage.data[1]};
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Product ID");
        return null;
    }

    public byte[] getBoardModelByte() {
        byte[] productID = this.getProductID();
        return productID;
    }

    public String getBoardModel() {
        byte[] productID = this.getProductID();
        if (productID != null) {
            for (int i = 0; i < this.idToBoard.length; ++i) {
                if (!this.idToBoard[i][0].equals(ByteUtility.byteToHex(productID[0])) || !this.idToBoard[i][1].equals(ByteUtility.byteToHex(productID[1]))) continue;
                return this.idToBoard[i][2];
            }
        }
        return null;
    }

    public byte[] getSensors() {
        IPMIMessage resMessage = this.getSensorsCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get Sensors");
        return null;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.236");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiOEMCommand.setIPMIInterface(rmcp);
        byte[] boardModelByte = ipmiOEMCommand.getBoardModelByte();
        String boardModel = ipmiOEMCommand.getBoardModel();
        System.out.println("board model is " + ByteUtility.bytesToHex(boardModelByte) + "[" + boardModel + "]");
        System.out.println("is UID present ? " + ipmiOEMCommand.isUIDPresent());
    }
}

