/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.lang.L;
import java.util.ArrayList;

public class IPMISDRCommand
extends IPMICommand {
    public IPMISDRCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getSDRRepositoryInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage deleteSDRCommand(byte[] reservationID, byte[] recordID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[4];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 2, 2);
        ipmiMessage.setCommandAndData((byte)40, (byte)38, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearSDRCommand(byte[] reservationID, byte cmd) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        data[2] = 67;
        data[3] = 76;
        data[4] = 82;
        data[5] = cmd;
        ipmiMessage.setCommandAndData((byte)40, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage addSDRCommand(byte[] data) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        ipmiMessage.setCommandAndData((byte)40, (byte)36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage ReserveSDR() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)40, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSDRCommand(byte[] reservationID, byte[] recordID, byte offset, byte bytesToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[6];
        System.arraycopy(reservationID, 0, data, 0, 2);
        System.arraycopy(recordID, 0, data, 2, 2);
        data[4] = offset;
        data[5] = bytesToRead;
        ipmiMessage.setCommandAndData((byte)40, (byte)35, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getSensorReadingCommand(byte sensorNumber) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{sensorNumber};
        ipmiMessage.setCommandAndData((byte)16, (byte)45, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public SDRInfo getSDRRepositoryInfoModal() {
        IPMIMessage resMessage = this.getSDRRepositoryInfoCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return SDRInfo.fromRaw(resMessage.data);
            }
            if (resMessage.completionCode == 129) {
                MessageCenter.getInstance().put(this, (Object)"cannot execute command, SEL erase in progress");
            } else {
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            }
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute get SDR repository info");
        return null;
    }

    public byte[] getSDRReservationID() {
        IPMIMessage resMessage = this.ReserveSDR();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Reserve SDR ID");
        return null;
    }

    public boolean clearSDR() {
        byte[] reservationID = this.getSDRReservationID();
        byte initErease = -86;
        byte getStatus = 0;
        if (reservationID == null) {
            return false;
        }
        IPMIMessage resMessage = this.clearSDRCommand(reservationID, initErease);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                for (int i = 0; i < 20; ++i) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        System.out.println(ex.getStackTrace());
                    }
                    reservationID = this.getSDRReservationID();
                    resMessage = this.clearSDRCommand(reservationID, getStatus);
                    if (resMessage.completionCode == 0) {
                        if (resMessage.data[0] != 1) continue;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public boolean addSDR(byte[] data) {
        IPMIMessage resMessage = this.addSDRCommand(data);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public boolean deleteSDR(int recordID) {
        byte[] recordIDBytes = new byte[2];
        ByteUtility.intTo2Bytes(recordIDBytes, 0, recordID);
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            return false;
        }
        IPMIMessage resMessage = this.deleteSDRCommand(reservationID, recordIDBytes);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return true;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return false;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute delete SDR");
        return false;
    }

    public ArrayList getSDRs(int length) {
        ArrayList<SDRRecord> list = new ArrayList<SDRRecord>();
        byte[] recordID = new byte[2];
        byte offset = 0;
        byte byteToRead = 22;
        byte[] reservationID = this.getSDRReservationID();
        if (reservationID == null) {
            return null;
        }
        for (int i = 0; i < length; ++i) {
            MessageCenter.getInstance().put(this, (Object)(L.t("sdr.Getting_SDR_entry") + " (" + (i + 1) + ")"));
            IPMIMessage resMessage = this.getSDRCommand(reservationID, recordID, offset, byteToRead);
            if (resMessage != null) {
                if (resMessage.completionCode == 0) {
                    byte[] bytes = new byte[64];
                    System.arraycopy(resMessage.data, 2, bytes, 0, byteToRead);
                    IPMIMessage resMessage2 = this.getSDRCommand(reservationID, recordID, byteToRead, byteToRead);
                    IPMIMessage resMessage3 = this.getSDRCommand(reservationID, recordID, (byte)(byteToRead * 2), (byte)20);
                    if (resMessage2 == null || resMessage2.completionCode != 0) {
                        MessageCenter.getInstance().put(this, (Object)("2nd Get SDR error:" + GlobalDefine.getCompletionCodeString(resMessage2.completionCode)));
                        continue;
                    }
                    System.arraycopy(resMessage2.data, 2, bytes, byteToRead, resMessage2.data.length - 2);
                    if (resMessage3 == null || resMessage3.completionCode != 0) {
                        MessageCenter.getInstance().put(this, (Object)("3nd Get SDR error:" + GlobalDefine.getCompletionCodeString(resMessage3.completionCode)));
                        continue;
                    }
                    System.arraycopy(resMessage3.data, 2, bytes, byteToRead * 2, resMessage3.data.length - 2);
                    System.arraycopy(resMessage.data, 0, recordID, 0, 2);
                    list.add(SDRRecord.fromRaw(bytes));
                    continue;
                }
                MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
                continue;
            }
            MessageCenter.getInstance().put(this, (Object)"Can't execute Get SDR");
            break;
        }
        return list;
    }

    public byte getSensorReading(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return -1;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Reading");
        return -1;
    }

    public byte[] getFullSensorValue(byte sensorNumber) {
        IPMIMessage resMessage = this.getSensorReadingCommand(sensorNumber);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                byte[] bytes = new byte[resMessage.data.length];
                System.arraycopy(resMessage.data, 0, bytes, 0, bytes.length);
                return bytes;
            }
            MessageCenter.getInstance().put(this, (Object)GlobalDefine.getCompletionCodeString(resMessage.completionCode));
            return null;
        }
        MessageCenter.getInstance().put(this, (Object)"Can't execute Get Sensor Value");
        return null;
    }

    public static void main_del_sdr(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.241");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSDRCommand.setIPMIInterface(rmcp);
        boolean result = ipmiSDRCommand.deleteSDR(3);
        System.out.println("result =" + result);
        result = ipmiSDRCommand.deleteSDR(4);
        System.out.println("result =" + result);
        sessionController.closeSession();
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.10.200");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiSDRCommand.setIPMIInterface(rmcp);
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        if (sdrInfo != null) {
            MessageCenter.getInstance().put(sdrInfo.toString());
        }
        ArrayList list = ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        for (Object item : list) {
            System.out.print(((SDRRecord)item).toEileenString());
        }
        for (Object item : SDRRecord.sensorNumberToSensorName.keySet()) {
            Object value = SDRRecord.sensorNumberToSensorName.get(item);
            System.out.println(item + " = " + value);
        }
        sessionController.closeSession();
    }
}

