/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import java.util.ArrayList;

public class SessionControllerFactory {
    public static ISessionController createSessionController(IPMIInterfaceConfig config, IPMICommand ipmiCommand) {
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static ISessionController createSessionControllerEx(IPMIInterfaceConfig config, IPMICommand ipmiCommand) throws IPMIException {
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            throw new IPMIException("Can't connect to " + config.getIp());
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            throw new IPMIException("Can't login to " + config.getIp());
        }
        ipmiCommand.setIPMIInterface(rmcp);
        return sessionController;
    }

    public static ISessionController createSessionController(IPMIInterfaceConfig config, ArrayList ipmiCommands) {
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return null;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        for (Object item : ipmiCommands) {
            if (!(item instanceof IPMICommand)) continue;
            ((IPMICommand)item).setIPMIInterface(rmcp);
        }
        return sessionController;
    }

    public static ISessionController createSessionControllerWithAutomaticllyCheckPrivilege(IPMIInterfaceConfig config, IPMICommand ipmiCommand) {
        IPMINetworkInterface rmcp = null;
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        if (sessionController == null) {
            MessageCenter.getInstance().put("Can't connect to " + config.getIp());
            return null;
        }
        for (int i = 4; i >= 2; --i) {
            config.setPrivilege((byte)i);
            rmcp = sessionController.startup(config);
            if (rmcp == null) continue;
            MessageCenter.getInstance().put("RMCP Login successfully");
            break;
        }
        if (rmcp != null) {
            ipmiCommand.setIPMIInterface(rmcp);
        }
        return sessionController;
    }

    public static void main(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        config.setIp("192.168.10.241");
        config.setUserName("oper");
        config.setPassword("oper");
        SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(config, ipmiGlobalCommand);
        if (ipmiGlobalCommand.getIPMIInterface() != null) {
            System.out.println(ipmiGlobalCommand.getDevice().toString());
        } else {
            System.out.println("ip or password error");
        }
    }
}

