/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.ByteUtility;
import java.util.Observable;

public class CMMModuleEntity
extends Observable {
    private byte present;
    private byte masterSlave;
    private byte status;
    private byte slot;
    private byte reserve2;
    private byte reserve3;
    private byte reserve4;
    private byte reserve5;
    private byte reserve6;
    private byte reserve7;
    private byte reserve8;
    private byte[] raw;
    private int moduleIndex;
    private boolean connected = false;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\npresent =" + this.present);
        sb.append("\nmasterSlave =" + this.masterSlave);
        sb.append("\nstatus =" + this.status);
        sb.append("\nslot =" + this.slot);
        sb.append("\nreserve2 =" + this.reserve2);
        sb.append("\nreserve3 =" + this.reserve3);
        sb.append("\nreserve4 =" + this.reserve4);
        sb.append("\nreserve5 =" + this.reserve5);
        sb.append("\nreserve6 =" + this.reserve6);
        sb.append("\nreserve7 =" + this.reserve7);
        sb.append("\nreserve8 =" + this.reserve8);
        sb.append("\nRAW =" + ByteUtility.bytesToHex(this.raw));
        sb.append("\nconnected =" + this.connected);
        return sb.toString();
    }

    public boolean fromRaw(byte[] raw) {
        if (raw.length != 11) {
            return false;
        }
        try {
            this.present = raw[0];
            this.masterSlave = raw[1];
            this.status = raw[2];
            this.slot = raw[3];
            this.reserve2 = raw[4];
            this.reserve3 = raw[5];
            this.reserve4 = raw[6];
            this.reserve5 = raw[7];
            this.reserve6 = raw[8];
            this.reserve7 = raw[9];
            this.reserve8 = raw[10];
            this.raw = raw;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
        return true;
    }

    public void setPresent(byte present) {
        this.present = present;
    }

    public void setMasterSlave(byte masterSlave) {
        this.masterSlave = masterSlave;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setRaw(byte[] raw) {
        this.raw = raw;
    }

    public void setReserve2(byte reserve2) {
        this.reserve2 = reserve2;
    }

    public void setReserve3(byte reserve3) {
        this.reserve3 = reserve3;
    }

    public void setReserve4(byte reserve4) {
        this.reserve4 = reserve4;
    }

    public void setReserve5(byte reserve5) {
        this.reserve5 = reserve5;
    }

    public void setReserve6(byte reserve6) {
        this.reserve6 = reserve6;
    }

    public void setReserve7(byte reserve7) {
        this.reserve7 = reserve7;
    }

    public void setReserve8(byte reserve8) {
        this.reserve8 = reserve8;
    }

    public void setModuleIndex(int moduleIndex) {
        this.moduleIndex = moduleIndex;
    }

    public void setSlot(byte slot) {
        this.slot = slot;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public byte getPresent() {
        return this.present;
    }

    public byte getMasterSlave() {
        return this.masterSlave;
    }

    public byte getStatus() {
        return this.status;
    }

    public byte[] getRaw() {
        return this.raw;
    }

    public byte getReserve2() {
        return this.reserve2;
    }

    public byte getReserve3() {
        return this.reserve3;
    }

    public byte getReserve4() {
        return this.reserve4;
    }

    public byte getReserve5() {
        return this.reserve5;
    }

    public byte getReserve6() {
        return this.reserve6;
    }

    public byte getReserve7() {
        return this.reserve7;
    }

    public byte getReserve8() {
        return this.reserve8;
    }

    public int getModuleIndex() {
        return this.moduleIndex;
    }

    public byte getSlot() {
        return this.slot;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String toFormatedHeader() {
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer header = new StringBuffer();
        header.append(String.format(formatTemplate, "CMM", "M/S", "Status"));
        header.append(String.format(formatTemplate, "---", "---", "------"));
        return header.toString();
    }

    public String toFormatedString() {
        if (this.getPresent() == 0) {
            return "";
        }
        String formatTemplate = " %-5s | %-6s | %-8s\n";
        StringBuffer formatedString = new StringBuffer();
        String index = "CMM " + this.moduleIndex;
        String master = this.getMasterSlave() == 0 ? "Master" : "Slave";
        String status = this.getStatus() == 0 ? "OK" : ",Err";
        formatedString.append(String.format(formatTemplate, index, master, status));
        return formatedString.toString();
    }
}

