/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingACPIState
extends Command {
    public static final String ACPI_INFO = "ACPI_INFO";

    public Result execute(Host host) {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiGlobalCommand.setIPMIInterface(rmcp);
        ACPIInfo acpiInfo = ipmiGlobalCommand.getACPI();
        if (acpiInfo != null) {
            result.booleanResult = true;
            result.description = result.description + "\n";
            result.description = result.description + "ACPI state: " + acpiInfo.getSystemStateInfo() + "\n";
            result.description = result.description + "ACPI Description: " + acpiInfo.getSystemStateDescription() + "\n";
            result.description = result.description + "Device state: " + acpiInfo.getDeviceStateInfo() + "\n";
            result.description = result.description + "Device Description: " + acpiInfo.getDeviceStateDescription();
            result.setSingleData(ACPI_INFO, acpiInfo);
        } else {
            result.booleanResult = false;
            result.description = "Get ACPI status failed";
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get ACPI State";
    }
}

