/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Argument {
    public static final int STRING_TYPE = 0;
    public static final int INTEGER_TYPE = 1;
    public static final int DATETIME_TYPE = 2;
    public static final int IP_TYPE = 3;
    private String value;
    private String name;
    private int argumentType = 0;
    ArrayList nextArguments;
    Command command;
    private String comment;

    public Argument(String name, String value) {
        this(name, value, "");
    }

    public Argument(String name, String value, String comment) {
        this(name, value, comment, null);
    }

    public Argument(String name, String value, String comment, Command command) {
        this.name = name;
        this.value = value;
        this.comment = comment;
        this.command = command;
        this.nextArguments = new ArrayList();
    }

    public void clearValue() {
        if (this.argumentType == 1) {
            this.value = "";
        }
        if (this.nextArguments != null) {
            for (int i = 0; i < this.nextArguments.size(); ++i) {
                ((Argument)this.nextArguments.get(i)).clearValue();
            }
        }
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setArgumentType(int argumentType) {
        this.argumentType = argumentType;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getValue() {
        return this.value;
    }

    public void addNextArgument(Argument argument) {
        this.nextArguments.add(argument);
    }

    public ArrayList getNextArguments() {
        return this.nextArguments;
    }

    public String getName() {
        return this.name;
    }

    public Command getCommand() {
        return this.command;
    }

    public int getArgumentType() {
        return this.argumentType;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean validate() {
        boolean result = false;
        switch (this.argumentType) {
            case 0: {
                result = this.validateString();
                break;
            }
            case 1: {
                result = this.validateInteger();
                break;
            }
            case 2: {
                result = this.validateDateTime();
                break;
            }
            case 3: {
                result = this.validateIP();
            }
        }
        return result;
    }

    public boolean validateString() {
        return this.value.length() != 0;
    }

    public boolean validateIP() {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(this.value);
        return m.matches();
    }

    public boolean validateInteger() {
        try {
            Integer.parseInt(this.value);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public boolean validateDateTime() {
        try {
            SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            f.setLenient(false);
            Date date = f.parse(this.value);
        }
        catch (ParseException ex1) {
            return false;
        }
        return true;
    }
}

