/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.SuperBladeCommand;

public class BladePowerCommand
extends SuperBladeCommand {
    public static final int ON = 0;
    public static final int OFF = 1;
    public static final int GRACEFULSHUTDOWN = 2;
    public static final int RESET = 3;
    private int subCommand = -1;

    public boolean preValidate() {
        boolean passValidate = false;
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (bladeIndex < 1 || bladeIndex > 10) {
            System.out.println("blade Index out of range");
            return false;
        }
        if (this.parameters != null) {
            if (this.parameters[0].equalsIgnoreCase("on")) {
                this.subCommand = 0;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("off")) {
                this.subCommand = 1;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("gracefulshutdown")) {
                this.subCommand = 2;
                passValidate = true;
            } else if (this.parameters[0].equalsIgnoreCase("reset")) {
                this.subCommand = 3;
                passValidate = true;
            }
        }
        if (!passValidate) {
            System.out.println("Available command: on,off,gracefulshutdown,reset");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte bladeIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isBladePresent(bladeIndex)) {
            System.out.println("Blade " + bladeIndex + " is not present");
            return;
        }
        switch (this.subCommand) {
            case 0: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)1);
                if (result == 0) {
                    System.out.println("Done");
                    break;
                }
                if (result == 0) {
                    System.out.println("No enough power");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 1: {
                int result = this.ipmiCMMOEMCommand.enableP12V(bladeIndex, (byte)0);
                if (result == 0) {
                    System.out.println("Done");
                    break;
                }
                if (result == 0) {
                    System.out.println("No enough power");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 2: {
                boolean boolResult = this.ipmiCMMOEMCommand.gracefulPowerDownBlade(bladeIndex);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
                break;
            }
            case 3: {
                boolean boolResult = this.ipmiCMMOEMCommand.resetBlade(bladeIndex);
                if (boolResult) {
                    System.out.println("Done");
                    break;
                }
                System.out.println("Failed");
            }
        }
    }
}

