/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class CMMIPCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (cmmIndex < 1 || cmmIndex > 2) {
            System.out.println("CMM Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        byte cmmIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (!this.isConnectToCMM(cmmIndex - 1)) {
            System.out.println("This function only available for the CMM connected");
            return;
        }
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ipmiLanCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        if (this.parameters != null && this.parameters.length == 1) {
            String newIP = this.parameters[0];
            if (!IPMILanCommand.isIPAddress(newIP)) {
                System.out.println("IP format error!");
                return;
            }
            if (newIP.equals("0.0.0.0")) {
                System.out.println("IP cannot be 0.0.0.0!");
                return;
            }
            String oldIP = ipmiLanCommand.getIP();
            boolean result = ipmiLanCommand.setIP(newIP);
            if (result) {
                System.out.println("old IP:" + oldIP);
                System.out.println("new IP:" + newIP);
            } else {
                System.out.println(oldIP);
                System.out.println("Update IP failed");
            }
        } else {
            String ip = ipmiLanCommand.getIP();
            System.out.println(ip);
        }
    }
}

