/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (gbIndex < 1 || gbIndex > 4) {
            System.out.println("Gigabit switch Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryGigabitSwitchEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            System.out.println("Login error!");
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        GigabitSwitchEntity gb = bladeSystem.getGigabitSwitchs()[index - 1];
        if (gb.getPresent() == 0) {
            System.out.println("Gigabit Switch " + index + " is not present");
            return;
        }
        System.out.print(gb.toFormatedHeader());
        System.out.print(gb.toFormatedString());
    }
}

