/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class InfinibandStatusCommand
extends SuperBladeCommand {
    public boolean preValidate() {
        byte ibIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (ibIndex < 1 || ibIndex > 2) {
            System.out.println("Infiniband Index out of range");
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryInfiniBandEntity(true);
        bladeSystem.getData();
        if (!bladeSystem.isLoginSuccessful) {
            System.out.println("Login error!");
            return;
        }
        byte index = Byte.parseByte((String)this.preParameters.get(1));
        InfiniBandEntity ib = bladeSystem.getInfiniBands()[index - 1];
        if (ib.getPresent() == 0) {
            System.out.println("InfiniBand " + index + " is not present");
            return;
        }
        System.out.print(ib.toFormatedHeader());
        System.out.print(ib.toFormatedString());
    }
}

