/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.AllBladeStatusCommand;
import com.supermicro.ipmi.text.AllCMMStatusCommand;
import com.supermicro.ipmi.text.AllGigabitSwitchStatusCommnad;
import com.supermicro.ipmi.text.AllInfinibandStatusCommand;
import com.supermicro.ipmi.text.AllPowerSupplyStatusCommand;
import com.supermicro.ipmi.text.Argument;
import com.supermicro.ipmi.text.BladeBMCIPSettingCommand;
import com.supermicro.ipmi.text.BladeKVMCommand;
import com.supermicro.ipmi.text.BladePowerCommand;
import com.supermicro.ipmi.text.BladeSensorsCommand;
import com.supermicro.ipmi.text.BladeStatusCommand;
import com.supermicro.ipmi.text.BladeUIDCommand;
import com.supermicro.ipmi.text.CMMDateTimeCommand;
import com.supermicro.ipmi.text.CMMFlashCommand;
import com.supermicro.ipmi.text.CMMGatewayCommand;
import com.supermicro.ipmi.text.CMMIPCommand;
import com.supermicro.ipmi.text.CMMNetmaskCommand;
import com.supermicro.ipmi.text.CMMResetCommand;
import com.supermicro.ipmi.text.CMMStatusCommand;
import com.supermicro.ipmi.text.CMMVersionCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.FailureCommand;
import com.supermicro.ipmi.text.GBPowerCommand;
import com.supermicro.ipmi.text.GBStatusCommand;
import com.supermicro.ipmi.text.GBWSSCommand;
import com.supermicro.ipmi.text.InfinibandPowerCommand;
import com.supermicro.ipmi.text.InfinibandStatusCommand;
import com.supermicro.ipmi.text.PowerSupplyFanCommand;
import com.supermicro.ipmi.text.PowerSupplyPowerCommand;
import com.supermicro.ipmi.text.PowerSupplyStatusCommand;
import com.supermicro.ipmi.text.SELClearCommand;
import com.supermicro.ipmi.text.SELInfoCommand;
import com.supermicro.ipmi.text.SELListCommand;
import com.supermicro.ipmi.text.ShellCommand;
import com.supermicro.ipmi.text.SystemCommand;
import com.supermicro.ipmi.text.UserAddCommand;
import com.supermicro.ipmi.text.UserDeleteCommand;
import com.supermicro.ipmi.text.UserLevelCommand;
import com.supermicro.ipmi.text.UserListCommand;
import com.supermicro.ipmi.text.UserTestCommand;
import com.supermicro.ipmi.text.VMFloppyCommand;
import com.supermicro.ipmi.text.VMISOCommand;
import com.supermicro.ipmi.text.VMStatusCommand;
import com.supermicro.ipmi.text.VMStopCommand;
import com.supermicro.ipmi.text.VerCommand;
import java.util.ArrayList;

public class Parser {
    boolean enableShell = true;
    Argument argumentRoot = new Argument("", "");
    Argument system = new Argument("system", "system", "System status overview", new SystemCommand());
    Argument failure = new Argument("failure", "failure", "Blade system failure report", new FailureCommand());
    Argument blade = new Argument("blade", "blade", "Server blade management");
    Argument gigabit = new Argument("gigabit", "gigabit", "Gigabit switch management");
    Argument power = new Argument("power", "power", "Power supply management");
    Argument ib = new Argument("ib", "ib", "Infiniband management");
    Argument cmm = new Argument("cmm", "cmm", "CMM management");
    Argument sel = new Argument("sel", "sel", "System event log");
    Argument user = new Argument("user", "user", "User management");
    Argument vm = new Argument("vm", "vm", "Virtual Media management");
    Argument shell = new Argument("shell", "shell", "Shell mode", new ShellCommand());
    Argument allBladeStatus = new Argument("status", "status", "Blade status", new AllBladeStatusCommand());
    Argument allGigabitStatus = new Argument("status", "status", "Gigabit Switch status", new AllGigabitSwitchStatusCommnad());
    Argument allPowerStatus = new Argument("status", "status", "Power Supply status", new AllPowerSupplyStatusCommand());
    Argument allIBStatus = new Argument("status", "status", "Infiniband status", new AllInfinibandStatusCommand());
    Argument allCmmStatus = new Argument("status", "status", "CMM status", new AllCMMStatusCommand());
    Argument bladeIndex = new Argument("<blade index>", "", "An index number of blade");
    Argument gigabitIndex = new Argument("<gigabit index>", "", "An index number of gigabit switch");
    Argument powerIndex = new Argument("<power index>", "", "An index number of power supply");
    Argument ibIndex = new Argument("<ib index>", "", "An index number of infiniband");
    Argument cmmIndex = new Argument("<cmm index>", "", "An index number of CMM");
    Argument bladeStatus = new Argument("status", "status", "Blade status", new BladeStatusCommand());
    Argument bladePower = new Argument("power", "power", "Power control", new BladePowerCommand());
    Argument bladeKVM = new Argument("kvm", "kvm", "Request KVM switch", new BladeKVMCommand());
    Argument bladeUID = new Argument("uid", "uid", "on/off UID LED", new BladeUIDCommand());
    Argument bladeSensors = new Argument("sensors", "sensors", "Sensors status", new BladeSensorsCommand());
    Argument bladeIPMI = new Argument("bmc [BMC_IP]", "bmc", "get/set BMC IP", new BladeBMCIPSettingCommand());
    Argument gbStatus = new Argument("status", "status", "Gigabit Switch status", new GBStatusCommand());
    Argument gbPower = new Argument("power", "power", "Power control", new GBPowerCommand());
    Argument gbWSS = new Argument("wss", "wss", "WSS web configuration", new GBWSSCommand());
    Argument powerStatus = new Argument("status", "status", "Power Supply status", new PowerSupplyStatusCommand());
    Argument powerPower = new Argument("power", "power", "Power supply power control", new PowerSupplyPowerCommand());
    Argument powerFanSpeed = new Argument("fan", "fan", "Power supply fan control", new PowerSupplyFanCommand());
    Argument ibStatus = new Argument("status", "status", "Infiniband status", new InfinibandStatusCommand());
    Argument ibPower = new Argument("power", "power", "Infiniband power control", new InfinibandPowerCommand());
    Argument cmmStatus = new Argument("status", "status", "CMM status", new CMMStatusCommand());
    Argument cmmTime = new Argument("dtime [datetime]", "dtime", "get/set CMM date time. Format: \"MM/dd/yyyy HH:mm:ss\"", new CMMDateTimeCommand());
    Argument cmmReset = new Argument("reset", "reset", "Reset CMM", new CMMResetCommand());
    Argument cmmFlash = new Argument("flash", "flash", "Flash CMM firmware", new CMMFlashCommand());
    Argument cmmVer = new Argument("ver", "ver", "CMM firmware version", new CMMVersionCommand());
    Argument cmmIP = new Argument("ip [ip]", "ip", "get/set IP", new CMMIPCommand());
    Argument cmmGateway = new Argument("gateway [gateway_IP]", "gateway", "get/set gateway", new CMMGatewayCommand());
    Argument cmmnetmask = new Argument("netmask [netmask]", "netmask", "get/set netmask", new CMMNetmaskCommand());
    Argument selInfo = new Argument("info", "info", "System event log information", new SELInfoCommand());
    Argument selList = new Argument("list", "list", "List system event log", new SELListCommand());
    Argument selClear = new Argument("clear", "clear", "Clear system event log", new SELClearCommand());
    Argument userList = new Argument("list", "list", "List user", new UserListCommand());
    Argument userAdd = new Argument("add", "add", "Add user", new UserAddCommand());
    Argument userDelete = new Argument("delete", "delete", "delete user", new UserDeleteCommand());
    Argument userLevel = new Argument("level", "level", "update user level", new UserLevelCommand());
    Argument userTest = new Argument("test", "test", "test login", new UserTestCommand());
    Argument vmStatus = new Argument("status", "status", "Virtual media status", new VMStatusCommand());
    Argument vmStop = new Argument("stop", "stop", "Stop virtual media", new VMStopCommand());
    Argument vmFloppy = new Argument("floppy", "floppy", "Upload a floppy image as virutal media", new VMFloppyCommand());
    Argument vmISO = new Argument("iso", "iso", "virtual media via windows share", new VMISOCommand());
    Argument ver = new Argument("ver", "ver", "Print version", new VerCommand());
    Argument sol = new Argument("sol", "sol", "SOL Test");

    public Parser() {
        this(true);
    }

    public Parser(boolean enableShell) {
        this.enableShell = enableShell;
        this.initialFunctions();
    }

    public void initialFunctions() {
        this.argumentRoot.addNextArgument(this.system);
        this.argumentRoot.addNextArgument(this.failure);
        this.argumentRoot.addNextArgument(this.blade);
        this.argumentRoot.addNextArgument(this.gigabit);
        this.argumentRoot.addNextArgument(this.power);
        this.argumentRoot.addNextArgument(this.ib);
        this.argumentRoot.addNextArgument(this.cmm);
        this.argumentRoot.addNextArgument(this.sel);
        this.argumentRoot.addNextArgument(this.user);
        this.argumentRoot.addNextArgument(this.vm);
        if (this.enableShell) {
            this.argumentRoot.addNextArgument(this.shell);
        }
        this.argumentRoot.addNextArgument(this.ver);
        this.blade.addNextArgument(this.allBladeStatus);
        this.gigabit.addNextArgument(this.allGigabitStatus);
        this.power.addNextArgument(this.allPowerStatus);
        this.ib.addNextArgument(this.allIBStatus);
        this.cmm.addNextArgument(this.allCmmStatus);
        this.blade.addNextArgument(this.bladeIndex);
        this.gigabit.addNextArgument(this.gigabitIndex);
        this.power.addNextArgument(this.powerIndex);
        this.ib.addNextArgument(this.ibIndex);
        this.cmm.addNextArgument(this.cmmIndex);
        this.bladeIndex.setArgumentType(1);
        this.gigabitIndex.setArgumentType(1);
        this.powerIndex.setArgumentType(1);
        this.ibIndex.setArgumentType(1);
        this.cmmIndex.setArgumentType(1);
        this.bladeIndex.addNextArgument(this.bladeStatus);
        this.bladeIndex.addNextArgument(this.bladePower);
        this.bladeIndex.addNextArgument(this.bladeKVM);
        this.bladeIndex.addNextArgument(this.bladeUID);
        this.bladeIndex.addNextArgument(this.bladeSensors);
        this.bladeIndex.addNextArgument(this.bladeIPMI);
        this.gigabitIndex.addNextArgument(this.gbStatus);
        this.gigabitIndex.addNextArgument(this.gbPower);
        this.gigabitIndex.addNextArgument(this.gbWSS);
        this.powerIndex.addNextArgument(this.powerStatus);
        this.powerIndex.addNextArgument(this.powerPower);
        this.powerIndex.addNextArgument(this.powerFanSpeed);
        this.ibIndex.addNextArgument(this.ibStatus);
        this.ibIndex.addNextArgument(this.ibPower);
        this.cmmIndex.addNextArgument(this.cmmStatus);
        this.cmmIndex.addNextArgument(this.cmmTime);
        this.cmmIndex.addNextArgument(this.cmmReset);
        this.cmmIndex.addNextArgument(this.cmmFlash);
        this.cmmIndex.addNextArgument(this.cmmVer);
        this.cmmIndex.addNextArgument(this.cmmIP);
        this.cmmIndex.addNextArgument(this.cmmGateway);
        this.cmmIndex.addNextArgument(this.cmmnetmask);
        this.sel.addNextArgument(this.selInfo);
        this.sel.addNextArgument(this.selList);
        this.sel.addNextArgument(this.selClear);
        this.user.addNextArgument(this.userAdd);
        this.user.addNextArgument(this.userList);
        this.user.addNextArgument(this.userDelete);
        this.user.addNextArgument(this.userLevel);
        this.user.addNextArgument(this.userTest);
        this.vm.addNextArgument(this.vmStatus);
        this.vm.addNextArgument(this.vmStop);
        this.vm.addNextArgument(this.vmFloppy);
        this.vm.addNextArgument(this.vmISO);
    }

    public Command parse(Argument argu, String[] input) {
        Argument currentArgu = argu;
        Argument backupArgu = argu;
        ArrayList<String> preParameters = new ArrayList<String>();
        String[] tailParameters = null;
        for (int i = 0; i < input.length; ++i) {
            preParameters.add(input[i]);
            for (int j = 0; j < currentArgu.getNextArguments().size(); ++j) {
                Argument anArgu = (Argument)currentArgu.getNextArguments().get(j);
                if (anArgu.getValue().length() != 0) {
                    if (!anArgu.getValue().equalsIgnoreCase(input[i])) continue;
                    currentArgu = anArgu;
                    break;
                }
                anArgu.setValue(input[i]);
                if (anArgu.validate()) {
                    currentArgu = anArgu;
                    break;
                }
                System.out.println(anArgu.getValue() + "," + anArgu.getName() + " format error ");
                return null;
            }
            if (currentArgu.equals(backupArgu)) {
                this.printPreParameter(preParameters);
                this.helpPrintAvailableCommand(currentArgu);
                return null;
            }
            backupArgu = currentArgu;
            if (currentArgu.getNextArguments().size() != 0 || input.length - 1 <= i) continue;
            tailParameters = new String[input.length - i - 1];
            System.arraycopy(input, i + 1, tailParameters, 0, tailParameters.length);
            break;
        }
        if (currentArgu.getNextArguments().size() != 0) {
            this.printPreParameter(preParameters);
            this.helpPrintAvailableCommand(currentArgu);
            return null;
        }
        Command command = currentArgu.getCommand();
        if (command != null) {
            command.clearParameter();
            command.setPreParameters(preParameters);
            if (tailParameters != null) {
                command.setParameters(tailParameters);
            }
        } else {
            System.out.println("Not yet implemented");
        }
        return command;
    }

    public void printPreParameter(ArrayList preParameters) {
        System.out.print("Command:");
        for (int i = 0; i < preParameters.size(); ++i) {
            System.out.print(preParameters.get(i) + " ");
        }
        System.out.println("");
    }

    public void helpPrintAvailableCommand(Argument currentArgu) {
        if (currentArgu.getNextArguments().size() != 0) {
            System.out.println("Available command(s): ");
            for (int j = 0; j < currentArgu.getNextArguments().size(); ++j) {
                Argument nextArguments = (Argument)currentArgu.getNextArguments().get(j);
                String name = nextArguments.getName();
                String comment = nextArguments.getComment();
                Command command = nextArguments.getCommand();
                System.out.printf("%-20s \t %-20s \n", name, (comment == null ? "" : comment) + (command == null && nextArguments.nextArguments.size() == 0 ? " (!)" : ""));
            }
            System.out.println("");
        }
    }
}

