/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShellCommand
extends Command {
    Parser parser;

    public void execute() {
        System.out.println("Press Ctrl+C or \"exit\" to exit");
        System.out.println("Press \"?\" or \"help\" for help");
        BufferedReader from_user = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("=>");
            String line = null;
            try {
                line = from_user.readLine();
                if (line == null) {
                    System.out.println("\nbye");
                    break;
                }
                if (this.parser == null) {
                    this.parser = new Parser(false);
                }
                if (line.trim().equalsIgnoreCase("exit")) {
                    System.out.println("bye");
                    break;
                }
                if (line.trim().equalsIgnoreCase("help") || line.trim().equalsIgnoreCase("?")) {
                    this.parser.helpPrintAvailableCommand(this.parser.argumentRoot);
                    this.printRuntimeAndHelp();
                    continue;
                }
                this.processCommand(line);
            }
            catch (IOException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private void printRuntimeAndHelp() {
        System.out.println("Runtime Info:");
        System.out.printf("%-20s \t %-20s \n", "Host IP", this.config.getIp());
        System.out.printf("%-20s \t %-20s \n", "Username", this.config.getUserName());
        System.out.printf("%-20s \t %-20s \n", "Java Version", System.getProperty("java.vm.version"));
        System.out.println("");
        System.out.println("Press Ctrl+C or \"exit\" to exit");
        System.out.println("Press \"?\" or \"help\" for help");
    }

    public void processCommand(String commandLine) {
        if (commandLine.length() == 0) {
            return;
        }
        ArrayList<String> string = new ArrayList<String>();
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(commandLine);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            string.add(token);
        }
        String[] args = new String[string.size()];
        string.toArray(args);
        this.parser.argumentRoot.clearValue();
        Command command = this.parser.parse(this.parser.argumentRoot, args);
        if (command == null) {
            return;
        }
        try {
            command.setConfig(this.config);
            command.execute();
            System.out.println("");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void main(String[] args) {
        String a = "1 2 3 4 \"asdf asd fasdfa sdf\" ";
        Pattern p = Pattern.compile("\".*?\"|\\S+");
        Matcher m = p.matcher(a);
        while (m.find()) {
            String token = m.group();
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.substring(1, token.length() - 1);
            }
            System.out.println(token);
        }
    }
}

