/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.Command;

public abstract class SuperBladeCommand
extends Command {
    IPMICMMOEMCommand ipmiCMMOEMCommand = null;
    ISessionController sessionController = null;

    public void execute() {
        boolean b = this.preValidate();
        if (!b) {
            return;
        }
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerEx(this.config, this.ipmiCMMOEMCommand);
        }
        catch (IPMIException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        try {
            this.runCommand();
        }
        catch (Exception e) {
            System.out.println("Exception:");
            e.printStackTrace();
            return;
        }
        b = this.sessionController.closeSession();
    }

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;

    public boolean isBladePresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getBlades()[--index].getPresent() != 0;
    }

    public boolean isCMMPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getCmmModules()[--index].getPresent() != 0;
    }

    public boolean isPowerSupplyPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getPowerSupplies()[--index].getPresent() != 0;
    }

    public boolean isGigabitPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getGigabitSwitchs()[--index].getPresent() != 0;
    }

    public boolean isIBPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getInfiniBands()[--index].getPresent() != 0;
    }

    public BladeSystemEntity getBladeSystemEntity() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.getData();
        if (bladeSystem.isLoginSuccessful) {
            return bladeSystem;
        }
        return null;
    }

    public boolean isConnectToCMM(int cmmIndex) {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config, 10, 2, 2, 2, 4);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.getData();
        CMMModuleEntity cmm = bladeSystem.getCmmModules()[cmmIndex];
        return cmm.isConnected();
    }
}

