/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.Parser;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperBladeTool {
    public static String version = "1.00.04 Beta";
    public static String buildNo = "070906";
    public static final boolean DEBUG = false;

    public static void main(String[] args) {
        SuperBladeTool.doExecute(args);
    }

    private static void doExecute(String[] args) {
        if (args.length < 3) {
            SuperBladeTool.usage();
            System.exit(0);
        }
        Parser parser = new Parser();
        String ip = args[0];
        String username = args[1];
        String password = args[2];
        if (!SuperBladeTool.validateIP(ip)) {
            System.out.println("IP format erorr !");
            System.exit(1);
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        String[] subArgs = new String[args.length - 3];
        System.arraycopy(args, 3, subArgs, 0, subArgs.length);
        Command command = parser.parse(parser.argumentRoot, subArgs);
        if (command == null) {
            return;
        }
        command.setConfig(config);
        try {
            command.execute();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static void usage() {
        System.out.println("\nSupermicro SuperBlade Command Line Interface V" + version + " Build " + buildNo);
        System.out.println("Usage:");
        System.out.println("      SuperBladeTool <IP> <username> <password> [commands ... ]");
    }

    public static void ver() {
        System.out.println("Supermicro SuperBlade Command Line Interface V" + version + " Build " + buildNo);
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }
}

