/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserDeleteCommand
extends SuperBladeCommand {
    byte userID;

    public boolean preValidate() {
        String usage = "Usage: user delete <user id> \n";
        if (this.parameters == null || this.parameters.length != 1) {
            System.out.println(usage);
            return false;
        }
        try {
            this.userID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("user id should be number");
            System.out.println(usage);
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte privilege = ipmiMessagingCommand.getUserPrivilegeByID(this.userID);
        boolean b1 = ipmiMessagingCommand.setUserNameByID(this.userID, "");
        if (!b1) {
            System.out.println("clear user name failed");
            return;
        }
        boolean b2 = ipmiMessagingCommand.setUserPrivilegeByID(this.userID, (byte)0);
        if (!b2) {
            System.out.println("clear user privilege failed");
            return;
        }
        boolean b3 = ipmiMessagingCommand.setDisableUserByID(this.userID);
        if (!b3) {
            System.out.println("disable user failed");
            return;
        }
        boolean b4 = ipmiMessagingCommand.setDisableUserPlusByID(this.userID, (byte)0);
        if (!b4) {
            System.out.println("disable user(+) failed");
            return;
        }
        System.out.println("done");
    }
}

