/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UserTestCommand
extends SuperBladeCommand {
    String username;
    String password;

    public boolean preValidate() {
        String usage = "Usage: user test <user name> <password>";
        if (this.parameters == null || this.parameters.length != 2) {
            System.out.println(usage);
            return false;
        }
        this.username = this.parameters[0];
        if (this.username.length() > 20) {
            System.out.println("username should less then 20 characters");
            System.out.println(usage);
            return false;
        }
        this.password = this.parameters[1];
        if (this.password.length() > 20) {
            System.out.println("password should less then 20 characters");
            System.out.println(usage);
            return false;
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        ipmiMessagingCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIMessagingCommand testIPMIMessagingCommand = new IPMIMessagingCommand(null);
        IPMIInterfaceConfig testConfig = new IPMIInterfaceConfig();
        testConfig.setIp(this.config.getIp());
        testConfig.setUserName(this.username);
        testConfig.setPassword(this.password);
        ISessionController sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilege(testConfig, testIPMIMessagingCommand);
        if (sessionController != null && testIPMIMessagingCommand.getIPMIInterface() != null) {
            System.out.println("pass");
            System.out.println("privilege: " + this.getPriviledgeString(testConfig.getPrivilege()));
        } else {
            System.out.println("fail");
        }
    }

    private String getPriviledgeString(int p) {
        switch (p) {
            case 4: {
                return "Administrator";
            }
            case 3: {
                return "Operator";
            }
            case 2: {
                return "User";
            }
            case 1: {
                return "CallBack";
            }
        }
        return "";
    }
}

