/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMIRaritanOEMCommand;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class VMISOCommand
extends SuperBladeCommand {
    byte driveID;
    String hostIP;
    String shareName;
    String imageName;
    String username;
    String password;

    public boolean preValidate() {
        String usage = "Usage: vm iso <drive ID> <host IP> <share name> <path to image> [username] [password]\ndrive ID = <1|2>\nPlease make sure the drive is empty";
        if (this.parameters == null || this.parameters.length < 4 || this.parameters.length > 6) {
            System.out.println(usage);
            return false;
        }
        try {
            this.driveID = Byte.parseByte(this.parameters[0]);
        }
        catch (NumberFormatException ex) {
            System.out.println("drive ID should be number");
            System.out.println(usage);
            return false;
        }
        if (this.driveID < 1 || this.driveID > 2) {
            System.out.println("Invalid drive number");
            System.out.println(usage);
            return false;
        }
        this.hostIP = this.parameters[1];
        if (!IPMILanCommand.isIPAddress(this.hostIP)) {
            System.out.println("host IP is not valid");
            return false;
        }
        this.shareName = this.parameters[2];
        this.imageName = this.parameters[3];
        if (this.parameters.length > 4) {
            this.username = this.parameters[4];
        }
        if (this.parameters.length > 5) {
            this.password = this.parameters[5];
        }
        return true;
    }

    public void runCommand() throws Exception {
        IPMIRaritanOEMCommand ipmiRaritanOEMCommand = new IPMIRaritanOEMCommand(null);
        ipmiRaritanOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean b = ipmiRaritanOEMCommand.mountISOImageForTextMode(this.driveID, this.hostIP, this.shareName, this.imageName, this.username, this.password);
        if (b) {
            System.out.println("done");
        } else {
            System.out.println("fail");
        }
    }
}

