/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

public class CipherSuite {
    public static final byte AUTHENTICATION_ALGORITHM_RAKP_NONE = 0;
    public static final byte AUTHENTICATION_ALGORITHM_RAKP_HMAC_SHA1 = 1;
    public static final byte AUTHENTICATION_ALGORITHM_RAKP_HMAC_MD5 = 2;
    public static final byte INTEGRITY_ALGORITHM_NONE = 0;
    public static final byte INTEGRITY_ALGORITHM_HMAC_SHA1_96 = 1;
    public static final byte INTEGRITY_ALGORITHM_HMAC_MD5_128 = 2;
    public static final byte INTEGRITY_ALGORITHM_MD5_128 = 3;
    public static final byte CONFIDENTIALITY_ALGORITHM_NONE = 0;
    public static final byte CONFIDENTIALITY_ALGORITHM_AES_CBC_128 = 1;
    public static final byte CONFIDENTIALITY_ALGORITHM_XRC4_128 = 2;
    public static final byte CONFIDENTIALITY_ALGORITHM_XRC4_40 = 3;
    public static final String[] AUTHENTICATION_ALGORITHMS = new String[]{"RAKP-none", "RAKP-HMAC-SHA1", "RAKP-HMAC-MD5"};
    public static final String[] INTEGIRTY_ALGORITHMS = new String[]{"None", "HMAC-SHA1-96", "HMAC-MD5-128", "MD5-128"};
    public static final String[] CONFIDENTICALITY_ALGORITHMS = new String[]{"None", "AES-CBC-128", "xRC4-128", "xRC4-40"};
    public static final byte[][] CIPHER_SUITES = new byte[][]{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {1, 1, 1}, {1, 1, 2}, {1, 1, 3}, {2, 0, 0}, {2, 2, 0}, {2, 2, 1}, {2, 2, 2}, {2, 2, 3}, {2, 3, 0}, {2, 3, 1}, {2, 3, 2}, {2, 3, 3}};
    private byte authenticationAlgorithm = 1;
    private byte integrityAlgorithm = 1;
    private byte confidentialityAlgorithm = 1;

    public byte getAuthenticationAlgorithm() {
        return this.authenticationAlgorithm;
    }

    public void setAuthenticationAlgorithm(byte authenticationAlgorithm) {
        this.authenticationAlgorithm = authenticationAlgorithm;
    }

    public byte getIntegrityAlgorithm() {
        return this.integrityAlgorithm;
    }

    public void setIntegrityAlgorithm(byte integrityAlgorithm) {
        this.integrityAlgorithm = integrityAlgorithm;
    }

    public byte getConfidentialityAlgorithm() {
        return this.confidentialityAlgorithm;
    }

    public void setConfidentialityAlgorithm(byte confidentialityAlgorithm) {
        this.confidentialityAlgorithm = confidentialityAlgorithm;
    }

    public boolean setCipherSuiteById(byte id) {
        if (id < 0 || id > 14) {
            return false;
        }
        this.setAuthenticationAlgorithm(CIPHER_SUITES[id][0]);
        this.setIntegrityAlgorithm(CIPHER_SUITES[id][1]);
        this.setConfidentialityAlgorithm(CIPHER_SUITES[id][2]);
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cipher Suite:\n");
        sb.append("Authentication Algorithm  : " + AUTHENTICATION_ALGORITHMS[this.getAuthenticationAlgorithm()] + "\n");
        sb.append("Integrity Algorithm       : " + INTEGIRTY_ALGORITHMS[this.getIntegrityAlgorithm()] + "\n");
        sb.append("Confidentiality Algorithm : " + CONFIDENTICALITY_ALGORITHMS[this.getIntegrityAlgorithm()] + "\n");
        return sb.toString();
    }
}

