/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.IPMIView20;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

public class DeviceFile {
    private Vector GroupName;
    private Vector[][] GroupMember;
    private Vector TextFromFile = new Vector(20);
    private TreeMap hostnameToIP = new TreeMap();

    public void LoadFromFile(String Filename) {
        File f = new File(Filename + ".properties");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException ie) {
                System.err.println();
                System.err.println("Can't create the properties file that contains the IPMI devices information.");
                System.err.println("Please check your file access rights.");
                System.err.println();
                System.exit(1);
            }
        }
        try {
            String tempString;
            this.TextFromFile.removeAllElements();
            FileReader fin = new FileReader(Filename + ".properties");
            BufferedReader br = new BufferedReader(fin);
            boolean i = false;
            while ((tempString = br.readLine()) != null) {
                this.TextFromFile.addElement(tempString);
            }
            fin.close();
        }
        catch (IOException e) {
            System.err.println();
            System.err.println("Can't find the properties file that contains the IPMI devices information.");
            System.err.println("Its name should be IPMIView.properties");
            System.err.println();
            System.exit(1);
        }
    }

    public boolean SaveToFile(String Filename) {
        try {
            FileWriter fout = new FileWriter(Filename + ".properties");
            PrintWriter pw = new PrintWriter(fout);
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                pw.println(this.TextFromFile.get(i).toString());
            }
            fout.close();
            IPMIView20.getInstance();
            IPMIView20.configurationChanged = false;
            return true;
        }
        catch (IOException e) {
            System.err.println();
            System.err.println("Can't save to file!");
            System.err.println();
            return false;
        }
    }

    public void SaveLayoutToFile(String Filename, String hostname, String Layposition) {
        String tempString = null;
        Object xString = null;
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(hostname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                int z = tempString.indexOf(58, y + 1);
                if (z > y) {
                    this.TextFromFile.set(i, tempString.substring(0, z + 1) + Layposition);
                } else {
                    this.TextFromFile.set(i, tempString.substring(0) + ":" + Layposition);
                }
            } else {
                this.TextFromFile.set(i, tempString.substring(0) + "::" + Layposition);
            }
            this.SaveToFile(Filename);
            return;
        }
    }

    public String hostnameToIP(String hostname) {
        if (this.hostnameToIP.containsKey(hostname)) {
            return (String)this.hostnameToIP.get(hostname);
        }
        String tempString = null;
        String xString = null;
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(hostname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            xString = y > x ? tempString.substring(x + 1, y) : tempString.substring(x + 1);
            this.hostnameToIP.put(hostname, xString);
            return xString;
        }
        return xString;
    }

    protected static Vector parseList(String theStringList) {
        Vector<String> v = new Vector<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(theStringList, ";");
        while (tokenizer.hasMoreTokens()) {
            String Id = tokenizer.nextToken();
            v.addElement(Id);
        }
        return v;
    }

    public Vector getDevice(String devicename) {
        Vector<String> deviceentry = new Vector<String>(20);
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(devicename + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                int z = tempString.indexOf(58, y + 1);
                if (z > y) {
                    deviceentry.addElement(tempString.substring(0, x));
                    deviceentry.addElement(tempString.substring(x + 1, y));
                    deviceentry.addElement(tempString.substring(y + 1, z));
                    deviceentry.addElement(tempString.substring(z + 1, tempString.length()));
                } else {
                    deviceentry.addElement(tempString.substring(0, x));
                    deviceentry.addElement(tempString.substring(x + 1, y));
                    deviceentry.addElement(tempString.substring(y + 1, tempString.length()));
                    deviceentry.addElement("");
                }
            } else {
                deviceentry.addElement(tempString.substring(0, x));
                deviceentry.addElement(tempString.substring(x + 1, tempString.length()));
                deviceentry.addElement("");
                deviceentry.addElement("");
            }
            return deviceentry;
        }
        return deviceentry;
    }

    public Vector getDeviceVector(String groupname) {
        Vector devices = new Vector(20);
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String xString;
            int x;
            String tempString = this.TextFromFile.get(i).toString();
            if (groupname == null || groupname == "IPMI Domain") {
                if (tempString.startsWith("!")) continue;
                x = tempString.indexOf(61);
                xString = tempString.substring(0, x);
                devices.addElement(xString);
                continue;
            }
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            xString = y > x ? tempString.substring(x + 1, y) : tempString.substring(x + 1);
            devices = DeviceFile.parseList(xString);
            return devices;
        }
        return devices;
    }

    public Vector getGroupVector(String groupname) {
        Vector<String> groupentry = new Vector<String>(20);
        if (groupname == null || groupname == "IPMI Domain") {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!")) continue;
                int x = tempString.indexOf(61);
                int y = tempString.indexOf(58, x + 1);
                if (y > x) {
                    groupentry.addElement(tempString.substring(1, x));
                    groupentry.addElement(tempString.substring(y + 1, tempString.length()));
                    continue;
                }
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement("");
            }
            return groupentry;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement(tempString.substring(y + 1, tempString.length()));
            } else {
                groupentry.addElement(tempString.substring(1, x));
                groupentry.addElement("");
            }
            return groupentry;
        }
        return groupentry;
    }

    public void addGroup(String groupname, String description) {
        this.TextFromFile.addElement("!" + groupname + "=" + ":" + description);
        IPMIView20.getInstance().setConfigurationUpdated();
    }

    public void addDevice(String devicename, String IP, String description) {
        this.TextFromFile.addElement(devicename + "=" + IP + ":" + description);
        IPMIView20.getInstance().setConfigurationUpdated();
    }

    public void deleteGroup(String groupname) {
        if (groupname == null || groupname == "IPMI Domain") {
            return;
        }
        if (groupname != null) {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!" + groupname + "=")) continue;
                this.TextFromFile.remove(i);
                IPMIView20.getInstance().setConfigurationUpdated();
                return;
            }
        }
    }

    public void dump() {
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            System.out.println(i + " " + this.TextFromFile.get(i).toString());
        }
    }

    public void joinGroup(String groupname, String devicename) {
        if (groupname == null || groupname.compareTo("IPMI Domain") == 0) {
            return;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int x = tempString.indexOf(61);
            int y = tempString.indexOf(58, x + 1);
            tempString = y > x ? (tempString.charAt(y - 1) == '=' ? tempString.substring(0, y) + devicename + tempString.substring(y) : tempString.substring(0, y) + ";" + devicename + tempString.substring(y)) : (tempString.charAt(tempString.length() - 1) == '=' ? tempString + devicename + ":" : tempString + ";" + devicename + ":");
            this.TextFromFile.set(i, tempString);
            IPMIView20.getInstance().setConfigurationUpdated();
            return;
        }
    }

    public void disjoinGroup(String groupname, String devicename) {
        if (groupname == null || groupname.compareTo("IPMI Domain") == 0) {
            return;
        }
        for (int i = 0; i < this.TextFromFile.size(); ++i) {
            String tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!" + groupname + "=")) continue;
            int j = tempString.indexOf(devicename);
            if (j >= 0) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
            }
            IPMIView20.getInstance().setConfigurationUpdated();
            return;
        }
    }

    public void deleteDevice(String devicename, String IP, String description) {
        String tempString;
        int i;
        if (this.hostnameToIP.containsKey(devicename)) {
            this.hostnameToIP.remove(devicename);
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (tempString.compareTo(devicename + "=" + IP) != 0 && !tempString.startsWith(devicename + "=" + IP + ":")) continue;
            this.TextFromFile.remove(i);
            IPMIView20.getInstance().setConfigurationUpdated();
            break;
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!")) continue;
            int j = tempString.indexOf(devicename);
            if (j >= 0) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
    }

    public void modifyDevice(String devicename, String IP, String description, String old_devicename, String old_IP, String old_description) {
        String tempString;
        int i;
        if (this.hostnameToIP.containsKey(devicename)) {
            this.hostnameToIP.put(devicename, IP);
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith(old_devicename + "=" + old_IP + ":" + old_description)) continue;
            int x = tempString.indexOf(58);
            int y = tempString.indexOf(58, x + 1);
            if (y > x) {
                String pos = tempString.substring(y + 1, tempString.length());
                this.TextFromFile.set(i, devicename + "=" + IP + ":" + description + ":" + pos);
            } else {
                this.TextFromFile.set(i, devicename + "=" + IP + ":" + description);
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
        for (i = 0; i < this.TextFromFile.size(); ++i) {
            tempString = this.TextFromFile.get(i).toString();
            if (!tempString.startsWith("!")) continue;
            int j = tempString.indexOf(old_devicename);
            if (j >= 0) {
                int k = tempString.indexOf(";", j + 1);
                if (k > 0) {
                    this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k + 1));
                } else {
                    k = tempString.indexOf(":", j + 1);
                    if (k > 0) {
                        if (tempString.charAt(j - 1) == '=') {
                            this.TextFromFile.set(i, tempString.substring(0, j) + tempString.substring(k));
                        } else {
                            this.TextFromFile.set(i, tempString.substring(0, j - 1) + tempString.substring(k));
                        }
                    } else if (tempString.charAt(j - 1) == '=') {
                        this.TextFromFile.set(i, tempString.substring(0, j));
                    } else {
                        this.TextFromFile.set(i, tempString.substring(0, j - 1));
                    }
                }
                int eqIndex = tempString.indexOf("=");
                String groupName = tempString.substring(1, eqIndex);
                this.joinGroup(groupName, devicename);
            }
            IPMIView20.getInstance().setConfigurationUpdated();
        }
    }

    public void modifyGroup(String groupname, String description, String old_groupname, String old_description) {
        if (groupname == null || groupname == "IPMI Domain") {
            return;
        }
        if (groupname != null) {
            for (int i = 0; i < this.TextFromFile.size(); ++i) {
                String tempString = this.TextFromFile.get(i).toString();
                if (!tempString.startsWith("!" + old_groupname + "=")) continue;
                int x = tempString.indexOf(61);
                int y = tempString.indexOf(58, x + 1);
                tempString = y > x ? "!" + groupname + "=" + tempString.substring(x + 1, y) + ":" + description : "!" + groupname + "=" + tempString.substring(x + 1, tempString.length()) + ":" + description;
                this.TextFromFile.set(i, tempString);
                IPMIView20.getInstance().setConfigurationUpdated();
                return;
            }
        }
    }
}

