/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.RMCPPlus;
import IPMIView20.UDPSocket;
import IPMIView20.algo.CipherAlgorithmFactory;
import java.util.Vector;
import javax.swing.JLabel;

public class RAKPTalker {
    CSession session;
    UDPSocket udpSocket;
    GlobalDefine gd = new GlobalDefine();
    RMCPPlus rmcpPlusPacket = new RMCPPlus();
    public OpenSessionRequest openSessionRequest = new OpenSessionRequest();
    public OpenSessionResponse openSessionResponse = new OpenSessionResponse();
    public RAKPMessage1 rakpMessage1 = new RAKPMessage1();
    public RAKPMessage2 rakpMessage2 = new RAKPMessage2();
    public RAKPMessage3 rakpMessage3 = new RAKPMessage3();
    public RAKPMessage4 rakpMessage4 = new RAKPMessage4();
    byte messageTag = 1;
    static byte consoleSessionIDCount = 1;
    byte[] consoleSessionID = new byte[]{1, 0, 0, 0};
    byte[] SIK = null;
    byte[] K1 = null;
    byte[] K2 = null;
    byte[] password;
    JLabel xMessage;
    byte maxPrivilege;

    public RAKPTalker(CSession session, UDPSocket udpSocket) {
        this.session = session;
        this.udpSocket = udpSocket;
    }

    public byte testUserPrivilegeByLogin(String userID, byte[] password, JLabel xMessage) {
        xMessage.setText(L.t("rakp.prepare_to_RAKP_Open_Session"));
        JLabel dummyMessage = new JLabel();
        byte tempMaxPrivilege = 0;
        byte[] privilege = new byte[]{4, 3, 2, 1};
        for (int i = 0; i < privilege.length; ++i) {
            if (this.openSession(userID, password, dummyMessage, privilege[i])) {
                this.closeSession();
                return privilege[i];
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (dummyMessage.getText().indexOf("Verify error") != -1) break;
        }
        xMessage.setText(dummyMessage.getText());
        return tempMaxPrivilege;
    }

    public boolean openSession(String userID, byte[] password, JLabel xMessage, byte maxPrivilege) {
        byte[] rawData = new byte[256];
        int[] length = new int[1];
        this.maxPrivilege = maxPrivilege;
        this.password = new byte[password.length];
        for (int i = 0; i < password.length; ++i) {
            this.password[i] = password[i];
        }
        this.xMessage = xMessage;
        Vector para = this.createRAKPOpenSessionMessage();
        this.rmcpPlusPacket.RAKPSetup(para, this.session, rawData, length);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog(" open 1 =" + ByteUtility.bytesToHex(rawData));
        }
        xMessage.setText(L.t("rakp.Sending_RMCP_Open_Session_Request"));
        if (this.udpSocket.SendPacket(this.session.SIP, 623, this.session.InboundSessionSeq, rawData, length[0], true)) {
            xMessage.setText(L.t("rakp.Receiving_RMCP_Open_Session_Response"));
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog(" open 2 =" + ByteUtility.bytesToHex(this.udpSocket.recvBuf));
            }
            if (!this.resolveOpenSessionResponse(this.udpSocket.recvBuf)) {
                return false;
            }
            para = this.createRAKPMessage1(userID);
            this.rmcpPlusPacket.RAKPSetup(para, this.session, rawData, length);
            if (Logger.writeLog || Logger.displayLog) {
                Logger.writeLog(" rakp 1 =" + ByteUtility.bytesToHex(rawData));
            }
            xMessage.setText(L.t("rakp.Sending_RAKP_Message_1"));
            if (this.udpSocket.SendPacket(this.session.SIP, 623, this.session.InboundSessionSeq, rawData, length[0], true)) {
                xMessage.setText(L.t("rakp.Receiving_RAKP_Message_2"));
                if (Logger.writeLog || Logger.displayLog) {
                    Logger.writeLog(" rakp 2 =" + ByteUtility.bytesToHex(this.udpSocket.recvBuf));
                }
                if (!this.resolveRAKPMessage2(this.udpSocket.recvBuf)) {
                    return false;
                }
                para = this.createRAKPMessage3();
                this.rmcpPlusPacket.RAKPSetup(para, this.session, rawData, length);
                if (Logger.writeLog || Logger.displayLog) {
                    Logger.writeLog(" rakp 3 =" + ByteUtility.bytesToHex(rawData));
                }
                xMessage.setText(L.t("rakp.Sending_RAKP_Message_3"));
                if (this.udpSocket.SendPacket(this.session.SIP, 623, this.session.InboundSessionSeq, rawData, length[0], true)) {
                    if (Logger.writeLog || Logger.displayLog) {
                        Logger.writeLog(" rakp 4 =" + ByteUtility.bytesToHex(this.udpSocket.recvBuf));
                    }
                    xMessage.setText(L.t("rakp.Receiving_RAKP_Message_4"));
                    if (!this.resolveRAKPMessage4(this.udpSocket.recvBuf)) {
                        xMessage.setText(L.t("rakp.RAKP_Message_4_error_colon") + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage4.RMCPPlusStatusCode]);
                        return false;
                    }
                }
            }
        }
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.session.SessionID, 0, 4);
        this.session.IncreaseSessionSeq();
        Logger.writeLog("");
        Logger.writeLog("=========== RAKP Close ============");
        Logger.writeLog("");
        return true;
    }

    private Vector createRAKPOpenSessionMessage() {
        byte[] authType = new byte[]{6};
        byte[] payloadType = new byte[]{16};
        byte[] sessionID = new byte[]{0, 0, 0, 0};
        byte[] sessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[32];
        Vector<byte[]> para = new Vector<byte[]>(1);
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Object sResult = null;
        this.openSessionRequest.messageTag = this.messageTag;
        this.openSessionRequest.requestedMaxPrivilegeLevel = (byte)4;
        this.openSessionRequest.reserved[0] = 0;
        this.openSessionRequest.reserved[1] = 0;
        consoleSessionIDCount = (byte)(consoleSessionIDCount + 1);
        System.arraycopy(this.consoleSessionID, 0, this.openSessionRequest.remoteConsoleSessionID, 0, 4);
        byte[] auth = new byte[]{0, 0, 0, 8, this.session.cipherSuite.getAuthenticationAlgorithm(), 0, 0, 0};
        System.arraycopy(auth, 0, this.openSessionRequest.authenticationPayload, 0, 8);
        byte[] integirty = new byte[]{1, 0, 0, 8, this.session.cipherSuite.getIntegrityAlgorithm(), 0, 0, 0};
        System.arraycopy(integirty, 0, this.openSessionRequest.integrityPayload, 0, 8);
        byte[] confidentiality = new byte[]{2, 0, 0, 8, this.session.cipherSuite.getConfidentialityAlgorithm(), 0, 0, 0};
        System.arraycopy(confidentiality, 0, this.openSessionRequest.confidentialityPayload, 0, 8);
        para.addElement(authType);
        para.addElement(payloadType);
        para.addElement(sessionSeq);
        para.addElement(sessionID);
        para.addElement(this.openSessionRequest.getBytes());
        Logger.writeLog(this.openSessionRequest.toString());
        return para;
    }

    private boolean resolveOpenSessionResponse(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 17) {
            this.xMessage.setText(L.t("rakp.Open_Session_Response_error_colon_Not_a_Open_Session_Response_Payload"));
            Logger.writeLog("Open Session Response error: Not a Open Session Response Payload");
            return false;
        }
        this.openSessionResponse.messageTag = recvBuf[index];
        this.openSessionResponse.RMCPPlusStatusCode = recvBuf[++index];
        if (this.openSessionResponse.RMCPPlusStatusCode != 0) {
            this.xMessage.setText(L.t("rakp.RMCP_Open_Session_Response_error_colon") + RMCPPlus.RMCPPlusStatusCode[this.openSessionResponse.RMCPPlusStatusCode]);
            Logger.writeLog("RMCP Open Session Response error: " + RMCPPlus.RMCPPlusStatusCode[this.openSessionResponse.RMCPPlusStatusCode]);
            return false;
        }
        this.openSessionResponse.maxPrivilegeLevel = recvBuf[++index];
        ++index;
        System.arraycopy(recvBuf, ++index, this.openSessionResponse.remoteConsoleSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.openSessionResponse.managedSystemSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.openSessionResponse.authenticationPayload, 0, 8);
        System.arraycopy(recvBuf, index += 8, this.openSessionResponse.integrityPayload, 0, 8);
        System.arraycopy(recvBuf, index += 8, this.openSessionResponse.confidentialityPayload, 0, 8);
        Logger.writeLog(this.openSessionResponse.toString());
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.session.SessionID, 0, 4);
        return true;
    }

    private Vector createRAKPMessage1(String userID) {
        byte[] authType = new byte[]{6};
        byte[] payloadType = new byte[]{18};
        byte[] sessionID = new byte[]{0, 0, 0, 0};
        byte[] sessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[28 + userID.length()];
        Vector<byte[]> para = new Vector<byte[]>(1);
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Object sResult = null;
        this.rakpMessage1.messageTag = this.messageTag;
        byte[] reserved1 = new byte[]{0, 0, 0};
        System.arraycopy(reserved1, 0, this.rakpMessage1.reserved1, 0, 3);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rakpMessage1.managedSystemSessionID, 0, 4);
        System.arraycopy(ByteUtility.random16Bytes(), 0, this.rakpMessage1.remoteConsoleRandomNumber, 0, 16);
        this.rakpMessage1.requestedMaxPrivilegeLevel = this.maxPrivilege;
        byte[] reserved2 = new byte[]{0, 0};
        System.arraycopy(reserved2, 0, this.rakpMessage1.reserved2, 0, 2);
        if (userID.length() > 0) {
            this.rakpMessage1.userNameLength = (byte)userID.length();
            this.rakpMessage1.userName = new byte[userID.length()];
            System.arraycopy(userID.getBytes(), 0, this.rakpMessage1.userName, 0, userID.length());
        } else {
            this.rakpMessage1.userNameLength = 0;
        }
        Logger.writeLog(this.rakpMessage1.toString());
        para.addElement(authType);
        para.addElement(payloadType);
        para.addElement(sessionSeq);
        para.addElement(sessionID);
        para.addElement(this.rakpMessage1.getBytes());
        return para;
    }

    private boolean resolveRAKPMessage2(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 19) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_2_error_colon_Not_a_RAKP_Message_2_Payload"));
            Logger.writeLog("RAKP Message 2 error: Not a RAKP Message 2 Payload");
            return false;
        }
        this.rakpMessage2.messageTag = recvBuf[index];
        this.rakpMessage2.RMCPPlusStatusCode = recvBuf[++index];
        if (this.rakpMessage2.RMCPPlusStatusCode != 0) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_2_error_colon") + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage2.RMCPPlusStatusCode]);
            Logger.writeLog("RAKP Message 2 error: " + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage2.RMCPPlusStatusCode]);
            return false;
        }
        ++index;
        ++index;
        System.arraycopy(recvBuf, ++index, this.rakpMessage2.remoteConsoleSessionID, 0, 4);
        System.arraycopy(recvBuf, index += 4, this.rakpMessage2.managedSystemRandomNumber, 0, 16);
        System.arraycopy(recvBuf, index += 16, this.rakpMessage2.managedSystemGUID, 0, 16);
        index += 16;
        switch (this.session.cipherSuite.getAuthenticationAlgorithm()) {
            case 0: {
                break;
            }
            case 2: {
                this.rakpMessage2.keyExchangeAuthenticationCode = new byte[16];
                System.arraycopy(recvBuf, index, this.rakpMessage2.keyExchangeAuthenticationCode, 0, 16);
                break;
            }
            case 1: {
                this.rakpMessage2.keyExchangeAuthenticationCode = new byte[20];
                System.arraycopy(recvBuf, index, this.rakpMessage2.keyExchangeAuthenticationCode, 0, 20);
            }
        }
        Logger.writeLog(this.rakpMessage2.toString());
        boolean hmac = this.checkRAKPMessage2HMAC();
        if (!hmac) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_2_error_colon_Verify_error_Maybe_the_password_invalid"));
            Logger.writeLog("RAKP Message 2 error: Verify error. Maybe the password invalid");
            return false;
        }
        Logger.writeLog("RAKP 2 Key verify Successful");
        this.SIK = this.calculateSIK();
        this.K1 = this.calculateK1();
        this.K2 = this.calculateK2();
        this.session.SIK = this.SIK;
        this.session.K1 = this.K1;
        this.session.K2 = this.K2;
        return true;
    }

    private boolean checkRAKPMessage2HMAC() {
        if (this.session.cipherSuite.getAuthenticationAlgorithm() == 0) {
            return true;
        }
        byte[] plainText = null;
        int size = 0;
        size = this.consoleSessionID.length + this.openSessionResponse.managedSystemSessionID.length + this.rakpMessage1.remoteConsoleRandomNumber.length + this.rakpMessage2.managedSystemRandomNumber.length + this.rakpMessage2.managedSystemGUID.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.consoleSessionID, 0, plainText, 0, 4);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, plainText, 4, 4);
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 8, 16);
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 24, 16);
        System.arraycopy(this.rakpMessage2.managedSystemGUID, 0, plainText, 40, 16);
        plainText[56] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[57] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 58, this.rakpMessage1.userName.length);
        }
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.password, plainText);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog(" cal key = " + ByteUtility.bytesToHex(result));
        }
        return ByteUtility.bytesToHex(result).equals(ByteUtility.bytesToHex(this.rakpMessage2.keyExchangeAuthenticationCode));
    }

    private Vector createRAKPMessage3() {
        byte[] authType = new byte[]{6};
        byte[] payloadType = new byte[]{20};
        byte[] sessionID = new byte[]{0, 0, 0, 0};
        byte[] sessionSeq = new byte[]{0, 0, 0, 0};
        byte[] param = new byte[8 + this.getAuthenticationByteSize()];
        Vector<byte[]> para = new Vector<byte[]>(1);
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Object sResult = null;
        this.rakpMessage3.messageTag = this.messageTag;
        this.rakpMessage3.RMCPPlusStatusCode = 0;
        byte[] reserved = new byte[]{0, 0};
        System.arraycopy(reserved, 0, this.rakpMessage3.reserved, 0, 2);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, this.rakpMessage3.managedSystemSessionID, 0, 4);
        this.rakpMessage3.keyExchangeAuthenticationCode = this.createRAKPMessage3HMAC();
        Logger.writeLog(this.rakpMessage3.toString());
        para.addElement(authType);
        para.addElement(payloadType);
        para.addElement(sessionSeq);
        para.addElement(sessionID);
        para.addElement(this.rakpMessage3.getBytes());
        return para;
    }

    private byte[] createRAKPMessage3HMAC() {
        if (this.session.cipherSuite.getAuthenticationAlgorithm() == 0) {
            return new byte[0];
        }
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage2.managedSystemRandomNumber.length + this.consoleSessionID.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.consoleSessionID, 0, plainText, 16, 4);
        plainText[20] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[21] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 22, this.rakpMessage1.userName.length);
        }
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.password, plainText);
        return result;
    }

    private byte[] calculateSIK() {
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage1.remoteConsoleRandomNumber.length + this.rakpMessage2.managedSystemRandomNumber.length + 1 + 1;
        if (this.rakpMessage1.userNameLength != 0) {
            size += this.rakpMessage1.userName.length;
        }
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.rakpMessage2.managedSystemRandomNumber, 0, plainText, 16, 16);
        plainText[32] = this.rakpMessage1.requestedMaxPrivilegeLevel;
        plainText[33] = this.rakpMessage1.userNameLength;
        if (this.rakpMessage1.userNameLength != 0) {
            System.arraycopy(this.rakpMessage1.userName, 0, plainText, 34, this.rakpMessage1.userName.length);
        }
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.password, plainText);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog(" SIK = " + ByteUtility.bytesToHex(result));
        }
        return result;
    }

    private byte[] calculateK1() {
        if (this.session.cipherSuite.getIntegrityAlgorithm() == 0) {
            return new byte[0];
        }
        byte[] const1 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] k1 = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.SIK, const1);
        byte[] k1_128 = new byte[16];
        System.arraycopy(k1, 0, k1_128, 0, 16);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("New K1(160 bits) = " + ByteUtility.bytesToHex(k1));
        }
        if (this.session.cipherSuite.getIntegrityAlgorithm() == 1) {
            return k1;
        }
        return k1_128;
    }

    private byte[] calculateK2() {
        if (this.session.cipherSuite.getIntegrityAlgorithm() == 0) {
            return new byte[0];
        }
        byte[] const2 = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
        byte[] k2 = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.SIK, const2);
        byte[] k2_128 = new byte[16];
        System.arraycopy(k2, 0, k2_128, 0, 16);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog("New K2(160 bits) = " + ByteUtility.bytesToHex(k2));
        }
        return k2_128;
    }

    private boolean resolveRAKPMessage4(byte[] recvBuf) {
        int index = 16;
        byte payLoadType = recvBuf[5];
        if (payLoadType != 21) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_4_error_colon_Not_a_RAKP_Message_4_Payload"));
            Logger.writeLog("RAKP Message 4 error: Not a RAKP Message 4 Payload");
            return false;
        }
        this.rakpMessage4.messageTag = recvBuf[index];
        this.rakpMessage4.RMCPPlusStatusCode = recvBuf[++index];
        if (this.rakpMessage4.RMCPPlusStatusCode != 0) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_4_error_colon") + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage4.RMCPPlusStatusCode]);
            Logger.writeLog("RAKP Message 4 error: " + RMCPPlus.RMCPPlusStatusCode[this.rakpMessage4.RMCPPlusStatusCode]);
            return false;
        }
        ++index;
        ++index;
        System.arraycopy(recvBuf, ++index, this.rakpMessage4.mgmtConsoleSessionID, 0, 4);
        index += 4;
        switch (this.session.cipherSuite.getAuthenticationAlgorithm()) {
            case 0: {
                break;
            }
            case 2: {
                this.rakpMessage4.integrityCheckValue = new byte[16];
                System.arraycopy(recvBuf, index, this.rakpMessage4.integrityCheckValue, 0, 16);
                break;
            }
            case 1: {
                this.rakpMessage4.integrityCheckValue = new byte[20];
                System.arraycopy(recvBuf, index, this.rakpMessage4.integrityCheckValue, 0, 20);
            }
        }
        Logger.writeLog(this.rakpMessage4.toString());
        boolean hmac = this.checkRAKPMessage4HMAC();
        if (!hmac) {
            this.xMessage.setText(L.t("rakp.RAKP_Message_4_error_Verify_error_Maybe_the_password_invalid"));
            Logger.writeLog("RAKP Message 4 error: Verify error. Maybe the password invalid");
            return false;
        }
        Logger.writeLog(" RAKP 4 Key verify Successful");
        return true;
    }

    private boolean checkRAKPMessage4HMAC() {
        if (this.session.cipherSuite.getAuthenticationAlgorithm() == 0) {
            return true;
        }
        byte[] plainText = null;
        int size = 0;
        size = this.rakpMessage1.remoteConsoleRandomNumber.length + this.openSessionResponse.managedSystemSessionID.length + this.rakpMessage2.managedSystemGUID.length;
        plainText = new byte[size];
        System.arraycopy(this.rakpMessage1.remoteConsoleRandomNumber, 0, plainText, 0, 16);
        System.arraycopy(this.openSessionResponse.managedSystemSessionID, 0, plainText, 16, 4);
        System.arraycopy(this.rakpMessage2.managedSystemGUID, 0, plainText, 20, 16);
        byte[] result = CipherAlgorithmFactory.createRAKPAlgorithm(this.session).mac(this.SIK, plainText);
        if (Logger.writeLog || Logger.displayLog) {
            Logger.writeLog(" rakp4 Integrity check value = " + ByteUtility.bytesToHex(result));
        }
        if (this.session.cipherSuite.getAuthenticationAlgorithm() == 1) {
            byte[] b1 = new byte[12];
            byte[] b2 = new byte[12];
            System.arraycopy(result, 0, b1, 0, 12);
            System.arraycopy(this.rakpMessage4.integrityCheckValue, 0, b2, 0, 12);
            if (!ByteUtility.bytesToHex(b1).equals(ByteUtility.bytesToHex(b2))) {
                this.xMessage.setText(L.t("rakp.RAKP4_Integrity_check_value_error"));
                Logger.writeLog("RAKP4 Integrity check value error");
                return false;
            }
        } else if (!ByteUtility.bytesToHex(result).equals(ByteUtility.bytesToHex(this.rakpMessage4.integrityCheckValue))) {
            Logger.writeLog("RAKP4 Integrity check value error");
            this.xMessage.setText(L.t("rakp.RAKP4_Integrity_check_value_error"));
            return false;
        }
        return true;
    }

    private byte getAuthenticationByteSize() {
        byte b = 0;
        switch (this.session.cipherSuite.getAuthenticationAlgorithm()) {
            case 0: {
                b = 0;
                break;
            }
            case 2: {
                b = 16;
                break;
            }
            case 1: {
                b = 20;
            }
        }
        return b;
    }

    public void getCipherSuites() {
        byte[] cipherSuitesRecord = new byte[256];
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            byte[] result = new byte[16];
            if (!this.getCipherSuite(i, result)) continue;
            System.arraycopy(result, 0, cipherSuitesRecord, i * 16, 16);
        }
        Vector<Byte> supportedCipherSuite = new Vector<Byte>();
        for (int i = 0; i < cipherSuitesRecord.length; ++i) {
            if (cipherSuitesRecord[i] != -64) continue;
            supportedCipherSuite.add(new Byte(cipherSuitesRecord[i + 1]));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCipherSuite(byte index, byte[] result) {
        CSession Session;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        RMCPPlus rmcpPacket = new RMCPPlus();
        CSession cSession = Session = new CSession();
        synchronized (cSession) {
            Session.lockout();
            byte[] reqdata = new byte[]{1, 0, 0};
            reqdata[2] = (byte)(0xFFFFFF80 | index);
            Session.SessionID[0] = 0;
            Session.SessionID[1] = 0;
            Session.SessionID[2] = 0;
            Session.SessionID[3] = 0;
            Session.SessionSeq[0] = 0;
            Session.SessionSeq[1] = 0;
            Session.SessionSeq[2] = 0;
            Session.SessionSeq[3] = 0;
            Session.cipherSuite.setAuthenticationAlgorithm((byte)0);
            Session.cipherSuite.setIntegrityAlgorithm((byte)0);
            Session.cipherSuite.setConfidentialityAlgorithm((byte)0);
            Para.addElement(AuthType);
            Para.addElement(Session.SessionSeq);
            Para.addElement(Session.SessionID);
            Para.addElement(reqdata);
            ((RMCP)rmcpPacket).RMCPSetup((byte)7, (byte)24, (byte)84, (byte)65, Para, Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.session.SIP, 623, Session.InboundSessionSeq, rawdata, length[0], true)) {
                ((RMCP)rmcpPacket).ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
                if (rmcpPacket.compeletecode == 0) {
                    System.arraycopy((byte[])rmcpPacket.retValue.get(1), 0, result, 0, 16);
                    bResult = true;
                }
            }
            Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Object sResult = null;
        RMCP rmcpPacket = RMCPFactory.getInstance().createRMCP(this.session);
        AuthType[0] = this.session.IPMIVersion == 0 ? 0 : 2;
        CSession cSession = this.session;
        synchronized (cSession) {
            this.session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.session.SessionSeq);
            Para.addElement(this.session.SessionID);
            Para.addElement(this.session.SessionID);
            rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)60, (byte)65, Para, this.session, rawdata, length);
            if (this.udpSocket.SendPacket(this.session.SIP, 623, this.session.InboundSessionSeq, rawdata, length[0], true)) {
                rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.session.IPMIVersion, this.udpSocket.receiveByteLength);
                if (rmcpPacket.compeletecode == 0) {
                    this.session.IncreaseSessionSeq();
                    Logger.writeLog("Close session OK");
                } else {
                    Logger.writeLog("Close session Failed");
                }
            }
            this.session.releaselock();
        }
    }

    public class RAKPMessage4 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] mgmtConsoleSessionID = new byte[4];
        byte[] integrityCheckValue;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 4: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n mgmtConsoleSessionID = " + ByteUtility.bytesToHex(this.mgmtConsoleSessionID));
            if (this.integrityCheckValue != null) {
                sb.append("\n integrityCheckValue  = " + ByteUtility.bytesToHex(this.integrityCheckValue));
            }
            return sb.toString();
        }
    }

    public class RAKPMessage3 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] reserved = new byte[2];
        byte[] managedSystemSessionID = new byte[4];
        byte[] keyExchangeAuthenticationCode = null;

        public byte[] getBytes() {
            byte[] raw = null;
            raw = new byte[8 + RAKPTalker.this.getAuthenticationByteSize()];
            raw[0] = this.messageTag;
            raw[1] = this.RMCPPlusStatusCode;
            System.arraycopy(this.reserved, 0, raw, 2, 2);
            System.arraycopy(this.managedSystemSessionID, 0, raw, 4, 4);
            switch (RAKPTalker.this.session.cipherSuite.getAuthenticationAlgorithm()) {
                case 0: {
                    break;
                }
                case 2: {
                    System.arraycopy(this.keyExchangeAuthenticationCode, 0, raw, 8, 16);
                    break;
                }
                case 1: {
                    System.arraycopy(this.keyExchangeAuthenticationCode, 0, raw, 8, 20);
                }
            }
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 3: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n reserved        = " + ByteUtility.bytesToHex(this.reserved));
            sb.append("\n managedSystemSessionID     = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            if (this.keyExchangeAuthenticationCode != null) {
                sb.append("\n keyExchangeAuthenticationCode = " + ByteUtility.bytesToHex(this.keyExchangeAuthenticationCode));
            }
            return sb.toString();
        }
    }

    public class RAKPMessage2 {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] managedSystemRandomNumber = new byte[16];
        byte[] managedSystemGUID = new byte[16];
        byte[] keyExchangeAuthenticationCode = null;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 2: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n remoteConsoleSessionID        = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n managedSystemRandomNumber     = " + ByteUtility.bytesToHex(this.managedSystemRandomNumber));
            sb.append("\n managedSystemGUID             = " + ByteUtility.bytesToHex(this.managedSystemGUID));
            if (this.keyExchangeAuthenticationCode != null) {
                sb.append("\n keyExchangeAuthenticationCode = " + ByteUtility.bytesToHex(this.keyExchangeAuthenticationCode));
            }
            return sb.toString();
        }
    }

    public class RAKPMessage1 {
        byte messageTag;
        byte[] reserved1 = new byte[3];
        byte[] managedSystemSessionID = new byte[4];
        byte[] remoteConsoleRandomNumber = new byte[16];
        byte requestedMaxPrivilegeLevel;
        byte[] reserved2 = new byte[2];
        byte userNameLength;
        byte[] userName;

        public byte[] getBytes() {
            byte[] raw = new byte[28 + this.userNameLength];
            raw[0] = this.messageTag;
            System.arraycopy(this.reserved1, 0, raw, 1, 3);
            System.arraycopy(this.managedSystemSessionID, 0, raw, 4, 4);
            System.arraycopy(this.remoteConsoleRandomNumber, 0, raw, 8, 16);
            raw[24] = this.requestedMaxPrivilegeLevel;
            System.arraycopy(this.reserved2, 0, raw, 25, 2);
            raw[27] = this.userNameLength;
            if (this.userNameLength != 0 && this.userName.length != 0) {
                System.arraycopy(this.userName, 0, raw, 28, this.userName.length);
            }
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << RAKPMessage 1: >>");
            sb.append("\n messageTag = " + this.messageTag);
            sb.append("\n reserved1  = " + ByteUtility.bytesToHex(this.reserved1));
            sb.append("\n managedSystemSessionID     = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            sb.append("\n remoteConsoleRandomNumber  = " + ByteUtility.bytesToHex(this.remoteConsoleRandomNumber));
            sb.append("\n requestedMaxPrivilegeLevel = " + this.requestedMaxPrivilegeLevel);
            sb.append("\n reserved2      = " + ByteUtility.bytesToHex(this.reserved2));
            sb.append("\n userNameLength = " + this.userNameLength);
            if (this.userName != null && this.userName.length > 0) {
                sb.append("\n userName       = " + ByteUtility.bytesToHex(this.userName));
            }
            return sb.toString();
        }
    }

    public class OpenSessionResponse {
        byte messageTag;
        byte RMCPPlusStatusCode;
        byte maxPrivilegeLevel;
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] managedSystemSessionID = new byte[4];
        byte[] authenticationPayload = new byte[8];
        byte[] integrityPayload = new byte[8];
        byte[] confidentialityPayload = new byte[8];

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << OpenSessionResponse: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n RMCPPlusStatusCode = " + this.RMCPPlusStatusCode);
            sb.append("\n maxPrivilegeLevel  = " + this.maxPrivilegeLevel);
            sb.append("\n remoteConsoleSessionID = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n managedSystemSessionID = " + ByteUtility.bytesToHex(this.managedSystemSessionID));
            sb.append("\n authenticationPayload  = " + ByteUtility.bytesToHex(this.authenticationPayload));
            sb.append("\n integrityPayload       = " + ByteUtility.bytesToHex(this.integrityPayload));
            sb.append("\n confidentialityPayload = " + ByteUtility.bytesToHex(this.confidentialityPayload));
            return sb.toString();
        }
    }

    public class OpenSessionRequest {
        byte messageTag;
        byte requestedMaxPrivilegeLevel;
        byte[] reserved = new byte[2];
        byte[] remoteConsoleSessionID = new byte[4];
        byte[] authenticationPayload = new byte[8];
        byte[] integrityPayload = new byte[8];
        byte[] confidentialityPayload = new byte[8];

        public byte[] getBytes() {
            byte[] raw = new byte[32];
            raw[0] = this.messageTag;
            raw[1] = this.requestedMaxPrivilegeLevel;
            System.arraycopy(this.reserved, 0, raw, 2, 2);
            System.arraycopy(this.remoteConsoleSessionID, 0, raw, 4, 4);
            System.arraycopy(this.authenticationPayload, 0, raw, 8, 8);
            System.arraycopy(this.integrityPayload, 0, raw, 16, 8);
            System.arraycopy(this.confidentialityPayload, 0, raw, 24, 8);
            return raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n << OpenSessionRequest: >>");
            sb.append("\n messageTag         = " + this.messageTag);
            sb.append("\n requestedMaxPrivilegeLevel = " + this.requestedMaxPrivilegeLevel);
            sb.append("\n reserved = " + ByteUtility.bytesToHex(this.reserved));
            sb.append("\n remoteConsoleSessionID = " + ByteUtility.bytesToHex(this.remoteConsoleSessionID));
            sb.append("\n authenticationPayload  = " + ByteUtility.bytesToHex(this.authenticationPayload));
            sb.append("\n integrityPayload       = " + ByteUtility.bytesToHex(this.integrityPayload));
            sb.append("\n confidentialityPayload = " + ByteUtility.bytesToHex(this.confidentialityPayload));
            return sb.toString();
        }
    }
}

