/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SELDevice
extends JPanel {
    boolean bLoaded = false;
    boolean SDRloaded = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    JTable jEntryTable = null;
    CSession Session;
    int TotalEntries = 0;
    int TotalSDR = 0;
    Vector sRecords = new Vector(10);
    int TabId;
    UDPSocket udpSocket;
    SimpleTimeZone stz = new SimpleTimeZone(0, "PST");
    TimeZone tz;
    String sTimeZone;
    static JFileChooser fileChooser;
    myFilter filter = new myFilter();
    String PathName = "";
    private JTextField EFrom;
    private JTextField ETo;
    private JLabel FreeSpace;
    private JLabel REAdd;
    private JLabel REErase;
    private JLabel SELVersion;
    private JTextField SelTime;
    private JLabel TotalEntry;
    private ButtonGroup buttonGroup1;
    private JButton jButton3;
    private JButton jClearAllEntries;
    private JButton jClearSelectedEntry;
    private JButton jExport;
    private JButton jGetEntry;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JButton jRefresh;
    private JScrollPane jScrollPane1;
    private JComboBox jTimeZone;

    public SELDevice() {
        this.initComponents();
        this.jClearSelectedEntry.setVisible(false);
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = iSession.Loading;
        this.jTimeZone.addItem("GMT+13:00");
        this.jTimeZone.addItem("GMT+12:00");
        this.jTimeZone.addItem("GMT+11:00");
        this.jTimeZone.addItem("GMT+10:00");
        this.jTimeZone.addItem("GMT+09:00");
        this.jTimeZone.addItem("GMT+08:00");
        this.jTimeZone.addItem("GMT+07:00");
        this.jTimeZone.addItem("GMT+06:00");
        this.jTimeZone.addItem("GMT+05:00");
        this.jTimeZone.addItem("GMT+04:00");
        this.jTimeZone.addItem("GMT+03:00");
        this.jTimeZone.addItem("GMT+02:00");
        this.jTimeZone.addItem("GMT+01:00");
        this.jTimeZone.addItem("GMT");
        this.jTimeZone.addItem("GMT-01:00");
        this.jTimeZone.addItem("GMT-02:00");
        this.jTimeZone.addItem("GMT-03:00");
        this.jTimeZone.addItem("GMT-04:00");
        this.jTimeZone.addItem("GMT-05:00");
        this.jTimeZone.addItem("GMT-06:00");
        this.jTimeZone.addItem("GMT-07:00");
        this.jTimeZone.addItem("GMT-08:00");
        this.jTimeZone.addItem("GMT-09:00");
        this.jTimeZone.addItem("GMT-10:00");
        this.jTimeZone.addItem("GMT-11:00");
        this.jTimeZone.addItem("GMT-12:00");
        this.GetTimeZone();
        this.GetSelInfo();
        this.GetSelTime();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    private boolean GetSelInfo() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SEL Info");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)64, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SEL Info succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                this.SELVersion.setText((bytex[0] & 0xF) + "." + ((bytex[0] & 0xF0) >> 4));
                bytex = (byte[])this.rmcpPacket.retValue.get(1);
                this.TotalEntries = this.ByteToInt(bytex, 0, 2);
                this.EFrom.setText("1");
                this.ETo.setText(this.TotalEntries + "");
                this.TotalEntry.setText(this.TotalEntries + "");
                bytex = (byte[])this.rmcpPacket.retValue.get(2);
                this.FreeSpace.setText(this.ByteToInt(bytex, 0, 2) + " bytes");
                bytex = (byte[])this.rmcpPacket.retValue.get(3);
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                long k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                Date d = new Date(k);
                f.setTimeZone(this.stz);
                this.REAdd.setText(f.format(d));
                bytex = (byte[])this.rmcpPacket.retValue.get(4);
                k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                d = new Date(k);
                this.REErase.setText(f.format(d));
                bResult = true;
            } else {
                this.Message.setText("Get SEL Info failed");
            }
        } else {
            this.Message.setText("Get SEL Info failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSelTime() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SEL Time");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)72, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SEL Time succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                long k = (long)this.ByteToInt(bytex, 0, 4) * 1000L;
                Date d = new Date(k);
                f.setTimeZone(this.stz);
                this.SelTime.setText(f.format(d));
                bResult = true;
            } else {
                this.Message.setText("Get SEL Time failed");
            }
        } else {
            this.Message.setText("Get SEL Time failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private void GetTimeZone() {
        String strout = new String("propget\u0007SERVER_TIMEZONE\u0007");
        Vector[] retValue = new Vector[1];
        int length = 0;
        int prindex = 0;
        int parseStatus = 0;
        boolean lastpacket = false;
        this.Message.setText("Getting Server TimeZone");
        if (this.LongAsciiCmd(strout)) {
            if (this.LongAsciiCmdGo(retValue)) {
                byte[] retbytes = (byte[])retValue[0].get(0);
                String retString = (String)retValue[0].get(1);
                byte FLFlag = retbytes[0];
                if ((FLFlag & 0x80) != 0) {
                    length = (FLFlag & 0xF) * 256 + (retbytes[1] & 0xFF) - 2;
                }
                if ((FLFlag & 0x40) != 0) {
                    lastpacket = true;
                }
                prindex = 0;
                parseStatus = 0;
                while (prindex < length) {
                    int ipos = retString.indexOf(7, prindex);
                    if (ipos < 0) continue;
                    String tempString = retString.substring(prindex, ipos);
                    switch (parseStatus) {
                        case 0: {
                            if (tempString.compareTo("propget") == 0) {
                                parseStatus = 1;
                                break;
                            }
                            if (tempString.compareTo("SERVER_TIMEZONE") != 0) break;
                            parseStatus = 2;
                            break;
                        }
                        case 1: {
                            parseStatus = 0;
                            break;
                        }
                        case 2: {
                            if (tempString.compareTo("RW") == 0) {
                                // empty if block
                            }
                            parseStatus = 21;
                            break;
                        }
                        case 21: {
                            tempString = "0" + tempString.substring(2);
                            BigInteger bi = new BigInteger(tempString, 16);
                            int iTimezone = bi.intValue();
                            this.jTimeZone.setSelectedIndex(13 - iTimezone);
                            this.sTimeZone = (String)this.jTimeZone.getSelectedItem();
                            SimpleTimeZone.setDefault(TimeZone.getTimeZone(this.sTimeZone));
                            parseStatus = 0;
                        }
                    }
                    prindex = ipos + 1;
                }
                this.Message.setText("Get Server TimeZone succeeded");
            } else {
                this.Message.setText("Get Server TimeZone failed");
            }
        } else {
            this.Message.setText("Get Server TimeZone failed");
        }
    }

    private boolean SetSelTime() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] timebyte = new byte[4];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        f.setTimeZone(this.stz);
        ParsePosition pos = new ParsePosition(0);
        Date Time2Set = f.parse(this.SelTime.getText(), pos);
        try {
            int inttime = (int)(Time2Set.getTime() / 1000L);
            this.IntToByte(timebyte, 0, inttime);
        }
        catch (NullPointerException ne) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Date,Time format invalid!");
            return bResult;
        }
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(timebyte);
        this.SIP = this.Session.SIP;
        this.Message.setText("Setting SEL Time");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)73, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Set SEL Time succeeded");
                bResult = true;
            } else {
                this.Message.setText("Set SEL Time failed");
            }
        } else {
            this.Message.setText("Set SEL Time failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private void SetTimeZone() {
        int iSelect = 13 - this.jTimeZone.getSelectedIndex();
        String strout = new String("propset\u0007SERVER_TIMEZONE\u00070x" + Integer.toHexString(iSelect) + '\u0007');
        Vector[] retValue = new Vector[1];
        boolean length = false;
        boolean prindex = false;
        boolean parseStatus = false;
        boolean lastpacket = false;
        this.Message.setText("Setting Server TimeZone");
        if (this.LongAsciiCmd(strout)) {
            if (this.LongAsciiCmdGo(retValue)) {
                this.sTimeZone = (String)this.jTimeZone.getSelectedItem();
                SimpleTimeZone.setDefault(TimeZone.getTimeZone(this.sTimeZone));
                this.Message.setText("Set Server TimeZone succeeded");
            } else {
                this.Message.setText("Set Server TimeZone failed");
            }
        } else {
            this.Message.setText("Set Server TimeZone failed");
        }
    }

    private boolean ReserveSEL(byte[] ReserveID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)66, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, ReserveID, 0, 2);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean ClearSEL(byte[] ReserveID, boolean bInit, boolean[] bStatus) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        byte[] cmddata = new byte[]{67, 76, 82, -86};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!bInit) {
            cmddata[3] = 0;
        }
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReserveID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)71, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            this.Session.IncreaseSessionSeq();
            if (this.rmcpPacket.compeletecode == 0) {
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                bStatus[0] = (bytex[0] & 1) != 0;
                bResult = true;
            } else {
                bResult = false;
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private boolean DeleteSelEntry(byte[] ReserveID, byte[] RecordID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReserveID);
        Para.addElement(RecordID);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)70, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            this.Session.IncreaseSessionSeq();
            if (this.rmcpPacket.compeletecode == 0) {
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, RecordID, 0, 2);
                bResult = true;
            } else {
                bResult = false;
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private String GetSelEntry(boolean screen) {
        int i;
        byte[] AuthType = new byte[]{0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] RecordID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] ByteToRead = new byte[]{-1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        int StartE = 0;
        int EndE = 0;
        int ArrayNum = 6;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        Vector<String[]> vRecords = new Vector<String[]>(10);
        String xStr = "";
        Object[] ColumnHead = new String[]{"Event", "Type", "Timestamp", "Sensor Type", "Sensor", "Event Type"};
        String[] toolTipStr = new String[]{"Event Number used for SEL Record access", "Event Record Type", "Time when event was logged", "Sensor Type Code for sensor that generated the event", "Sensor Name that generated the event", "Event Type"};
        if (this.jRadioButton1.isSelected()) {
            StartE = 0;
            EndE = this.TotalEntries - 1;
        } else {
            try {
                StartE = Integer.parseInt(this.EFrom.getText());
                EndE = Integer.parseInt(this.ETo.getText());
                if (StartE < 1) {
                    StartE = 1;
                }
                if (EndE > this.TotalEntries) {
                    EndE = this.TotalEntries;
                }
            }
            catch (Exception e) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Invalid numeric!");
                StartE = 1;
                EndE = this.TotalEntries;
            }
        }
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        for (i = StartE; i <= EndE; ++i) {
            bResult = false;
            this.Session.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(ReserveID);
            Para.addElement(RecordID);
            Para.addElement(Offset);
            Para.addElement(ByteToRead);
            this.SIP = this.Session.SIP;
            this.Message.setText("Getting SEL Entry: " + i);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)67, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    Date d;
                    long k;
                    SimpleDateFormat f;
                    this.Session.IncreaseSessionSeq();
                    this.Message.setText("Get SEL Entry: " + i + " succeeded");
                    String[] xString = new String[11];
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, RecordID, 0, 2);
                    bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    xString[0] = new String(this.ByteToInt(bytex, 0, 2) + "");
                    if (bytex[2] < 192) {
                        xString[1] = "System Event";
                        f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                        k = (long)this.ByteToInt(bytex, 3, 4) * 1000L;
                        d = new Date(k);
                        f.setTimeZone(this.stz);
                        xString[2] = new String(f.format(d));
                        xString[3] = this.gd.getSensorType(this.ByteToInt(bytex, 10, 1));
                        xString[4] = this.findSDRSensorName(this.ByteToInt(bytex, 11, 1));
                        xString[5] = this.gd.getEventType(this.ByteToInt(bytex, 12, 1), bytex[10], (byte)(bytex[13] & 0xF));
                        xString[6] = "";
                        xString[7] = "";
                    } else if (bytex[2] < 224) {
                        xString[1] = "OEM timestamped";
                        f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                        k = (long)this.ByteToInt(bytex, 3, 4) * 1000L;
                        d = new Date(k);
                        f.setTimeZone(this.stz);
                        xString[2] = new String(f.format(d));
                        xString[3] = "";
                        xString[4] = "";
                        xString[5] = "";
                        xString[6] = new String(this.ByteToInt(bytex, 7, 3) + "");
                        xString[7] = new String(this.ByteToInt(bytex, 10, 6) + "");
                    } else {
                        xString[1] = "OEM non-timestamped";
                        xString[2] = "";
                        xString[3] = "";
                        xString[4] = "";
                        xString[5] = "";
                        xString[6] = "";
                        xString[7] = new String(this.ByteToInt(bytex, 3, 13) + "");
                    }
                    vRecords.addElement(xString);
                    bResult = true;
                } else {
                    this.Message.setText("Get SEL Entry: " + i + " failed");
                }
            } else {
                this.Message.setText("Get SEL Entry: " + i + " failed");
            }
            this.Session.releaselock();
        }
        if (screen) {
            if (vRecords.size() > 0) {
                Object[][] Records = new String[vRecords.size()][ArrayNum];
                for (int j = 0; j < vRecords.size(); ++j) {
                    for (int k = 0; k < ArrayNum; ++k) {
                        Records[j][k] = ((String[])vRecords.get(j))[k];
                    }
                }
                DefaultTableModel dtm = new DefaultTableModel(Records, ColumnHead);
                this.jEntryTable = new JTable(dtm);
                this.jEntryTable.setAutoResizeMode(4);
                ToolTipHeader header = new ToolTipHeader(this.jEntryTable.getColumnModel());
                header.setToolTipStrings(toolTipStr);
                header.setToolTipText("Default ToolTip TEXT");
                this.jEntryTable.setTableHeader(header);
                TableColumn tc = this.jEntryTable.getColumn("Event");
                tc.setPreferredWidth(30);
                tc = this.jEntryTable.getColumn("Event Type");
                tc.setPreferredWidth(120);
                this.jScrollPane1.setViewportView(this.jEntryTable);
                this.jClearSelectedEntry.setEnabled(true);
            }
        } else {
            for (i = 0; i < ColumnHead.length; ++i) {
                xStr = xStr + ColumnHead[i] + ",";
            }
            xStr = xStr.substring(0, xStr.length() - 1) + "\r\n";
            if (vRecords.size() > 0) {
                for (int j = 0; j < vRecords.size(); ++j) {
                    for (int k = 0; k < ArrayNum; ++k) {
                        xStr = xStr + ((String[])vRecords.get(j))[k] + ",";
                    }
                    xStr = xStr.substring(0, xStr.length() - 1) + "\r\n";
                }
                xStr = xStr.substring(0, xStr.length() - 2);
            }
        }
        this.Message.setText("Get SEL Entry is successful");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return xStr;
    }

    public void GetSensors() {
        if (this.GetSDRRepoInfo() && this.TotalSDR > 0) {
            this.sRecords.removeAllElements();
            while (!this.GetSDRRecords()) {
                this.sRecords.removeAllElements();
            }
        }
    }

    private boolean GetSDRRepoInfo() {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.Message.setText("Getting SDR Repository Info");
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)32, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                this.Message.setText("Get SDR Repository Info succeeded");
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(1);
                this.TotalSDR = this.ByteToInt(bytex, 0, 2);
                bResult = true;
            } else {
                this.Message.setText("Get SDR Repository Info failed");
            }
        } else {
            this.Message.setText("Get SDR Repository Info failed");
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecords() {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        boolean EndE = false;
        Vector Para = new Vector(1);
        boolean bResult = false;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        StartE = 0;
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(ReserveID)) {
            int i = StartE;
            do {
                bResult = false;
                this.Message.setText("Getting SDR Record: " + i);
                Offset[0] = 0;
                if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx)) {
                    SensorRecord sensorR = new SensorRecord();
                    this.Message.setText("Get SDR Record: " + i + " succeeded");
                    if (bytex[3] == 1) {
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        for (int totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText("Get SDR Record: " + i + " failed");
                            break;
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        strout.write(bytex, 48, bytex[47] & 0x1F);
                        sensorR.SensorName = strout.toString();
                        this.sRecords.addElement(sensorR);
                    }
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText("Get SDR Record: " + i + " failed");
            } while (bResult && this.ByteToInt(RecordID, 0, 2) != 65535 && ++i < this.TotalSDR);
        }
        if (this.ByteToInt(RecordID, 0, 2) == 65535) {
            this.Message.setText("Get SDR Record is successful");
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            return bResult;
        }
        this.Message.setText("Get SDR Record is failed");
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return bResult;
    }

    private boolean ReserveSDR(byte[] ReserveID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)34, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, ReserveID, 0, 2);
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean GetSDRRecord(byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength) {
        byte[] AuthType = new byte[]{0};
        byte[] ByteToRead = new byte[]{-1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(ReserveID);
        Para.addElement(RecordID);
        Para.addElement(Offset);
        Para.addElement(ByteToRead);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)35, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, this.Session.IPMIVersion, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                System.arraycopy(bytex, 0, NextRecordID, 0, 2);
                bytex = (byte[])this.rmcpPacket.retValue.get(1);
                System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                retlength[0] = bytex.length;
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private String findSDRSensorName(int xSensorNumber) {
        for (int i = 0; i < this.sRecords.size(); ++i) {
            SensorRecord Sensor = (SensorRecord)this.sRecords.get(i);
            if (Sensor.SensorNumber != xSensorNumber) continue;
            return Sensor.SensorName;
        }
        return "";
    }

    private boolean LongAsciiCmd(String Keyword) {
        Vector[] retValue = new Vector[1];
        boolean bFirst = true;
        boolean bResult = false;
        int offset = 0;
        while (Keyword.length() > 0) {
            if (Keyword.length() > 32) {
                String tempString = Keyword.substring(0, 32);
                bResult = this._LongAsciiCmd(tempString, bFirst, false, Keyword.length());
                Keyword = Keyword.substring(32);
                offset += 32;
                bFirst = false;
                continue;
            }
            bResult = this._LongAsciiCmd(Keyword, bFirst, true, offset);
            Keyword = "";
        }
        return bResult;
    }

    private boolean _LongAsciiCmd(String Keyword, boolean bFirst, boolean bLast, int length_offset) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        int stroutlen = Keyword.length();
        byte[] cmddata = new byte[stroutlen + 2];
        cmddata[0] = (byte)(length_offset >> 8 & 0xFFF);
        cmddata[0] = (byte)(cmddata[0] | (byte)((bFirst ? 128 : 0) | (bLast ? 64 : 0)));
        cmddata[1] = (byte)(length_offset & 0xFFFFFFFF);
        System.arraycopy(Keyword.getBytes(), 0, cmddata, 2, stroutlen);
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private boolean LongAsciiCmdGo(Vector[] retValue) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] cmddata = new byte[]{0, 0};
        this.Session.lockout();
        Para.addElement(AuthType);
        Para.addElement(this.Session.SessionSeq);
        Para.addElement(this.Session.SessionID);
        Para.addElement(cmddata);
        this.SIP = this.Session.SIP;
        this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)48, (byte)65, Para, this.Session, rawdata, length);
        if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
            this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 0, this.udpSocket.receiveByteLength);
            if (this.rmcpPacket.compeletecode == 0) {
                this.Session.IncreaseSessionSeq();
                retValue[0] = this.rmcpPacket.retValue;
                bResult = true;
            }
        }
        this.Session.releaselock();
        return bResult;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jClearSelectedEntry = new JButton();
        this.jClearAllEntries = new JButton();
        this.SelTime = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.EFrom = new JTextField();
        this.jLabel7 = new JLabel();
        this.ETo = new JTextField();
        this.jGetEntry = new JButton();
        this.jExport = new JButton();
        this.jLabel8 = new JLabel();
        this.TotalEntry = new JLabel();
        this.jLabel10 = new JLabel();
        this.FreeSpace = new JLabel();
        this.jLabel12 = new JLabel();
        this.REAdd = new JLabel();
        this.jLabel14 = new JLabel();
        this.REErase = new JLabel();
        this.jLabel16 = new JLabel();
        this.SELVersion = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jRefresh = new JButton();
        this.jLabel2 = new JLabel();
        this.jTimeZone = new JComboBox();
        this.setLayout(new AbsoluteLayout());
        this.jClearSelectedEntry.setText("Delete Selected Entry");
        this.jClearSelectedEntry.setEnabled(false);
        this.jClearSelectedEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jClearSelectedEntryActionPerformed(evt);
            }
        });
        this.add((Component)this.jClearSelectedEntry, new AbsoluteConstraints(60, 340, 160, 30));
        this.jClearAllEntries.setText("Clear All Entries");
        this.jClearAllEntries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jClearAllEntriesActionPerformed(evt);
            }
        });
        this.add((Component)this.jClearAllEntries, new AbsoluteConstraints(230, 340, 160, 30));
        this.add((Component)this.SelTime, new AbsoluteConstraints(230, 390, 170, 20));
        this.jButton3.setText("Set Timestamp");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jButton3ActionPerformed(evt);
            }
        });
        this.add((Component)this.jButton3, new AbsoluteConstraints(410, 390, 120, 30));
        this.jLabel3.setText("Current SEL Device Timestamp:");
        this.jLabel3.setHorizontalAlignment(4);
        this.add((Component)this.jLabel3, new AbsoluteConstraints(30, 390, 190, -1));
        this.jLabel6.setText("System Event Log");
        this.jLabel6.setForeground(Color.blue);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setFont(new Font("Microsoft Sans Serif", 0, 18));
        this.jLabel6.setOpaque(true);
        this.add((Component)this.jLabel6, new AbsoluteConstraints(180, 0, 190, 30));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder("Export Entries"));
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("All");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton1, new AbsoluteConstraints(30, 20, -1, -1));
        this.jRadioButton2.setText("From");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton2, new AbsoluteConstraints(30, 50, 60, 20));
        this.EFrom.setEditable(false);
        this.jPanel1.add((Component)this.EFrom, new AbsoluteConstraints(100, 50, 40, 20));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText("To");
        this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(150, 50, -1, 20));
        this.ETo.setEditable(false);
        this.jPanel1.add((Component)this.ETo, new AbsoluteConstraints(170, 50, 40, 20));
        this.jGetEntry.setText("Get");
        this.jGetEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jGetEntryActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jGetEntry, new AbsoluteConstraints(10, 80, 100, 30));
        this.jExport.setText("Export");
        this.jExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jExportActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jExport, new AbsoluteConstraints(120, 80, 100, 30));
        this.add((Component)this.jPanel1, new AbsoluteConstraints(40, 40, 230, 120));
        this.jLabel8.setText("Total Entries:");
        this.jLabel8.setHorizontalAlignment(4);
        this.add((Component)this.jLabel8, new AbsoluteConstraints(280, 70, 120, -1));
        this.TotalEntry.setForeground(Color.blue);
        this.TotalEntry.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.TotalEntry, new AbsoluteConstraints(410, 70, 90, -1));
        this.jLabel10.setText("Recent Entry Added:");
        this.jLabel10.setHorizontalAlignment(4);
        this.add((Component)this.jLabel10, new AbsoluteConstraints(280, 110, 120, -1));
        this.FreeSpace.setForeground(Color.blue);
        this.FreeSpace.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.FreeSpace, new AbsoluteConstraints(410, 90, 90, -1));
        this.jLabel12.setText("Free Space:");
        this.jLabel12.setHorizontalAlignment(4);
        this.add((Component)this.jLabel12, new AbsoluteConstraints(280, 90, 120, -1));
        this.REAdd.setForeground(Color.blue);
        this.REAdd.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REAdd, new AbsoluteConstraints(410, 110, 150, -1));
        this.jLabel14.setText("Recent Entry Erased:");
        this.jLabel14.setHorizontalAlignment(4);
        this.add((Component)this.jLabel14, new AbsoluteConstraints(280, 130, 120, -1));
        this.REErase.setForeground(Color.blue);
        this.REErase.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REErase, new AbsoluteConstraints(410, 130, 150, -1));
        this.jLabel16.setText("SEL Version:");
        this.jLabel16.setHorizontalAlignment(4);
        this.add((Component)this.jLabel16, new AbsoluteConstraints(280, 50, 120, -1));
        this.SELVersion.setForeground(Color.blue);
        this.SELVersion.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.SELVersion, new AbsoluteConstraints(410, 50, 90, -1));
        this.add((Component)this.jScrollPane1, new AbsoluteConstraints(40, 170, 510, 160));
        this.jRefresh.setText("Refresh");
        this.jRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice.this.jRefreshActionPerformed(evt);
            }
        });
        this.add((Component)this.jRefresh, new AbsoluteConstraints(230, 460, -1, -1));
        this.jLabel2.setText("Time Zone:");
        this.jLabel2.setHorizontalAlignment(4);
        this.add((Component)this.jLabel2, new AbsoluteConstraints(31, 420, 190, -1));
        this.jTimeZone.setBackground(Color.white);
        this.jTimeZone.setFont(new Font("Dialog", 0, 12));
        this.add((Component)this.jTimeZone, new AbsoluteConstraints(230, 420, 170, -1));
    }

    private void jExportActionPerformed(ActionEvent evt) {
        boolean save = false;
        JOptionPane MBox = new JOptionPane();
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setFileFilter(this.filter);
            fileChooser.setFileSelectionMode(0);
        }
        if (fileChooser.showSaveDialog(null) == 0) {
            this.PathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.PathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), "Do you want to overwrite it?", "Request Confirmation", 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (save) {
            Thread th = new Thread(){

                public void run() {
                    Cursor csrTemp = new Cursor(3);
                    SELDevice.this.setCursor(csrTemp);
                    if (!SELDevice.this.SDRloaded) {
                        SELDevice.this.GetSensors();
                        SELDevice.this.SDRloaded = true;
                    }
                    try {
                        FileWriter fout = new FileWriter(SELDevice.this.PathName);
                        PrintWriter pw = new PrintWriter(fout);
                        pw.println(SELDevice.this.GetSelEntry(false));
                        fout.close();
                        SELDevice.this.Message.setText("Event Log Export done!");
                    }
                    catch (IOException e) {
                        JOptionPane MBox = new JOptionPane();
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), "Can't save to file!  It probably is locked or read-only.", "Warning", 0);
                        SELDevice.this.Message.setText("Event Log Export failed!");
                    }
                    csrTemp = new Cursor(0);
                    SELDevice.this.setCursor(csrTemp);
                }
            };
            th.start();
        } else {
            this.Message.setText("Event Log Export canceled!");
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice.this.setCursor(csrTemp);
                SELDevice.this.Session.Loading = SELDevice.this.TabId;
                SELDevice.this.SetSelTime();
                SELDevice.this.SetTimeZone();
                SELDevice.this.GetSelTime();
                SELDevice.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice.this.setCursor(csrTemp);
                SELDevice.this.Session.Loading = SELDevice.this.TabId;
                SELDevice.this.GetTimeZone();
                SELDevice.this.GetSelInfo();
                SELDevice.this.GetSelTime();
                SELDevice.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jClearSelectedEntryActionPerformed(ActionEvent evt) {
    }

    private void jClearAllEntriesActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice.this.setCursor(csrTemp);
                boolean[] bStatus = new boolean[]{false};
                byte[] ReserveID = new byte[]{0, 0};
                SELDevice.this.Session.Loading = SELDevice.this.TabId;
                SELDevice.this.Message.setText("Clear System Event Log");
                if (SELDevice.this.ReserveSEL(ReserveID)) {
                    SELDevice.this.ClearSEL(ReserveID, true, bStatus);
                    while (!bStatus[0]) {
                        bStatus[0] = false;
                        SELDevice.this.ClearSEL(ReserveID, false, bStatus);
                    }
                    SELDevice.this.Message.setText("Clear System Event Log is done");
                    SELDevice.this.GetSelInfo();
                    SELDevice.this.GetSelTime();
                    SELDevice.this.clearTable();
                } else {
                    SELDevice.this.Message.setText("Unable to clear System Event Log");
                }
                SELDevice.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    public void clearTable() {
        if (this.jEntryTable == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jEntryTable.getModel();
        for (int i = dtm.getRowCount() - 1; i >= 0; --i) {
            dtm.removeRow(i);
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(false);
        this.ETo.setEditable(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(true);
        this.ETo.setEditable(true);
    }

    private void jGetEntryActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                if (!SELDevice.this.SDRloaded) {
                    SELDevice.this.GetSensors();
                    SELDevice.this.SDRloaded = true;
                }
                SELDevice.this.Session.Loading = SELDevice.this.TabId;
                SELDevice.this.GetSelEntry(true);
                SELDevice.this.Session.Loading = -1;
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    class ToolTipHeader
    extends JTableHeader {
        String[] toolTips;

        public ToolTipHeader(TableColumnModel model) {
            super(model);
        }

        public String getToolTipText(MouseEvent e) {
            String retStr;
            int col = this.columnAtPoint(e.getPoint());
            int modelCol = this.getTable().convertColumnIndexToModel(col);
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
            return retStr;
        }

        public void setToolTipStrings(String[] toolTips) {
            this.toolTips = toolTips;
        }
    }

    private class myFilter
    extends FileFilter {
        private myFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.toUpperCase().endsWith(".csv") || fileName.toUpperCase().endsWith(".txt") || file.isDirectory();
        }

        public String getDescription() {
            return ".csv or .txt";
        }
    }

    class SensorRecord {
        int SensorNumber;
        int SensorType;
        String SensorName;

        SensorRecord() {
        }
    }
}

