/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.CSession;
import IPMIView20.GlobalDefine;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.UDPSocket;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SELDevice20
extends JPanel {
    boolean bLoaded = false;
    boolean SDRloaded = false;
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    JTable jEntryTable = null;
    CSession Session;
    int TotalEntries = 0;
    int TotalSDR = 0;
    Vector sRecords = new Vector(10);
    int TabId;
    UDPSocket udpSocket;
    static JFileChooser fileChooser;
    myFilter filter = new myFilter();
    String PathName = "";
    long zoneOffset = Calendar.getInstance().get(15);
    private JTextField EFrom;
    private JTextField ETo;
    private JLabel FreeSpace;
    private JLabel REAdd;
    private JLabel REErase;
    private JLabel SELVersion;
    private JTextField SelTime;
    private JLabel TotalEntry;
    private ButtonGroup buttonGroup1;
    private JButton jButton3;
    private JButton jClearAllEntries;
    private JButton jClearSelectedEntries;
    private JButton jClearSelectedEntry;
    private JButton jExport;
    private JButton jGetEntry;
    private JLabel jLabel10;
    private JLabel jLabel12;
    private JLabel jLabel14;
    private JLabel jLabel16;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JButton jRefresh;
    private JScrollPane jScrollPane1;

    public SELDevice20() {
        TimeZone tz = TimeZone.getDefault();
        if (tz.useDaylightTime()) {
            this.zoneOffset += (long)Calendar.getInstance().get(16);
        }
        this.initComponents();
        this.jClearSelectedEntry.setVisible(false);
        this.buttonGroup1.add(this.jRadioButton1);
        this.buttonGroup1.add(this.jRadioButton2);
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.Session = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.bLoaded) {
            this.Session.Loading = -1;
            return;
        }
        this.TabId = iSession.Loading;
        this.GetSelInfo();
        this.GetSelTime();
        this.bLoaded = true;
        this.Session.Loading = -1;
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSelInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sel.Getting_SEL_Info"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)64, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("sel.Get_SEL_Info_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    this.SELVersion.setText((bytex[0] & 0xF) + "." + ((bytex[0] & 0xF0) >> 4));
                    bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    this.TotalEntries = this.ByteToInt(bytex, 0, 2);
                    this.EFrom.setText("0");
                    this.ETo.setText(this.TotalEntries + "");
                    this.TotalEntry.setText(this.TotalEntries + "");
                    bytex = (byte[])this.rmcpPacket.retValue.get(2);
                    this.FreeSpace.setText(this.ByteToInt(bytex, 0, 2) + " bytes");
                    bytex = (byte[])this.rmcpPacket.retValue.get(3);
                    SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                    long k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 0, 4) * 1000L);
                    Date d = new Date(k);
                    this.REAdd.setText(f.format(d));
                    bytex = (byte[])this.rmcpPacket.retValue.get(4);
                    k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 0, 4) * 1000L);
                    d = new Date(k);
                    this.REErase.setText(f.format(d));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sel.Get_SEL_Info_failed"));
                }
            } else {
                this.Message.setText(L.t("sel.Get_SEL_Info_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSelTime() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sel.Getting_SEL_Time"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)72, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("sel.Get_SEL_Time_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                    long k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 0, 4) * 1000L);
                    Date d = new Date(k);
                    this.SelTime.setText(f.format(d));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sel.Get_SEL_Time_failed"));
                }
            } else {
                this.Message.setText(L.t("sel.Get_SEL_Time_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private void GetTimeZone() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetSelTime() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] timebyte = new byte[4];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        SimpleDateFormat f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
        ParsePosition pos = new ParsePosition(0);
        Date Time2Set = f.parse(this.SelTime.getText(), pos);
        Time2Set.setTime(Time2Set.getTime() + this.zoneOffset);
        try {
            int inttime = (int)(Time2Set.getTime() / 1000L);
            this.IntToByte(timebyte, 0, inttime);
        }
        catch (NullPointerException ne) {
            JOptionPane MBox = new JOptionPane();
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Date_Time_format_invalid"));
            return bResult;
        }
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(timebyte);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sel.Setting_SEL_Time"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)73, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("sel.Set_SEL_Time_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sel.Set_SEL_Time_failed"));
                }
            } else {
                this.Message.setText(L.t("sel.Set_SEL_Time_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private void SetTimeZone() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ReserveSEL(byte[] ReserveID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)66, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, ReserveID, 0, 2);
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ClearSEL(byte[] ReserveID, boolean bInit, boolean[] bStatus) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] cmddata = new byte[]{67, 76, 82, -86};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!bInit) {
            cmddata[3] = 0;
        }
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(ReserveID);
            Para.addElement(cmddata);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)71, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    bStatus[0] = (bytex[0] & 1) != 0;
                    bResult = true;
                } else {
                    bResult = false;
                }
                this.Session.releaselock();
            }
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean DeleteSelEntry(byte[] ReserveID, byte[] RecordID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(ReserveID);
            Para.addElement(RecordID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)70, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, RecordID, 0, 2);
                    bResult = true;
                } else {
                    bResult = false;
                }
                this.Session.releaselock();
            }
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String GetSelEntry(boolean screen) {
        int i;
        byte[] AuthType = new byte[]{2};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] RecordID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] ByteToRead = new byte[]{-1};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        int StartE = 0;
        int EndE = 0;
        int ArrayNum = 6;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        Vector<String[]> vRecords = new Vector<String[]>(10);
        String xStr = "";
        Object[] ColumnHead = new String[]{L.t("sel.Event"), L.t("sel.Type"), L.t("sel.Timestamp"), L.t("sel.Sensor_Type"), L.t("sel.Sensor"), L.t("sel.Event_Type")};
        String[] toolTipStr = new String[]{L.t("sel.Event_Number_used_for_SEL_Record_access"), L.t("sel.Event_Record_Type"), L.t("sel.Time_when_event_was_logged"), L.t("sel.Sensor_Type_Code_for_sensor_that_generated_the_event"), L.t("sel.Sensor_Name_that_generated_the_event"), L.t("sel.Event_Type")};
        boolean isSuccessfulGetSEL = true;
        if (this.jRadioButton1.isSelected()) {
            StartE = 0;
            EndE = this.TotalEntries - 1;
        } else {
            try {
                StartE = Integer.parseInt(this.EFrom.getText());
                EndE = Integer.parseInt(this.ETo.getText());
                if (StartE < 0) {
                    StartE = 0;
                }
                if (EndE > this.TotalEntries - 1) {
                    EndE = this.TotalEntries - 1;
                }
            }
            catch (Exception e) {
                JOptionPane MBox = new JOptionPane();
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Invalid_numeric"));
                StartE = 1;
                EndE = this.TotalEntries;
            }
        }
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        for (i = StartE; i <= EndE; ++i) {
            bResult = false;
            CSession cSession = this.Session;
            synchronized (cSession) {
                Object[] objs;
                this.Session.lockout();
                Para.removeAllElements();
                Para.addElement(AuthType);
                Para.addElement(this.Session.SessionSeq);
                Para.addElement(this.Session.SessionID);
                Para.addElement(ReserveID);
                Para.addElement(RecordID);
                Para.addElement(Offset);
                Para.addElement(ByteToRead);
                this.SIP = this.Session.SIP;
                this.Message.setText(L.t("sel.Getting_SEL_Entry_Colon") + i);
                this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)67, (byte)65, Para, this.Session, rawdata, length);
                if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                    this.Session.IncreaseSessionSeq();
                    this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                    if (this.rmcpPacket.compeletecode == 0) {
                        Date d;
                        long k;
                        SimpleDateFormat f;
                        objs = new Object[]{"" + i};
                        this.Message.setText(L.f("sel.Get_SEL_Entry__succeeded", objs));
                        String[] xString = new String[11];
                        byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                        System.arraycopy(bytex, 0, RecordID, 0, 2);
                        bytex = (byte[])this.rmcpPacket.retValue.get(1);
                        xString[0] = "" + (i + 1);
                        if (bytex[2] < 192) {
                            xString[1] = L.t("sel.System_Event");
                            if ((long)this.ByteToInt(bytex, 3, 4) < 0x20000000L) {
                                f = new SimpleDateFormat("HH:mm:ss");
                                k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 3, 4) * 1000L);
                                d = new Date(k);
                                xString[2] = "Pre-Init " + f.format(d);
                            } else {
                                f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                                k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 3, 4) * 1000L);
                                d = new Date(k);
                                xString[2] = new String(f.format(d));
                            }
                            xString[3] = this.gd.getSensorType(this.ByteToInt(bytex, 10, 1));
                            xString[4] = this.findSDRSensorName(this.ByteToInt(bytex, 11, 1));
                            xString[5] = this.gd.getEventType(this.ByteToInt(bytex, 12, 1), bytex[10], (byte)(bytex[13] & 0xF));
                            xString[6] = "";
                            xString[7] = "";
                        } else if (bytex[2] < 224) {
                            xString[1] = L.t("sel.OEM_timestamped");
                            f = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss EEE");
                            k = this.addTimeZoneOffset((long)this.ByteToInt(bytex, 3, 4) * 1000L);
                            d = new Date(k);
                            xString[2] = new String(f.format(d));
                            xString[3] = "";
                            xString[4] = "";
                            xString[5] = "";
                            xString[6] = new String(this.ByteToInt(bytex, 7, 3) + "");
                            xString[7] = new String(this.ByteToInt(bytex, 10, 6) + "");
                        } else {
                            xString[1] = L.t("sel.OEM_non-timestamped");
                            xString[2] = "";
                            xString[3] = "";
                            xString[4] = "";
                            xString[5] = "";
                            xString[6] = "";
                            xString[7] = new String(this.ByteToInt(bytex, 3, 13) + "");
                        }
                        vRecords.addElement(xString);
                        bResult = true;
                    } else {
                        isSuccessfulGetSEL = false;
                        objs = new Object[]{"" + i};
                        this.Message.setText(L.f("sel.Get_SEL_Entry__failed", objs));
                    }
                } else {
                    isSuccessfulGetSEL = false;
                    objs = new Object[]{"" + i};
                    this.Message.setText(L.f("sel.Get_SEL_Entry__failed", objs));
                }
                this.Session.releaselock();
                continue;
            }
        }
        if (screen) {
            if (vRecords.size() > 0) {
                Object[][] Records = new String[vRecords.size()][ArrayNum];
                for (int j = 0; j < vRecords.size(); ++j) {
                    for (int k = 0; k < ArrayNum; ++k) {
                        Records[j][k] = ((String[])vRecords.get(j))[k];
                    }
                }
                DefaultTableModel dtm = new DefaultTableModel(Records, ColumnHead);
                this.jEntryTable = new JTable(dtm);
                this.jEntryTable.setAutoResizeMode(4);
                ToolTipHeader header = new ToolTipHeader(this.jEntryTable.getColumnModel());
                header.setToolTipStrings(toolTipStr);
                header.setToolTipText("Default ToolTip TEXT");
                this.jEntryTable.setTableHeader(header);
                TableColumn tc = this.jEntryTable.getColumn(L.t("sel.Event"));
                tc.setPreferredWidth(30);
                tc = this.jEntryTable.getColumn(L.t("sel.Event_Type"));
                tc.setPreferredWidth(120);
                this.jScrollPane1.setViewportView(this.jEntryTable);
                this.jClearSelectedEntry.setEnabled(true);
            }
        } else {
            for (i = 0; i < ColumnHead.length; ++i) {
                xStr = xStr + ColumnHead[i] + ",";
            }
            xStr = xStr.substring(0, xStr.length() - 1) + "\r\n";
            if (vRecords.size() > 0) {
                for (int j = 0; j < vRecords.size(); ++j) {
                    for (int k = 0; k < ArrayNum; ++k) {
                        xStr = xStr + ((String[])vRecords.get(j))[k] + ",";
                    }
                    xStr = xStr.substring(0, xStr.length() - 1) + "\r\n";
                }
                xStr = xStr.substring(0, xStr.length() - 2);
            }
        }
        if (isSuccessfulGetSEL) {
            this.Message.setText(L.t("sel.Get_SEL_Entry_successful"));
        } else {
            this.Message.setText(" ");
        }
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return xStr;
    }

    public boolean GetSensors() {
        if (this.GetSDRRepoInfo() && this.TotalSDR > 0) {
            this.sRecords.removeAllElements();
            return this.GetSDRRecords();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSDRRepoInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.Message.setText(L.t("sel.Getting_SDR_Repository_Info"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)32, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.Message.setText(L.t("sel.Get_SDR_Repository_Info_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    this.TotalSDR = this.ByteToInt(bytex, 0, 2);
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sel.Get_SDR_Repository_Info_failed"));
                }
            } else {
                this.Message.setText(L.t("sel.Get_SDR_Repository_Info_failed"));
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private boolean GetSDRRecords() {
        byte[] RecordID = new byte[]{0, 0};
        byte[] NextRecordID = new byte[]{0, 0};
        byte[] ReserveID = new byte[]{0, 0};
        byte[] Offset = new byte[]{0};
        byte[] bytex = new byte[128];
        byte[] bytey = new byte[128];
        byte[] bytez = new byte[128];
        int[] lengthx = new int[1];
        int[] lengthz = new int[1];
        int StartE = 0;
        boolean EndE = false;
        Vector Para = new Vector(1);
        boolean bResult = false;
        Cursor csrTemp = new Cursor(3);
        this.setCursor(csrTemp);
        StartE = 0;
        RecordID[0] = (byte)StartE;
        RecordID[1] = (byte)(StartE >> 8);
        if (this.ReserveSDR(ReserveID)) {
            int i = StartE;
            do {
                bResult = false;
                Object[] objs = new Object[]{"" + i};
                this.Message.setText(L.t("sel.Getting_SDR_Record_colon") + i);
                Offset[0] = 0;
                if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytex, lengthx)) {
                    SensorRecord sensorR = new SensorRecord();
                    this.Message.setText(L.f("sel.Get_SDR_Record__succeeded", objs));
                    if (bytex[3] == 1) {
                        sensorR.SensorNumber = bytex[7] & 0xFF;
                        sensorR.SensorType = this.ByteToInt(bytex, 12, 1);
                        for (int totallen = bytex[4] - lengthx[0] + 5; totallen > 0; totallen -= lengthz[0]) {
                            Offset[0] = (byte)lengthx[0];
                            if (this.GetSDRRecord(ReserveID, RecordID, NextRecordID, Offset, bytez, lengthz)) {
                                System.arraycopy(bytez, 0, bytex, lengthx[0], lengthz[0]);
                                lengthx[0] = lengthx[0] + lengthz[0];
                                continue;
                            }
                            this.Message.setText(L.f("sel.Get_SDR_Record__failed", objs));
                            break;
                        }
                        ByteArrayOutputStream strout = new ByteArrayOutputStream();
                        strout.write(bytex, 48, bytex[47] & 0x1F);
                        sensorR.SensorName = strout.toString();
                        this.sRecords.addElement(sensorR);
                    }
                    System.arraycopy(NextRecordID, 0, RecordID, 0, 2);
                    bResult = true;
                    continue;
                }
                this.Message.setText(L.f("sel.Get_SDR_Record__failed", objs));
            } while (bResult && this.ByteToInt(RecordID, 0, 2) != 65535 && ++i < this.TotalSDR);
        }
        if (this.ByteToInt(RecordID, 0, 2) == 65535) {
            this.Message.setText(L.t("sel.Get_SDR_Record_successful"));
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            return bResult;
        }
        this.Message.setText(L.t("sel.Get_SDR_Record_failed"));
        csrTemp = new Cursor(0);
        this.setCursor(csrTemp);
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ReserveSDR(byte[] ReserveID) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)34, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, ReserveID, 0, 2);
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSDRRecord(byte[] ReserveID, byte[] RecordID, byte[] NextRecordID, byte[] Offset, byte[] byteResult, int[] retlength) {
        byte[] AuthType = new byte[]{2};
        byte[] ByteToRead = new byte[]{22};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.Session;
        synchronized (cSession) {
            this.Session.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.Session.SessionSeq);
            Para.addElement(this.Session.SessionID);
            Para.addElement(ReserveID);
            Para.addElement(RecordID);
            Para.addElement(Offset);
            Para.addElement(ByteToRead);
            this.SIP = this.Session.SIP;
            this.rmcpPacket.RMCPSetup((byte)7, (byte)40, (byte)35, (byte)65, Para, this.Session, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.Session.InboundSessionSeq, rawdata, length[0], true)) {
                this.Session.IncreaseSessionSeq();
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    System.arraycopy(bytex, 0, NextRecordID, 0, 2);
                    bytex = (byte[])this.rmcpPacket.retValue.get(1);
                    System.arraycopy(bytex, 0, byteResult, 0, bytex.length);
                    retlength[0] = bytex.length;
                    bResult = true;
                }
            }
            this.Session.releaselock();
        }
        return bResult;
    }

    private String findSDRSensorName(int xSensorNumber) {
        for (int i = 0; i < this.sRecords.size(); ++i) {
            SensorRecord Sensor = (SensorRecord)this.sRecords.get(i);
            if (Sensor.SensorNumber != xSensorNumber) continue;
            return Sensor.SensorName;
        }
        return "";
    }

    private long addTimeZoneOffset(long time) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTimeInMillis(time);
        long zoneOffset = 0L;
        zoneOffset = c.get(15) + c.get(16);
        return time - zoneOffset;
    }

    private void initComponents() {
        Font borderFont = new Font("default", 0, 11);
        this.buttonGroup1 = new ButtonGroup();
        this.jClearSelectedEntry = new JButton();
        this.jClearAllEntries = new JButton();
        this.jClearSelectedEntries = new JButton();
        this.SelTime = new JTextField();
        this.jButton3 = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.EFrom = new JTextField();
        this.jLabel7 = new JLabel();
        this.ETo = new JTextField();
        this.jGetEntry = new JButton();
        this.jExport = new JButton();
        this.jLabel8 = new JLabel();
        this.TotalEntry = new JLabel();
        this.jLabel10 = new JLabel();
        this.FreeSpace = new JLabel();
        this.jLabel12 = new JLabel();
        this.REAdd = new JLabel();
        this.jLabel14 = new JLabel();
        this.REErase = new JLabel();
        this.jLabel16 = new JLabel();
        this.SELVersion = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jRefresh = new JButton();
        this.setLayout(new AbsoluteLayout());
        this.jClearSelectedEntry.setText("Delete Selected Entry");
        this.jClearSelectedEntry.setEnabled(false);
        this.jClearSelectedEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jClearSelectedEntryActionPerformed(evt);
            }
        });
        this.add((Component)this.jClearSelectedEntry, new AbsoluteConstraints(60, 340, 160, 30));
        this.jClearAllEntries.setText(L.t("sel.Clear_All_Entries"));
        this.jClearAllEntries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jClearAllEntriesActionPerformed(evt);
            }
        });
        this.jClearSelectedEntries.setText("Clear Selected Entries");
        this.jClearSelectedEntries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jClearSelectedEntriesActionPerformed(evt);
            }
        });
        this.add((Component)this.jClearAllEntries, new AbsoluteConstraints(230, 340, 160, 30));
        this.add((Component)this.SelTime, new AbsoluteConstraints(230, 390, 170, 20));
        this.jButton3.setText(L.t("sel.Set_Timestamp"));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jButton3ActionPerformed(evt);
            }
        });
        this.add((Component)this.jButton3, new AbsoluteConstraints(410, 390, 130, 30));
        this.jLabel3.setText(L.t("sel.Current_SEL_Device_Timestamp_colon"));
        this.jLabel3.setHorizontalAlignment(4);
        this.add((Component)this.jLabel3, new AbsoluteConstraints(30, 390, 190, -1));
        this.jLabel6.setText(L.t("sel.System_Event_Log"));
        this.jLabel6.setForeground(Color.blue);
        this.jLabel6.setHorizontalAlignment(0);
        this.jLabel6.setFont(new Font("default", 0, 18));
        this.jLabel6.setOpaque(true);
        this.add((Component)this.jLabel6, new AbsoluteConstraints(180, 0, 190, 30));
        this.jPanel1.setLayout(new AbsoluteLayout());
        this.jPanel1.setBorder(new TitledBorder(null, L.t("sel.Export_Entries"), 0, 2, borderFont, Color.BLUE));
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText(L.t("sel.All"));
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton1, new AbsoluteConstraints(30, 20, -1, -1));
        this.jRadioButton2.setText(L.t("sel.From"));
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jRadioButton2, new AbsoluteConstraints(30, 50, 60, 20));
        this.EFrom.setEditable(false);
        this.jPanel1.add((Component)this.EFrom, new AbsoluteConstraints(100, 50, 40, 20));
        this.jLabel7.setHorizontalAlignment(0);
        this.jLabel7.setText(L.t("sel.To"));
        this.jPanel1.add((Component)this.jLabel7, new AbsoluteConstraints(150, 50, -1, 20));
        this.ETo.setEditable(false);
        this.jPanel1.add((Component)this.ETo, new AbsoluteConstraints(170, 50, 40, 20));
        this.jGetEntry.setText(L.t("sel.Get"));
        this.jGetEntry.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jGetEntryActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jGetEntry, new AbsoluteConstraints(10, 80, 100, 30));
        this.jExport.setText(L.t("sel.Export"));
        this.jExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jExportActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.jExport, new AbsoluteConstraints(120, 80, 100, 30));
        this.add((Component)this.jPanel1, new AbsoluteConstraints(40, 40, 230, 120));
        this.jLabel8.setText(L.t("sel.Total_Entries_colon"));
        this.jLabel8.setHorizontalAlignment(4);
        this.add((Component)this.jLabel8, new AbsoluteConstraints(270, 70, 130, -1));
        this.TotalEntry.setForeground(Color.blue);
        this.TotalEntry.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.TotalEntry, new AbsoluteConstraints(410, 70, 90, -1));
        this.jLabel10.setText(L.t("sel.Recent_Entry_Added_colon"));
        this.jLabel10.setHorizontalAlignment(4);
        this.add((Component)this.jLabel10, new AbsoluteConstraints(270, 110, 130, -1));
        this.FreeSpace.setForeground(Color.blue);
        this.FreeSpace.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.FreeSpace, new AbsoluteConstraints(410, 90, 90, -1));
        this.jLabel12.setText(L.t("sel.Free_Space_colon"));
        this.jLabel12.setHorizontalAlignment(4);
        this.add((Component)this.jLabel12, new AbsoluteConstraints(270, 90, 130, -1));
        this.REAdd.setForeground(Color.blue);
        this.REAdd.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REAdd, new AbsoluteConstraints(410, 110, 150, -1));
        this.jLabel14.setText(L.t("sel.Recent_Entry_Erased_colon"));
        this.jLabel14.setHorizontalAlignment(4);
        this.add((Component)this.jLabel14, new AbsoluteConstraints(270, 130, 130, -1));
        this.REErase.setForeground(Color.blue);
        this.REErase.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.REErase, new AbsoluteConstraints(410, 130, 150, -1));
        this.jLabel16.setText(L.t("sel.SEL_Version_colon"));
        this.jLabel16.setHorizontalAlignment(4);
        this.add((Component)this.jLabel16, new AbsoluteConstraints(270, 50, 130, -1));
        this.SELVersion.setForeground(Color.blue);
        this.SELVersion.setPreferredSize(new Dimension(0, 17));
        this.add((Component)this.SELVersion, new AbsoluteConstraints(410, 50, 90, -1));
        this.add((Component)this.jScrollPane1, new AbsoluteConstraints(40, 170, 510, 160));
        this.jRefresh.setText(L.t("sel.Refresh"));
        this.jRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SELDevice20.this.jRefreshActionPerformed(evt);
            }
        });
        this.add((Component)this.jRefresh, new AbsoluteConstraints(230, 460, -1, -1));
    }

    private void jExportActionPerformed(ActionEvent evt) {
        boolean save = false;
        JOptionPane MBox = new JOptionPane();
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setFileFilter(this.filter);
            fileChooser.setFileSelectionMode(0);
        }
        if (fileChooser.showSaveDialog(null) == 0) {
            this.PathName = fileChooser.getSelectedFile().getAbsolutePath();
            File xfi = new File(this.PathName);
            if (xfi.exists()) {
                int ret = JOptionPane.showConfirmDialog(IPMIView20.getInstance(), L.t("sel.Do_you_want_to_overwrite_it"), L.t("sel.Request_Confirmation"), 0);
                if (ret == 0) {
                    save = true;
                }
            } else {
                save = true;
            }
        }
        if (save) {
            Thread th = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    SELDevice20.this.jButton3.setEnabled(false);
                    SELDevice20.this.jGetEntry.setEnabled(false);
                    SELDevice20.this.jExport.setEnabled(false);
                    SELDevice20.this.jRefresh.setEnabled(false);
                    SELDevice20.this.jClearAllEntries.setEnabled(false);
                    Cursor csrTemp = new Cursor(3);
                    SELDevice20.this.setCursor(csrTemp);
                    if (!SELDevice20.this.SDRloaded) {
                        if (!SELDevice20.this.GetSensors()) {
                            SELDevice20.this.Message.setText(L.t("sel.Event_Log_Export_failed"));
                            return;
                        }
                        SELDevice20.this.SDRloaded = true;
                    }
                    try {
                        FileWriter fout = new FileWriter(SELDevice20.this.PathName);
                        PrintWriter pw = new PrintWriter(fout);
                        pw.println(SELDevice20.this.GetSelEntry(false));
                        fout.close();
                        SELDevice20.this.Message.setText(L.t("sel.Event_Log_Export_done"));
                    }
                    catch (IOException e) {
                        JOptionPane MBox = new JOptionPane();
                        JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sel.Cannot_save_to_file_It_probably_is_locked_or_read-only"), L.t("sel.Warning"), 0);
                        SELDevice20.this.Message.setText(L.t("sel.Event_Log_Export_failed"));
                    }
                    finally {
                        SELDevice20.this.jButton3.setEnabled(true);
                        SELDevice20.this.jGetEntry.setEnabled(true);
                        SELDevice20.this.jExport.setEnabled(true);
                        SELDevice20.this.jRefresh.setEnabled(true);
                        SELDevice20.this.jClearAllEntries.setEnabled(true);
                    }
                    csrTemp = new Cursor(0);
                    SELDevice20.this.setCursor(csrTemp);
                }
            };
            th.start();
        } else {
            this.Message.setText(L.t("sel.Event_Log_Export_canceled"));
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice20.this.setCursor(csrTemp);
                SELDevice20.this.Session.Loading = SELDevice20.this.TabId;
                SELDevice20.this.SetSelTime();
                SELDevice20.this.SetTimeZone();
                SELDevice20.this.GetSelTime();
                SELDevice20.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jRefreshActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice20.this.setCursor(csrTemp);
                SELDevice20.this.Session.Loading = SELDevice20.this.TabId;
                SELDevice20.this.GetSelInfo();
                SELDevice20.this.GetSelTime();
                SELDevice20.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jClearSelectedEntryActionPerformed(ActionEvent evt) {
    }

    private void jClearAllEntriesActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                Cursor csrTemp = new Cursor(3);
                SELDevice20.this.setCursor(csrTemp);
                boolean[] bStatus = new boolean[]{false};
                byte[] ReserveID = new byte[]{0, 0};
                SELDevice20.this.Session.Loading = SELDevice20.this.TabId;
                SELDevice20.this.Message.setText(L.t("sel.Clear_System_Event_Log"));
                if (SELDevice20.this.ReserveSEL(ReserveID)) {
                    SELDevice20.this.ClearSEL(ReserveID, true, bStatus);
                    int count = 0;
                    while (!bStatus[0]) {
                        bStatus[0] = false;
                        SELDevice20.this.ReserveSEL(ReserveID);
                        SELDevice20.this.ClearSEL(ReserveID, false, bStatus);
                        if (count++ != 10) continue;
                        System.out.println("The System Event Log should be cleared");
                        break;
                    }
                    SELDevice20.this.Message.setText(L.t("sel.Clear_System_Event_Log_done"));
                    SELDevice20.this.GetSelInfo();
                    SELDevice20.this.GetSelTime();
                    SELDevice20.this.clearTable();
                } else {
                    SELDevice20.this.Message.setText(L.t("sel.Unable_to_clear_System_Event_Log"));
                }
                SELDevice20.this.Session.Loading = -1;
                csrTemp = new Cursor(0);
                SELDevice20.this.setCursor(csrTemp);
            }
        };
        th.start();
    }

    private void jClearSelectedEntriesActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                byte[] reverseID = new byte[]{0, 0};
                byte[] recordID = new byte[]{0, 2};
                SELDevice20.this.DeleteSelEntry(reverseID, recordID);
                SELDevice20.this.Session.Loading = SELDevice20.this.TabId;
                SELDevice20.this.GetSelEntry(true);
                SELDevice20.this.Session.Loading = -1;
            }
        };
        th.start();
    }

    public void clearTable() {
        if (this.jEntryTable == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jEntryTable.getModel();
        for (int i = dtm.getRowCount() - 1; i >= 0; --i) {
            dtm.removeRow(i);
        }
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(false);
        this.ETo.setEditable(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.EFrom.setEditable(true);
        this.ETo.setEditable(true);
    }

    private void jGetEntryActionPerformed(ActionEvent evt) {
        Thread th = new Thread(){

            public void run() {
                SELDevice20.this.jButton3.setEnabled(false);
                SELDevice20.this.jGetEntry.setEnabled(false);
                SELDevice20.this.jExport.setEnabled(false);
                SELDevice20.this.jRefresh.setEnabled(false);
                SELDevice20.this.jClearAllEntries.setEnabled(false);
                if (!SELDevice20.this.SDRloaded) {
                    if (!SELDevice20.this.GetSensors()) {
                        SELDevice20.this.Message.setText(L.t("sel.Event_Log_Export_failed"));
                        return;
                    }
                    SELDevice20.this.SDRloaded = true;
                }
                SELDevice20.this.Session.Loading = SELDevice20.this.TabId;
                SELDevice20.this.GetSelEntry(true);
                SELDevice20.this.Session.Loading = -1;
                SELDevice20.this.jButton3.setEnabled(true);
                SELDevice20.this.jGetEntry.setEnabled(true);
                SELDevice20.this.jExport.setEnabled(true);
                SELDevice20.this.jRefresh.setEnabled(true);
                SELDevice20.this.jClearAllEntries.setEnabled(true);
            }
        };
        th.start();
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    class ToolTipHeader
    extends JTableHeader {
        String[] toolTips;

        public ToolTipHeader(TableColumnModel model) {
            super(model);
        }

        public String getToolTipText(MouseEvent e) {
            String retStr;
            int col = this.columnAtPoint(e.getPoint());
            int modelCol = this.getTable().convertColumnIndexToModel(col);
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
            return retStr;
        }

        public void setToolTipStrings(String[] toolTips) {
            this.toolTips = toolTips;
        }
    }

    private class myFilter
    extends FileFilter {
        private myFilter() {
        }

        public boolean accept(File file) {
            String fileName = file.getName();
            return fileName.toUpperCase().endsWith(".csv") || fileName.toUpperCase().endsWith(".txt") || file.isDirectory();
        }

        public String getDescription() {
            return ".csv or .txt";
        }
    }

    class SensorRecord {
        int SensorNumber;
        int SensorType;
        String SensorName;

        SensorRecord() {
        }
    }
}

