/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.ByteUtility;
import IPMIView20.CSession;
import IPMIView20.CipherSuite;
import IPMIView20.GlobalDefine;
import IPMIView20.Hardware;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.RAKPTalker;
import IPMIView20.RMCP;
import IPMIView20.RMCPFactory;
import IPMIView20.RMCPPlus;
import IPMIView20.SOLUDPSocket20;
import IPMIView20.UDPSocket;
import IPMIView20.UTF8_CheckBox_actionAdapter;
import IPMIView20.VT100;
import IPMIView20.sol.SOLPacketSender;
import IPMIView20.sol.Storage;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessagingCommand;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class SOL20
extends JPanel {
    GlobalDefine gd = new GlobalDefine();
    RMCP rmcpPacket = null;
    String SIP;
    JLabel Message;
    UDPSocket udpSocket;
    CRService CRDeamon = null;
    public CSession orgSession;
    SOLUDPSocket20 solUDPSocket;
    public CSession solSession;
    RMCP solRMCPPacket;
    public HashMap solPackets;
    public HashMap solPacketsSize;
    int solLocalTempPort;
    Storage storage;
    SOLPacketSender solPacketSender;
    VT100 VTHandle = null;
    boolean TCRunning = false;
    int KeySeq = 0;
    int KeyModifier = -1;
    int LastKey = -1;
    int testseq = 0;
    int testcount = 0;
    int DaemonPort = 0;
    Timer timer;
    HashMap javaKeyCodeToSOLKeyCode = new HashMap();
    public boolean bootingDisable = false;
    byte lastPktSeq = 0;
    int a_delay = 0;
    boolean keyPressed = false;
    private JTextPane Console;
    public JButton TestButton;
    public JButton Start;
    public JButton Stop;
    public JButton Refresh;
    public JCheckBox encryption;
    public JCheckBox utf8;
    public JComboBox baudRate;
    public JLabel baudRateLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    Font utf8Font = null;
    JComboBox fontComboBox = null;

    public SOL20() {
        this.initComponents();
        Font messageFont = new Font("Courier New", 0, 12);
        FontMetrics fm = this.getFontMetrics(messageFont);
        if (fm.charWidth('i') != fm.charWidth('W')) {
            messageFont = new Font("Courier", 0, 12);
        }
        this.Console.setFont(messageFont);
        this.Console.setVisible(false);
        this.Console.requestFocus();
        this.javaKeyCodeToSOLKeyCode.put("38", new byte[]{27, 91, 65});
        this.javaKeyCodeToSOLKeyCode.put("40", new byte[]{27, 91, 66});
        this.javaKeyCodeToSOLKeyCode.put("37", new byte[]{27, 91, 68});
        this.javaKeyCodeToSOLKeyCode.put("39", new byte[]{27, 91, 67});
        this.javaKeyCodeToSOLKeyCode.put("10", new byte[]{13});
        this.javaKeyCodeToSOLKeyCode.put("112", new byte[]{27, 79, 80, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("113", new byte[]{27, 79, 81, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("114", new byte[]{27, 79, 82, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("115", new byte[]{27, 79, 83, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("116", new byte[]{27, 53});
        this.javaKeyCodeToSOLKeyCode.put("117", new byte[]{27, 54});
        this.javaKeyCodeToSOLKeyCode.put("118", new byte[]{27, 55});
        this.javaKeyCodeToSOLKeyCode.put("119", new byte[]{27, 56});
        this.javaKeyCodeToSOLKeyCode.put("120", new byte[]{27, 57});
        this.javaKeyCodeToSOLKeyCode.put("121", new byte[]{27, 48});
        this.javaKeyCodeToSOLKeyCode.put("122", new byte[]{27, 33});
        this.javaKeyCodeToSOLKeyCode.put("123", new byte[]{27, 64});
        this.javaKeyCodeToSOLKeyCode.put("155", new byte[]{27, 43});
        this.javaKeyCodeToSOLKeyCode.put("127", new byte[]{27, 45});
        this.javaKeyCodeToSOLKeyCode.put("36", new byte[]{27, 104});
        this.javaKeyCodeToSOLKeyCode.put("35", new byte[]{27, 107});
        this.javaKeyCodeToSOLKeyCode.put("33", new byte[]{27, 63});
        this.javaKeyCodeToSOLKeyCode.put("34", new byte[]{27, 47});
    }

    public void preset(UDPSocket xSocket, CSession iSession, JLabel xMessage) {
        this.orgSession = iSession;
        this.Message = xMessage;
        this.udpSocket = xSocket;
        this.SIP = iSession.SIP;
        this.rmcpPacket = RMCPFactory.getInstance().createRMCP(iSession);
        if (this.orgSession.IPMIVersion == 2) {
            this.encryption.setVisible(true);
        } else {
            this.encryption.setVisible(false);
        }
        this.encryption.setSelected(true);
        if (this.orgSession.isPeppercon) {
            this.encryption.setEnabled(false);
            byte[] data = this.getSOLConfiguration(new byte[]{1, 5, 0, 0});
            if (data != null) {
                this.baudRate.setSelectedIndex(data[1] - 6);
            }
            if (this.orgSession.MaxLevel[0] == 4) {
                this.baudRate.setEnabled(true);
            } else {
                this.baudRate.setEnabled(false);
            }
        } else {
            this.baudRateLabel.setVisible(false);
            this.baudRate.setVisible(false);
            byte[] data = this.getSOLConfiguration(new byte[]{1, 2, 0, 0});
            if (data != null && (data[1] & 0xFFFFFF80) == 0 && (data[1] & 0x40) == 0) {
                if (this.orgSession.MaxLevel[0] < 4) {
                    this.encryption.setSelected(false);
                    this.encryption.setEnabled(false);
                }
            }
        }
    }

    public void setXMessgage(JLabel message) {
        this.Message = message;
    }

    public void closeTCR() {
        if (this.TCRunning) {
            this.CRCommand(new byte[]{2});
            this.CRDeamon.stopCR();
            this.Start.setEnabled(true);
            this.encryption.setEnabled(true);
            this.Stop.setEnabled(false);
            this.Refresh.setEnabled(false);
            this.TCRunning = false;
            this.Console.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CRCommand(byte[] ReqID) {
        byte[] AuthType = new byte[]{0};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] retIP = new byte[4];
        byte[] retPort = new byte[2];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        InetAddress tempaddress = null;
        boolean bResult = false;
        this.SIP = this.orgSession.SIP;
        try {
            tempaddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ue) {
            return false;
        }
        retIP = tempaddress.getAddress();
        retPort[0] = (byte)(this.DaemonPort >> 8);
        retPort[1] = (byte)(this.DaemonPort & 0xFF);
        CSession cSession = this.orgSession;
        synchronized (cSession) {
            this.orgSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.orgSession.SessionSeq);
            Para.addElement(this.orgSession.SessionID);
            Para.addElement(ReqID);
            Para.addElement(retIP);
            Para.addElement(retPort);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)50, (byte)0, Para, this.orgSession, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.orgSession.InboundSessionSeq, rawdata, length[0], true)) {
                this.Message.setText("IPMI request sent successfully");
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                switch (this.rmcpPacket.compeletecode) {
                    case 0: {
                        this.orgSession.IncreaseSessionSeq();
                        this.Message.setText("IPMI response received");
                        bResult = true;
                        break;
                    }
                    case -57: {
                        this.Message.setText("IPMI response received, but command failed (invalid request data size)");
                        break;
                    }
                    case -50: {
                        this.Message.setText("IPMI response received, but command failed (no response)");
                        break;
                    }
                    case -55: {
                        this.Message.setText("IPMI response received, but command failed (data out of range)");
                        break;
                    }
                    case -128: {
                        this.Message.setText("IPMI response received, but command failed (Text Remote Console not available)");
                    }
                }
            } else {
                this.Message.setText("IPMI request sent failed");
            }
            this.orgSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean KeyStroke(byte key) {
        byte[] AuthType = new byte[]{-126};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Vector<byte[]> solPara = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!this.TCRunning) {
            return false;
        }
        this.SIP = this.solSession.SIP;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            byte[] seq = new byte[1];
            byte[] ackSeq = new byte[1];
            byte[] acceptedCharCount = new byte[1];
            byte[] operation = new byte[1];
            byte[] data = new byte[1];
            seq[0] = this.solSession.SOLSeq;
            ackSeq[0] = 0;
            acceptedCharCount[0] = 0;
            operation[0] = 0;
            data[0] = key;
            solPara.addElement(seq);
            solPara.addElement(ackSeq);
            solPara.addElement(acceptedCharCount);
            solPara.addElement(operation);
            solPara.addElement(data);
            this.solRMCPPacket.RMCPSOLSetup(Para, solPara, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacketNoWait(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.Message.setText(L.t("sol.SOL_is_working"));
                this.solPackets.put(new Byte(this.solSession.SOLSeq), rawdata);
                this.solPacketsSize.put(new Byte(this.solSession.SOLSeq), new Integer(length[0]));
                this.solSession.incSOLSeq();
                this.solSession.IncreaseSessionSeq();
            } else {
                this.Message.setText(L.t("sol.SOL_Failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean KeyStrokes(byte[] keys) {
        byte[] AuthType = new byte[]{-126};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        Vector<byte[]> solPara = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!this.TCRunning) {
            return false;
        }
        this.SIP = this.solSession.SIP;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            byte[] seq = new byte[1];
            byte[] ackSeq = new byte[1];
            byte[] acceptedCharCount = new byte[1];
            byte[] operation = new byte[1];
            seq[0] = this.solSession.SOLSeq;
            ackSeq[0] = 0;
            acceptedCharCount[0] = 0;
            operation[0] = 0;
            solPara.addElement(seq);
            solPara.addElement(ackSeq);
            solPara.addElement(acceptedCharCount);
            solPara.addElement(operation);
            solPara.addElement(keys);
            this.solRMCPPacket.RMCPSOLSetup(Para, solPara, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacketNoWait(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.Message.setText(L.t("sol.SOL_Successful"));
                this.solPackets.put(new Byte(this.solSession.SOLSeq), rawdata);
                this.solPacketsSize.put(new Byte(this.solSession.SOLSeq), new Integer(length[0]));
                this.solSession.incSOLSeq();
                this.solSession.IncreaseSessionSeq();
            } else {
                this.Message.setText(L.t("sol.SOL_Failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendKeyStrokes(byte orgSeq) {
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            byte[] rawData = (byte[])this.solPackets.get(new Byte(orgSeq));
            this.replaceSessionSequenceNumber(rawData);
            int length = (Integer)this.solPacketsSize.get(new Byte(orgSeq));
            this.solUDPSocket.SendPacketNoWait(this.SIP, 623, this.solSession.InboundSessionSeq, rawData, length);
            this.solSession.IncreaseSessionSeq();
            this.solSession.releaselock();
        }
    }

    private void replaceSessionSequenceNumber(byte[] rawData) {
        rawData[10] = this.solSession.SessionSeq[0];
        rawData[11] = this.solSession.SessionSeq[1];
        rawData[12] = this.solSession.SessionSeq[2];
        rawData[13] = this.solSession.SessionSeq[3];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean CRKeyStroke(byte KeyB0, byte KeyB1, byte KeyStatus) {
        byte[] AuthType = new byte[]{-126};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] Keycode = new byte[]{0, 0};
        byte[] Keystatus = new byte[]{0};
        byte[] Keyboard = new byte[]{0};
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        if (!this.TCRunning) {
            return false;
        }
        this.SIP = this.orgSession.SIP;
        Keycode[0] = KeyB0;
        Keycode[1] = KeyB1;
        Keystatus[0] = KeyStatus;
        CSession cSession = this.orgSession;
        synchronized (cSession) {
            this.orgSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.orgSession.SessionSeq);
            Para.addElement(this.orgSession.SessionID);
            Para.addElement(Keycode);
            Para.addElement(Keystatus);
            Para.addElement(Keyboard);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)32, (byte)51, (byte)0, Para, this.orgSession, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.orgSession.InboundSessionSeq, rawdata, length[0], true)) {
                this.Message.setText("IPMI request sent successfully");
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                switch (this.rmcpPacket.compeletecode) {
                    case 0: {
                        this.orgSession.IncreaseSessionSeq();
                        this.Message.setText("IPMI response received");
                        bResult = true;
                        break;
                    }
                    case -57: {
                        this.Message.setText("IPMI response received, but command failed (invalid request data size)");
                        break;
                    }
                    case -50: {
                        this.Message.setText("IPMI response received, but command failed (no response)");
                    }
                }
            } else {
                this.Message.setText("IPMI request sent failed");
            }
            this.orgSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte GetACPIPowerState() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        byte bResult = -1;
        CSession cSession = this.orgSession;
        synchronized (cSession) {
            this.orgSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.orgSession.SessionSeq);
            Para.addElement(this.orgSession.SessionID);
            this.SIP = this.orgSession.SIP;
            this.Message.setText(L.t("sol.Getting_ACPI_Power_State"));
            this.rmcpPacket.RMCPSetup((byte)7, (byte)24, (byte)7, (byte)0, Para, this.orgSession, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.orgSession.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.orgSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Get_ACPI_Power_State_succeeded"));
                    byte[] bytex = (byte[])this.rmcpPacket.retValue.get(0);
                    bResult = bytex[0];
                } else {
                    this.Message.setText(L.t("sol.Get_ACPI_Power_State_failed"));
                }
            } else {
                this.Message.setText(L.t("sol.Get_ACPI_Power_State_failed"));
            }
            this.orgSession.releaselock();
        }
        return bResult;
    }

    private boolean setUserPayLoadAccess() {
        block6: {
            block5: {
                if (this.orgSession.MaxLevel[0] == 3) break block5;
                if (this.orgSession.MaxLevel[0] != 2) break block6;
            }
            return true;
        }
        byte[] retData = new byte[6];
        boolean result = this.orgSession.ipmiSession.getSessionInfoPlus(retData);
        if (result) {
            byte userID = retData[3];
            byte byte2 = (byte)(userID | 0);
            boolean b2 = this.setUserPayLoadAccess(new byte[]{1, byte2, 2, 0, 0, 0});
            if (b2) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUserPayLoadAccess(byte[] config) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(config);
            this.Message.setText(L.t("sol.Set_User_PayLoad_Access"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)76, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Set_User_PayLoad_Access_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.Set_User_PayLoad_Access_failed"));
                }
            } else {
                this.Message.setText(L.t("sol.Set_User_PayLoad_Access_failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    private boolean setSOLConfiguration() {
        boolean b4;
        boolean b3;
        block10: {
            block9: {
                if (this.orgSession.MaxLevel[0] == 3) break block9;
                if (this.orgSession.MaxLevel[0] != 2) break block10;
            }
            return true;
        }
        byte byte1 = 0;
        if (this.solSession.cipherSuite.getConfidentialityAlgorithm() > 0) {
            byte1 = (byte)(byte1 | 0x80);
        }
        if (this.solSession.cipherSuite.getIntegrityAlgorithm() > 0) {
            byte1 = (byte)(byte1 | 0x40);
        }
        byte1 = (byte)(byte1 | 2);
        Logger.writeLog("Set Sol configuration: SOL Enable");
        boolean b1 = this.setSOLConfiguration(new byte[]{1, 1, 1});
        Logger.writeLog("Set Sol configuration: SOL Authentication");
        boolean b2 = this.setSOLConfiguration(new byte[]{1, 2, byte1});
        Logger.writeLog("Set Sol configuration: Bit rate (non-volatile)");
        if (this.orgSession.isPeppercon) {
            byte selectIndex = (byte)this.baudRate.getSelectedIndex();
            b3 = this.setSOLConfiguration(new byte[]{1, 5, (byte)(6 + selectIndex)});
            b4 = this.setSOLConfiguration(new byte[]{1, 6, (byte)(6 + selectIndex)});
        } else {
            b3 = this.setSOLConfiguration(new byte[]{1, 5, 7});
            b4 = this.setSOLConfiguration(new byte[]{1, 6, 7});
        }
        Logger.writeLog("Set Sol configuration: Bit rate (volatile)");
        boolean b5 = true;
        if (this.orgSession.isPeppercon) {
            b5 = this.setSOLConfiguration(new byte[]{1, 4, 7, 100});
            this.setSOLConfiguration(new byte[]{1, 3, 10, 1});
        }
        Logger.writeLog("Set Sol configuration: Character Accumulate Interval & Character Send Threshold(don't do)");
        boolean b6 = true;
        if (!this.orgSession.isPeppercon) {
            b6 = Hardware.is82541NIC(this.orgSession) ? this.setSOLConfiguration(new byte[]{1, 3, 10, 100}) : (Hardware.is82546NIC(this.orgSession) ? this.setSOLConfiguration(new byte[]{1, 3, 10, 90}) : this.setSOLConfiguration(new byte[]{1, 3, 10, 100}));
        }
        return b1 && b2 && b3 && b4 && b5 && b6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSOLConfiguration(byte[] config) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(config);
            this.Message.setText(L.t("sol.Set_SOL_Configuration"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)48, (byte)33, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Set_SOL_Configuration_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.Set_SOL_Configuration_failed"));
                }
            } else {
                this.Message.setText(L.t("sol.Set_SOL_Configuration_failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSOLConfiguration(byte[] config) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] result = null;
        CSession cSession = this.orgSession;
        synchronized (cSession) {
            this.orgSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.orgSession.SessionSeq);
            Para.addElement(this.orgSession.SessionID);
            Para.addElement(config);
            this.rmcpPacket.RMCPSetup((byte)7, (byte)48, (byte)34, (byte)65, Para, this.orgSession, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.orgSession.InboundSessionSeq, rawdata, length[0], true)) {
                this.rmcpPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.rmcpPacket.compeletecode == 0) {
                    this.orgSession.IncreaseSessionSeq();
                    result = (byte[])this.rmcpPacket.retValue.get(0);
                } else {
                    this.Message.setText(L.t("Get_SOL_Configuration_failed"));
                }
            } else {
                this.Message.setText(L.t("Get_SOL_Configuration_failed"));
            }
            this.orgSession.releaselock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activatePayLoad() throws Exception {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] param = new byte[]{1, 1, 0, 0, 0, 0};
        if (this.solSession.IPMIVersion == 2 && this.encryption.isSelected()) {
            param[2] = -64;
        }
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(param);
            this.Message.setText(L.t("sol.Activate_Payload"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)72, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Activate_Payload_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.Activate_Payload_failed"));
                    Logger.writeLog("Activate Payload failed, completion code = " + ByteUtility.byteToHex(this.solRMCPPacket.compeletecode) + "h");
                }
            } else {
                this.Message.setText(L.t("sol.Activate_Payload_failed"));
            }
            this.solSession.releaselock();
        }
        if (this.solRMCPPacket.compeletecode != 0) {
            switch (this.solRMCPPacket.compeletecode) {
                case -128: {
                    throw new Exception(L.t("sol.SOL_already_active_on_another_session"));
                }
                case -127: {
                    throw new Exception(L.t("sol.SOL_is_disabled"));
                }
                case -126: {
                    throw new Exception(L.t("sol.Payload_activation_limit_reached"));
                }
                case -125: {
                    throw new Exception(L.t("sol.Cannot_activate_payload_with_encryption"));
                }
                case -124: {
                    throw new Exception(L.t("sol.Cannot_activate_payload_without_encryption"));
                }
            }
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deactivatePayLoad() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] param = new byte[]{1, 1, 0, 0, 0, 0};
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(param);
            this.Message.setText(L.t("sol.Deactivate_Payload"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)73, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Deactivate_Payload_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.Deactivate_Payload_failed"));
                }
            } else {
                this.Message.setText(L.t("sol.Deactivate_Payload_failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    private void sendZEROToCRService() {
        int localPort = this.solUDPSocket.socket.getLocalPort();
        byte[] b = new byte[]{0};
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        DatagramPacket dp = new DatagramPacket(b, b.length, ia, localPort);
        try {
            this.solUDPSocket.socket.send(dp);
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendDeactivatePayLoad() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        boolean intTemp = false;
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        byte[] param = new byte[]{1, 1, 0, 0, 0, 0};
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(param);
            this.Message.setText(L.t("sol.Deactivate_Payload"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)73, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.Deactivate_Payload_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.Deactivate_Payload_failed"));
                }
            } else {
                this.Message.setText(L.t("sol.Deactivate_Payload_failed"));
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeSession() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(this.solSession.SessionID);
            this.Message.setText(L.t("sol.stop_console_redirection"));
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)60, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    this.Message.setText(L.t("sol.stop_console_redirection_succeeded"));
                    bResult = true;
                } else {
                    this.Message.setText(L.t("sol.stop_console_redirection_failed"));
                }
            } else {
                this.Message.setText("stop console redirection failed");
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSessionChallenge(String sUserID) {
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] AuthType1 = new byte[]{0};
        byte[] UserName = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            this.solSession.SessionID[0] = 0;
            this.solSession.SessionID[1] = 0;
            this.solSession.SessionID[2] = 0;
            this.solSession.SessionID[3] = 0;
            System.arraycopy(sUserID.getBytes(), 0, UserName, 0, sUserID.length());
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            AuthType1[0] = 2;
            Para.addElement(AuthType1);
            Para.addElement(UserName);
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)57, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 0, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(0), 0, this.solSession.SessionID, 0, 4);
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(1), 0, this.solSession.ChallengeStringData, 0, 16);
                    bResult = true;
                }
            }
            this.solSession.releaselock();
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ActivateSession() {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] AuthType1 = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{1, 0, 0, 0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        AuthType[0] = 2;
        AuthType1[0] = 2;
        MaxLevel[0] = this.orgSession.MaxLevel[0];
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(AuthType1);
            Para.addElement(MaxLevel);
            Para.addElement(this.solSession.ChallengeStringData);
            Para.addElement(IniOutbSeq);
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)58, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, 1, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(1), 0, this.solSession.SessionID, 0, 4);
                    this.solSession.IncreaseSessionSeq();
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(3), 0, this.solSession.MaxLevel, 0, 1);
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(4), 0, this.solSession.InboundSessionSeq, 0, 4);
                    retResult = true;
                }
            }
            this.solSession.releaselock();
        }
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSessionInfoPlus(byte[] retData) {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        byte[] reqdata = new byte[]{0, 0, 0, 0, 0};
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bReturn = false;
        reqdata[0] = -1;
        for (int i = 0; i < 4; ++i) {
            reqdata[1 + i] = this.solSession.SessionID[i];
        }
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.removeAllElements();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(reqdata);
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)61, (byte)65, Para, this.solSession, rawdata, length);
            if (this.udpSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0], true)) {
                this.solSession.IncreaseSessionSeq();
                this.solRMCPPacket.ResolvePacket(this.udpSocket.recvBuf, 1, this.udpSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    byte[] xxbyte = (byte[])this.solRMCPPacket.retValue.get(0);
                    System.arraycopy(xxbyte, 0, retData, 0, xxbyte.length);
                    bReturn = true;
                }
            }
            this.solSession.releaselock();
        }
        return bReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean SetSessionPrivilege() {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        MaxLevel[0] = this.orgSession.MaxLevel[0];
        AuthType[0] = 2;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(MaxLevel);
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)59, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacket(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solRMCPPacket.ResolvePacket(this.solUDPSocket.recvBuf, this.solSession.IPMIVersion, this.solUDPSocket.receiveByteLength);
                if (this.solRMCPPacket.compeletecode == 0) {
                    this.solSession.IncreaseSessionSeq();
                    System.arraycopy((byte[])this.solRMCPPacket.retValue.get(0), 0, this.solSession.MaxLevel, 0, 1);
                    retResult = true;
                }
            }
            this.solSession.releaselock();
        }
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepSolSession() {
        boolean retResult = false;
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        byte[] AuthType = new byte[]{0};
        byte[] MaxLevel = new byte[]{4};
        byte[] IniOutbSeq = new byte[]{0};
        byte[] AuthCode = new byte[16];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        MaxLevel = this.solSession.MaxLevel;
        AuthType[0] = 2;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            Para.addElement(MaxLevel);
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)24, (byte)59, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacketNoWait(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solSession.IncreaseSessionSeq();
                retResult = true;
            }
        }
        this.solSession.releaselock();
        return retResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean GetSelInfo() {
        byte[] AuthType = new byte[]{2};
        byte[] rawdata = new byte[256];
        int[] length = new int[1];
        Vector<byte[]> Para = new Vector<byte[]>(1);
        boolean bResult = false;
        CSession cSession = this.solSession;
        synchronized (cSession) {
            this.solSession.lockout();
            Para.addElement(AuthType);
            Para.addElement(this.solSession.SessionSeq);
            Para.addElement(this.solSession.SessionID);
            this.SIP = this.solSession.SIP;
            this.solRMCPPacket.RMCPSetup((byte)7, (byte)40, (byte)64, (byte)65, Para, this.solSession, rawdata, length);
            if (this.solUDPSocket.SendPacketNoWait(this.SIP, 623, this.solSession.InboundSessionSeq, rawdata, length[0])) {
                this.solSession.IncreaseSessionSeq();
                bResult = true;
            }
        }
        this.solSession.releaselock();
        return bResult;
    }

    private boolean SOLLogin() throws Exception {
        boolean bResult = false;
        this.solSession = new CSession();
        this.copy();
        this.solRMCPPacket = RMCPFactory.getInstance().createRMCP(this.solSession);
        this.solPackets = new HashMap();
        this.solPacketsSize = new HashMap();
        this.solUDPSocket = new SOLUDPSocket20();
        this.solUDPSocket.initSession(this.solSession);
        this.lastPktSeq = 0;
        if (IPMIView20.getInstance().isProxyEnabled) {
            this.Message.setText("Initialize connection to Proxy ...");
            boolean result = this.initialSOLProxyConnection();
            this.Message.setText("Initialize connection to Proxy finished");
            if (!result) {
                IPMIView20.getInstance().isProxyEnabled = false;
                this.Message.setText("Initialize connection to Proxy failed");
            }
        }
        if (this.solSession.IPMIVersion == 2) {
            CipherSuite cs = new CipherSuite();
            if (this.encryption.isSelected()) {
                cs.setAuthenticationAlgorithm((byte)1);
                cs.setIntegrityAlgorithm((byte)1);
                cs.setConfidentialityAlgorithm((byte)1);
            } else {
                cs.setAuthenticationAlgorithm((byte)1);
                cs.setIntegrityAlgorithm((byte)0);
                cs.setConfidentialityAlgorithm((byte)0);
            }
            this.solSession.cipherSuite = cs;
            UDPSocket aUDPSocket = new UDPSocket(4, 2);
            aUDPSocket.socket = this.solUDPSocket.socket;
            RAKPTalker rakpTalker = new RAKPTalker(this.solSession, aUDPSocket);
            if (rakpTalker.openSession(this.solSession.userID, this.solSession.UserPassword, this.Message, this.solSession.MaxLevel[0])) {
                Logger.writeLog("RAKP Message ok");
                if (this.SetSessionPrivilege()) {
                    Logger.writeLog("SetSessionPrivilege ok");
                    if (this.setSOLConfiguration()) {
                        Logger.writeLog("Set SOL Configuration ok");
                        if (this.activatePayLoad()) {
                            Logger.writeLog("ActivatePayLoad ok");
                            this.Message.setText(L.t("sol.Activate_Payload_succeeded"));
                            bResult = true;
                        } else {
                            this.Message.setText(L.t("sol.Activate_Payload_failed"));
                        }
                    } else {
                        this.closeSession();
                    }
                } else {
                    this.Message.setText(L.t("sol.Activate_Payload_Failed"));
                    this.closeSession();
                }
            }
        } else if (this.solSession.IPMIVersion == 1 && this.GetSessionChallenge(this.solSession.userID)) {
            Logger.writeLog("GetSessionChallenge");
            if (this.ActivateSession()) {
                Logger.writeLog("ActivateSession");
                if (this.SetSessionPrivilege()) {
                    Logger.writeLog("SetSessionPrivilege");
                    if (this.activatePayLoad()) {
                        Logger.writeLog("activatePayLoad");
                        this.Message.setText(L.t("sol.Activate_Payload_Successful"));
                        bResult = true;
                    } else {
                        this.closeSession();
                    }
                }
            }
        }
        if (!bResult) {
            return false;
        }
        TimerTask t = new TimerTask(){
            int count = 0;

            public void run() {
                if (!SOL20.this.solSession.inUse) {
                    GlobalDefine cfr_ignored_0 = SOL20.this.gd;
                    if (SOL20.this.solSession.IPMIVersion == 1) {
                        Logger.writeLog("SOL Keep Session");
                        SOL20.this.keepSolSession();
                    } else {
                        GlobalDefine cfr_ignored_1 = SOL20.this.gd;
                        if (SOL20.this.solSession.IPMIVersion == 2) {
                            Logger.writeLog("SOL Keep Session (RMCP+)");
                            SOL20.this.GetSelInfo();
                        }
                    }
                }
            }
        };
        this.timer = new Timer();
        this.timer.schedule(t, 0L, 30000L);
        return bResult;
    }

    private void copy() {
        this.solSession.SessionActivated = true;
        this.solSession.SIP = this.orgSession.SIP;
        this.solSession.MaxLevel = this.orgSession.MaxLevel;
        this.solSession.userID = this.orgSession.userID;
        this.solSession.PasswordLength = this.orgSession.PasswordLength;
        this.solSession.UserPassword = this.orgSession.UserPassword;
        this.solSession.IPMIVersion = this.orgSession.IPMIVersion;
        this.solSession.cipherSuite = this.orgSession.cipherSuite;
        this.solSession.isPeppercon = this.orgSession.isPeppercon;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.TestButton = new JButton();
        this.Start = new JButton();
        this.Stop = new JButton();
        this.Refresh = new JButton();
        this.encryption = new JCheckBox(L.t("sol.RMCP_PLUS_Encryption"));
        this.utf8 = new JCheckBox("UTF-8");
        this.utf8.addActionListener(new UTF8_CheckBox_actionAdapter(this));
        this.baudRateLabel = new JLabel("  " + L.t("sol.Baud_Rate") + ":");
        this.baudRate = new JComboBox();
        this.jPanel2 = new JPanel();
        this.Console = new JTextPane();
        this.setLayout(new BorderLayout());
        this.TestButton.setText("TestButton");
        this.TestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SOL20.this.TestButtonActionPerformed(evt);
            }
        });
        this.Start.setText(L.t("sol.Start"));
        this.Start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SOL20.this.StartActionPerformed(evt);
            }
        });
        this.Stop.setText(L.t("sol.Stop"));
        this.Stop.setEnabled(false);
        this.Stop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SOL20.this.StopActionPerformed(evt);
            }
        });
        this.Refresh.setText("Refresh Screen");
        this.Refresh.setEnabled(false);
        this.Refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SOL20.this.RefreshActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.baudRateLabel);
        this.jPanel1.add(this.baudRate);
        this.jPanel1.add(this.utf8);
        this.jPanel1.add(this.encryption);
        this.jPanel1.add(this.Start);
        this.jPanel1.add(this.Stop);
        this.add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new AbsoluteLayout());
        this.jPanel2.setBorder(new BevelBorder(1));
        this.Console.setBackground(new Color(0, 0, 0));
        this.Console.setBorder(new EtchedBorder());
        this.Console.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                SOL20.this.ConsoleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                SOL20.this.ConsoleKeyReleased(evt);
            }

            public void keyTyped(KeyEvent evt) {
                SOL20.this.ConsoleKeyTyped(evt);
            }
        });
        this.jPanel2.add((Component)this.Console, new AbsoluteConstraints(5, 5, -1, -1));
        this.add((Component)this.jPanel2, "Center");
        this.baudRate.addItem("9600");
        this.baudRate.addItem("19200");
        this.baudRate.addItem("38400");
        this.baudRate.addItem("57600");
        this.baudRate.addItem("115200");
    }

    private void ConsoleKeyTyped(KeyEvent evt) {
        if (this.keyPressed) {
            this.keyPressed = false;
            return;
        }
        evt.consume();
        this.storage.put((byte)evt.getKeyChar());
    }

    private void ConsoleKeyReleased(KeyEvent evt) {
        this.keyPressed = false;
    }

    private void ConsoleKeyPressed(KeyEvent evt) {
        byte[] keycode = (byte[])this.javaKeyCodeToSOLKeyCode.get("" + evt.getKeyCode());
        if (keycode != null) {
            this.storage.puts(keycode);
            evt.consume();
            this.keyPressed = true;
            return;
        }
        evt.consume();
    }

    private void StopActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                SOL20.this.stopSOL();
            }
        };
        t.start();
    }

    private void RefreshActionPerformed(ActionEvent evt) {
        this.VTHandle.InvalidateRect();
    }

    public void stopSOL() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.orgSession.SIP);
        config.setUserName(this.orgSession.userID);
        config.setPassword(new String(this.orgSession.UserPassword));
        config.setRetry(0);
        com.supermicro.ipmi.RMCP rmcp = new com.supermicro.ipmi.RMCP();
        rmcp.initialize(config);
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(rmcp);
        if (ipmiMessagingCommand.GetChannelAuthenticationCapabilitiesCommand() == null) {
            this.Console.setVisible(false);
            this.Console.requestFocus();
            this.Start.setEnabled(true);
            if (!this.orgSession.isPeppercon) {
                this.encryption.setEnabled(true);
            }
            this.Stop.setEnabled(false);
            this.Refresh.setEnabled(false);
            this.solPacketSender.stopSend();
            this.timer.cancel();
            this.timer = null;
            this.TCRunning = false;
            return;
        }
        this.sendZEROToCRService();
        this.sendDeactivatePayLoad();
        if (this.orgSession.isPeppercon) {
            this.setSOLConfiguration(new byte[]{1, 3, 10, 80});
        }
        this.closeSession();
        this.Console.setVisible(false);
        this.Console.requestFocus();
        this.Start.setEnabled(true);
        if (!this.orgSession.isPeppercon) {
            this.encryption.setEnabled(true);
        }
        this.Stop.setEnabled(false);
        this.Refresh.setEnabled(false);
        this.solPacketSender.stopSend();
        this.timer.cancel();
        this.timer = null;
        this.TCRunning = false;
        if (IPMIView20.getInstance().isProxyEnabled) {
            this.closeSOLProxyConnection();
        }
        if (this.orgSession.isPeppercon) {
            this.encryption.setEnabled(false);
        }
        this.Message.setText(L.t("sol.stop_console_redirection_successfully"));
    }

    public boolean isSOLRunning() {
        return this.TCRunning;
    }

    private void TestButtonActionPerformed(ActionEvent evt) {
        for (int i = 0; i < 25; ++i) {
            System.out.println(new String(this.VTHandle.ScreenMap[i]));
        }
    }

    private void StartActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            public void run() {
                SOL20.this.startSOL();
            }
        };
        t.start();
    }

    public void startSOL() throws HeadlessException {
        byte bytex = this.GetACPIPowerState();
        bytex = 0;
        if (bytex == 0 || bytex == 1 || bytex == 32) {
            Cursor csrTemp = new Cursor(3);
            boolean solLoginResult = false;
            try {
                solLoginResult = this.SOLLogin();
            }
            catch (Exception ex) {
                String message;
                if (!this.solSession.isPeppercon) {
                    this.closeSession();
                }
                if ((message = ex.getMessage()) == null) {
                    message = "unknown error";
                }
                JOptionPane.showMessageDialog(IPMIView20.getInstance(), message);
                return;
            }
            if (!solLoginResult) {
                Logger.writeLog(L.t("sol.Cannot_start_SOL_The_session_of_Text_Console_may_not_be_closed_properly_Please_wait_two_minutes_then_start_SOL_again"));
                return;
            }
            Logger.writeLog(L.t("sol.SOL_Login_Successful"));
            this.VTHandle = new VT100(this.Console, this);
            this.CRDeamon = new CRService(this.solUDPSocket);
            this.CRDeamon.start();
            this.Start.setEnabled(false);
            this.encryption.setEnabled(false);
            this.Stop.setEnabled(true);
            this.Refresh.setEnabled(true);
            this.Console.setVisible(true);
            this.TCRunning = true;
            csrTemp = new Cursor(0);
            this.setCursor(csrTemp);
            this.Console.requestFocus();
            this.storage = new Storage();
            this.solPacketSender = new SOLPacketSender(this, this.storage);
            this.solPacketSender.start();
        } else {
            JOptionPane.showMessageDialog(IPMIView20.getInstance(), L.t("sol.Console_redirection_cannot_start_due_to_that_the_managed_server_may_be_turned_off_now"));
        }
        this.UTF8_CheckBox_actionPerformed(null);
    }

    private int ByteToInt(byte[] bytesrc, int offset, int length) {
        int intdes = 0;
        for (int i = offset + length - 1; i >= offset; --i) {
            intdes = (intdes << 8) + (bytesrc[i] & 0xFF);
        }
        return intdes;
    }

    private void IntToByte(byte[] bytedest, int offset, int intsrc) {
        bytedest[offset + 0] = (byte)intsrc;
        bytedest[offset + 1] = (byte)(intsrc >> 8);
        bytedest[offset + 2] = (byte)(intsrc >> 16);
        bytedest[offset + 3] = (byte)(intsrc >> 24);
    }

    private byte[] KeyTranslate(int KeyCode, char KeyChar) {
        byte[] newcode = new byte[2];
        switch (KeyCode) {
            case 112: {
                newcode[0] = -66;
                newcode[1] = -1;
                break;
            }
            case 113: {
                newcode[0] = -65;
                newcode[1] = -1;
                break;
            }
            case 114: {
                newcode[0] = -64;
                newcode[1] = -1;
                break;
            }
            case 115: {
                newcode[0] = -63;
                newcode[1] = -1;
                break;
            }
            case 116: {
                newcode[0] = -62;
                newcode[1] = -1;
                break;
            }
            case 117: {
                newcode[0] = -61;
                newcode[1] = -1;
                break;
            }
            case 118: {
                newcode[0] = -60;
                newcode[1] = -1;
                break;
            }
            case 119: {
                newcode[0] = -59;
                newcode[1] = -1;
                break;
            }
            case 120: {
                newcode[0] = -58;
                newcode[1] = -1;
                break;
            }
            case 121: {
                newcode[0] = -57;
                newcode[1] = -1;
                break;
            }
            case 122: {
                newcode[0] = -56;
                newcode[1] = -1;
                break;
            }
            case 123: {
                newcode[0] = -55;
                newcode[1] = -1;
                break;
            }
            case 8: {
                newcode[0] = 8;
                newcode[1] = -1;
                break;
            }
            case 9: {
                newcode[0] = 9;
                newcode[1] = -1;
                break;
            }
            case 10: {
                newcode[0] = 13;
                newcode[1] = -1;
                break;
            }
            case 19: {
                newcode[0] = 19;
                newcode[1] = -1;
                break;
            }
            case 145: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 27: {
                newcode[0] = 27;
                newcode[1] = -1;
                break;
            }
            case 155: {
                newcode[0] = 99;
                newcode[1] = -1;
                break;
            }
            case 36: {
                newcode[0] = 80;
                newcode[1] = -1;
                break;
            }
            case 37: {
                newcode[0] = 81;
                newcode[1] = -1;
                break;
            }
            case 38: {
                newcode[0] = 82;
                newcode[1] = -1;
                break;
            }
            case 39: {
                newcode[0] = 83;
                newcode[1] = -1;
                break;
            }
            case 40: {
                newcode[0] = 84;
                newcode[1] = -1;
                break;
            }
            case 33: {
                newcode[0] = 85;
                newcode[1] = -1;
                break;
            }
            case 34: {
                newcode[0] = 86;
                newcode[1] = -1;
                break;
            }
            case 35: {
                newcode[0] = 87;
                newcode[1] = -1;
                break;
            }
            case 20: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 144: {
                newcode[0] = 0;
                newcode[1] = 0;
                break;
            }
            case 127: {
                newcode[0] = -1;
                newcode[1] = -1;
                break;
            }
            case 18: {
                newcode[0] = -23;
                newcode[1] = -1;
                break;
            }
            case 16: {
                newcode[0] = -31;
                newcode[1] = -1;
                break;
            }
            case 17: {
                newcode[0] = -29;
                newcode[1] = -1;
                break;
            }
            case 96: {
                newcode[0] = -80;
                newcode[1] = -1;
                break;
            }
            case 97: {
                newcode[0] = -79;
                newcode[1] = -1;
                break;
            }
            case 98: {
                newcode[0] = -78;
                newcode[1] = -1;
                break;
            }
            case 99: {
                newcode[0] = -77;
                newcode[1] = -1;
                break;
            }
            case 100: {
                newcode[0] = -76;
                newcode[1] = -1;
                break;
            }
            case 101: {
                newcode[0] = -75;
                newcode[1] = -1;
                break;
            }
            case 102: {
                newcode[0] = -74;
                newcode[1] = -1;
                break;
            }
            case 103: {
                newcode[0] = -73;
                newcode[1] = -1;
                break;
            }
            case 104: {
                newcode[0] = -72;
                newcode[1] = -1;
                break;
            }
            case 105: {
                newcode[0] = -71;
                newcode[1] = -1;
                break;
            }
            case 106: {
                newcode[0] = -86;
                newcode[1] = -1;
                break;
            }
            case 107: {
                newcode[0] = -85;
                newcode[1] = -1;
                break;
            }
            case 109: {
                newcode[0] = -83;
                newcode[1] = -1;
                break;
            }
            case 110: {
                newcode[0] = -82;
                newcode[1] = -1;
                break;
            }
            case 111: {
                newcode[0] = -81;
                newcode[1] = -1;
                break;
            }
            case 192: {
                newcode[0] = 96;
                newcode[1] = 0;
                break;
            }
            default: {
                newcode[0] = (byte)(KeyChar & 0xFF);
                newcode[1] = 0;
                int keyx = KeyChar & 0xFF;
                if (keyx < 1 || keyx > 26) break;
                newcode[0] = (byte)(keyx | 0x40);
            }
        }
        return newcode;
    }

    public void requestFocusForConsole() {
        if (this.VTHandle != null) {
            this.VTHandle.Console.requestFocus();
        }
    }

    private boolean initialSOLProxyConnection() {
        String temp;
        String proxyIP = IPMIView20.getInstance().proxyIP;
        int proxyPort = IPMIView20.getInstance().proxyPort;
        String command = "1," + this.SIP + "," + 623;
        byte[] result = this.udpSocket.sendData(proxyIP, proxyPort, command.getBytes());
        return result != null && (temp = new String(result)).equals("0");
    }

    private boolean closeSOLProxyConnection() {
        String proxyIP = IPMIView20.getInstance().proxyIP;
        int proxyPort = IPMIView20.getInstance().proxyPort;
        String command = "0";
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(proxyIP);
        }
        catch (UnknownHostException ex) {
            ex.toString();
            return false;
        }
        DatagramPacket dp = new DatagramPacket(command.getBytes(), command.getBytes().length, ia, proxyPort);
        try {
            this.solUDPSocket.socket.send(dp);
        }
        catch (IOException ex1) {
            ex1.toString();
            return false;
        }
        return true;
    }

    public void UTF8_CheckBox_actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SOL20.this.helpUTF8_CheckBox();
            }
        });
    }

    private void helpUTF8_CheckBox() {
        Font messageFont = null;
        if (this.VTHandle == null) {
            return;
        }
        if (this.utf8.isSelected()) {
            if (this.utf8Font == null) {
                Vector fontCollected = this.testDisplayUTF8Font();
                this.utf8Font = (Font)fontCollected.get(0);
                this.utf8Font = new Font(this.utf8Font.getFontName(), 0, 14);
                if (fontCollected.size() > 1) {
                    this.helpAddFont(fontCollected);
                }
            }
            if (this.utf8Font == null) {
                this.utf8Font = new Font("SimSun", 0, 14);
            }
            messageFont = this.utf8Font;
            this.VTHandle.setEnableUTF8(true);
            if (this.fontComboBox != null) {
                this.fontComboBox.setEnabled(true);
            }
        } else {
            messageFont = new Font("Courier New", 0, 12);
            FontMetrics fm = this.getFontMetrics(messageFont);
            if (fm.charWidth('i') != fm.charWidth('W')) {
                messageFont = new Font("Courier", 0, 12);
            }
            this.VTHandle.setEnableUTF8(false);
            if (this.fontComboBox != null) {
                this.fontComboBox.setEnabled(false);
            }
        }
        this.Console.setFont(messageFont);
        this.VTHandle.InvalidateRect();
        this.requestFocusForConsole();
    }

    public void helpAddFont(Vector fontCollected) {
        this.fontComboBox = new JComboBox();
        Iterator iter = fontCollected.iterator();
        while (iter.hasNext()) {
            Font item = (Font)iter.next();
            this.fontComboBox.addItem(item.getFontName());
        }
        this.fontComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String fontString = (String)(this).SOL20.this.fontComboBox.getSelectedItem();
                        (this).SOL20.this.utf8Font = new Font(fontString, 0, 14);
                        SOL20.this.Console.setFont((this).SOL20.this.utf8Font);
                        (this).SOL20.this.VTHandle.InvalidateRect();
                    }
                });
            }
        });
        Vector<Component> controls = new Vector<Component>();
        for (int i = 0; i < this.jPanel1.getComponentCount(); ++i) {
            controls.add(this.jPanel1.getComponent(i));
        }
        controls.insertElementAt(this.fontComboBox, 3);
        this.jPanel1.removeAll();
        Iterator iter2 = controls.iterator();
        while (iter2.hasNext()) {
            Component item = (Component)iter2.next();
            this.jPanel1.add(item);
        }
    }

    public Vector testDisplayUTF8Font() {
        Vector<Font> fontCollected = new Vector<Font>();
        String sample = "\u4e2d\u6587\u4e00\u5207\u6b63\u5e38\u55ce\u529f\u8a31\u6e2c\u8a66\u3057\u307e\u3057\u305f";
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int q = 0;
        this.setCursor(new Cursor(3));
        for (int j = 0; j < fonts.length; ++j) {
            q = fonts[j].canDisplayUpTo(sample);
            if (q != -1 && q != sample.length()) continue;
            fontCollected.add(fonts[j]);
        }
        this.setCursor(new Cursor(0));
        return fontCollected;
    }

    private class CRService
    extends Thread {
        protected DatagramSocket socket = null;
        protected BufferedReader in = null;
        protected boolean moreQuotes = true;
        int solPacketCountAfterReboot = 0;
        int repeatCount = 0;
        int myCount = 0;
        byte[] lastScreenData = null;

        public CRService(SOLUDPSocket20 udpSocket) {
            this.socket = udpSocket.socket;
        }

        public void run() {
            byte[] bufin = new byte[4096];
            byte[] bufx = new byte[4096];
            byte[] bufout = new byte[4096];
            try {
                this.socket.setSoTimeout(0);
            }
            catch (SocketException ex) {
                // empty catch block
            }
            while (this.moreQuotes) {
                try {
                    DatagramPacket packet = new DatagramPacket(bufin, bufin.length);
                    this.socket.receive(packet);
                    if (packet.getLength() == 1 && packet.getData()[0] == 0) break;
                    switch (SOL20.this.solSession.IPMIVersion) {
                        case 1: {
                            this.resolveSOLPacket(packet);
                            break;
                        }
                        case 2: {
                            this.resolveSOLPacketForRMCPPlus(packet);
                        }
                    }
                    this.checkFirstSOLPacketAfterReboot();
                }
                catch (IOException e) {
                    SOL20.this.Message.setText(L.t("sol.SOL_Time_out"));
                    Logger.writeLog("SOL Time out");
                    Logger.writeLog(e.toString());
                    if (!SOL20.this.TCRunning) continue;
                    SOL20.this.deactivatePayLoad();
                    SOL20.this.closeSession();
                    SOL20.this.CRDeamon.stopCR();
                    SOL20.this.Start.setEnabled(true);
                    if (!SOL20.this.orgSession.isPeppercon) {
                        SOL20.this.encryption.setEnabled(true);
                    }
                    SOL20.this.Stop.setEnabled(false);
                    SOL20.this.Refresh.setEnabled(false);
                    SOL20.this.TCRunning = false;
                    this.socket.close();
                    SOL20.this.Message.setText(L.t("sol.stop_console_redirection_successfully"));
                    break;
                }
            }
            Logger.writeLog("-------------------- exit SOL Receive LOOP -----------------");
        }

        private void checkFirstSOLPacketAfterReboot() {
            if (!SOL20.this.Start.isEnabled() && !SOL20.this.Stop.isEnabled()) {
                ++this.solPacketCountAfterReboot;
                if (this.solPacketCountAfterReboot == 20) {
                    SOL20.this.Stop.setEnabled(true);
                    SOL20.this.bootingDisable = false;
                    this.solPacketCountAfterReboot = 0;
                    SOL20.this.storage.allowGet();
                }
            } else {
                this.solPacketCountAfterReboot = 0;
            }
        }

        public void stopCR() {
            this.moreQuotes = false;
        }

        private void resolveSOLPacketForRMCPPlus(DatagramPacket packet) {
            byte[] data = null;
            data = ((RMCPPlus)SOL20.this.solRMCPPacket).ResolvePacketToOriginal(packet.getData(), 0, packet.getLength());
            if (data == null) {
                System.out.println("data = null, it due to can't decript");
                return;
            }
            if (data[4] == 6 && (data[5] & 0x3F) == 0) {
                byte command = data[21];
                if (command == 73) {
                    this.stopCR();
                }
                if (command == 64) {
                    // empty if block
                }
                return;
            }
            byte pktSeq = data[16];
            if (pktSeq == 0) {
                byte fromSeq = data[17];
                if (SOL20.this.solPackets.containsKey(new Byte(fromSeq))) {
                    SOL20.this.solPackets.remove(new Byte(fromSeq));
                    SOL20.this.solPacketsSize.remove(new Byte(fromSeq));
                    SOL20.this.storage.allowGet();
                }
                String packetSeqs = "";
                if (SOL20.this.solPackets.size() > 0) {
                    Iterator iter = SOL20.this.solPackets.keySet().iterator();
                    while (iter.hasNext()) {
                        Object item = iter.next();
                        packetSeqs = packetSeqs + item.toString() + ",";
                    }
                }
            } else {
                byte pktLength = data[14];
                int intPktLength = pktLength & 0xFF;
                if (pktSeq == SOL20.this.lastPktSeq) {
                    this.screenDataAck(pktSeq, (byte)(intPktLength - 4));
                    byte[] repeatScreenData = new byte[intPktLength - 4];
                    System.arraycopy(data, 20, repeatScreenData, 0, repeatScreenData.length);
                    byte[] appendedScreenData = new byte[repeatScreenData.length - this.lastScreenData.length];
                    System.arraycopy(repeatScreenData, this.lastScreenData.length, appendedScreenData, 0, appendedScreenData.length);
                    SOL20.this.VTHandle.VTe_InParse(appendedScreenData, appendedScreenData.length);
                    return;
                }
                this.myCount = 0;
                if (intPktLength - 4 < 0) {
                    Logger.writeLog("pktLength error =" + (intPktLength - 4));
                    return;
                }
                byte[] screenData = new byte[intPktLength - 4];
                System.arraycopy(data, 20, screenData, 0, screenData.length);
                this.screenDataAck(pktSeq, (byte)(intPktLength - 4));
                if (SOL20.this.VTHandle == null) {
                    Logger.writeLog("VTHandle is null");
                }
                if (screenData == null) {
                    Logger.writeLog("ScreenData is null");
                }
                SOL20.this.VTHandle.VTe_InParse(screenData, screenData.length);
                SOL20.this.lastPktSeq = pktSeq;
                this.lastScreenData = screenData;
            }
        }

        private boolean checkContinueSeq(byte pktSeq, byte lastPktSeq) {
            if (pktSeq == 1) {
                pktSeq = (byte)16;
            }
            return pktSeq - lastPktSeq == 1;
        }

        private void resolveSOLPacket(DatagramPacket packet) {
            byte[] data = null;
            data = packet.getData();
            if ((data[4] & 0x80) == 0) {
                byte command = data[35];
                Logger.writeLog("Receive Command =" + Integer.toHexString(command));
                if (command == 73 || command == 60) {
                    this.stopCR();
                }
                return;
            }
            byte pktSeq = data[14];
            if (pktSeq == 0) {
                byte fromSeq = data[15];
                byte length = data[16];
                SOL20.this.solPackets.remove(new Byte(fromSeq));
                SOL20.this.solPacketsSize.remove(new Byte(fromSeq));
                SOL20.this.storage.allowGet();
                String packetSeqs = "";
                if (SOL20.this.solPackets.size() > 0) {
                    Iterator iter = SOL20.this.solPackets.keySet().iterator();
                    while (iter.hasNext()) {
                        Object item = iter.next();
                        packetSeqs = packetSeqs + item.toString() + ",";
                    }
                }
                Logger.writeLog("ACK. solPackets size =" + SOL20.this.solPackets.size() + "(" + packetSeqs + ")" + ",ack Seq = " + fromSeq);
            } else {
                byte pktLength = data[13];
                int intPktLength = pktLength & 0xFF;
                if (pktSeq == SOL20.this.lastPktSeq) {
                    this.screenDataAck(pktSeq, (byte)(intPktLength - 4));
                    return;
                }
                SOL20.this.lastPktSeq = pktSeq;
                if (intPktLength - 4 < 0) {
                    Logger.writeLog("pktLength error =" + (intPktLength - 4));
                    return;
                }
                byte[] screenData = new byte[intPktLength - 4];
                System.arraycopy(data, 18, screenData, 0, screenData.length);
                this.screenDataAck(pktSeq, (byte)(intPktLength - 4));
                if (SOL20.this.VTHandle == null) {
                    Logger.writeLog("VTHandle is null");
                }
                if (screenData == null) {
                    Logger.writeLog("ScreenData is null");
                }
                SOL20.this.VTHandle.VTe_InParse(screenData, screenData.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean screenDataAck(byte seq, byte screenDataLength) {
            byte[] AuthType = new byte[]{-126};
            byte[] rawdata = new byte[256];
            int[] length = new int[1];
            Vector<byte[]> Para = new Vector<byte[]>(1);
            Vector<byte[]> solPara = new Vector<byte[]>(1);
            boolean bResult = false;
            if (!SOL20.this.TCRunning) {
                return false;
            }
            SOL20.this.SIP = SOL20.this.solSession.SIP;
            CSession cSession = SOL20.this.solSession;
            synchronized (cSession) {
                SOL20.this.solSession.lockout();
                Para.addElement(AuthType);
                Para.addElement(SOL20.this.solSession.SessionSeq);
                Para.addElement(SOL20.this.solSession.SessionID);
                byte[] pAck = new byte[1];
                byte[] pSeq = new byte[1];
                byte[] pScreenDataLength = new byte[1];
                byte[] status = new byte[1];
                byte[] data = new byte[]{};
                pAck[0] = 0;
                pSeq[0] = seq;
                pScreenDataLength[0] = screenDataLength;
                status[0] = 0;
                solPara.addElement(pAck);
                solPara.addElement(pSeq);
                solPara.addElement(pScreenDataLength);
                solPara.addElement(status);
                solPara.addElement(data);
                SOL20.this.solRMCPPacket.RMCPSOLSetup(Para, solPara, SOL20.this.solSession, rawdata, length);
                if (SOL20.this.solUDPSocket.SendPacketNoWait(SOL20.this.SIP, 623, SOL20.this.solSession.InboundSessionSeq, rawdata, length[0])) {
                    SOL20.this.solSession.IncreaseSessionSeq();
                } else {
                    SOL20.this.Message.setText(L.t("sol.Response_acknowledge_Failed"));
                }
                SOL20.this.solSession.releaselock();
            }
            return bResult;
        }
    }
}

