/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.WatchDog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

class SplashWindow
extends Window {
    String msg1;
    int width = 400;
    int height = 30;
    WatchDog watchDog;

    public SplashWindow(Frame parent, JComponent comp, String msg1) {
        super(parent);
        this.setSize(this.width, this.height);
        this.msg1 = msg1;
        this.watchDog = new WatchDog(this, 10);
        this.watchDog.start();
        Dimension screenDim = comp.getSize();
        Rectangle winDim = comp.getVisibleRect();
        this.setLocation((screenDim.width - winDim.width) / 2, (screenDim.height - winDim.height) / 2);
        this.setVisible(true);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SplashWindow.this.hide();
            }
        });
    }

    public void setMessage(String msg1) {
        this.msg1 = msg1;
    }

    public void setWatchDogTime(int time) {
        this.watchDog.reset();
        this.watchDog.setcountLimit(time);
    }

    public void paint(Graphics g) {
        g.setColor(new Color(204, 204, 255));
        g.fillRect(0, 0, this.width, this.height);
        g.setColor(Color.lightGray);
        g.drawLine(0, 0, this.width - 1, 0);
        g.drawLine(0, 0, 0, this.height - 1);
        g.setColor(Color.GRAY);
        g.drawLine(this.width - 1, this.height - 1, this.width - 1, 0);
        g.drawLine(this.width - 1, this.height - 1, 0, this.height - 1);
        g.setFont(Font.getFont("Arrial"));
        g.setColor(Color.black);
        g.drawString(this.msg1, 70, 20);
    }
}

