/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

import IPMIView20.DeviceStatus;
import IPMIView20.IPMIView20;
import IPMIView20.L;
import IPMIView20.SystemPropertiesPanel_jButton1_actionAdapter;
import IPMIView20.SystemPropertiesPanel_jGCButton_actionAdapter;
import IPMIView20.SystemPropertiesPanel_jTable_mouseAdapter;
import IPMIView20.group.TableSorter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class SystemPropertiesPanel
extends JPanel {
    public static final int TYPE_SYSTEM_PROPERTIES = 1;
    public static final int TYPE_ENVIRONMENT_VARIABLES = 2;
    public static final int TYPE_RUN_TIME = 3;
    TableSorter ts;
    DefaultTableModel dtm;
    int currentType = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable = new JTable();
    JPanel jSouthPanel = new JPanel();
    JPanel jNorthPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel jTimeElaspedLabel = new JLabel();
    JLabel jLabel1 = new JLabel();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton jRefreshButton = new JButton();
    JButton jGCButton = new JButton();

    public SystemPropertiesPanel() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jSouthPanel.setLayout(this.borderLayout2);
        this.jTimeElaspedLabel.setText("Time elapsed:");
        this.jLabel1.setFont(new Font("\u65b0\u7d30\u660e\u9ad4", 1, 12));
        this.jNorthPanel.setLayout(this.borderLayout3);
        this.jRefreshButton.setText(L.t("systemProperties.Refresh"));
        this.jRefreshButton.addActionListener(new SystemPropertiesPanel_jButton1_actionAdapter(this));
        this.jTable.addMouseListener(new SystemPropertiesPanel_jTable_mouseAdapter(this));
        this.jGCButton.setText("GC");
        this.jGCButton.addActionListener(new SystemPropertiesPanel_jGCButton_actionAdapter(this));
        this.add((Component)this.jSouthPanel, "South");
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jSouthPanel.add((Component)this.jTimeElaspedLabel, "East");
        this.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jNorthPanel, "North");
        this.jNorthPanel.add((Component)this.jLabel1, "Center");
        this.jNorthPanel.add((Component)this.jRefreshButton, "East");
        this.jNorthPanel.add((Component)this.jGCButton, "West");
        this.jTimeElaspedLabel.setVisible(false);
    }

    public void getSystemProperties() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
        Properties properties = System.getProperties();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            String value = properties.getProperty(key.toString());
            ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{key, value});
        }
        this.ts.setTableHeader(this.jTable.getTableHeader());
        this.currentType = 1;
    }

    public void getEnv() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
        String version = System.getProperty("java.vm.version");
        if (version.indexOf("1.5") == -1) {
            return;
        }
        Map<String, String> m = System.getenv();
        Iterator<String> iter = m.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            String value = m.get(key);
            ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{key, value});
        }
        this.ts.setTableHeader(this.jTable.getTableHeader());
        this.currentType = 2;
    }

    public void getRunTime() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.ts.getTableModel();
        Object[] objectArray = new Object[2];
        objectArray[0] = L.t("systemProperties.Version");
        StringBuffer stringBuffer = new StringBuffer().append("");
        IPMIView20.getInstance();
        objectArray[1] = stringBuffer.append(IPMIView20.BuildVersion).toString();
        defaultTableModel.addRow(objectArray);
        DefaultTableModel defaultTableModel2 = (DefaultTableModel)this.ts.getTableModel();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = L.t("systemProperties.Build");
        StringBuffer stringBuffer2 = new StringBuffer().append("");
        IPMIView20.getInstance();
        objectArray2[1] = stringBuffer2.append(IPMIView20.BuildSeq).toString();
        defaultTableModel2.addRow(objectArray2);
        int deviceOnCount = 0;
        int deviceOffCount = 0;
        int kvmDeviceCount = 0;
        Vector devices = IPMIView20.getInstance().xDeviceFile.getDeviceVector(null);
        Iterator iter = devices.iterator();
        while (iter.hasNext()) {
            Object device = iter.next();
            String ip = IPMIView20.getInstance().xDeviceFile.hostnameToIP(device.toString());
            DeviceStatus.DeviceInfo dd = (DeviceStatus.DeviceInfo)IPMIView20.getInstance().deviceStatus.device.get(ip);
            if (dd.isOn) {
                ++deviceOnCount;
            } else {
                ++deviceOffCount;
            }
            if (dd.deviceType != 2) continue;
            ++kvmDeviceCount;
        }
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Number_of_Device_On"), "" + deviceOnCount});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Number_of_Device_Off"), "" + deviceOffCount});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Number_of_KVM_Device"), "" + kvmDeviceCount});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("Socket time out (sec)"), "" + IPMIView20.getInstance().socketTimeout});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("Number of retry packet"), "" + IPMIView20.getInstance().retryTime});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Number_of_KVM_Device"), "" + kvmDeviceCount});
        int sessionCount = 0;
        int i = 0;
        while (true) {
            IPMIView20.getInstance();
            if (i >= IPMIView20.sessionarray.length) break;
            IPMIView20.getInstance();
            if (IPMIView20.sessionarray[i] != null) {
                ++sessionCount;
            }
            ++i;
        }
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Session_Opened"), "" + sessionCount});
        SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Available_Processors"), "" + Runtime.getRuntime().availableProcessors()});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Used_Memory"), "" + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + "K"});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Free_Memory"), "" + Runtime.getRuntime().freeMemory() / 1024L + "K"});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Total_Memory"), "" + Runtime.getRuntime().totalMemory() / 1024L + "K"});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Max_Memory"), "" + Runtime.getRuntime().maxMemory() / 1024L + "K"});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Max_Available_Memory"), "" + (Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) / 1024L + "K"});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.IPMIView_Start_Time"), "" + f.format(IPMIView20.getInstance().startTime.getTime())});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Current_Time"), "" + f.format(Calendar.getInstance().getTime())});
        ((DefaultTableModel)this.ts.getTableModel()).addRow(new Object[]{L.t("systemProperties.Time_Elapsed"), this.getTimeDiff()});
        this.ts.setTableHeader(this.jTable.getTableHeader());
        this.currentType = 3;
    }

    public static String timeDiff(Calendar c1, Calendar c2) {
        long diffMillis = c2.getTimeInMillis() - c1.getTimeInMillis();
        long diffSecs = diffMillis / 1000L;
        long diffMins = diffMillis / 60000L;
        long diffHours = diffMillis / 3600000L;
        long diffDays = diffMillis / 86400000L;
        long leafHours = diffMillis % 86400000L / 3600000L;
        long leafMins = diffMillis % 86400000L % 3600000L / 60000L;
        return "" + diffDays + L.t("systemProperties.d") + " " + leafHours + L.t("systemProperties.h") + " " + leafMins + L.t("systemProperties.m");
    }

    public void setTimeDiff() {
        this.jTimeElaspedLabel.setText("Time elapsed:" + SystemPropertiesPanel.timeDiff(IPMIView20.getInstance().startTime, Calendar.getInstance()));
    }

    public String getTimeDiff() {
        return SystemPropertiesPanel.timeDiff(IPMIView20.getInstance().startTime, Calendar.getInstance());
    }

    public void setTitle(String title) {
        this.jLabel1.setText(title);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("systemProperties.Name") + "   ");
        headerList.add(L.t("systemProperties.Value") + "   ");
        return headerList;
    }

    public void jRefreshButton_actionPerformed(ActionEvent e) {
        this.refresh();
    }

    public void refresh() {
        switch (this.currentType) {
            case 1: {
                this.getSystemProperties();
                break;
            }
            case 2: {
                this.getEnv();
                break;
            }
            case 3: {
                this.getRunTime();
            }
        }
        this.setTimeDiff();
    }

    public void jTable_mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            int row = this.jTable.getSelectedRow();
            int column = this.jTable.getSelectedColumn();
            String key = ((TableSorter)this.jTable.getModel()).getValueAt(row, 0).toString();
            String value = ((TableSorter)this.jTable.getModel()).getValueAt(row, 1).toString();
            Object[] message = new Object[1];
            JTextField textField = new JTextField();
            textField.setText(value);
            textField.setPreferredSize(new Dimension(140, 20));
            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(2, 1));
            p1.add(new JLabel(key));
            p1.add(textField);
            message[0] = p1;
            int result = JOptionPane.showOptionDialog(this, message, L.t("systemProperties.Info"), -1, 1, null, null, null);
        }
    }

    public void jGCButton_actionPerformed(ActionEvent e) {
        System.gc();
    }
}

