/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20;

public class UOLMessage {
    public static final byte UOL_TYPE_OUT_OF_SESSION_MESSAGE = 0;
    public static final byte UOL_TYPE_USB_OVER_LAN_COMMAND = 16;
    public static final byte UOL_TYPE_BULK_TRANSFER = 32;
    public static final byte UOL_TYPE_INTERRUPT_TRANSFER = 48;
    public static final byte UOL_TYPE_ISOCHRONOUS_TRANSFER = 64;
    public static final byte UOL_TYPE_CONTROL_TRANSFER = 80;
    public static final byte BMC_STATE_DISCONNECT = 0;
    public static final byte BMC_STATE_CONNECT = 1;
    public static final byte BMC_STATE_POWER = 3;
    public static final byte BMC_STATE_DEFAULT = 4;
    public static final byte BMC_STATE_ADDRESS = 5;
    public static final byte BMC_STATE_CONFIGURED = 6;
    public static final byte BMC_STATE_POWER_SUSPENDED = 7;
    public static final byte BMC_STATE_DEFAULT_SUSPENDED = 8;
    public static final byte BMC_STATE_ADDRESS_SUSPENDED = 9;
    public static final byte BMC_STATE_CONFIGURED_SUSPENDED = 10;
    public static final byte SERVER_STATE_NO_CONNECTION = 0;
    public static final byte SERVER_STATE_PREPARE_CONNECTION = 1;
    public static final byte SERVER_STATE_CONNECTION_IS_READY = 2;
    public static final byte OUT_OF_SESSION_STATUS_RESET = 64;
    public static final byte OUT_OF_SESSION_STATUS_SYNCHRONIZED = 32;
    public static final byte OUT_OF_SESSION_STATUS_FINISH = 16;
    public static final byte TRANSFER_STATUS_ACK = -128;
    public static final byte TRANSFER_STATUS_RESET = 64;
    public static final byte COMMAND_GET_DESCRIPTOR = 1;
    public static final byte COMMAND_GET_STRING_DESCRIPTOR = 2;
    public static final byte COMMAND_DESCRIPTION_NOTIFICATION = 3;
    public static final byte COMMAND_SETUP_SESSION = 4;
    public static final byte COMMAND_KEEP_CONNECTION = 5;
    public static final byte COMMAND_SEND_DEFAULT_CONTROL_PIPE_DATA = 10;
    public static final byte SERVER_TO_BMC = 0;
    public static final byte BMC_TO_SERVER = 1;
    private byte version;
    private byte channelID;
    private byte state;
    private byte status;
    private byte packetSequenceNumber;
    private byte ACKSequenceNumber;
    private byte[] dataSize;
    private byte headChecksum = 0;
    private byte[] data;
    private byte dataChecksum = 0;
    private int direction = 0;

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
    }

    public byte getChannelID() {
        return this.channelID;
    }

    public void setChannelID(byte channelID) {
        this.channelID = channelID;
    }

    public byte getState() {
        return this.state;
    }

    public void setState(byte state) {
        this.state = state;
    }

    public byte getStatus() {
        return this.status;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public byte getPacketSequenceNumber() {
        return this.packetSequenceNumber;
    }

    public void setPacketSequenceNumber(byte packetSequenceNumber) {
        this.packetSequenceNumber = packetSequenceNumber;
    }

    public byte getACKSequenceNumber() {
        return this.ACKSequenceNumber;
    }

    public void setACKSequenceNumber(byte ACKSequenceNumber) {
        this.ACKSequenceNumber = ACKSequenceNumber;
    }

    public byte[] getDataSize() {
        return this.dataSize;
    }

    public void setDataSize(byte[] dataSize) {
        this.dataSize = dataSize;
    }

    public void setDataSize(int size) {
        this.dataSize[0] = (byte)(size & 0xFF);
        this.dataSize[1] = (byte)((size & 0xFF00) >> 8);
    }

    public byte getHeadChecksum() {
        return this.headChecksum;
    }

    public void setHeadChecksum(byte headChecksum) {
        this.headChecksum = headChecksum;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte getDataChecksum() {
        return this.dataChecksum;
    }

    public void setDataChecksum(byte dataChecksum) {
        this.dataChecksum = dataChecksum;
    }

    public UOLMessage replyACKOnlyMessage() {
        UOLMessage replyACKMessage = new UOLMessage();
        replyACKMessage.setVersion((byte)9);
        replyACKMessage.setChannelID((byte)0);
        replyACKMessage.setState(this.getState());
        replyACKMessage.setStatus((byte)0);
        replyACKMessage.setPacketSequenceNumber((byte)0);
        replyACKMessage.setACKSequenceNumber(this.getPacketSequenceNumber());
        byte[] b = new byte[]{0, 0};
        replyACKMessage.setDataSize(b);
        return replyACKMessage;
    }

    public int dataSizeToInt() {
        int aDataSize = (this.dataSize[1] & 0xFF) * 256 + (this.dataSize[0] & 0xFF);
        return aDataSize;
    }

    public byte[] toByteArray() {
        byte[] bytearray = null;
        switch (this.state & 0xF0) {
            case 0: 
            case 16: {
                bytearray = this.toUOLCommandByteArray();
                break;
            }
            case 32: 
            case 48: {
                bytearray = this.toBulkByteArray();
                break;
            }
            case 80: {
                break;
            }
        }
        return bytearray;
    }

    public byte[] toUOLCommandByteArray() {
        int bytesLength = 9;
        int aDataSize = this.dataSizeToInt();
        if (aDataSize != 0) {
            bytesLength += aDataSize + 1;
        }
        byte[] byteData = new byte[bytesLength];
        byteData[0] = this.version;
        byteData[1] = this.channelID;
        byteData[2] = this.state;
        byteData[3] = this.status;
        byteData[4] = this.packetSequenceNumber;
        byteData[5] = this.ACKSequenceNumber;
        byteData[6] = this.dataSize[0];
        byteData[7] = this.dataSize[1];
        byteData[8] = this.headChecksum;
        if (aDataSize != 0) {
            System.arraycopy(this.data, 0, byteData, 9, this.data.length);
            byteData[bytesLength - 1] = this.dataChecksum;
        }
        return byteData;
    }

    public byte[] toBulkByteArray() {
        int bytesLength = 8;
        int aDataSize = this.dataSizeToInt();
        if (aDataSize != 0) {
            bytesLength += aDataSize + 1;
        }
        byte[] byteData = new byte[bytesLength];
        byteData[0] = this.version;
        byteData[1] = this.channelID;
        byteData[2] = this.state;
        byteData[3] = this.status;
        byteData[4] = this.packetSequenceNumber;
        byteData[5] = this.dataSize[0];
        byteData[6] = this.dataSize[1];
        byteData[7] = this.headChecksum;
        if (aDataSize != 0) {
            System.arraycopy(this.data, 0, byteData, 8, this.data.length);
            byteData[bytesLength - 1] = this.dataChecksum;
        }
        return byteData;
    }

    private String byteToString(byte b) {
        int i = b & 0xFF;
        String strByte = Integer.toHexString(i);
        if (strByte.length() == 1) {
            strByte = "0" + strByte;
        }
        if (strByte.length() > 2) {
            strByte = strByte.substring(strByte.length() - 1, strByte.length());
        }
        strByte = strByte.toUpperCase();
        return strByte;
    }

    public String toByteString() {
        StringBuffer sb = new StringBuffer();
        byte[] byteArray = this.toByteArray();
        for (int i = 0; i < byteArray.length; ++i) {
            sb.append(this.byteToString(byteArray[i]) + " ");
        }
        return sb.toString();
    }

    public static UOLMessage makeMessage(byte[] data) {
        UOLMessage message = null;
        if (data[0] != 9) {
            return message;
        }
        message = new UOLMessage();
        message.version = data[0];
        message.channelID = data[1];
        message.state = data[2];
        message.status = data[3];
        message.packetSequenceNumber = data[4];
        message.ACKSequenceNumber = data[5];
        message.dataSize = new byte[]{data[6], data[7]};
        message.dataChecksum = data[8];
        int aDataSize = message.dataSizeToInt();
        if (aDataSize != 0) {
            byte[] c = new byte[aDataSize];
            System.arraycopy(data, 9, c, 0, aDataSize);
            message.data = c;
            message.dataChecksum = data[9 + aDataSize];
        }
        message.direction = 1;
        return message;
    }

    public String stateToString() {
        String stateStr = "";
        int aMessageType = this.state & 0xF0;
        int aState = this.state & 0xF;
        stateStr = "Msg Type:";
        switch (aMessageType) {
            case 0: {
                stateStr = stateStr + "Out of Session";
                break;
            }
            case 16: {
                stateStr = stateStr + "USB over LAN Command";
                break;
            }
            case 32: {
                stateStr = stateStr + "Bulk Transfer";
                break;
            }
            case 48: {
                stateStr = stateStr + "Interrupt Transfer";
                break;
            }
            case 64: {
                stateStr = stateStr + "Isochronous Transfer";
                break;
            }
            case 80: {
                stateStr = stateStr + "Control Transfer";
            }
        }
        if (aMessageType == 16) {
            switch (this.data[0]) {
                case 1: {
                    stateStr = stateStr + "(Command:Get Descriptor)";
                    break;
                }
                case 2: {
                    stateStr = stateStr + "(Command:Get String Descriptor)";
                    break;
                }
                case 3: {
                    stateStr = stateStr + "(Command:Description Notification)";
                    break;
                }
                case 4: {
                    stateStr = stateStr + "(Command:Setup Session)";
                    break;
                }
                case 5: {
                    stateStr = stateStr + "(Command:Keep Connection)";
                    break;
                }
                case 10: {
                    stateStr = stateStr + "(Command:Send Default Control PIPE Data)";
                }
            }
        }
        stateStr = stateStr + ",";
        if (this.direction == 1) {
            switch (aState) {
                case 0: {
                    stateStr = stateStr + "Disconnect";
                    break;
                }
                case 1: {
                    stateStr = stateStr + "Connect";
                    break;
                }
                case 3: {
                    stateStr = stateStr + "Power";
                    break;
                }
                case 4: {
                    stateStr = stateStr + "Default";
                    break;
                }
                case 5: {
                    stateStr = stateStr + "Address";
                    break;
                }
                case 6: {
                    stateStr = stateStr + "Configured";
                    break;
                }
                case 7: {
                    stateStr = stateStr + "Power Suspended";
                    break;
                }
                case 8: {
                    stateStr = stateStr + "Default Suspended";
                    break;
                }
                case 9: {
                    stateStr = stateStr + "Address Suspended";
                    break;
                }
                case 10: {
                    stateStr = stateStr + "Configured Suspended";
                }
            }
        } else {
            switch (aState) {
                case 0: {
                    stateStr = stateStr + "No Connection";
                    break;
                }
                case 1: {
                    stateStr = stateStr + "Prepare Connection";
                    break;
                }
                case 2: {
                    stateStr = stateStr + "Connection is ready";
                }
            }
        }
        return stateStr;
    }

    public int getDirection() {
        return this.direction;
    }

    public static void main(String[] args) {
        System.out.println(1);
    }

    class CommandResponseFormat {
        public byte commandID;
        public byte seq;
        public byte completeCode;
        public byte[] requestData;

        CommandResponseFormat() {
        }
    }

    class CommandRequestFormat {
        public byte commandID;
        public byte seq;
        public byte[] requestData;

        CommandRequestFormat() {
        }
    }
}

