/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.algo;

import IPMIView20.CSession;
import IPMIView20.algo.HMAC_MD5_128;
import IPMIView20.algo.HMAC_SHA1_96;
import IPMIView20.algo.IntegrityAlgorithm;
import IPMIView20.algo.Integrity_NONE;
import IPMIView20.algo.MD5_128;
import IPMIView20.algo.RAKPAlgorithm;
import IPMIView20.algo.RAKP_HMAC_MD5;
import IPMIView20.algo.RAKP_HMAC_NONE;
import IPMIView20.algo.RAKP_HMAC_SHA1;

public class CipherAlgorithmFactory {
    public static RAKPAlgorithm createRAKPAlgorithm(CSession session) {
        RAKPAlgorithm rakpAlgorithm = null;
        switch (session.cipherSuite.getAuthenticationAlgorithm()) {
            case 0: {
                rakpAlgorithm = new RAKP_HMAC_NONE();
                break;
            }
            case 2: {
                rakpAlgorithm = new RAKP_HMAC_MD5();
                break;
            }
            case 1: {
                rakpAlgorithm = new RAKP_HMAC_SHA1();
            }
        }
        return rakpAlgorithm;
    }

    public static IntegrityAlgorithm createIntegrityAlgorithm(CSession session) {
        IntegrityAlgorithm integirtyAlgorithm = null;
        switch (session.cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                integirtyAlgorithm = new Integrity_NONE();
                break;
            }
            case 1: {
                integirtyAlgorithm = new HMAC_SHA1_96();
                break;
            }
            case 2: {
                integirtyAlgorithm = new HMAC_MD5_128();
                break;
            }
            case 3: {
                integirtyAlgorithm = new MD5_128();
            }
        }
        return integirtyAlgorithm;
    }
}

