/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.IPMIView20;
import IPMIView20.Logger;
import IPMIView20.blade.LabelBladeComponent;
import IPMIView20.blade.LabelBladeGroup;
import IPMIView20.blade.LabelBladeSystemFrontView;
import IPMIView20.blade.LabelBladeSystemMouseAdapter;
import IPMIView20.blade.LabelBladeSystemRearView;
import IPMIView20.blade.LabelBladeSystem_jLegendLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jNumberCheckBox_actionAdapter;
import IPMIView20.blade.LabelBladeSystem_jPictureCheckBox_actionAdapter;
import IPMIView20.blade.LabelBladeSystem_jStatusCheckBox_actionAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummaryBladeLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummaryCMMLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummaryFailLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummaryIBLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummaryPowerLabel_mouseAdapter;
import IPMIView20.blade.LabelBladeSystem_jSummarySwitchLabel_mouseAdapter;
import IPMIView20.blade.LegendHelpPanel;
import IPMIView20.blade.SummaryMouseAdapter;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.FrontLEDEntity;
import com.supermicro.ipmi.blade.GigabitSwitchEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class LabelBladeSystem
extends JPanel
implements Observer {
    ImageIcon ledGrayIcon = new ImageIcon(this.getClass().getResource("/images/led-gray.gif"));
    ImageIcon ledGreenIcon = new ImageIcon(this.getClass().getResource("/images/led-green.gif"));
    ImageIcon ledGreenBlinkIcon = new ImageIcon(this.getClass().getResource("/images/led-green-blink.gif"));
    ImageIcon ledRedIcon = new ImageIcon(this.getClass().getResource("/images/led-red.gif"));
    ImageIcon ledRedBlinkIcon = new ImageIcon(this.getClass().getResource("/images/led-red-blink.gif"));
    ImageIcon ledAmberIcon = new ImageIcon(this.getClass().getResource("/images/led-amber.gif"));
    ImageIcon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/labelBladeComponentPowerOn.gif"));
    public static final String SUMMARY_BLADE = "summaryBlade";
    public static final String SUMMARY_POWER = "summaryPower";
    public static final String SUMMARY_SWITCH = "summarySwitch";
    public static final String SUMMARY_CMM = "summaryCMM";
    public static final String SUMMARY_IB = "summaryIB";
    public static final String SUMMARY_FAILURE = "summaryFailure";
    ArrayList failureLabel = new ArrayList();
    public LabelBladeSystemFrontView bladeSystemFront = new LabelBladeSystemFrontView();
    public LabelBladeSystemRearView bladeSystemRear = new LabelBladeSystemRearView();
    LabelBladeGroup labelBladeGroup = new LabelBladeGroup();
    LabelBladeSystemMouseAdapter labelBladeSystemMouseAdapter = null;
    SummaryMouseAdapter summaryMouseAdapter = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jBladeSystemPanel = new JPanel();
    JPanel jInfoPanel = new JPanel();
    JCheckBox jNumberCheckBox = new JCheckBox();
    JCheckBox jStatusCheckBox = new JCheckBox();
    JLabel jSummaryCMMLabel = new JLabel();
    JLabel jCMMNumberLabel = new JLabel();
    JLabel jSummaryIBLabel = new JLabel();
    JLabel jIBNumberLabel = new JLabel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JLabel jSummaryBladeLabel = new JLabel();
    TitledBorder titledBorder2 = new TitledBorder("");
    JPanel jSummaryPanel = new JPanel();
    JPanel jSelectionPanel = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    GridLayout gridLayout2 = new GridLayout();
    JLabel jSwitchNumberLabel = new JLabel();
    JLabel jSummarySwitchLabel = new JLabel();
    JLabel jPowerNumberLabel = new JLabel();
    JLabel jSummaryPowerLabel = new JLabel();
    JLabel jBaladeNumberLabel = new JLabel();
    JLabel jSummaryFailLabel = new JLabel();
    JLabel jFailNumberLabel = new JLabel();
    TitledBorder titledBorder3 = new TitledBorder("");
    JPanel jSetAndSelectedPanel = new JPanel();
    TitledBorder titledBorder4 = new TitledBorder("");
    JTable jTable1 = new JTable();
    JCheckBox jPictureCheckBox = new JCheckBox();
    JPanel jViewOptionPanel = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    GridLayout gridLayout4 = new GridLayout();
    JLabel jSelectedModuleNameLabel = new JLabel();
    JLabel jSelectedModuleSideLabel = new JLabel();
    JLabel jPowerLEDLabel = new JLabel();
    JLabel jErrorLEDLabel = new JLabel();
    JLabel jLegendLabel = new JLabel();
    JPanel jBladeSystemRearPanel = new JPanel();
    JPanel jBladeSystemFrontPanel = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel jBladeSystemFrontLabel = new JLabel();
    JLabel jBladeSystemRearLabel = new JLabel();
    GridLayout gridLayout1 = new GridLayout();
    BladeSystemEntity bladeSystemEntity = null;

    public LabelBladeSystem() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void clearReference() {
        int i;
        for (i = 0; i < this.bladeSystemFront.labelBlades.length; ++i) {
            this.bladeSystemFront.labelBlades[i].setAlertVisible(false);
            this.bladeSystemFront.labelBlades[i].labelBladeGroup = null;
        }
        for (i = 0; i < this.bladeSystemRear.labelCMM.length; ++i) {
            this.bladeSystemRear.labelCMM[i].setAlertVisible(false);
            this.bladeSystemRear.labelCMM[i].labelBladeGroup = null;
        }
        for (i = 0; i < this.bladeSystemRear.labelGigibitSwitch.length; ++i) {
            this.bladeSystemRear.labelGigibitSwitch[i].setAlertVisible(false);
            this.bladeSystemRear.labelGigibitSwitch[i].labelBladeGroup = null;
        }
        for (i = 0; i < this.bladeSystemRear.labelInfiniBand.length; ++i) {
            this.bladeSystemRear.labelInfiniBand[i].setAlertVisible(false);
            this.bladeSystemRear.labelInfiniBand[i].labelBladeGroup = null;
        }
        for (i = 0; i < this.bladeSystemRear.labelPowerSupply.length; ++i) {
            this.bladeSystemRear.labelPowerSupply[i].setAlertVisible(false);
            this.bladeSystemRear.labelPowerSupply[i].labelBladeGroup = null;
        }
        this.jSummaryFailLabel.removeMouseListener(this.summaryMouseAdapter);
        this.jSummaryBladeLabel.removeMouseListener(this.summaryMouseAdapter);
        this.jSummaryPowerLabel.removeMouseListener(this.summaryMouseAdapter);
        this.jSummarySwitchLabel.removeMouseListener(this.summaryMouseAdapter);
        this.failureLabel.clear();
        this.failureLabel = null;
        this.bladeSystemFront.clearReference();
        this.bladeSystemFront = null;
        this.bladeSystemRear.clearReference();
        this.bladeSystemRear = null;
        this.labelBladeGroup.getLabelBladeComponents().clear();
        this.labelBladeGroup = null;
        this.labelBladeSystemMouseAdapter = null;
        this.summaryMouseAdapter = null;
    }

    private void myInit() {
        int i;
        this.labelBladeSystemMouseAdapter = new LabelBladeSystemMouseAdapter(this);
        this.bladeSystemFront.addMouseAdaptorForAllModule(this.labelBladeSystemMouseAdapter);
        this.bladeSystemRear.addMouseAdaptorForAllModule(this.labelBladeSystemMouseAdapter);
        this.summaryMouseAdapter = new SummaryMouseAdapter(this);
        this.jSummaryFailLabel.addMouseListener(this.summaryMouseAdapter);
        this.jSummaryBladeLabel.addMouseListener(this.summaryMouseAdapter);
        this.jSummaryPowerLabel.addMouseListener(this.summaryMouseAdapter);
        this.jSummarySwitchLabel.addMouseListener(this.summaryMouseAdapter);
        for (i = 0; i < this.bladeSystemFront.labelBlades.length; ++i) {
            this.labelBladeGroup.addLabelBladeComponent(this.bladeSystemFront.labelBlades[i]);
        }
        for (i = 0; i < this.bladeSystemRear.labelCMM.length; ++i) {
            this.labelBladeGroup.addLabelBladeComponent(this.bladeSystemRear.labelCMM[i]);
        }
        for (i = 0; i < this.bladeSystemRear.labelGigibitSwitch.length; ++i) {
            this.labelBladeGroup.addLabelBladeComponent(this.bladeSystemRear.labelGigibitSwitch[i]);
        }
        for (i = 0; i < this.bladeSystemRear.labelInfiniBand.length; ++i) {
            this.labelBladeGroup.addLabelBladeComponent(this.bladeSystemRear.labelInfiniBand[i]);
        }
        for (i = 0; i < this.bladeSystemRear.labelPowerSupply.length; ++i) {
            this.labelBladeGroup.addLabelBladeComponent(this.bladeSystemRear.labelPowerSupply[i]);
        }
        TitledBorder titledBorder = new TitledBorder("Chassis LED");
        this.jSelectionPanel.setBorder(titledBorder);
        this.jSelectionPanel.removeAll();
        this.jSelectedModuleNameLabel.setVisible(false);
        this.jSelectedModuleSideLabel.setVisible(false);
        this.jPowerLEDLabel.setText(" Power");
        this.jErrorLEDLabel.setText(" Error");
        this.jPowerLEDLabel.setForeground(Color.BLUE);
        this.jErrorLEDLabel.setForeground(Color.BLUE);
        this.jPowerLEDLabel.setIcon(this.ledGrayIcon);
        this.jErrorLEDLabel.setIcon(this.ledGrayIcon);
        this.jSelectionPanel.add(this.jPowerLEDLabel);
        this.jSelectionPanel.add(this.jErrorLEDLabel);
    }

    private void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder("View Option");
        this.titledBorder3 = new TitledBorder("Selection");
        this.titledBorder2 = new TitledBorder("Blade System");
        this.titledBorder1 = new TitledBorder("Summary");
        this.setLayout(this.borderLayout1);
        this.jBladeSystemPanel.setLayout(this.gridLayout1);
        this.jInfoPanel.setLayout(this.borderLayout2);
        this.jNumberCheckBox.setMinimumSize(new Dimension(59, 15));
        this.jNumberCheckBox.setToolTipText("");
        this.jNumberCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jNumberCheckBox.setSelected(true);
        this.jNumberCheckBox.setText("Number");
        this.jNumberCheckBox.setVerticalAlignment(1);
        this.jNumberCheckBox.addActionListener(new LabelBladeSystem_jNumberCheckBox_actionAdapter(this));
        this.jStatusCheckBox.setMinimumSize(new Dimension(49, 15));
        this.jStatusCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jStatusCheckBox.setSelected(true);
        this.jStatusCheckBox.setText("Status");
        this.jStatusCheckBox.setVerticalAlignment(1);
        this.jStatusCheckBox.addActionListener(new LabelBladeSystem_jStatusCheckBox_actionAdapter(this));
        this.jSummaryCMMLabel.setForeground(Color.blue);
        this.jSummaryCMMLabel.setHorizontalAlignment(11);
        this.jSummaryCMMLabel.setText(this.htmlString("CMM:"));
        this.jSummaryCMMLabel.addMouseListener(new LabelBladeSystem_jSummaryCMMLabel_mouseAdapter(this));
        this.jCMMNumberLabel.setForeground(Color.blue);
        this.jCMMNumberLabel.setToolTipText("");
        this.jCMMNumberLabel.setHorizontalAlignment(0);
        this.jCMMNumberLabel.setText("1 / 2");
        this.jSummaryIBLabel.setForeground(Color.blue);
        this.jSummaryIBLabel.setHorizontalAlignment(11);
        this.jSummaryIBLabel.setText(this.htmlString("IB:"));
        this.jSummaryIBLabel.addMouseListener(new LabelBladeSystem_jSummaryIBLabel_mouseAdapter(this));
        this.jIBNumberLabel.setForeground(Color.blue);
        this.jIBNumberLabel.setToolTipText("");
        this.jIBNumberLabel.setHorizontalAlignment(0);
        this.jIBNumberLabel.setText("1 / 1");
        this.jInfoPanel.setBorder(null);
        this.jInfoPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 135));
        this.jInfoPanel.setMinimumSize(new Dimension(90, 100));
        this.jInfoPanel.setPreferredSize(new Dimension(95, 100));
        this.jSummaryBladeLabel.setForeground(Color.blue);
        this.jSummaryBladeLabel.setHorizontalAlignment(11);
        this.jSummaryBladeLabel.setText(this.htmlString("Blade:"));
        this.jSummaryBladeLabel.addMouseListener(new LabelBladeSystem_jSummaryBladeLabel_mouseAdapter(this));
        this.jBladeSystemPanel.setBorder(this.titledBorder2);
        this.jSelectionPanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(0);
        this.gridLayout3.setVgap(4);
        this.jSummaryPanel.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setHgap(7);
        this.gridLayout2.setRows(0);
        this.gridLayout2.setVgap(2);
        this.jSwitchNumberLabel.setForeground(Color.blue);
        this.jSwitchNumberLabel.setToolTipText("");
        this.jSwitchNumberLabel.setHorizontalAlignment(0);
        this.jSwitchNumberLabel.setText("2 / 2");
        this.jSummarySwitchLabel.setForeground(Color.blue);
        this.jSummarySwitchLabel.setHorizontalAlignment(11);
        this.jSummarySwitchLabel.setText(this.htmlString("Switch:"));
        this.jSummarySwitchLabel.addMouseListener(new LabelBladeSystem_jSummarySwitchLabel_mouseAdapter(this));
        this.jPowerNumberLabel.setForeground(Color.blue);
        this.jPowerNumberLabel.setHorizontalAlignment(0);
        this.jPowerNumberLabel.setText("2 / 4");
        this.jSummaryPowerLabel.setForeground(Color.blue);
        this.jSummaryPowerLabel.setHorizontalAlignment(11);
        this.jSummaryPowerLabel.setText(this.htmlString("Power:"));
        this.jSummaryPowerLabel.addMouseListener(new LabelBladeSystem_jSummaryPowerLabel_mouseAdapter(this));
        this.jBaladeNumberLabel.setForeground(Color.blue);
        this.jBaladeNumberLabel.setToolTipText("");
        this.jBaladeNumberLabel.setHorizontalAlignment(0);
        this.jBaladeNumberLabel.setText("8 / 10");
        this.jSummaryFailLabel.setForeground(Color.red);
        this.jSummaryFailLabel.setToolTipText("");
        this.jSummaryFailLabel.setHorizontalAlignment(11);
        this.jSummaryFailLabel.setText(this.htmlString("Failure:"));
        this.jSummaryFailLabel.addMouseListener(new LabelBladeSystem_jSummaryFailLabel_mouseAdapter(this));
        this.jFailNumberLabel.setForeground(Color.green);
        this.jFailNumberLabel.setHorizontalAlignment(0);
        this.jFailNumberLabel.setText("0");
        this.jSummaryPanel.setBorder(this.titledBorder1);
        this.jSelectionPanel.setBorder(this.titledBorder3);
        this.jSetAndSelectedPanel.setActionMap(null);
        this.jSetAndSelectedPanel.setLayout(this.borderLayout3);
        this.jPictureCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.jPictureCheckBox.setSelected(true);
        this.jPictureCheckBox.setText("Picture");
        this.jPictureCheckBox.setVerticalAlignment(1);
        this.jPictureCheckBox.addActionListener(new LabelBladeSystem_jPictureCheckBox_actionAdapter(this));
        this.jViewOptionPanel.setBorder(this.titledBorder4);
        this.jViewOptionPanel.setMinimumSize(new Dimension(200, 120));
        this.jViewOptionPanel.setPreferredSize(new Dimension(100, 86));
        this.jViewOptionPanel.setLayout(this.gridLayout4);
        this.gridLayout4.setColumns(1);
        this.gridLayout4.setRows(0);
        this.jSelectedModuleNameLabel.setForeground(Color.blue);
        this.jSelectedModuleNameLabel.setText("None");
        this.jSelectedModuleSideLabel.setText(" ");
        this.jLegendLabel.setForeground(Color.blue);
        this.jLegendLabel.setBorder(null);
        this.jLegendLabel.setToolTipText("");
        this.jLegendLabel.setHorizontalAlignment(2);
        this.jLegendLabel.setIcon(this.powerOnIcon);
        this.jLegendLabel.setText(this.htmlString("Legend Help"));
        this.jLegendLabel.setVerticalTextPosition(1);
        this.jLegendLabel.addMouseListener(new LabelBladeSystem_jLegendLabel_mouseAdapter(this));
        this.jBladeSystemRearPanel.setLayout(this.borderLayout4);
        this.jBladeSystemFrontPanel.setLayout(this.borderLayout5);
        this.jBladeSystemFrontLabel.setHorizontalAlignment(0);
        this.jBladeSystemFrontLabel.setHorizontalTextPosition(2);
        this.jBladeSystemFrontLabel.setText("Front");
        this.jBladeSystemRearLabel.setHorizontalAlignment(0);
        this.jBladeSystemRearLabel.setText("Rear");
        this.jBladeSystemPanel.add(this.jBladeSystemFrontPanel);
        this.jBladeSystemPanel.add(this.jBladeSystemRearPanel);
        this.jSummaryPanel.add(this.jSummaryFailLabel);
        this.jSummaryPanel.add(this.jFailNumberLabel);
        this.jSummaryPanel.add(this.jSummaryBladeLabel);
        this.jSummaryPanel.add(this.jBaladeNumberLabel);
        this.jSummaryPanel.add(this.jSummaryPowerLabel);
        this.jSummaryPanel.add(this.jPowerNumberLabel);
        this.jSummaryPanel.add(this.jSummarySwitchLabel);
        this.jSummaryPanel.add(this.jSwitchNumberLabel);
        this.jSummaryPanel.add(this.jSummaryCMMLabel);
        this.jSummaryPanel.add(this.jCMMNumberLabel);
        this.jSummaryPanel.add(this.jSummaryIBLabel);
        this.jSummaryPanel.add(this.jIBNumberLabel);
        this.jInfoPanel.add((Component)this.jSummaryPanel, "Center");
        this.add((Component)this.jInfoPanel, "West");
        this.add((Component)this.jBladeSystemPanel, "Center");
        this.add((Component)this.jSetAndSelectedPanel, "East");
        this.jViewOptionPanel.add(this.jStatusCheckBox);
        this.jViewOptionPanel.add(this.jPictureCheckBox);
        this.jViewOptionPanel.add(this.jNumberCheckBox);
        this.jViewOptionPanel.add(this.jLegendLabel);
        this.jSetAndSelectedPanel.add((Component)this.jViewOptionPanel, "Center");
        this.jSelectionPanel.add(this.jSelectedModuleNameLabel);
        this.jSelectionPanel.add(this.jSelectedModuleSideLabel);
        this.jSetAndSelectedPanel.add((Component)this.jSelectionPanel, "North");
        this.jBladeSystemFrontPanel.add((Component)this.bladeSystemFront, "Center");
        this.jBladeSystemFrontPanel.add((Component)this.jBladeSystemFrontLabel, "North");
        this.jBladeSystemRearPanel.add((Component)this.bladeSystemRear, "Center");
        this.jBladeSystemRearPanel.add((Component)this.jBladeSystemRearLabel, "North");
    }

    public String htmlString(String string) {
        String s = "<html>" + string + "</html>";
        return s;
    }

    public String underLineString(String string) {
        String s = "<html><u>" + string + "</u></html>";
        return s;
    }

    public void jNumberCheckBox_actionPerformed(ActionEvent e) {
        if (this.jNumberCheckBox.isSelected()) {
            this.bladeSystemFront.setAllModuleNumberVisible(true);
            this.bladeSystemRear.setAllModuleNumberVisible(true);
        } else {
            this.bladeSystemFront.setAllModuleNumberVisible(false);
            this.bladeSystemRear.setAllModuleNumberVisible(false);
        }
    }

    public void jPictureCheckBox_actionPerformed(ActionEvent e) {
        if (this.jPictureCheckBox.isSelected()) {
            this.bladeSystemFront.setAllModulePictureVisible(true);
            this.bladeSystemRear.setAllModulePictureVisible(true);
        } else {
            this.bladeSystemFront.setAllModulePictureVisible(false);
            this.bladeSystemRear.setAllModulePictureVisible(false);
        }
    }

    public void jStatusCheckBox_actionPerformed(ActionEvent e) {
        if (this.jStatusCheckBox.isSelected()) {
            this.bladeSystemFront.setAllModuleShowStatus(true);
            this.bladeSystemRear.setAllModuleShowStatus(true);
        } else {
            this.bladeSystemFront.setAllModuleShowStatus(false);
            this.bladeSystemRear.setAllModuleShowStatus(false);
        }
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[LabelBladeSystem] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        this.bladeSystemFront.update(o, obj);
        this.bladeSystemRear.update(o, obj);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    LabelBladeSystem.this.summaryBladeModule();
                    LabelBladeSystem.this.markFailureModule();
                    LabelBladeSystem.this.helpSetFrontPanelLED();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpSetFrontPanelLED() {
        if (this.bladeSystemEntity.isIsFrontLEDEntityAvailable()) {
            this.jPowerLEDLabel.setEnabled(true);
            this.jErrorLEDLabel.setEnabled(true);
            FrontLEDEntity frontLEDEntity = this.bladeSystemEntity.getFrontLED();
            switch (frontLEDEntity.getPowerLED()) {
                case 0: {
                    this.jPowerLEDLabel.setIcon(this.ledGreenIcon);
                    this.jPowerLEDLabel.setToolTipText("Power Normal");
                    break;
                }
                case 2: {
                    this.jPowerLEDLabel.setIcon(this.ledGreenBlinkIcon);
                    this.jPowerLEDLabel.setToolTipText("Power Over Load");
                    break;
                }
                case 1: {
                    this.jPowerLEDLabel.setIcon(this.ledRedIcon);
                    this.jPowerLEDLabel.setToolTipText("Power Failure");
                    break;
                }
                case 3: {
                    this.jPowerLEDLabel.setIcon(this.ledAmberIcon);
                    this.jPowerLEDLabel.setToolTipText("Power Standby");
                }
            }
            switch (frontLEDEntity.getErrorLED()) {
                case 2: {
                    this.jErrorLEDLabel.setIcon(this.ledRedBlinkIcon);
                    this.jErrorLEDLabel.setToolTipText("Fan Failure");
                    break;
                }
                case 0: {
                    this.jErrorLEDLabel.setIcon(this.ledGrayIcon);
                    this.jErrorLEDLabel.setToolTipText("Normal");
                    break;
                }
                case 1: {
                    this.jErrorLEDLabel.setIcon(this.ledRedIcon);
                    this.jErrorLEDLabel.setToolTipText("Over Temperature");
                }
            }
        } else {
            this.jPowerLEDLabel.setEnabled(false);
            this.jErrorLEDLabel.setEnabled(false);
            this.jPowerLEDLabel.setIcon(this.ledGrayIcon);
            this.jPowerLEDLabel.setToolTipText("Unknown Status");
            this.jErrorLEDLabel.setIcon(this.ledGrayIcon);
            this.jErrorLEDLabel.setToolTipText("Unknown Status");
        }
    }

    private void markFailureModule() {
        this.failureLabel.clear();
        ArrayList failures = this.bladeSystemEntity.getFailures();
        Iterator iter = failures.iterator();
        while (iter.hasNext()) {
            int index;
            FailureEntity item = (FailureEntity)iter.next();
            Object o = item.getSourceObject();
            if (o instanceof BladeEntity) {
                index = ((BladeEntity)o).getModuleIndex();
                this.failureLabel.add(this.bladeSystemFront.labelBlades[index - 1]);
                continue;
            }
            if (o instanceof PowerSupplyEntity) {
                index = ((PowerSupplyEntity)o).getModuleIndex();
                this.failureLabel.add(this.bladeSystemRear.labelPowerSupply[index - 1]);
                continue;
            }
            if (o instanceof GigabitSwitchEntity) {
                index = ((GigabitSwitchEntity)o).getModuleIndex();
                this.failureLabel.add(this.bladeSystemRear.labelGigibitSwitch[index - 1]);
                continue;
            }
            if (o instanceof CMMModuleEntity) {
                index = ((CMMModuleEntity)o).getModuleIndex();
                this.failureLabel.add(this.bladeSystemRear.labelCMM[index - 1]);
                continue;
            }
            if (!(o instanceof InfiniBandEntity)) continue;
            index = ((InfiniBandEntity)o).getModuleIndex();
            this.failureLabel.add(this.bladeSystemRear.labelInfiniBand[index - 1]);
        }
    }

    private void summaryBladeModule() {
        int i;
        int total = this.bladeSystemEntity.getBlades().length;
        int available = 0;
        for (i = 0; i < total; ++i) {
            if (this.bladeSystemEntity.getBlades()[i].getPresent() <= 0) continue;
            ++available;
        }
        this.jBaladeNumberLabel.setText("" + available + " / " + total);
        total = this.bladeSystemEntity.getPowerSupplies().length;
        available = 0;
        for (i = 0; i < total; ++i) {
            if (this.bladeSystemEntity.getPowerSupplies()[i].getPresent() <= 0) continue;
            ++available;
        }
        this.jPowerNumberLabel.setText("" + available + " / " + total);
        total = this.bladeSystemEntity.getGigabitSwitchs().length;
        available = 0;
        for (i = 0; i < total; ++i) {
            if (this.bladeSystemEntity.getGigabitSwitchs()[i].getPresent() <= 0) continue;
            ++available;
        }
        this.jSwitchNumberLabel.setText("" + available + " / " + total);
        total = this.bladeSystemEntity.getInfiniBands().length;
        available = 0;
        for (i = 0; i < total; ++i) {
            if (this.bladeSystemEntity.getInfiniBands()[i].getPresent() <= 0) continue;
            ++available;
        }
        this.jIBNumberLabel.setText("" + available + " / " + total);
        total = this.bladeSystemEntity.getCmmModules().length;
        available = 0;
        for (i = 0; i < total; ++i) {
            if (this.bladeSystemEntity.getCmmModules()[i].getPresent() <= 0) continue;
            ++available;
        }
        this.jCMMNumberLabel.setText("" + available + " / " + total);
        if (this.bladeSystemEntity.getFailures().size() == 0) {
            this.jFailNumberLabel.setForeground(Color.GREEN);
            this.jFailNumberLabel.setText("0");
        } else {
            this.jFailNumberLabel.setForeground(Color.RED);
            this.jFailNumberLabel.setText("" + this.bladeSystemEntity.getFailures().size());
        }
    }

    public LabelBladeSystemFrontView getBladeSystemFront() {
        return this.bladeSystemFront;
    }

    public LabelBladeSystemRearView getBladeSystemRear() {
        return this.bladeSystemRear;
    }

    public LabelBladeGroup getLabelBladeGroup() {
        return this.labelBladeGroup;
    }

    public JLabel getJSummaryBladeLabel() {
        return this.jSummaryBladeLabel;
    }

    public JLabel getJSummaryCMMLabel() {
        return this.jSummaryCMMLabel;
    }

    public JLabel getJSummaryFailLabel() {
        return this.jSummaryFailLabel;
    }

    public JLabel getJSummaryIBLabel() {
        return this.jSummaryIBLabel;
    }

    public JLabel getJSummaryPowerLabel() {
        return this.jSummaryPowerLabel;
    }

    public JLabel getJSummarySwitchLabel() {
        return this.jSummarySwitchLabel;
    }

    public void jSummaryBladeLabel_mouseClicked(MouseEvent e) {
        this.labelBladeGroup.setIndicatorUnique(false);
        this.labelBladeGroup.setIndicatorName(SUMMARY_BLADE);
        this.jSelectedModuleNameLabel.setText("Blades");
        this.jSelectedModuleSideLabel.setText("Side: Front");
        this.labelBladeSystemMouseAdapter.name = "Blades";
        this.labelBladeSystemMouseAdapter.side = "Side: Front";
        for (int i = 0; i < this.bladeSystemFront.labelBlades.length; ++i) {
            if (!this.bladeSystemFront.labelBlades[i].isVisible()) continue;
            this.bladeSystemFront.labelBlades[i].setIndicatorVisible(true);
        }
    }

    public void jSummaryPowerLabel_mouseClicked(MouseEvent e) {
        this.labelBladeGroup.setIndicatorUnique(false);
        this.labelBladeGroup.setIndicatorName(SUMMARY_POWER);
        this.jSelectedModuleNameLabel.setText("Power Supplies");
        this.jSelectedModuleSideLabel.setText("Side: Rear");
        this.labelBladeSystemMouseAdapter.name = "Power Supplies";
        this.labelBladeSystemMouseAdapter.side = "Side: Rear";
        for (int i = 0; i < this.bladeSystemRear.labelPowerSupply.length; ++i) {
            if (!this.bladeSystemRear.labelPowerSupply[i].isVisible()) continue;
            this.bladeSystemRear.labelPowerSupply[i].setIndicatorVisible(true);
        }
    }

    public void jSummarySwitchLabel_mouseClicked(MouseEvent e) {
        this.labelBladeGroup.setIndicatorUnique(false);
        this.labelBladeGroup.setIndicatorName(SUMMARY_SWITCH);
        this.jSelectedModuleNameLabel.setText("Gigabit Switches");
        this.jSelectedModuleSideLabel.setText("Side: Rear");
        this.labelBladeSystemMouseAdapter.name = "Gigabit Switches";
        this.labelBladeSystemMouseAdapter.side = "Side: Rear";
        for (int i = 0; i < this.bladeSystemRear.labelGigibitSwitch.length; ++i) {
            if (!this.bladeSystemRear.labelGigibitSwitch[i].isVisible()) continue;
            this.bladeSystemRear.labelGigibitSwitch[i].setIndicatorVisible(true);
        }
    }

    public void jSummaryCMMLabel_mouseClicked(MouseEvent e) {
    }

    public void jSummaryIBLabel_mouseClicked(MouseEvent e) {
    }

    public void jSummaryFailLabel_mouseClicked(MouseEvent e) {
        this.labelBladeGroup.setIndicatorUnique(false);
        this.labelBladeGroup.setIndicatorName(SUMMARY_FAILURE);
        Iterator iter = this.failureLabel.iterator();
        while (iter.hasNext()) {
            LabelBladeComponent item = (LabelBladeComponent)iter.next();
            item.setShowRedrectangular(true);
            item.repaint();
        }
    }

    public void jLegendLabel_mouseExited(MouseEvent e) {
        this.jLegendLabel.setCursor(new Cursor(0));
        this.jLegendLabel.setText(this.htmlString("Legend Help"));
    }

    public void jLegendLabel_mouseEntered(MouseEvent e) {
        this.jLegendLabel.setCursor(new Cursor(12));
        this.jLegendLabel.setText(this.underLineString("Legend Help"));
    }

    public void jLegendLabel_mouseClicked(MouseEvent e) {
        LegendHelpPanel legendHelpPanel = new LegendHelpPanel();
        JPanel p = new JPanel(new GridLayout(1, 1));
        p.add(legendHelpPanel);
        JOptionPane.showMessageDialog(IPMIView20.getInstance(), p, "Lenged Help", 1);
    }
}

