/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.AbstractMBSensorTableUIHelper;
import IPMIView20.blade.LabelBlade;
import IPMIView20.blade.MBSensorTableUIHelperFactory;
import IPMIView20.blade.SingleBladePanel_jCursorHereMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jErrorLEDCheckBox_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jGracefulPowerDownButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jGracefulShutdownMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPopupWindowMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerDownMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRefreshSIMBLIPButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRequestKVMButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jRequestKVMMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jResetButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jResetMenuItem_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jSetSIMBLIPButton_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jUIDCheckBoxMenuItem1_actionAdapter;
import IPMIView20.blade.SingleBladePanel_jUIDCheckBox_actionAdapter;
import IPMIView20.blade.SingleModuleAbstractPanel;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.IPMB;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.AbstractMBSensorEntity;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SingleBladePanel
extends SingleModuleAbstractPanel {
    TableSorter ts;
    AbstractMBSensorTableUIHelper mbSensorTableUIHelper;
    Icon listIcon = new ImageIcon(this.getClass().getResource("/images/list.gif"));
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okBlueIcon = new ImageIcon(this.getClass().getResource("/images/ok_blue.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon refresh16Icon = new ImageIcon(this.getClass().getResource("/images/Refresh16.gif"));
    Icon Preferences16Icon = new ImageIcon(this.getClass().getResource("/images/Preferences16.gif"));
    Icon edit16Icon = new ImageIcon(this.getClass().getResource("/images/Edit16.gif"));
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jLeftDownPanel = new JPanel();
    JPanel jLeftUpPanel = new JPanel();
    TitledBorder titledBorder2 = new TitledBorder("");
    GridLayout gridLayout3 = new GridLayout();
    JPanel jManagementPanel = new JPanel();
    JLabel jManagementLabel = new JLabel();
    JLabel jManagementStringLabel = new JLabel();
    JLabel jErrorLEDLabel = new JLabel();
    JLabel jErrorLEDStringLabel = new JLabel();
    JButton jRequestKVMButton = new JButton();
    JLabel jLabel6 = new JLabel();
    JLabel jUIDStringLabel = new JLabel();
    JLabel jKVMLabel = new JLabel();
    JLabel jUIDLabel = new JLabel();
    JLabel jKVMStringLabel = new JLabel();
    JLabel jBoardLabel = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JCheckBox jUIDCheckBox = new JCheckBox();
    JPanel jPowerControlPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    TitledBorder titledBorder3 = new TitledBorder("");
    JButton jResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    TitledBorder titledBorder4 = new TitledBorder("");
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jLanSettingPanel = new JPanel();
    JCheckBox jErrorLEDCheckBox = new JCheckBox();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel jLabel3 = new JLabel();
    JLabel jWattLabel = new JLabel();
    JLabel jWattStringLabel = new JLabel();
    TitledBorder titledBorder5 = new TitledBorder("");
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable jTable = null;
    TitledBorder titledBorder6 = new TitledBorder("");
    JToolBar jToolBar1 = new JToolBar();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanel7 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JLabel jLabel2 = new JLabel();
    JTextField jIPTextField = new JTextField();
    JButton jGracefulPowerDownButton = new JButton();
    BorderLayout borderLayout8 = new BorderLayout();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jGracefulShutdownMenuItem = new JMenuItem();
    JMenuItem jPowerDownMenuItem = new JMenuItem();
    JMenuItem jResetMenuItem = new JMenuItem();
    JMenuItem jRequestKVMMenuItem = new JMenuItem();
    JCheckBoxMenuItem jUIDCheckBoxMenuItem1 = new JCheckBoxMenuItem();
    JMenuItem jPopupWindowMenuItem = new JMenuItem();
    JMenuItem jCursorHereMenuItem = new JMenuItem();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    FlowLayout flowLayout2 = new FlowLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout9 = new BorderLayout();
    JLabel notPresent = new JLabel("Module not present");
    JToolBar jManagementSIMBLToolBar = new JToolBar();
    JButton jSetSIMBLIPButton = new JButton();
    JButton jRefreshSIMBLIPButton = new JButton();
    TitledBorder titledBorder7 = new TitledBorder("");
    boolean isGetSIMBL_IP = false;
    AbstractMBSensorEntity sensor;
    BladeSystemEntity bladeSystemEntity = null;
    String tempIP;

    public SingleBladePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void myInit() {
        this.jErrorLEDCheckBox.setVisible(false);
        this.showHeader();
        this.setIPMBFunctionEnable(false);
    }

    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jResetButton.setEnabled(false);
        this.jGracefulPowerDownButton.setEnabled(false);
        this.jUIDCheckBox.setEnabled(false);
        this.jManagementPanel.setVisible(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerDownMenuItem.setEnabled(false);
        this.jResetMenuItem.setEnabled(false);
        this.jGracefulShutdownMenuItem.setEnabled(false);
        this.jUIDCheckBoxMenuItem1.setEnabled(false);
    }

    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jUIDCheckBox.setEnabled(true);
        this.jManagementPanel.setVisible(true);
    }

    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jUIDCheckBox.setEnabled(true);
        this.jManagementPanel.setVisible(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setEnableControls(boolean isEnable) {
        this.jRequestKVMButton.setEnabled(isEnable);
        this.jResetButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jPowerOnButton.setEnabled(isEnable);
        this.jGracefulPowerDownButton.setEnabled(isEnable);
        this.jUIDCheckBox.setEnabled(isEnable);
    }

    private void jbInit() throws Exception {
        this.jTable = new JTable(){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        this.titledBorder6 = new TitledBorder("IPMI LAN(IPMB function)");
        this.titledBorder5 = new TitledBorder("Sensors");
        this.titledBorder4 = new TitledBorder("Management Module");
        this.titledBorder3 = new TitledBorder("Power Control");
        this.titledBorder2 = new TitledBorder("Status");
        this.titledBorder1 = new TitledBorder("Right");
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setLayout(this.borderLayout3);
        this.jRightPanel.setLayout(this.borderLayout4);
        this.jLeftPanel.setLayout(this.borderLayout8);
        this.jLeftUpPanel.setBorder(this.titledBorder2);
        this.jLeftUpPanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(0);
        this.jManagementStringLabel.setForeground(Color.blue);
        this.jManagementStringLabel.setText("BMC:");
        this.jErrorLEDStringLabel.setForeground(Color.blue);
        this.jErrorLEDStringLabel.setText("System Fault:");
        this.jRequestKVMButton.setPreferredSize(new Dimension(70, 23));
        this.jRequestKVMButton.setHorizontalTextPosition(10);
        this.jRequestKVMButton.setText("Request");
        this.jRequestKVMButton.addActionListener(new SingleBladePanel_jRequestKVMButton_actionAdapter(this));
        this.jUIDStringLabel.setForeground(Color.blue);
        this.jUIDStringLabel.setText("UID:");
        this.jUIDLabel.setIcon(null);
        this.jKVMStringLabel.setForeground(Color.blue);
        this.jKVMStringLabel.setText("KVM:");
        this.jPowerStatusLabel.setToolTipText("");
        this.jPowerStatusLabel.setIcon(null);
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText("Power Status:");
        this.jUIDCheckBox.setText("Enable");
        this.jUIDCheckBox.addActionListener(new SingleBladePanel_jUIDCheckBox_actionAdapter(this));
        this.jLeftDownPanel.setLayout(this.borderLayout2);
        this.jResetButton.setFont(new Font("Dialog", 1, 12));
        this.jResetButton.setForeground(Color.red);
        this.jResetButton.setPreferredSize(new Dimension(140, 25));
        this.jResetButton.setText("Reset");
        this.jResetButton.addActionListener(new SingleBladePanel_jResetButton_actionAdapter(this));
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setPreferredSize(new Dimension(140, 25));
        this.jPowerOffButton.setText("Power Down");
        this.jPowerOffButton.addActionListener(new SingleBladePanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setPreferredSize(new Dimension(140, 25));
        this.jPowerOnButton.setText("Power On");
        this.jPowerOnButton.addActionListener(new SingleBladePanel_jPowerOnButton_actionAdapter(this));
        this.jPowerControlPanel.setLayout(this.gridLayout2);
        this.jPowerControlPanel.setBorder(this.titledBorder3);
        this.jErrorLEDCheckBox.setForeground(Color.orange);
        this.jErrorLEDCheckBox.setText("Err LED[Test]");
        this.jErrorLEDCheckBox.addActionListener(new SingleBladePanel_jErrorLEDCheckBox_actionAdapter(this));
        this.jRightPanel.setBorder(null);
        this.jWattStringLabel.setForeground(Color.blue);
        this.jWattStringLabel.setText("Watt:");
        this.jPanel1.setLayout(this.borderLayout7);
        this.jPanel1.setBorder(this.titledBorder5);
        this.jLanSettingPanel.setBorder(this.titledBorder6);
        this.jLanSettingPanel.setLayout(this.gridLayout1);
        this.jToolBar1.setFloatable(false);
        this.jPanel7.setLayout(this.gridLayout5);
        this.gridLayout5.setColumns(2);
        this.jLabel2.setForeground(Color.blue);
        this.jLabel2.setText("IPMI IP:");
        this.setPreferredSize(new Dimension(680, 300));
        this.jGracefulPowerDownButton.setFont(new Font("Dialog", 1, 12));
        this.jGracefulPowerDownButton.setForeground(Color.red);
        this.jGracefulPowerDownButton.setPreferredSize(new Dimension(140, 25));
        this.jGracefulPowerDownButton.setText("Graceful Shutdown");
        this.jGracefulPowerDownButton.addActionListener(new SingleBladePanel_jGracefulPowerDownButton_actionAdapter(this));
        this.jPowerOnMenuItem.setText("Power On");
        this.jPowerOnMenuItem.addActionListener(new SingleBladePanel_jPowerOnMenuItem_actionAdapter(this));
        this.jGracefulShutdownMenuItem.setText("Graceful Shutdown");
        this.jGracefulShutdownMenuItem.addActionListener(new SingleBladePanel_jGracefulShutdownMenuItem_actionAdapter(this));
        this.jPowerDownMenuItem.setText("Power Down");
        this.jPowerDownMenuItem.addActionListener(new SingleBladePanel_jPowerDownMenuItem_actionAdapter(this));
        this.jResetMenuItem.setText("Reset");
        this.jResetMenuItem.addActionListener(new SingleBladePanel_jResetMenuItem_actionAdapter(this));
        this.jRequestKVMMenuItem.setText("Request KVM");
        this.jRequestKVMMenuItem.addActionListener(new SingleBladePanel_jRequestKVMMenuItem_actionAdapter(this));
        this.jUIDCheckBoxMenuItem1.setText("UID");
        this.jUIDCheckBoxMenuItem1.addActionListener(new SingleBladePanel_jUIDCheckBoxMenuItem1_actionAdapter(this));
        this.jPopupWindowMenuItem.setText("Popup Management Window");
        this.jPopupWindowMenuItem.addActionListener(new SingleBladePanel_jPopupWindowMenuItem_actionAdapter(this));
        this.jCursorHereMenuItem.setText("Focus Here");
        this.jCursorHereMenuItem.addActionListener(new SingleBladePanel_jCursorHereMenuItem_actionAdapter(this));
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jPanel3.setLayout(this.flowLayout1);
        this.jPanel2.setLayout(this.flowLayout2);
        this.flowLayout2.setAlignment(0);
        this.flowLayout1.setAlignment(0);
        this.jSetSIMBLIPButton.setToolTipText("Update");
        this.jSetSIMBLIPButton.setIcon(this.edit16Icon);
        this.jSetSIMBLIPButton.setMargin(new Insets(0, 0, 0, 0));
        this.jSetSIMBLIPButton.setText("Update");
        this.jSetSIMBLIPButton.addActionListener(new SingleBladePanel_jSetSIMBLIPButton_actionAdapter(this));
        this.jRefreshSIMBLIPButton.setToolTipText("Refresh");
        this.jRefreshSIMBLIPButton.setIcon(this.refresh16Icon);
        this.jRefreshSIMBLIPButton.setMargin(new Insets(0, 0, 0, 0));
        this.jRefreshSIMBLIPButton.addActionListener(new SingleBladePanel_jRefreshSIMBLIPButton_actionAdapter(this));
        this.jManagementSIMBLToolBar.setFloatable(false);
        this.jManagementPanel.setLayout(this.borderLayout9);
        this.add((Component)this.jCenterPanel, "Center");
        this.jLeftUpPanel.add(this.jPowerStatusStringLabel);
        this.jLeftUpPanel.add(this.jPowerStatusLabel);
        this.jLeftUpPanel.add(this.jBoardLabel);
        this.jLeftUpPanel.add(this.jKVMStringLabel);
        this.jLeftUpPanel.add(this.jKVMLabel);
        JPanel p = new JPanel();
        p.setLayout(this.borderLayout6);
        this.jLeftUpPanel.add(p);
        this.jLeftUpPanel.add(this.jUIDStringLabel);
        this.jLeftUpPanel.add(this.jUIDLabel);
        this.jLeftUpPanel.add(this.jUIDCheckBox);
        this.jLeftUpPanel.add(this.jErrorLEDStringLabel);
        this.jLeftUpPanel.add(this.jErrorLEDLabel);
        this.jLeftUpPanel.add(this.jLabel6);
        this.jLeftUpPanel.add(this.jManagementStringLabel);
        this.jLeftUpPanel.add(this.jManagementLabel);
        this.jLeftUpPanel.add(this.jManagementPanel);
        this.jManagementSIMBLToolBar.add(this.jSetSIMBLIPButton);
        this.jManagementSIMBLToolBar.addSeparator();
        this.jManagementSIMBLToolBar.add(this.jRefreshSIMBLIPButton);
        this.jPowerControlPanel.add(this.jPanel3);
        this.jPanel3.add(this.jPowerOnButton);
        this.jPanel3.add(this.jResetButton);
        this.jPowerControlPanel.add(this.jPanel2);
        this.jPanel2.add(this.jGracefulPowerDownButton);
        this.jPanel2.add(this.jPowerOffButton);
        this.jLanSettingPanel.add(this.jPanel7);
        this.jPanel7.add(this.jLabel2);
        this.jPanel7.add(this.jIPTextField);
        p.add((Component)this.jRequestKVMButton, "Center");
        this.jLeftUpPanel.add(this.jWattStringLabel);
        this.jLeftUpPanel.add(this.jWattLabel);
        this.jLeftUpPanel.add(this.jErrorLEDCheckBox);
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.add((Component)this.jToolBar1, "North");
        this.jScrollPane1.getViewport().add(this.jTable);
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jGracefulShutdownMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerDownMenuItem);
        this.jPopupMenuForLabel.add(this.jResetMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jRequestKVMMenuItem);
        this.jPopupMenuForLabel.add(this.jUIDCheckBoxMenuItem1);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jCursorHereMenuItem);
        this.jLeftDownPanel.add((Component)this.jPowerControlPanel, "Center");
        this.jLeftPanel.add((Component)this.jLeftUpPanel, "North");
        this.jLeftPanel.add((Component)this.jLeftDownPanel, "Center");
        this.jManagementPanel.add((Component)this.jManagementSIMBLToolBar, "Center");
        this.jRightPanel.add((Component)this.jPanel1, "Center");
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SingleBladePanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SingleBladePanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        boolean isPowerOff = false;
        BladeEntity blade = this.bladeSystemEntity.getBlades()[this.moduleIndex - 1];
        this.sensor = this.bladeSystemEntity.getMbSensors()[this.moduleIndex - 1];
        if (blade.getPresent() == 0) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        boolean powerSupply = true;
        if (blade.isV12vEnable() && blade.isV3_3v() && powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOnIcon);
            this.jPowerStatusLabel.setText("On");
        } else if (!blade.isV12vEnable() && !blade.isV3_3v()) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText("Off");
            isPowerOff = true;
        } else if (blade.isV12vEnable() && !blade.isV3_3v() && powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText("Off");
            isPowerOff = true;
        } else if (!powerSupply) {
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            this.jPowerStatusLabel.setText("Off");
            isPowerOff = true;
        }
        if (blade.getKvmEnable() > 0) {
            this.jKVMLabel.setIcon(this.okBlueIcon);
            this.jKVMLabel.setText("Selected");
        } else {
            this.jKVMLabel.setIcon(null);
            this.jKVMLabel.setText("Non-Selected");
        }
        if (blade.getUidEnable() > 0) {
            this.jUIDLabel.setIcon(this.uidLEDOnIcon);
            this.jUIDLabel.setText("On");
            this.jUIDCheckBox.setSelected(true);
            this.jUIDCheckBoxMenuItem1.setSelected(true);
        } else {
            this.jUIDLabel.setIcon(this.uidLEDOffIcon);
            this.jUIDLabel.setText("Off");
            this.jUIDCheckBox.setSelected(false);
            this.jUIDCheckBoxMenuItem1.setSelected(false);
        }
        if (blade.isError1LED()) {
            this.jErrorLEDLabel.setIcon(this.xRedIcon);
            this.jErrorLEDLabel.setForeground(Color.RED);
            this.jErrorLEDLabel.setText("Error");
        } else {
            this.jErrorLEDLabel.setIcon(this.okGreenIcon);
            this.jErrorLEDLabel.setForeground(Color.GREEN);
            this.jErrorLEDLabel.setText("Normal");
        }
        if (blade.isSimCardDetectPin()) {
            if (this.bladeSystemEntity.isIsSupportIPMB() && this.bladeSystemEntity.getIsMaster()) {
                this.helpShowSIMBL_IP_ViaIPMB();
            } else {
                this.helpShowSIMBLInstalledWithoutIPMBSupport();
            }
        } else {
            this.jManagementLabel.setForeground(Color.BLACK);
            this.jManagementLabel.setText("Not Installed");
            this.jSetSIMBLIPButton.setEnabled(false);
            this.jRefreshSIMBLIPButton.setEnabled(false);
        }
        this.jWattLabel.setText("" + blade.getWattByFormula());
        if (this.mbSensorTableUIHelper == null || !MBSensorTableUIHelperFactory.checkUIHelperType(blade.getMBModel(), this.mbSensorTableUIHelper)) {
            this.mbSensorTableUIHelper = MBSensorTableUIHelperFactory.createMBSensorTableUIHelper(blade.getMBModel(), this.jTable, this.ts);
            this.mbSensorTableUIHelper.removeAllRaw();
        }
        if (isPowerOff) {
            this.mbSensorTableUIHelper.removeAllRaw();
        } else if ((this.sensor.getFlag() & 1) == 1) {
            this.mbSensorTableUIHelper.updateTable(this.sensor);
        }
        String mbName = blade.getMBModelName();
        if (mbName != null) {
            this.titledBorder5 = new TitledBorder(mbName + " Sensors");
            this.jPanel1.setBorder(this.titledBorder5);
        } else {
            this.titledBorder5 = new TitledBorder("Sensors");
            this.jPanel1.setBorder(this.titledBorder5);
        }
    }

    private void helpShowSIMBLInstalledWithoutIPMBSupport() {
        this.jManagementLabel.setForeground(Color.BLUE);
        this.jSetSIMBLIPButton.setEnabled(false);
        this.jRefreshSIMBLIPButton.setEnabled(false);
        this.jManagementLabel.setText("Installed");
    }

    private void helpShowSIMBL_IP_ViaIPMB() {
        this.jManagementLabel.setForeground(Color.BLUE);
        this.jSetSIMBLIPButton.setEnabled(true);
        this.jRefreshSIMBLIPButton.setEnabled(true);
        if (!this.isGetSIMBL_IP) {
            this.jManagementLabel.setText("Refresh ...");
            Thread thread = new Thread(){

                public void run() {
                    SingleBladePanel.this.getSIMBLIPViaIPMB();
                }
            };
            thread.start();
            this.isGetSIMBL_IP = true;
        }
    }

    private void setIPMBFunctionEnable(boolean isEnable) {
        this.jIPTextField.setEnabled(isEnable);
    }

    public void jRequestKVMButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SingleBladePanel.this.requestKVM();
            }
        };
        thread.start();
    }

    private void requestKVM() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.requestKVM((byte)this.moduleIndex);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Request KVM failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jUIDCheckBox_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SingleBladePanel.this.setUID();
            }
        };
        thread.start();
    }

    private void setUID() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = this.jUIDCheckBox.isSelected() ? ipmiCMMOEMCommand.setBladeUID((byte)this.moduleIndex, (byte)1) : ipmiCMMOEMCommand.setBladeUID((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Set UID failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), "Are you sure that you want to power on ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                b = ipmiCMMOEMCommand.enableP12V((byte)this.moduleIndex, (byte)1);
                if (b != 0) {
                    if (b == 1) {
                        JOptionPane.showMessageDialog(this.findParentFrame(), "Not enough Power");
                    } else if (b == 99) {
                        JOptionPane.showMessageDialog(this.findParentFrame(), "Power on failed");
                    }
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), "Are you sure that you want to power off ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                b = ipmiCMMOEMCommand.enableP12V((byte)this.moduleIndex, (byte)0);
                if (b != 0 && b == 99) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power off failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jResetButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), "Are you sure that you want to reset ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.reset();
            }
        };
        thread.start();
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.resetBlade((byte)this.moduleIndex);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Reset failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public void jErrorLEDCheckBox_actionPerformed(ActionEvent e) {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = this.jErrorLEDCheckBox.isSelected() ? ipmiCMMOEMCommand.testBladeErrorLED((byte)this.moduleIndex, (byte)1) : ipmiCMMOEMCommand.testBladeErrorLED((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Set Error LED failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public Object clone() {
        SingleBladePanel singleBladePanel = new SingleBladePanel();
        singleBladePanel.moduleIndex = this.moduleIndex;
        return singleBladePanel;
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        DefaultTableModel dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(dtm);
        this.jTable.setModel(this.ts);
        this.jTable.getColumnModel().getColumn(0).setPreferredWidth(25);
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(" ");
        headerList.add(L.t("Sensor") + "    ");
        headerList.add(L.t("Reading") + "    ");
        headerList.add(L.t("Low Limit"));
        headerList.add(L.t("High Limit"));
        return headerList;
    }

    public void jGracefulPowerDownButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleBladePanel.this.findParentFrame(), "Are you sure that you want to graceful shutdown ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleBladePanel.this.gracefulShutdown();
            }
        };
        thread.start();
    }

    private void gracefulShutdown() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            try {
                boolean b = ipmiCMMOEMCommand.gracefulPowerDownBlade((byte)this.moduleIndex);
                if (b) {
                    this.xMessage.setText("Graceful shutdown sent");
                } else {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Graceful shutdown failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.getMessage());
            }
        }
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jGracefulShutdownMenuItem_actionPerformed(ActionEvent e) {
        this.jGracefulPowerDownButton_actionPerformed(null);
    }

    public void jPowerDownMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jResetMenuItem_actionPerformed(ActionEvent e) {
        this.jResetButton_actionPerformed(null);
    }

    public void jRequestKVMMenuItem_actionPerformed(ActionEvent e) {
        this.jRequestKVMButton_actionPerformed(null);
    }

    public void jUIDCheckBoxMenuItem1_actionPerformed(ActionEvent e) {
        if (this.jUIDCheckBoxMenuItem1.isSelected()) {
            this.jUIDCheckBox.setSelected(true);
        } else {
            this.jUIDCheckBox.setSelected(false);
        }
        this.jUIDCheckBox_actionPerformed(null);
    }

    public void jPopupWindowMenuItem_actionPerformed(ActionEvent e) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemFront.labelBlades[this.moduleIndex - 1]);
    }

    public void jCursorHereMenuItem_actionPerformed(ActionEvent e) {
        LabelBlade c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemFront.labelBlades[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Front");
        c.labelBladeGroup.setIndicatorUnique(true);
        c.setIndicatorVisible(true);
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }

    public void getSIMBLIPViaIPMB() {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.moduleIndex);
        if (sessionController != null) {
            String ip = ipmiLanCommand.getIP();
            if (ip != null) {
                this.jManagementLabel.setText(ip);
            } else {
                this.jManagementLabel.setText("Installed");
            }
            sessionController.closeSession();
        }
    }

    public void jRefreshSIMBLIPButton_actionPerformed(ActionEvent e) {
        this.jManagementLabel.setText("Refresh ...");
        Thread thread = new Thread(){

            public void run() {
                SingleBladePanel.this.getSIMBLIPViaIPMB();
            }
        };
        thread.start();
    }

    public void jSetSIMBLIPButton_actionPerformed(ActionEvent e) {
        this.showSIMBLIPConfigDialog();
    }

    public void showSIMBLIPConfigDialog() {
        int result;
        Object[] message = new Object[1];
        JPanel p = new JPanel();
        JLabel l = new JLabel("BMC IP:");
        JTextField t = new JTextField(18);
        if (IPMILanCommand.isIPAddress(this.jManagementLabel.getText())) {
            t.setText(this.jManagementLabel.getText());
        }
        p.add(l);
        p.add(t);
        t.requestFocus();
        message[0] = p;
        boolean flag = true;
        while (flag && (result = JOptionPane.showOptionDialog(this.findParentFrame(), message, L.t("Management IP"), 2, 1, null, null, null)) == 0) {
            boolean b1 = IPMILanCommand.isIPAddress(t.getText());
            if (!b1) {
                JOptionPane.showMessageDialog(this.findParentFrame(), "IP format error !!");
                t.setText(this.jManagementLabel.getText());
                continue;
            }
            if (t.getText().equals(this.jManagementLabel.getText())) break;
            this.tempIP = t.getText();
            Thread thread = new Thread(){

                public void run() {
                    SingleBladePanel.this.helpUpdateSIMBLIP(SingleBladePanel.this.tempIP);
                }
            };
            thread.start();
            flag = false;
        }
    }

    private void helpUpdateSIMBLIP(String ip) throws HeadlessException {
        this.jManagementLabel.setText("Updating ...");
        boolean b2 = this.setSIMBLIPViaIPMB(ip);
        if (b2) {
            this.jManagementLabel.setText("OK");
        } else {
            this.jManagementLabel.setText("Failed");
        }
        this.jRefreshSIMBLIPButton_actionPerformed(null);
    }

    public boolean setSIMBLIPViaIPMB(String ip) {
        IPMILanCommand ipmiLanCommand = new IPMILanCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiLanCommand);
        IPMB ipmb = new IPMB(ipmiLanCommand.getIPMIInterface());
        ipmiLanCommand.setIPMIInterface(ipmb);
        ipmb.setChannel((byte)this.moduleIndex);
        boolean b = false;
        if (sessionController != null) {
            b = ipmiLanCommand.setIP(ip);
            sessionController.closeSession();
        }
        return b;
    }
}

