/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.JVolPanel;
import IPMIView20.blade.LabelInfiniBand;
import IPMIView20.blade.SingleInfiniBandPanel_jFocusHereMenuItem_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jPopupManagementWindowMenuItem_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jPowerOffMenuItem_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jResetButton_actionAdapter;
import IPMIView20.blade.SingleInfiniBandPanel_jResetMenuItem_actionAdapter;
import IPMIView20.blade.SingleModuleAbstractPanel;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.InfiniBandEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.Observable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SingleInfiniBandPanel
extends SingleModuleAbstractPanel {
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static int VOLTAGE_33V_AUX_FULL_SCALE = 5;
    public static int VOLTAGE_VVDD_FULL_SCALE = 2;
    public static int VOLTAGE_12V_FULL_SCALE = 2;
    public static int VOLTAGE_18V_FULL_SCALE = 2;
    public static int VOLTAGE_33V_FULL_SCALE = 5;
    boolean isPowerOffFlag = false;
    boolean initSensors = false;
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    JTempPanel temperature = new JTempPanel();
    JVolPanel v33vAuxVoltage = new JVolPanel();
    JVolPanel vvddVoltage = new JVolPanel();
    JVolPanel v12vVoltage = new JVolPanel();
    JVolPanel v18vVoltage = new JVolPanel();
    JVolPanel v33vVoltage = new JVolPanel();
    JLabel notPresent = new JLabel("Module not present");
    BladeSystemEntity bladeSystemEntity = null;
    JPanel jCenterPanel = new JPanel();
    JPanel jVoltagePanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    TitledBorder titledBorder1 = new TitledBorder("");
    JPanel jPanel1 = new JPanel();
    JPanel jStatusPanel = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    JPanel jPanel5 = new JPanel();
    JPanel jPanel6 = new JPanel();
    JPanel jPanel7 = new JPanel();
    JPanel jPanel8 = new JPanel();
    JPanel jPanel9 = new JPanel();
    GridLayout gridLayout4 = new GridLayout();
    GridLayout gridLayout5 = new GridLayout();
    GridLayout gridLayout6 = new GridLayout();
    GridLayout gridLayout7 = new GridLayout();
    GridLayout gridLayout8 = new GridLayout();
    GridLayout gridLayout9 = new GridLayout();
    GridLayout gridLayout10 = new GridLayout();
    JLabel jPowerStatusStringLabel = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jInitializedStringLabel = new JLabel();
    JLabel jLabel5 = new JLabel();
    JLabel jInitializedLabel = new JLabel();
    JLabel j33vAuxStringLabel = new JLabel();
    JLabel jLabel8 = new JLabel();
    JLabel j33vAuxLabel = new JLabel();
    JLabel j12vStringLabel = new JLabel();
    JLabel jLabel11 = new JLabel();
    JLabel j12vLabel = new JLabel();
    JLabel j18vStringLabel = new JLabel();
    JLabel jLabel14 = new JLabel();
    JLabel j18vLabel = new JLabel();
    JLabel j33vStringLabel = new JLabel();
    JLabel jLabel17 = new JLabel();
    JLabel j33vLabel = new JLabel();
    JLabel jTempStringLabel = new JLabel();
    JLabel jLabel20 = new JLabel();
    JLabel jtempLabel = new JLabel();
    TitledBorder titledBorder2 = new TitledBorder("");
    BorderLayout borderLayout1 = new BorderLayout();
    TitledBorder titledBorder3 = new TitledBorder("");
    JPanel jPowerControlPanel = new JPanel();
    TitledBorder titledBorder4 = new TitledBorder("");
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton jResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jVol2Panel = new JPanel();
    JPanel jVol1Panel = new JPanel();
    JPanel jVol3Panel = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JPanel jPanel10 = new JPanel();
    JLabel jLabel1 = new JLabel();
    JLabel jvvddLabel = new JLabel();
    JLabel jvvddStringLabel = new JLabel();
    GridLayout gridLayout11 = new GridLayout();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jPowerOffMenuItem = new JMenuItem();
    JMenuItem jResetMenuItem = new JMenuItem();
    JMenuItem jPopupManagementWindowMenuItem = new JMenuItem();
    JMenuItem jFocusHereMenuItem = new JMenuItem();

    public SingleInfiniBandPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setEnableControls(boolean isEnable) {
        this.jPowerOnButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jResetButton.setEnabled(isEnable);
    }

    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jResetButton.setEnabled(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerOffMenuItem.setEnabled(false);
        this.jResetMenuItem.setEnabled(false);
    }

    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
    }

    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    private void myInit() throws Exception {
        this.temperature.tempMeter.setPreferredSize(new Dimension(120, 28));
        this.v33vAuxVoltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.vvddVoltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.v12vVoltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.v18vVoltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.v33vVoltage.volMeter.setPreferredSize(new Dimension(98, 58));
        this.jVol1Panel.add(this.temperature);
        this.jVol1Panel.add(this.vvddVoltage);
        this.jVol2Panel.add(this.v33vAuxVoltage);
        this.jVol2Panel.add(this.v12vVoltage);
        this.jVol3Panel.add(this.v18vVoltage);
        this.jVol3Panel.add(this.v33vVoltage);
        this.temperature.init("Board", (byte)0, (byte)0, "", "");
        this.v33vAuxVoltage.init("3.3V AUX", (byte)0, (byte)0, (byte)0, "", "", "");
        this.vvddVoltage.init("VVDD", (byte)0, (byte)0, (byte)0, "", "", "");
        this.v12vVoltage.init("1.2V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.v18vVoltage.init("1.8V", (byte)0, (byte)0, (byte)0, "", "", "");
        this.v33vVoltage.init("3.3V", (byte)0, (byte)0, (byte)0, "", "", "");
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SingleInfiniBandPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SingleInfiniBandPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        InfiniBandEntity infiniBandEntity = this.bladeSystemEntity.getInfiniBands()[this.moduleIndex - 1];
        if (infiniBandEntity.getPresent() == 0) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        if (infiniBandEntity.isPowerOn()) {
            this.jPowerStatusLabel.setText("On");
            this.jPowerStatusLabel.setIcon(this.powerOnIcon);
            if (this.isPowerOffFlag && (infiniBandEntity.getFlag() & 1) == 1) {
                this.helpShowUIForPowerOn();
            }
        } else {
            this.jPowerStatusLabel.setText("Off");
            this.jPowerStatusLabel.setIcon(this.powerOffIcon);
            if (!this.isPowerOffFlag) {
                this.helpShowUIForPowerOff();
            }
        }
        if (infiniBandEntity.getInitialized() > 0) {
            this.jInitializedLabel.setIcon(this.okGreenIcon);
            this.jInitializedLabel.setForeground(Color.GREEN);
            this.jInitializedLabel.setText("OK");
        } else {
            this.jInitializedLabel.setIcon(this.xRedIcon);
            this.jInitializedLabel.setForeground(Color.RED);
            this.jInitializedLabel.setText("Error");
        }
        if (infiniBandEntity.getTemperature() < 80) {
            this.jtempLabel.setIcon(this.okGreenIcon);
            this.jtempLabel.setForeground(Color.GREEN);
            this.jtempLabel.setText("Normal");
        } else {
            this.jtempLabel.setIcon(this.xRedIcon);
            this.jtempLabel.setForeground(Color.RED);
            this.jtempLabel.setText("Error");
        }
        byte temp = infiniBandEntity.getTemperature();
        byte tempLimit = 80;
        double v33vAux = infiniBandEntity.getV33AuxFormula();
        double v33vAuxLowLimit = 2.9699999999999998;
        double v33vAuxHighLimit = 3.63;
        byte v33vAuxRatio = (byte)(v33vAux * 256.0 / (double)VOLTAGE_33V_AUX_FULL_SCALE);
        byte v33vAuxLowLimitRatio = (byte)(v33vAuxLowLimit * 256.0 / (double)VOLTAGE_33V_AUX_FULL_SCALE);
        byte v33vAuxHighLimitRatio = (byte)(v33vAuxHighLimit * 256.0 / (double)VOLTAGE_33V_AUX_FULL_SCALE);
        String v33vAuxString = this.doubleToString(v33vAux);
        String v33vAuxLowLimitString = this.doubleToString(v33vAuxLowLimit);
        String v33vAuxHighLimitString = this.doubleToString(v33vAuxHighLimit);
        double vvdd = infiniBandEntity.getVvddFormula();
        double vvddLowLimit = 1.4400000000000002;
        double vvddHighLimit = 1.7600000000000002;
        byte vvddRatio = (byte)(vvdd * 256.0 / (double)VOLTAGE_VVDD_FULL_SCALE);
        byte vvddLowLimitRatio = (byte)(vvddLowLimit * 256.0 / (double)VOLTAGE_VVDD_FULL_SCALE);
        byte vvddHighLimitRatio = (byte)(vvddHighLimit * 256.0 / (double)VOLTAGE_VVDD_FULL_SCALE);
        String vvddString = this.doubleToString(vvdd);
        String vvddLowLimitString = this.doubleToString(vvddLowLimit);
        String vvddHighLimitString = this.doubleToString(vvddHighLimit);
        double v12 = infiniBandEntity.getV12Formula();
        double v12LowLimit = 1.08;
        double v12HighLimit = 1.32;
        byte v12Ratio = (byte)(v12 * 256.0 / (double)VOLTAGE_12V_FULL_SCALE);
        byte v12LowLimitRatio = (byte)(v12LowLimit * 256.0 / (double)VOLTAGE_12V_FULL_SCALE);
        byte v12HighLimitRatio = (byte)(v12HighLimit * 256.0 / (double)VOLTAGE_12V_FULL_SCALE);
        String v12String = this.doubleToString(v12);
        String v12LowLimitString = this.doubleToString(v12LowLimit);
        String v12HighLimitString = this.doubleToString(v12HighLimit);
        double v18 = infiniBandEntity.getV18Formula();
        double v18LowLimit = 1.62;
        double v18HighLimit = 1.9800000000000002;
        byte v18Ratio = (byte)(v18 * 256.0 / (double)VOLTAGE_18V_FULL_SCALE);
        byte v18LowLimitRatio = (byte)(v18LowLimit * 256.0 / (double)VOLTAGE_18V_FULL_SCALE);
        byte v18HighLimitRatio = (byte)(v18HighLimit * 256.0 / (double)VOLTAGE_18V_FULL_SCALE);
        String v18String = this.doubleToString(v18);
        String v18LowLimitString = this.doubleToString(v18LowLimit);
        String v18HighLimitString = this.doubleToString(v18HighLimit);
        double v33 = infiniBandEntity.getV33Formula();
        double v33LowLimit = 2.9699999999999998;
        double v33HighLimit = 3.63;
        byte v33Ratio = (byte)(v33 * 256.0 / (double)VOLTAGE_33V_FULL_SCALE);
        byte v33LowLimitRatio = (byte)(v33LowLimit * 256.0 / (double)VOLTAGE_33V_FULL_SCALE);
        byte v33HighLimitRatio = (byte)(v33HighLimit * 256.0 / (double)VOLTAGE_33V_FULL_SCALE);
        String v33String = this.doubleToString(v33);
        String v33LowLimitString = this.doubleToString(v33LowLimit);
        String v33HighLimitString = this.doubleToString(v33HighLimit);
        if (!this.initSensors) {
            this.temperature.init("Board ", temp, tempLimit, "" + temp, "" + tempLimit);
            this.v33vAuxVoltage.init("3.3V Aux", v33vAuxRatio, v33vAuxHighLimitRatio, v33vAuxLowLimitRatio, v33vAuxString, v33vAuxHighLimitString, v33vAuxLowLimitString);
            this.vvddVoltage.init("VVDD", vvddRatio, vvddHighLimitRatio, vvddLowLimitRatio, vvddString, vvddHighLimitString, vvddLowLimitString);
            this.v12vVoltage.init("1.2 V", v12Ratio, v12HighLimitRatio, v12LowLimitRatio, v12String, v12HighLimitString, v12LowLimitString);
            this.v18vVoltage.init("1.8 V", v18Ratio, v18HighLimitRatio, v18LowLimitRatio, v18String, v18HighLimitString, v18LowLimitString);
            this.v33vVoltage.init("3.3 V", v33Ratio, v33HighLimitRatio, v33LowLimitRatio, v33String, v33HighLimitString, v33LowLimitString);
            this.initSensors = true;
        }
        if (v33vAux < v33vAuxLowLimit || v33vAux > v33vAuxHighLimit) {
            this.j33vAuxLabel.setIcon(this.xRedIcon);
            this.j33vAuxLabel.setForeground(Color.RED);
            this.j33vAuxLabel.setText("Abnormal");
        } else {
            this.j33vAuxLabel.setIcon(this.okGreenIcon);
            this.j33vAuxLabel.setForeground(Color.GREEN);
            this.j33vAuxLabel.setText("Normal");
        }
        if (vvdd < vvddLowLimit || vvdd > vvddHighLimit) {
            this.jvvddLabel.setIcon(this.xRedIcon);
            this.jvvddLabel.setForeground(Color.RED);
            this.jvvddLabel.setText("Abnormal");
        } else {
            this.jvvddLabel.setIcon(this.okGreenIcon);
            this.jvvddLabel.setForeground(Color.GREEN);
            this.jvvddLabel.setText("Normal");
        }
        if (v12 < v12LowLimit || v12 > v12HighLimit) {
            this.j12vLabel.setIcon(this.xRedIcon);
            this.j12vLabel.setForeground(Color.RED);
            this.j12vLabel.setText("Abnormal");
        } else {
            this.j12vLabel.setIcon(this.okGreenIcon);
            this.j12vLabel.setForeground(Color.GREEN);
            this.j12vLabel.setText("Normal");
        }
        if (v18 < v18LowLimit || v18 > v18HighLimit) {
            this.j18vLabel.setIcon(this.xRedIcon);
            this.j18vLabel.setForeground(Color.RED);
            this.j18vLabel.setText("Abnormal");
        } else {
            this.j18vLabel.setIcon(this.okGreenIcon);
            this.j18vLabel.setForeground(Color.GREEN);
            this.j18vLabel.setText("Normal");
        }
        if (v33 < v33LowLimit || v33 > v33HighLimit) {
            this.j33vLabel.setIcon(this.xRedIcon);
            this.j33vLabel.setForeground(Color.RED);
            this.j33vLabel.setText("Abnormal");
        } else {
            this.j33vLabel.setIcon(this.okGreenIcon);
            this.j33vLabel.setForeground(Color.GREEN);
            this.j33vLabel.setText("Normal");
        }
        if (infiniBandEntity.isPowerOn()) {
            this.temperature.updateValue(temp, "" + temp);
            this.v33vAuxVoltage.updateValue(v33vAuxRatio, v33vAuxString);
            this.vvddVoltage.updateValue(vvddRatio, vvddString);
            this.v12vVoltage.updateValue(v12Ratio, v12String);
            this.v18vVoltage.updateValue(v18Ratio, v18String);
            this.v33vVoltage.updateValue(v33Ratio, v33String);
        }
    }

    public double underZero2Digit(double a, double b) {
        double value = a * b;
        return value / 100.0;
    }

    private void helpShowUIForPowerOn() {
        this.jInitializedLabel.setVisible(true);
        this.j33vAuxLabel.setVisible(true);
        this.jvvddLabel.setVisible(true);
        this.j12vLabel.setVisible(true);
        this.j18vLabel.setVisible(true);
        this.j33vLabel.setVisible(true);
        this.jtempLabel.setVisible(true);
        this.isPowerOffFlag = false;
    }

    private void helpShowUIForPowerOff() {
        this.jInitializedLabel.setVisible(false);
        this.j33vAuxLabel.setVisible(false);
        this.jvvddLabel.setVisible(false);
        this.j12vLabel.setVisible(false);
        this.j18vLabel.setVisible(false);
        this.j33vLabel.setVisible(false);
        this.jtempLabel.setVisible(false);
        this.temperature.setNA();
        this.v33vAuxVoltage.setNA();
        this.vvddVoltage.setNA();
        this.v12vVoltage.setNA();
        this.v18vVoltage.setNA();
        this.v33vVoltage.setNA();
        this.isPowerOffFlag = true;
    }

    public String doubleToString(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d;
    }

    public String doubleToString4(double value) {
        int temp = (int)(value * 10000.0);
        double d = (double)temp / 10000.0;
        return "" + d;
    }

    private void jbInit() throws Exception {
        this.titledBorder4 = new TitledBorder("Power Control");
        this.titledBorder3 = new TitledBorder("Temperature");
        this.titledBorder2 = new TitledBorder("Status");
        this.titledBorder1 = new TitledBorder("Voltage and Temperature");
        this.jCenterPanel.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(2);
        this.jVoltagePanel.setBorder(this.titledBorder1);
        this.jVoltagePanel.setLayout(this.gridLayout2);
        this.jLeftPanel.setLayout(this.borderLayout1);
        this.jStatusPanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(1);
        this.gridLayout3.setRows(8);
        this.jPanel3.setLayout(this.gridLayout4);
        this.jPanel9.setLayout(this.gridLayout5);
        this.jPanel8.setLayout(this.gridLayout6);
        this.jPanel7.setLayout(this.gridLayout7);
        this.jPanel6.setLayout(this.gridLayout8);
        this.jPanel5.setLayout(this.gridLayout9);
        this.jPanel4.setLayout(this.gridLayout10);
        this.gridLayout4.setColumns(3);
        this.gridLayout10.setColumns(3);
        this.gridLayout9.setColumns(3);
        this.gridLayout8.setColumns(3);
        this.gridLayout7.setColumns(3);
        this.gridLayout6.setColumns(3);
        this.gridLayout5.setColumns(3);
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText("Power Status:");
        this.jInitializedStringLabel.setForeground(Color.blue);
        this.jInitializedStringLabel.setText("Initialized:");
        this.j33vAuxStringLabel.setForeground(Color.blue);
        this.j33vAuxStringLabel.setText("3.3V AUX:");
        this.j12vStringLabel.setForeground(Color.blue);
        this.j12vStringLabel.setText("1.2V:");
        this.j18vStringLabel.setForeground(Color.blue);
        this.j18vStringLabel.setText("1.8V:");
        this.j33vStringLabel.setForeground(Color.blue);
        this.j33vStringLabel.setText("3.3V:");
        this.jTempStringLabel.setForeground(Color.blue);
        this.jTempStringLabel.setText("Temperature:");
        this.jStatusPanel.setBorder(this.titledBorder2);
        this.jPowerControlPanel.setBorder(this.titledBorder4);
        this.jPanel2.setLayout(this.borderLayout2);
        this.jResetButton.setFont(new Font("Dialog", 1, 12));
        this.jResetButton.setForeground(Color.red);
        this.jResetButton.setText("Reset");
        this.jResetButton.addActionListener(new SingleInfiniBandPanel_jResetButton_actionAdapter(this));
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setText("Power Off");
        this.jPowerOffButton.addActionListener(new SingleInfiniBandPanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setText("Power On");
        this.jPowerOnButton.addActionListener(new SingleInfiniBandPanel_jPowerOnButton_actionAdapter(this));
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(3);
        this.jVol3Panel.setLayout(this.flowLayout1);
        this.jvvddStringLabel.setForeground(Color.blue);
        this.jvvddStringLabel.setText("VVDD:");
        this.jPanel10.setLayout(this.gridLayout11);
        this.gridLayout11.setColumns(3);
        this.jPowerOnMenuItem.setText("Power On");
        this.jPowerOnMenuItem.addActionListener(new SingleInfiniBandPanel_jPowerOnMenuItem_actionAdapter(this));
        this.jPowerOffMenuItem.setText("Power Off");
        this.jPowerOffMenuItem.addActionListener(new SingleInfiniBandPanel_jPowerOffMenuItem_actionAdapter(this));
        this.jResetMenuItem.setText("Reset");
        this.jResetMenuItem.addActionListener(new SingleInfiniBandPanel_jResetMenuItem_actionAdapter(this));
        this.jPopupManagementWindowMenuItem.setText("Popup Management Window");
        this.jPopupManagementWindowMenuItem.addActionListener(new SingleInfiniBandPanel_jPopupManagementWindowMenuItem_actionAdapter(this));
        this.jFocusHereMenuItem.setText("Focus Here");
        this.jFocusHereMenuItem.addActionListener(new SingleInfiniBandPanel_jFocusHereMenuItem_actionAdapter(this));
        this.add((Component)this.jCenterPanel, "Center");
        this.jCenterPanel.add(this.jLeftPanel);
        this.jStatusPanel.add(this.jPanel3);
        this.jPanel3.add(this.jPowerStatusStringLabel);
        this.jPanel3.add(this.jPowerStatusLabel);
        this.jPanel3.add(this.jLabel2);
        this.jStatusPanel.add(this.jPanel9);
        this.jPanel9.add(this.jInitializedStringLabel);
        this.jPanel9.add(this.jInitializedLabel);
        this.jPanel9.add(this.jLabel5);
        this.jStatusPanel.add(this.jPanel10);
        this.jPanel10.add(this.jvvddStringLabel);
        this.jPanel10.add(this.jvvddLabel);
        this.jPanel10.add(this.jLabel1);
        this.jStatusPanel.add(this.jPanel8);
        this.jPanel8.add(this.j33vAuxStringLabel);
        this.jPanel8.add(this.j33vAuxLabel);
        this.jPanel8.add(this.jLabel8);
        this.jStatusPanel.add(this.jPanel7);
        this.jPanel7.add(this.j12vStringLabel);
        this.jPanel7.add(this.j12vLabel);
        this.jPanel7.add(this.jLabel11);
        this.jStatusPanel.add(this.jPanel6);
        this.jPanel6.add(this.j18vStringLabel);
        this.jPanel6.add(this.j18vLabel);
        this.jPanel6.add(this.jLabel14);
        this.jStatusPanel.add(this.jPanel5);
        this.jPanel5.add(this.j33vStringLabel);
        this.jPanel5.add(this.j33vLabel);
        this.jPanel5.add(this.jLabel17);
        this.jStatusPanel.add(this.jPanel4);
        this.jPanel4.add(this.jTempStringLabel);
        this.jPanel4.add(this.jtempLabel);
        this.jPanel4.add(this.jLabel20);
        this.jCenterPanel.add(this.jVoltagePanel);
        this.jVoltagePanel.add(this.jVol1Panel);
        this.jVoltagePanel.add(this.jVol2Panel);
        this.jPowerControlPanel.add(this.jPowerOnButton);
        this.jPowerControlPanel.add(this.jPowerOffButton);
        this.jPowerControlPanel.add(this.jResetButton);
        this.jVoltagePanel.add(this.jVol3Panel);
        this.jPanel2.add((Component)this.jPowerControlPanel, "North");
        this.jLeftPanel.add((Component)this.jStatusPanel, "Center");
        this.jLeftPanel.add((Component)this.jPanel2, "South");
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerOffMenuItem);
        this.jPopupMenuForLabel.add(this.jResetMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupManagementWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jFocusHereMenuItem);
    }

    public Object clone() {
        SingleInfiniBandPanel singleInfiniBandPanel = new SingleInfiniBandPanel();
        singleInfiniBandPanel.moduleIndex = this.moduleIndex;
        return singleInfiniBandPanel;
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleInfiniBandPanel.this.findParentFrame(), "Are you sure that you want to power on ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleInfiniBandPanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.enableInfinibandPower((byte)this.moduleIndex, (byte)1);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power on failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleInfiniBandPanel.this.findParentFrame(), "Are you sure that you want to power off ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleInfiniBandPanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.enableInfinibandPower((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power off failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jResetButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SingleInfiniBandPanel.this.findParentFrame(), "Are you sure that you want to reset ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SingleInfiniBandPanel.this.reset();
            }
        };
        thread.start();
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.resetInfiniband((byte)this.moduleIndex);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Reset failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jPowerOffMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jResetMenuItem_actionPerformed(ActionEvent e) {
        this.jResetButton_actionPerformed(null);
    }

    public void jPopupManagementWindowMenuItem_actionPerformed(ActionEvent e) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelInfiniBand[this.moduleIndex - 1]);
    }

    public void jFocusHereMenuItem_actionPerformed(ActionEvent e) {
        LabelInfiniBand c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelInfiniBand[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Rear");
        c.labelBladeGroup.setIndicatorUnique(true);
        c.setIndicatorVisible(true);
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }
}

