/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.Logger;
import IPMIView20.blade.JFanPanel;
import IPMIView20.blade.JSliderObserver;
import IPMIView20.blade.JTempPanel;
import IPMIView20.blade.LabelPowerSupply;
import IPMIView20.blade.SingleModuleAbstractPanel;
import IPMIView20.blade.SinglePowerSupplyPanel_jAutomaticFanRadioButtonMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jCursorHereMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanAutomaticRadioButton_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanManualRadioButton_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanSpeed1MenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanSpeed2MenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanSpeed3MenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jFanSpeed4MenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jManualFanRadioButtonMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jPopupManagementWindowMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jPowerOffMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jPowerOnMenuItem_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSlider1_changeAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSlider1_keyAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSlider1_mouseAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSlider1_mouseMotionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSpeed1Button_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSpeed2Button_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSpeed3Button_actionAdapter;
import IPMIView20.blade.SinglePowerSupplyPanel_jSpeed4Button_actionAdapter;
import IPMIView20.blade.SliderObservable;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.PowerSupplyEntity;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Observable;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class SinglePowerSupplyPanel
extends SingleModuleAbstractPanel {
    public static int FAN_FULL_SPEED_RPM = 15000;
    public static int TEMPERATURE_FULL_SCALE = 100;
    public static boolean showFan3 = false;
    public static boolean showFan4 = false;
    boolean isPowerOffFlag = false;
    ButtonGroup jFanSpeedButtomGroup = new ButtonGroup();
    ButtonGroup jFanSpeedModeRadioButtonGroup = new ButtonGroup();
    ButtonGroup jFanModeRadioMenuItemButtonGroup = new ButtonGroup();
    Icon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    Icon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    Icon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    Icon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    Icon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    Icon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    Icon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    Icon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    Icon fanSpeed1Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed1.gif"));
    Icon fanSpeed2Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed2.gif"));
    Icon fanSpeed3Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed3.gif"));
    Icon fanSpeed4Icon = new ImageIcon(this.getClass().getResource("/images/fanSpeed4.gif"));
    JFanPanel fan1Panel = new JFanPanel();
    JFanPanel fan2Panel = new JFanPanel();
    JFanPanel fan3Panel = new JFanPanel();
    JFanPanel fan4Panel = new JFanPanel();
    JTempPanel tempPanel = new JTempPanel();
    SliderObservable sliderObservable = null;
    JPanel jCenterPanel = new JPanel();
    JPanel jRightPanel = new JPanel();
    JPanel jLeftPanel = new JPanel();
    JPanel jControlPanel = new JPanel();
    JPanel jStatusPanel = new JPanel();
    JPanel jFanPanel = new JPanel();
    JPanel jTemperaturePanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder_powerSupplyFan_poweron = new TitledBorder("");
    TitledBorder titledBorder3 = new TitledBorder("");
    TitledBorder titledBorder_powerSupplyFan_poweroff = new TitledBorder("");
    JLabel jFirmwareVersionLabel = new JLabel();
    GridLayout gridLayout3 = new GridLayout();
    JLabel jFirmwareVersionStringLabel = new JLabel();
    JLabel jFRUVersionStringLabel = new JLabel();
    JLabel jFan2SpeedLabel = new JLabel();
    JLabel jFan2StatusLabel = new JLabel();
    JLabel jFan2StatusStringLabel = new JLabel();
    JLabel jFan1SpeedLabel = new JLabel();
    JLabel jFan1StatusLabel = new JLabel();
    JLabel jFan1StatusStringLabel = new JLabel();
    JLabel jLabel10 = new JLabel();
    JLabel jWattsLabel = new JLabel();
    JLabel jWattsStringLabel = new JLabel();
    JLabel jFan4SpeedLabel = new JLabel();
    JLabel jFan4StatusLabel = new JLabel();
    JLabel jFan4StatusStringLabel = new JLabel();
    JLabel jFan3SpeedLabel = new JLabel();
    JLabel jFan3StatusLabel = new JLabel();
    JLabel jFan3StatusStringLabel = new JLabel();
    JLabel jLabel19 = new JLabel();
    JLabel jPowerStatusLabel = new JLabel();
    JLabel jPowerStatusStringLabel = new JLabel();
    JLabel jFRUVersionLabel = new JLabel();
    JLabel jLabel23 = new JLabel();
    JLabel jLabel24 = new JLabel();
    JLabel jACCurrentString = new JLabel();
    JLabel jACCurrentLabel = new JLabel();
    JLabel jACCurrentTail = new JLabel();
    JLabel jDCCurrentString = new JLabel();
    JLabel jDCCurrentLabel = new JLabel();
    JLabel jDCCurrentTail = new JLabel();
    JPanel jPowerControlPanel = new JPanel();
    JPanel jFanSpeedControlPanel = new JPanel();
    TitledBorder titledBorder4 = new TitledBorder("");
    TitledBorder titledBorder5 = new TitledBorder("");
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    public JSliderObserver jSlider1 = new JSliderObserver();
    boolean initSensors = false;
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JLabel notPresent = new JLabel("Module not present");
    BladeSystemEntity bladeSystemEntity = null;
    boolean isShowCurrent = true;
    boolean userSliding = false;
    JPanel jFanControlRightPanel = new JPanel();
    JButton jSpeed1Button = new JButton();
    JButton jSpeed2Button = new JButton();
    JButton jSpeed3Button = new JButton();
    JButton jSpeed4Button = new JButton();
    JPopupMenu jPopupMenuForLabel = new JPopupMenu();
    JMenuItem jPowerOnMenuItem = new JMenuItem();
    JMenuItem jPowerOffMenuItem = new JMenuItem();
    JMenuItem jFanSpeed1MenuItem = new JMenuItem();
    JMenuItem jFanSpeed2MenuItem = new JMenuItem();
    JMenuItem jFanSpeed3MenuItem = new JMenuItem();
    JMenuItem jFanSpeed4MenuItem = new JMenuItem();
    JMenuItem jPopupManagementWindowMenuItem = new JMenuItem();
    JMenuItem jCursorHereMenuItem = new JMenuItem();
    JPanel jPanel1 = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JRadioButton jFanAutomaticRadioButton = new JRadioButton();
    JRadioButton jFanManualRadioButton = new JRadioButton();
    JToolBar jToolBar1 = new JToolBar();
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jFanSpeedToolbarPanel = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JRadioButtonMenuItem jAutomaticFanRadioButtonMenuItem = new JRadioButtonMenuItem();
    JRadioButtonMenuItem jManualFanRadioButtonMenuItem = new JRadioButtonMenuItem();

    public SinglePowerSupplyPanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void myInit() {
        this.tempPanel.tempMeter.setPreferredSize(new Dimension(135, 31));
        if (showFan3) {
            this.fan1Panel.fanMeter.setPreferredSize(new Dimension(80, 80));
            this.fan2Panel.fanMeter.setPreferredSize(new Dimension(80, 80));
            this.fan3Panel.fanMeter.setPreferredSize(new Dimension(80, 80));
            this.fan4Panel.fanMeter.setPreferredSize(new Dimension(80, 80));
        } else {
            this.fan1Panel.fanMeter.setPreferredSize(new Dimension(72, 72));
            this.fan2Panel.fanMeter.setPreferredSize(new Dimension(72, 72));
        }
        this.jFanPanel.add(this.fan1Panel);
        this.jFanPanel.add(this.fan2Panel);
        if (showFan3) {
            this.jFanPanel.add(this.fan3Panel);
        }
        if (showFan4) {
            this.jFanPanel.add(this.fan4Panel);
        }
        this.jTemperaturePanel.add(this.tempPanel);
        this.fan1Panel.init("Fan1", (byte)0, (byte)0, "", "");
        this.fan2Panel.init("Fan2", (byte)0, (byte)0, "", "");
        this.fan3Panel.init("Fan3", (byte)0, (byte)0, "", "");
        this.fan4Panel.init("Fan4", (byte)0, (byte)0, "", "");
        this.tempPanel.init("Temperature", (byte)0, (byte)0, "", "");
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(1), new JLabel("Min"));
        labelTable.put(new Integer(4), new JLabel("Max"));
        this.jSlider1.setLabelTable(labelTable);
        this.jSlider1.setPaintLabels(true);
        this.jSlider1.setSnapToTicks(true);
        this.jFanSpeedModeRadioButtonGroup.add(this.jFanAutomaticRadioButton);
        this.jFanSpeedModeRadioButtonGroup.add(this.jFanManualRadioButton);
        this.jFanModeRadioMenuItemButtonGroup.add(this.jAutomaticFanRadioButtonMenuItem);
        this.jFanModeRadioMenuItemButtonGroup.add(this.jManualFanRadioButtonMenuItem);
    }

    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jSlider1.setEnabled(false);
        this.jFanSpeedControlPanel.setVisible(false);
        this.jPowerOnMenuItem.setEnabled(false);
        this.jPowerOffMenuItem.setEnabled(false);
        this.jPopupMenuForLabel.remove(this.jAutomaticFanRadioButtonMenuItem);
        this.jPopupMenuForLabel.remove(this.jManualFanRadioButtonMenuItem);
        this.jPopupMenuForLabel.remove(this.jFanSpeed1MenuItem);
        this.jPopupMenuForLabel.remove(this.jFanSpeed2MenuItem);
        this.jPopupMenuForLabel.remove(this.jFanSpeed3MenuItem);
        this.jPopupMenuForLabel.remove(this.jFanSpeed4MenuItem);
    }

    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jSlider1.setEnabled(true);
        this.jFanSpeedControlPanel.setVisible(true);
    }

    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jSlider1.setEnabled(true);
        this.jFanSpeedControlPanel.setVisible(true);
    }

    public void setPresentUI(boolean isPresent) {
        if (isPresent) {
            if (this.getComponent(0).equals(this.jCenterPanel)) {
                return;
            }
            this.remove(this.notPresent);
            this.add((Component)this.jCenterPanel, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            if (this.getComponent(0).equals(this.notPresent)) {
                return;
            }
            this.remove(this.jCenterPanel);
            this.add((Component)this.notPresent, "Center");
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void setEnableControls(boolean isEnable) {
        this.jPowerOnButton.setEnabled(isEnable);
        this.jPowerOffButton.setEnabled(isEnable);
        this.jSlider1.setEnabled(isEnable);
        this.jSpeed1Button.setEnabled(isEnable);
        this.jSpeed2Button.setEnabled(isEnable);
        this.jSpeed3Button.setEnabled(isEnable);
        this.jSpeed4Button.setEnabled(isEnable);
    }

    private void jbInit() throws Exception {
        this.titledBorder5 = new TitledBorder("Centralized Power Fan Speed Control");
        this.titledBorder4 = new TitledBorder("Power Control");
        this.titledBorder3 = new TitledBorder("Status");
        this.titledBorder_powerSupplyFan_poweron = new TitledBorder("Power Supply Fan");
        this.titledBorder1 = new TitledBorder("Power Supply Temperature");
        this.titledBorder_powerSupplyFan_poweroff = new TitledBorder("Power Supply Fan (Fan are driven by other power supplies currently)");
        this.jCenterPanel.setLayout(this.borderLayout3);
        this.jLeftPanel.setLayout(this.borderLayout2);
        this.jRightPanel.setLayout(this.borderLayout1);
        this.jTemperaturePanel.setBorder(this.titledBorder1);
        this.jFanPanel.setBorder(this.titledBorder_powerSupplyFan_poweron);
        this.jFanPanel.setLayout(this.flowLayout1);
        this.jStatusPanel.setBorder(this.titledBorder3);
        this.jStatusPanel.setLayout(this.gridLayout3);
        this.gridLayout3.setColumns(3);
        this.gridLayout3.setRows(8);
        if (showFan3) {
            this.gridLayout3.setRows(10);
        } else {
            this.gridLayout3.setRows(8);
        }
        this.jFirmwareVersionStringLabel.setForeground(Color.blue);
        this.jFirmwareVersionStringLabel.setText("Firmware Ver:");
        this.jFRUVersionStringLabel.setForeground(Color.blue);
        this.jFRUVersionStringLabel.setText("FRU Version:");
        this.jFan2StatusStringLabel.setForeground(Color.blue);
        this.jFan2StatusStringLabel.setText("Fan 2 Status:");
        this.jFan1StatusStringLabel.setForeground(Color.blue);
        this.jFan1StatusStringLabel.setText("Fan 1 Status:");
        this.jWattsStringLabel.setForeground(Color.blue);
        this.jWattsStringLabel.setText("Watts:");
        this.jFan4StatusStringLabel.setForeground(Color.blue);
        this.jFan4StatusStringLabel.setText("Fan 4 Status:");
        this.jFan3StatusStringLabel.setForeground(Color.blue);
        this.jFan3StatusStringLabel.setText("Fan 3 Status:");
        this.jPowerStatusStringLabel.setForeground(Color.blue);
        this.jPowerStatusStringLabel.setText("Power Status:");
        this.jControlPanel.setLayout(this.borderLayout4);
        this.jPowerControlPanel.setBorder(this.titledBorder4);
        this.jFanSpeedControlPanel.setBorder(this.titledBorder5);
        this.jFanSpeedControlPanel.setLayout(this.borderLayout5);
        this.jPowerOffButton.setFont(new Font("Dialog", 1, 12));
        this.jPowerOffButton.setForeground(Color.red);
        this.jPowerOffButton.setText("Power Off");
        this.jPowerOffButton.addActionListener(new SinglePowerSupplyPanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setText("Power On");
        this.jPowerOnButton.addActionListener(new SinglePowerSupplyPanel_jPowerOnButton_actionAdapter(this));
        this.jSlider1.setMaximum(4);
        this.jSlider1.setMinimum(1);
        this.jSlider1.addMouseMotionListener(new SinglePowerSupplyPanel_jSlider1_mouseMotionAdapter(this));
        this.jSlider1.addKeyListener(new SinglePowerSupplyPanel_jSlider1_keyAdapter(this));
        this.jSlider1.addMouseListener(new SinglePowerSupplyPanel_jSlider1_mouseAdapter(this));
        this.jSlider1.addChangeListener(new SinglePowerSupplyPanel_jSlider1_changeAdapter(this));
        this.jFanControlRightPanel.setLayout(this.gridLayout2);
        this.jSpeed1Button.setIcon(this.fanSpeed1Icon);
        this.jSpeed1Button.setMargin(new Insets(0, 0, 0, 0));
        this.jSpeed1Button.setText("1");
        this.jSpeed1Button.addActionListener(new SinglePowerSupplyPanel_jSpeed1Button_actionAdapter(this));
        this.jSpeed2Button.setIcon(this.fanSpeed2Icon);
        this.jSpeed2Button.setMargin(new Insets(0, 0, 0, 0));
        this.jSpeed2Button.setText("2");
        this.jSpeed2Button.addActionListener(new SinglePowerSupplyPanel_jSpeed2Button_actionAdapter(this));
        this.jSpeed3Button.setIcon(this.fanSpeed3Icon);
        this.jSpeed3Button.setMargin(new Insets(0, 0, 0, 0));
        this.jSpeed3Button.setText("3");
        this.jSpeed3Button.addActionListener(new SinglePowerSupplyPanel_jSpeed3Button_actionAdapter(this));
        this.jSpeed4Button.setIcon(this.fanSpeed4Icon);
        this.jSpeed4Button.setMargin(new Insets(0, 0, 0, 0));
        this.jSpeed4Button.setText("4");
        this.jSpeed4Button.addActionListener(new SinglePowerSupplyPanel_jSpeed4Button_actionAdapter(this));
        this.jPowerOnMenuItem.setText("Power On");
        this.jPowerOnMenuItem.addActionListener(new SinglePowerSupplyPanel_jPowerOnMenuItem_actionAdapter(this));
        this.jPowerOffMenuItem.setText("Power Off");
        this.jPowerOffMenuItem.addActionListener(new SinglePowerSupplyPanel_jPowerOffMenuItem_actionAdapter(this));
        this.jFanSpeed1MenuItem.setText("Fan Speed 1");
        this.jFanSpeed1MenuItem.addActionListener(new SinglePowerSupplyPanel_jFanSpeed1MenuItem_actionAdapter(this));
        this.jFanSpeed2MenuItem.setText("Fan Speed 2");
        this.jFanSpeed2MenuItem.addActionListener(new SinglePowerSupplyPanel_jFanSpeed2MenuItem_actionAdapter(this));
        this.jFanSpeed3MenuItem.setText("Fan Speed 3");
        this.jFanSpeed3MenuItem.addActionListener(new SinglePowerSupplyPanel_jFanSpeed3MenuItem_actionAdapter(this));
        this.jFanSpeed4MenuItem.setText("Fan Speed 4");
        this.jFanSpeed4MenuItem.addActionListener(new SinglePowerSupplyPanel_jFanSpeed4MenuItem_actionAdapter(this));
        this.jPopupManagementWindowMenuItem.setText("Popup Management Window");
        this.jPopupManagementWindowMenuItem.addActionListener(new SinglePowerSupplyPanel_jPopupManagementWindowMenuItem_actionAdapter(this));
        this.jCursorHereMenuItem.setText("Focus Here");
        this.jCursorHereMenuItem.addActionListener(new SinglePowerSupplyPanel_jCursorHereMenuItem_actionAdapter(this));
        this.jPanel1.setLayout(this.gridLayout1);
        this.gridLayout1.setColumns(1);
        this.gridLayout1.setRows(2);
        this.jFanAutomaticRadioButton.setText("Automatic");
        this.jFanAutomaticRadioButton.addActionListener(new SinglePowerSupplyPanel_jFanAutomaticRadioButton_actionAdapter(this));
        this.jFanManualRadioButton.setText("Manual");
        this.jFanManualRadioButton.addActionListener(new SinglePowerSupplyPanel_jFanManualRadioButton_actionAdapter(this));
        this.jToolBar1.setFloatable(false);
        this.gridLayout2.setColumns(1);
        this.gridLayout2.setRows(2);
        this.jFanSpeedToolbarPanel.setLayout(this.borderLayout6);
        this.jLabel1.setForeground(Color.blue);
        this.jLabel1.setText("Speed Level:");
        this.jAutomaticFanRadioButtonMenuItem.setText("Automatic Fan Control");
        this.jAutomaticFanRadioButtonMenuItem.addActionListener(new SinglePowerSupplyPanel_jAutomaticFanRadioButtonMenuItem_actionAdapter(this));
        this.jManualFanRadioButtonMenuItem.setText("Manual Fan Control");
        this.jManualFanRadioButtonMenuItem.addActionListener(new SinglePowerSupplyPanel_jManualFanRadioButtonMenuItem_actionAdapter(this));
        this.jACCurrentString.setForeground(Color.blue);
        this.jACCurrentString.setText("AC RMS current:");
        this.jDCCurrentString.setForeground(Color.blue);
        this.jDCCurrentString.setText("DC current:");
        this.jStatusPanel.add(this.jPowerStatusStringLabel);
        this.jStatusPanel.add(this.jPowerStatusLabel);
        this.jStatusPanel.add(this.jLabel19);
        this.jStatusPanel.add(this.jFan1StatusStringLabel);
        this.jStatusPanel.add(this.jFan1StatusLabel);
        this.jStatusPanel.add(this.jFan1SpeedLabel);
        this.jStatusPanel.add(this.jFan2StatusStringLabel);
        this.jStatusPanel.add(this.jFan2StatusLabel);
        this.jStatusPanel.add(this.jFan2SpeedLabel);
        if (showFan3) {
            this.jStatusPanel.add(this.jFan3StatusStringLabel);
            this.jStatusPanel.add(this.jFan3StatusLabel);
            this.jStatusPanel.add(this.jFan3SpeedLabel);
        }
        if (showFan4) {
            this.jStatusPanel.add(this.jFan4StatusStringLabel);
            this.jStatusPanel.add(this.jFan4StatusLabel);
            this.jStatusPanel.add(this.jFan4SpeedLabel);
        }
        this.jStatusPanel.add(this.jWattsStringLabel);
        this.jStatusPanel.add(this.jWattsLabel);
        this.jStatusPanel.add(this.jLabel10);
        this.jStatusPanel.add(this.jDCCurrentString);
        this.jStatusPanel.add(this.jDCCurrentLabel);
        this.jStatusPanel.add(this.jDCCurrentTail);
        this.jStatusPanel.add(this.jACCurrentString);
        this.jStatusPanel.add(this.jACCurrentLabel);
        this.jStatusPanel.add(this.jACCurrentTail);
        this.jStatusPanel.add(this.jFirmwareVersionStringLabel);
        this.jStatusPanel.add(this.jFirmwareVersionLabel);
        this.jStatusPanel.add(this.jLabel24);
        this.jPowerControlPanel.add(this.jPowerOnButton);
        this.jPowerControlPanel.add(this.jPowerOffButton);
        this.add((Component)this.jCenterPanel, "Center");
        this.jRightPanel.add((Component)this.jPowerControlPanel, "North");
        this.jStatusPanel.add(this.jFRUVersionStringLabel);
        this.jStatusPanel.add(this.jFRUVersionLabel);
        this.jStatusPanel.add(this.jLabel23);
        this.jLeftPanel.add((Component)this.jStatusPanel, "Center");
        this.jLeftPanel.add((Component)this.jControlPanel, "South");
        this.jCenterPanel.add((Component)this.jRightPanel, "Center");
        this.jCenterPanel.add((Component)this.jLeftPanel, "West");
        this.jControlPanel.add((Component)this.jFanSpeedControlPanel, "Center");
        this.jFanControlRightPanel.add(this.jPanel2);
        this.jFanControlRightPanel.add(this.jFanSpeedToolbarPanel);
        this.jToolBar1.add(this.jSpeed1Button);
        this.jToolBar1.add(this.jSpeed2Button);
        this.jToolBar1.add(this.jSpeed3Button);
        this.jToolBar1.add(this.jSpeed4Button);
        this.jPanel1.add(this.jFanAutomaticRadioButton);
        this.jPanel1.add(this.jFanManualRadioButton);
        this.jPopupMenuForLabel.add(this.jPowerOnMenuItem);
        this.jPopupMenuForLabel.add(this.jPowerOffMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jAutomaticFanRadioButtonMenuItem);
        this.jPopupMenuForLabel.add(this.jManualFanRadioButtonMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jFanSpeed1MenuItem);
        this.jPopupMenuForLabel.add(this.jFanSpeed2MenuItem);
        this.jPopupMenuForLabel.add(this.jFanSpeed3MenuItem);
        this.jPopupMenuForLabel.add(this.jFanSpeed4MenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jPopupManagementWindowMenuItem);
        this.jPopupMenuForLabel.addSeparator();
        this.jPopupMenuForLabel.add(this.jCursorHereMenuItem);
        this.jFanSpeedControlPanel.add((Component)this.jPanel1, "West");
        this.jFanSpeedControlPanel.add((Component)this.jFanControlRightPanel, "Center");
        this.jFanSpeedToolbarPanel.add((Component)this.jToolBar1, "Center");
        this.jFanSpeedToolbarPanel.add((Component)this.jLabel1, "West");
        this.jRightPanel.add((Component)this.jFanPanel, "South");
        this.jRightPanel.add((Component)this.jTemperaturePanel, "Center");
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SinglePowerSupplyPanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SinglePowerSupplyPanel.this.helpUpdate();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdate() {
        int fan4RPMLimit;
        int fan4RPM;
        PowerSupplyEntity powerSupply = this.bladeSystemEntity.getPowerSupplies()[this.moduleIndex - 1];
        if (powerSupply.getPresent() == 0) {
            this.setPresentUI(false);
            return;
        }
        this.setPresentUI(true);
        switch (powerSupply.getStatus()) {
            case 0: {
                this.jPowerStatusLabel.setIcon(this.powerOffIcon);
                this.jPowerStatusLabel.setText("Off");
                this.helpHideUIForPowerOff(powerSupply);
                break;
            }
            case 1: {
                this.jPowerStatusLabel.setIcon(this.powerOnIcon);
                this.jPowerStatusLabel.setText("On");
                this.helpSHowUIForPowerOn();
                break;
            }
            case 2: {
                this.jPowerStatusLabel.setIcon(this.powerFailureIcon);
                this.jPowerStatusLabel.setText("Failure");
                break;
            }
            default: {
                this.jPowerStatusLabel.setIcon(this.powerOffIcon);
                this.jPowerStatusLabel.setText("Off");
                if (this.isPowerOffFlag) break;
                this.helpHideUIForPowerOff(powerSupply);
            }
        }
        if (powerSupply.getAcCurrentLimit() != 0 && powerSupply.getDcCurrentLimit() != 0) {
            if (!this.isShowCurrent) {
                this.setShowCurrent(true);
                this.isShowCurrent = true;
            }
        } else if (this.isShowCurrent) {
            this.setShowCurrent(false);
            this.isShowCurrent = false;
        }
        if (powerSupply.getAcCurrentLimit() != 0) {
            this.jACCurrentString.setVisible(true);
            this.jACCurrentLabel.setVisible(true);
            this.jACCurrentLabel.setText("" + this.d2StrA(powerSupply.getAcRMSCurrentFormula()));
        } else {
            this.jACCurrentString.setVisible(false);
            this.jACCurrentLabel.setVisible(false);
        }
        if (powerSupply.getDcCurrentLimit() != 0) {
            this.jDCCurrentString.setVisible(true);
            this.jDCCurrentLabel.setVisible(true);
            this.jDCCurrentLabel.setText("" + this.d2StrA(powerSupply.getDcOuputCurrentFormula()));
        } else {
            this.jDCCurrentString.setVisible(false);
            this.jDCCurrentLabel.setVisible(false);
        }
        this.jWattsLabel.setText("" + (int)powerSupply.getWatt());
        int fan1RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan1Speed());
        int fan1RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan1SpeedLowLimit());
        if (fan1RPM <= fan1RPMLimit) {
            this.jFan1StatusLabel.setForeground(Color.RED);
            this.jFan1StatusLabel.setIcon(this.xRedIcon);
            this.jFan1StatusLabel.setText("Abnormal");
        } else {
            this.jFan1StatusLabel.setForeground(Color.GREEN);
            this.jFan1StatusLabel.setIcon(this.okGreenIcon);
            this.jFan1StatusLabel.setText("Normal");
        }
        int fan2RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan2Speed());
        int fan2RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan2SpeedLowLimit());
        if (fan2RPM <= fan2RPMLimit) {
            this.jFan2StatusLabel.setForeground(Color.RED);
            this.jFan2StatusLabel.setIcon(this.xRedIcon);
            this.jFan2StatusLabel.setText("Abnormal");
        } else {
            this.jFan2StatusLabel.setForeground(Color.GREEN);
            this.jFan2StatusLabel.setIcon(this.okGreenIcon);
            this.jFan2StatusLabel.setText("Normal");
        }
        int fan3RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan3Speed());
        int fan3RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan3SpeedLowLimit());
        if (fan3RPM <= fan3RPMLimit) {
            // empty if block
        }
        if ((fan4RPM = (int)powerSupply.fanRPMFormula(powerSupply.getFan4Speed())) <= (fan4RPMLimit = (int)powerSupply.fanRPMFormula(powerSupply.getFan4SpeedLowLimit()))) {
            // empty if block
        }
        String v = ByteUtility.byteToHex(powerSupply.getFirmwareVersion());
        String fVersion = v.substring(0, 1) + "." + v.substring(1, 2);
        this.jFirmwareVersionLabel.setText(fVersion);
        this.jFRUVersionLabel.setText(ByteUtility.byteToHex(powerSupply.getFruVersion()));
        byte fan1Ratio = (byte)(fan1RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan1LimitRatio = (byte)(fan1RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte fan2Ratio = (byte)(fan2RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan2LimitRatio = (byte)(fan2RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte fan3Ratio = (byte)(fan3RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan3LimitRatio = (byte)(fan3RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte fan4Ratio = (byte)(fan4RPM * 256 / FAN_FULL_SPEED_RPM);
        byte fan4LimitRatio = (byte)(fan4RPMLimit * 256 / FAN_FULL_SPEED_RPM);
        byte temp = powerSupply.getTemperature();
        byte tempLimit = powerSupply.getTemperatureHighLimit();
        if (!this.initSensors) {
            this.fan1Panel.init("Fan 1", fan1Ratio, fan1LimitRatio, "" + fan1RPM, "" + fan1RPMLimit);
            this.fan2Panel.init("Fan 2", fan2Ratio, fan2LimitRatio, "" + fan2RPM, "" + fan2RPMLimit);
            if (showFan3) {
                this.fan3Panel.init("Fan 3", fan3Ratio, fan3LimitRatio, "" + fan3RPM, "" + fan3RPMLimit);
            }
            if (showFan4) {
                this.fan4Panel.init("Fan 4", fan4Ratio, fan4LimitRatio, "" + fan4RPM, "" + fan4RPMLimit);
            }
            this.tempPanel.init("Temperature", temp, tempLimit, "" + temp, "" + tempLimit);
            this.initSensors = true;
        }
        if (powerSupply.getFan1Speed() != 0 || powerSupply.getFan2Speed() != 0) {
            this.fan1Panel.updateValue(fan1Ratio, "" + fan1RPM);
            this.fan2Panel.updateValue(fan2Ratio, "" + fan2RPM);
            if (showFan3) {
                this.fan3Panel.updateValue(fan3Ratio, "" + fan3RPM);
            }
            if (showFan4) {
                this.fan4Panel.updateValue(fan4Ratio, "" + fan4RPM);
            }
            this.tempPanel.updateValue(temp, "" + temp);
        }
        int sliderFanValueAVG = 0;
        int bal = 0;
        int sliderValue = 0;
        if (fan1RPM != 0) {
            sliderFanValueAVG += fan1RPM;
            ++bal;
        }
        if (fan2RPM != 0) {
            sliderFanValueAVG += fan2RPM;
            ++bal;
        }
        if (fan3RPM != 0) {
            sliderFanValueAVG += fan3RPM;
            ++bal;
        }
        if (fan4RPM != 0) {
            sliderFanValueAVG += fan4RPM;
            ++bal;
        }
        if (bal == 0) {
            this.jSlider1.setValue(1);
            return;
        }
        if ((sliderFanValueAVG /= bal) > 7500) {
            sliderValue = 4;
        } else if (sliderFanValueAVG < 7500 && sliderFanValueAVG >= 6500) {
            sliderValue = 3;
        } else if (sliderFanValueAVG < 6500 && sliderFanValueAVG >= 5500) {
            sliderValue = 2;
        } else if (sliderFanValueAVG < 5500) {
            sliderValue = 1;
        }
        this.jSlider1.setValue(sliderValue);
        if (this.bladeSystemEntity.getFanControlMode() == 0) {
            this.jFanAutomaticRadioButton.setSelected(true);
            this.jFanManualRadioButton.setSelected(false);
            this.jSpeed1Button.setEnabled(false);
            this.jSpeed2Button.setEnabled(false);
            this.jSpeed3Button.setEnabled(false);
            this.jSpeed4Button.setEnabled(false);
            this.jAutomaticFanRadioButtonMenuItem.setSelected(true);
            this.jManualFanRadioButtonMenuItem.setSelected(false);
            this.jFanSpeed1MenuItem.setEnabled(false);
            this.jFanSpeed2MenuItem.setEnabled(false);
            this.jFanSpeed3MenuItem.setEnabled(false);
            this.jFanSpeed4MenuItem.setEnabled(false);
        } else if (this.bladeSystemEntity.getFanControlMode() == 1) {
            this.jFanAutomaticRadioButton.setSelected(false);
            this.jFanManualRadioButton.setSelected(true);
            this.jSpeed1Button.setEnabled(true);
            this.jSpeed2Button.setEnabled(true);
            this.jSpeed3Button.setEnabled(true);
            this.jSpeed4Button.setEnabled(true);
            this.jAutomaticFanRadioButtonMenuItem.setSelected(false);
            this.jManualFanRadioButtonMenuItem.setSelected(true);
            this.jFanSpeed1MenuItem.setEnabled(true);
            this.jFanSpeed2MenuItem.setEnabled(true);
            this.jFanSpeed3MenuItem.setEnabled(true);
            this.jFanSpeed4MenuItem.setEnabled(true);
        }
    }

    public void setShowCurrent(boolean isShow) {
        if (isShow) {
            this.gridLayout3.setColumns(3);
            this.gridLayout3.setRows(8);
            this.jStatusPanel.add((Component)this.jDCCurrentString, 12);
            this.jStatusPanel.add((Component)this.jDCCurrentLabel, 13);
            this.jStatusPanel.add((Component)this.jDCCurrentTail, 14);
            this.jStatusPanel.add((Component)this.jACCurrentString, 15);
            this.jStatusPanel.add((Component)this.jACCurrentLabel, 16);
            this.jStatusPanel.add((Component)this.jACCurrentTail, 17);
        } else {
            this.jStatusPanel.remove(this.jDCCurrentString);
            this.jStatusPanel.remove(this.jDCCurrentLabel);
            this.jStatusPanel.remove(this.jDCCurrentTail);
            this.jStatusPanel.remove(this.jACCurrentString);
            this.jStatusPanel.remove(this.jACCurrentLabel);
            this.jStatusPanel.remove(this.jACCurrentTail);
            this.gridLayout3.setColumns(3);
            this.gridLayout3.setRows(6);
        }
    }

    public String d2StrA(double value) {
        int temp = (int)(value * 100.0);
        double d = (double)temp / 100.0;
        return "" + d + " A";
    }

    public void helpHideUIForPowerOff(PowerSupplyEntity powerSupply) {
        this.jFan1StatusLabel.setVisible(false);
        this.jFan2StatusLabel.setVisible(false);
        this.jWattsLabel.setVisible(false);
        this.jFirmwareVersionLabel.setVisible(false);
        this.jFRUVersionLabel.setVisible(false);
        this.jACCurrentLabel.setVisible(false);
        this.jDCCurrentLabel.setVisible(false);
        this.jSlider1.setEnabled(false);
        this.tempPanel.setNA();
        if (powerSupply.getFan1Speed() != 0 || powerSupply.getFan2Speed() != 0) {
            this.jFanPanel.setBorder(this.titledBorder_powerSupplyFan_poweroff);
        } else {
            this.fan1Panel.setNA();
            this.fan2Panel.setNA();
        }
        this.isPowerOffFlag = true;
    }

    public void helpSHowUIForPowerOn() {
        this.jFan1StatusLabel.setVisible(true);
        this.jFan2StatusLabel.setVisible(true);
        this.jWattsLabel.setVisible(true);
        this.jFirmwareVersionLabel.setVisible(true);
        this.jFRUVersionLabel.setVisible(true);
        this.jACCurrentLabel.setVisible(true);
        this.jDCCurrentLabel.setVisible(true);
        this.jSlider1.setEnabled(true);
        this.jFanPanel.setBorder(this.titledBorder_powerSupplyFan_poweron);
        this.isPowerOffFlag = false;
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SinglePowerSupplyPanel.this.findParentFrame(), "Are you sure that you want to power on ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SinglePowerSupplyPanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.enablePowerSupply((byte)this.moduleIndex, (byte)1);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power on failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SinglePowerSupplyPanel.this.findParentFrame(), "Are you sure that you want to power off ?", "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SinglePowerSupplyPanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                b = ipmiCMMOEMCommand.enablePowerSupply((byte)this.moduleIndex, (byte)0);
                if (!b) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power off failed");
                }
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    private void fanSpeed(byte speed) throws HeadlessException, HeadlessException {
        BladeSystemEntity bladeSystemEntity = this.cmmSessionPanel.bladeSystemEntity;
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                ipmiCMMOEMCommand.setAllPowerSupplyFanSpeed(speed);
                sessionController.closeSession();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jSlider1_mouseReleased(MouseEvent e) {
        this.userSliding = true;
    }

    public void jSlider1_keyReleased(KeyEvent e) {
        this.userSliding = true;
    }

    public void jSlider1_mouseDragged(MouseEvent e) {
        this.userSliding = true;
    }

    public void jSlider1_stateChanged(ChangeEvent e) {
    }

    public void setSliderObservable(SliderObservable sliderObservable) {
        this.sliderObservable = sliderObservable;
    }

    public SliderObservable getSliderObservable() {
        return this.sliderObservable;
    }

    public JPopupMenu getJPopupMenuForLabel() {
        return this.jPopupMenuForLabel;
    }

    public void jSpeed1Button_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.fanSpeed((byte)0);
            }
        };
        thread.start();
    }

    public void jSpeed2Button_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.fanSpeed((byte)1);
            }
        };
        thread.start();
    }

    public void jSpeed3Button_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.fanSpeed((byte)2);
            }
        };
        thread.start();
    }

    public void jSpeed4Button_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.fanSpeed((byte)3);
            }
        };
        thread.start();
    }

    public void jPowerOnMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOnButton_actionPerformed(null);
    }

    public void jPowerOffMenuItem_actionPerformed(ActionEvent e) {
        this.jPowerOffButton_actionPerformed(null);
    }

    public void jFanSpeed1MenuItem_actionPerformed(ActionEvent e) {
        this.jSpeed1Button_actionPerformed(null);
    }

    public void jFanSpeed2MenuItem_actionPerformed(ActionEvent e) {
        this.jSpeed2Button_actionPerformed(null);
    }

    public void jFanSpeed3MenuItem_actionPerformed(ActionEvent e) {
        this.jSpeed3Button_actionPerformed(null);
    }

    public void jFanSpeed4MenuItem_actionPerformed(ActionEvent e) {
        this.jSpeed4Button_actionPerformed(null);
    }

    public void jPopupManagementWindowMenuItem_actionPerformed(ActionEvent e) {
        this.cmmSessionPanel.cmmBladeSystemPanel.helpTakeSinglePanelOut(this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelPowerSupply[this.moduleIndex - 1]);
    }

    public void jCursorHereMenuItem_actionPerformed(ActionEvent e) {
        LabelPowerSupply c = this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.bladeSystemRear.labelPowerSupply[this.moduleIndex - 1];
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleNameLabel.setText(c.getModuleName() + " " + c.getNumber());
        this.cmmSessionPanel.cmmBladeSystemPanel.labelBladeSystem.jSelectedModuleSideLabel.setText("Side: Rear");
        c.labelBladeGroup.setIndicatorUnique(true);
        c.setIndicatorVisible(true);
        String label = c.getModuleName() + " " + c.getNumber();
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setIcon(this.cmmSessionPanel.cmmBladeSystemPanel.bookmarkIcon);
        this.cmmSessionPanel.cmmBladeSystemPanel.jSelectedModuleLabel.setText("[ " + label + " ]");
        this.cmmSessionPanel.cmmBladeSystemPanel.cardLayout.show(this.cmmSessionPanel.cmmBladeSystemPanel.jSinglePanel, c.getModuleName() + c.getNumber());
    }

    public void jFanAutomaticRadioButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.enableAutoFanControl(true);
            }
        };
        thread.start();
        this.jFanAutomaticRadioButton.setSelected(true);
        this.jSpeed1Button.setEnabled(false);
        this.jSpeed2Button.setEnabled(false);
        this.jSpeed3Button.setEnabled(false);
        this.jSpeed4Button.setEnabled(false);
        this.jFanSpeed1MenuItem.setEnabled(false);
        this.jFanSpeed2MenuItem.setEnabled(false);
        this.jFanSpeed3MenuItem.setEnabled(false);
        this.jFanSpeed4MenuItem.setEnabled(false);
    }

    public void jFanManualRadioButton_actionPerformed(ActionEvent e) {
        Thread thread = new Thread(){

            public void run() {
                SinglePowerSupplyPanel.this.enableAutoFanControl(false);
            }
        };
        thread.start();
        this.jFanManualRadioButton.setSelected(true);
        this.jSpeed1Button.setEnabled(true);
        this.jSpeed2Button.setEnabled(true);
        this.jSpeed3Button.setEnabled(true);
        this.jSpeed4Button.setEnabled(true);
        this.jFanSpeed1MenuItem.setEnabled(true);
        this.jFanSpeed2MenuItem.setEnabled(true);
        this.jFanSpeed3MenuItem.setEnabled(true);
        this.jFanSpeed4MenuItem.setEnabled(true);
    }

    public boolean enableAutoFanControl(boolean isEnable) {
        BladeSystemEntity bladeSystemEntity = this.cmmSessionPanel.bladeSystemEntity;
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController == null) {
            return false;
        }
        boolean b = false;
        try {
            b = isEnable ? ipmiCMMOEMCommand.setFanControlMode((byte)0) : ipmiCMMOEMCommand.setFanControlMode((byte)1);
        }
        catch (IPMIException ex) {
            JOptionPane.showMessageDialog(this.findParentFrame(), "Set fan control mode failed");
        }
        sessionController.closeSession();
        return b;
    }

    public void jAutomaticFanRadioButtonMenuItem_actionPerformed(ActionEvent e) {
        this.jFanAutomaticRadioButton_actionPerformed(null);
    }

    public void jManualFanRadioButtonMenuItem_actionPerformed(ActionEvent e) {
        this.jFanManualRadioButton_actionPerformed(null);
    }
}

