/*
 * Decompiled with CFR 0.152.
 */
package IPMIView20.blade;

import IPMIView20.CMMDebug;
import IPMIView20.L;
import IPMIView20.Logger;
import IPMIView20.blade.SummaryAbstractPanel;
import IPMIView20.blade.SummaryBladePanel_jGracefulPowerDownButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jKVMButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jPowerOffButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jPowerOnButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jResetButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jUIDOffButton_actionAdapter;
import IPMIView20.blade.SummaryBladePanel_jUIDOnButton_actionAdapter;
import IPMIView20.blade.SummaryBladeSelectionListener;
import IPMIView20.group.TableSorter;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Observable;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public class SummaryBladePanel
extends SummaryAbstractPanel {
    TableSorter ts;
    DefaultTableModel dtm;
    ImageIcon powerOnIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_on.gif"));
    ImageIcon powerOffIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_off.gif"));
    ImageIcon powerFailureIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_failure.gif"));
    ImageIcon uidLEDOnIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOn.gif"));
    ImageIcon uidLEDOffIcon = new ImageIcon(this.getClass().getResource("/images/uidLEDOff.gif"));
    ImageIcon saveIcon = new ImageIcon(this.getClass().getResource("/images/toolbar_save.gif"));
    ImageIcon okBlueIcon = new ImageIcon(this.getClass().getResource("/images/ok_blue.gif"));
    ImageIcon okGreenIcon = new ImageIcon(this.getClass().getResource("/images/ok_green.gif"));
    ImageIcon xRedIcon = new ImageIcon(this.getClass().getResource("/images/x_red.gif"));
    ImageIcon powerResetIcon = new ImageIcon(this.getClass().getResource("/images/blade_kvm_power_reset.gif"));
    ImageIcon emptyIcon = new ImageIcon(this.getClass().getResource("/images/empty.gif"));
    JTable jTable = null;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jCenterPanel = new JPanel();
    TitledBorder titledBorder1 = new TitledBorder("");
    TitledBorder titledBorder2 = new TitledBorder("");
    JScrollPane jScrollPane = new JScrollPane();
    BorderLayout borderLayout2 = new BorderLayout();
    JToolBar jToolBar1 = new JToolBar();
    JButton jResetButton = new JButton();
    JButton jPowerOffButton = new JButton();
    JButton jPowerOnButton = new JButton();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JButton jUIDOnButton = new JButton();
    JButton jUIDOffButton = new JButton();
    JButton jKVMButton = new JButton();
    JButton jGracefulPowerDownButton = new JButton();
    BladeSystemEntity bladeSystemEntity = null;

    public SummaryBladePanel() {
        try {
            this.jbInit();
            this.myInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void myInit() {
        this.emptyIcon.setDescription("empty");
        this.showHeader();
        this.jTable.setSelectionMode(2);
        this.jTable.getSelectionModel().addListSelectionListener(new SummaryBladeSelectionListener(this));
        this.jTable.setRowHeight(18);
    }

    public void setUserPrivilege() {
        this.jPowerOnButton.setEnabled(false);
        this.jGracefulPowerDownButton.setEnabled(false);
        this.jPowerOffButton.setEnabled(false);
        this.jResetButton.setEnabled(false);
        this.jUIDOnButton.setEnabled(false);
        this.jUIDOffButton.setEnabled(false);
    }

    public void setOperatorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jUIDOnButton.setEnabled(true);
        this.jUIDOffButton.setEnabled(true);
    }

    public void setAdministratorPrivilege() {
        this.jPowerOnButton.setEnabled(true);
        this.jGracefulPowerDownButton.setEnabled(true);
        this.jPowerOffButton.setEnabled(true);
        this.jResetButton.setEnabled(true);
        this.jUIDOnButton.setEnabled(true);
        this.jUIDOffButton.setEnabled(true);
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("Blade Summary");
        this.titledBorder2 = new TitledBorder("Cmmand for Selected Blades");
        this.setLayout(this.borderLayout1);
        this.jCenterPanel.setBorder(null);
        this.jCenterPanel.setLayout(this.borderLayout2);
        this.setBorder(this.titledBorder1);
        this.jResetButton.setIcon(this.powerResetIcon);
        this.jResetButton.setText("Reset");
        this.jResetButton.addActionListener(new SummaryBladePanel_jResetButton_actionAdapter(this));
        this.jPowerOffButton.setIcon(this.powerOffIcon);
        this.jPowerOffButton.setText("Power Down");
        this.jPowerOffButton.addActionListener(new SummaryBladePanel_jPowerOffButton_actionAdapter(this));
        this.jPowerOnButton.setIcon(this.powerOnIcon);
        this.jPowerOnButton.setText("Power On");
        this.jPowerOnButton.addActionListener(new SummaryBladePanel_jPowerOnButton_actionAdapter(this));
        this.jToolBar1.setBorderPainted(false);
        this.jToolBar1.setFloatable(false);
        this.jPanel1.setLayout(this.borderLayout3);
        this.jUIDOnButton.setIcon(this.uidLEDOnIcon);
        this.jUIDOnButton.setText("UID On");
        this.jUIDOnButton.addActionListener(new SummaryBladePanel_jUIDOnButton_actionAdapter(this));
        this.jUIDOffButton.setIcon(this.uidLEDOffIcon);
        this.jUIDOffButton.setText("UID Off");
        this.jUIDOffButton.addActionListener(new SummaryBladePanel_jUIDOffButton_actionAdapter(this));
        this.jKVMButton.setIcon(this.okBlueIcon);
        this.jKVMButton.setText("KVM");
        this.jKVMButton.addActionListener(new SummaryBladePanel_jKVMButton_actionAdapter(this));
        this.jGracefulPowerDownButton.setIcon(this.powerOffIcon);
        this.jGracefulPowerDownButton.setText("Graceful Shutdown");
        this.jGracefulPowerDownButton.addActionListener(new SummaryBladePanel_jGracefulPowerDownButton_actionAdapter(this));
        this.add((Component)this.jCenterPanel, "Center");
        this.jCenterPanel.add((Component)this.jScrollPane, "Center");
        this.jCenterPanel.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add(this.jKVMButton);
        this.jToolBar1.add(this.jPowerOnButton);
        this.jToolBar1.add(this.jGracefulPowerDownButton);
        this.jToolBar1.add(this.jPowerOffButton);
        this.jToolBar1.add(this.jResetButton);
        this.jToolBar1.add(this.jUIDOnButton);
        this.jToolBar1.add(this.jUIDOffButton);
        this.add((Component)this.jPanel1, "South");
        this.jScrollPane.setPreferredSize(new Dimension(530, 240));
    }

    public ArrayList getHeader() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add(L.t("Blade Index") + "  ");
        headerList.add(L.t("Power Status") + "  ");
        headerList.add(L.t("KVM Selected"));
        headerList.add(L.t("UID") + "  ");
        headerList.add(L.t("System Fault") + "  ");
        headerList.add(L.t("BMC") + "  ");
        return headerList;
    }

    public void showHeader() {
        ArrayList headerList = this.getHeader();
        this.dtm = new DefaultTableModel(headerList.toArray(), 0);
        this.ts = new TableSorter(this.dtm);
        this.jTable = new JTable(){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }
        };
        this.jTable.setModel(this.ts);
        this.jScrollPane.getViewport().add(this.jTable);
    }

    public void update(Observable o, Object obj) {
        if (CMMDebug.notifyDebug) {
            Logger.printLog("[SummaryBladePanel] [Notify]");
        }
        this.bladeSystemEntity = (BladeSystemEntity)o;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SummaryBladePanel.this.helpUpdateTable();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    private void helpUpdateTable() {
        int i;
        int[] rowSelectIndex = this.jTable.getSelectedRows();
        int rowCount = this.dtm.getRowCount();
        for (i = 0; i < rowCount; ++i) {
            this.dtm.removeRow(0);
        }
        for (i = 0; i < this.bladeSystemEntity.getBlades().length; ++i) {
            BladeEntity blade = this.bladeSystemEntity.getBlades()[i];
            ArrayList<Object> raw = new ArrayList<Object>();
            raw.add("" + (i + 1));
            if (blade.getPresent() == 0) {
                raw.add(this.emptyIcon);
                raw.add(this.emptyIcon);
                raw.add(this.emptyIcon);
                raw.add(this.emptyIcon);
                raw.add(this.emptyIcon);
                ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
                continue;
            }
            boolean powerSupply = true;
            if (blade.isV12vEnable() && blade.isV3_3v() && powerSupply) {
                raw.add(this.powerOnIcon);
            } else if (!blade.isV12vEnable() && !blade.isV3_3v()) {
                raw.add(this.powerOffIcon);
            } else if (blade.isV12vEnable() && !blade.isV3_3v() && powerSupply) {
                raw.add(this.powerOffIcon);
            } else if (!powerSupply) {
                raw.add(this.powerOffIcon);
            }
            if (blade.getKvmEnable() > 0) {
                raw.add(this.okBlueIcon);
            } else {
                raw.add(this.emptyIcon);
            }
            if (blade.getUidEnable() > 0) {
                raw.add(this.uidLEDOnIcon);
            } else {
                raw.add(this.emptyIcon);
            }
            if (blade.isError1LED()) {
                raw.add(this.xRedIcon);
            } else {
                raw.add(this.emptyIcon);
            }
            if (blade.isSimCardDetectPin()) {
                raw.add(this.okGreenIcon);
            } else {
                raw.add(this.emptyIcon);
            }
            ((DefaultTableModel)this.ts.getTableModel()).addRow(raw.toArray());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SummaryBladePanel.this.jTable.setModel(SummaryBladePanel.this.ts);
            }
        });
        if (rowSelectIndex.length >= 0 && this.jTable.getRowCount() > 0) {
            for (i = 0; i < rowSelectIndex.length; ++i) {
                this.jTable.addRowSelectionInterval(rowSelectIndex[i], rowSelectIndex[i]);
            }
        }
        if (rowSelectIndex.length == 0) {
            this.jKVMButton.setEnabled(false);
            this.jGracefulPowerDownButton.setEnabled(false);
            this.jPowerOffButton.setEnabled(false);
            this.jPowerOnButton.setEnabled(false);
            this.jResetButton.setEnabled(false);
            this.jUIDOffButton.setEnabled(false);
            this.jUIDOnButton.setEnabled(false);
        } else if (this.cmmSessionPanel.ipmiInterfaceConfig.getPrivilege() != 2) {
            this.jPowerOffButton.setEnabled(true);
            this.jGracefulPowerDownButton.setEnabled(true);
            this.jPowerOnButton.setEnabled(true);
            this.jResetButton.setEnabled(true);
            this.jUIDOffButton.setEnabled(true);
            this.jUIDOnButton.setEnabled(true);
        }
    }

    public void jtableValueChanged() {
        int[] selectedRow = this.jTable.getSelectedRows();
        if (selectedRow.length > 1) {
            this.jKVMButton.setEnabled(false);
        } else {
            this.jKVMButton.setEnabled(true);
        }
        if (selectedRow.length > 0 && this.cmmSessionPanel.ipmiInterfaceConfig.getPrivilege() != 2) {
            this.jGracefulPowerDownButton.setEnabled(true);
            this.jPowerOffButton.setEnabled(true);
            this.jPowerOnButton.setEnabled(true);
            this.jResetButton.setEnabled(true);
            this.jUIDOffButton.setEnabled(true);
            this.jUIDOnButton.setEnabled(true);
        }
    }

    public boolean isSelectedOnPresnetedBlade() {
        int[] selectedRows = this.jTable.getSelectedRows();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < selectedRows.length; ++i) {
            ImageIcon icon = (ImageIcon)this.jTable.getModel().getValueAt(selectedRows[i], 1);
            if (icon.getDescription().equals("empty")) continue;
            return true;
        }
        return false;
    }

    public String selectedBlade() {
        int[] selectedRows = this.jTable.getSelectedRows();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < selectedRows.length; ++i) {
            ImageIcon icon = (ImageIcon)this.jTable.getModel().getValueAt(selectedRows[i], 1);
            if (icon.getDescription().equals("empty")) continue;
            sb.append("\nBlade " + (selectedRows[i] + 1));
        }
        return sb.toString();
    }

    public byte[] getFormatedSelectedBlade() {
        byte[] selectedBlade = new byte[2];
        int[] selectedRows = this.jTable.getSelectedRows();
        StringBuffer sb = new StringBuffer();
        int temp = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            ImageIcon icon = (ImageIcon)this.jTable.getModel().getValueAt(selectedRows[i], 1);
            if (icon.getDescription().equals("empty")) continue;
            temp |= 1 << selectedRows[i];
        }
        selectedBlade[0] = (byte)temp;
        selectedBlade[1] = (byte)(temp >> 8);
        return selectedBlade;
    }

    public boolean isPresent(int index) {
        ImageIcon icon = (ImageIcon)this.jTable.getModel().getValueAt(index, 1);
        return !icon.getDescription().equals("empty");
    }

    public void jKVMButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                SummaryBladePanel.this.requestKVM();
            }
        };
        thread.start();
    }

    private void requestKVM() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                int selectedRow = this.jTable.getSelectedRow();
                if (this.isPresent(selectedRow) && !(b = ipmiCMMOEMCommand.requestKVM((byte)(selectedRow + 1)))) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Request KVM failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOnButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SummaryBladePanel.this.findParentFrame(), "Are you sure that you want to power on following blade(s) ? " + SummaryBladePanel.this.selectedBlade(), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SummaryBladePanel.this.powerOn();
            }
        };
        thread.start();
    }

    private void powerOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                byte[] bladeBits = this.getFormatedSelectedBlade();
                boolean isEnoughPower = ipmiCMMOEMCommand.checkIfEnoughPowerForBlades(bladeBits);
                if (!isEnoughPower) {
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Not enough power to turn the blades", "error", 0);
                    return;
                }
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.enableP12V((byte)(selectedRows[i] + 1), (byte)1)) == 0) continue;
                    if (b == 1) {
                        JOptionPane.showMessageDialog(this.findParentFrame(), "Not enough Power on blade " + (selectedRows[i] + 1));
                        continue;
                    }
                    if (b != 99) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power on failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jPowerOffButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SummaryBladePanel.this.findParentFrame(), "Are you sure that you want to power down following blade(s) ? " + SummaryBladePanel.this.selectedBlade(), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SummaryBladePanel.this.powerOff();
            }
        };
        thread.start();
    }

    private void powerOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            int b = 99;
            try {
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.enableP12V((byte)(selectedRows[i] + 1), (byte)0)) == 0 || b != 99) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Power down failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jResetButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SummaryBladePanel.this.findParentFrame(), "Are you sure that you want to reset following blade(s) ? " + SummaryBladePanel.this.selectedBlade(), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SummaryBladePanel.this.reset();
            }
        };
        thread.start();
    }

    private void reset() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.resetBlade((byte)(selectedRows[i] + 1)))) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Reset balde " + (i + 1) + " failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jUIDOnButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                SummaryBladePanel.this.uidOn();
            }
        };
        thread.start();
    }

    private void uidOn() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.setBladeUID((byte)(selectedRows[i] + 1), (byte)1))) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Set UID on balde " + (i + 1) + " failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jUIDOffButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                SummaryBladePanel.this.uidOff();
            }
        };
        thread.start();
    }

    private void uidOff() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.setBladeUID((byte)(selectedRows[i] + 1), (byte)0))) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Reset UID on balde " + (i + 1) + " failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }

    public void jGracefulPowerDownButton_actionPerformed(ActionEvent e) {
        if (!this.isSelectedOnPresnetedBlade()) {
            return;
        }
        Thread thread = new Thread(){

            public void run() {
                int result = JOptionPane.showConfirmDialog(SummaryBladePanel.this.findParentFrame(), "Are you sure that you want to graceful shutdown following blade(s) ? " + SummaryBladePanel.this.selectedBlade(), "Confirmation", 0);
                if (result == 1) {
                    return;
                }
                SummaryBladePanel.this.gracefulshutdown();
            }
        };
        thread.start();
    }

    private void gracefulshutdown() throws HeadlessException, HeadlessException {
        IPMICMMOEMCommand ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.cmmSessionPanel.ipmiInterfaceConfig, ipmiCMMOEMCommand);
        if (sessionController != null) {
            boolean b = false;
            try {
                int[] selectedRows = this.jTable.getSelectedRows();
                for (int i = 0; i < selectedRows.length; ++i) {
                    if (!this.isPresent(selectedRows[i]) || (b = ipmiCMMOEMCommand.gracefulPowerDownBlade((byte)(selectedRows[i] + 1))) || b) continue;
                    JOptionPane.showMessageDialog(this.findParentFrame(), "Graceful shutdown failed");
                }
                sessionController.closeSession();
                this.cmmSessionPanel.bladeSystemEntity.getData();
            }
            catch (IPMIException ex) {
                JOptionPane.showMessageDialog(this.findParentFrame(), ex.toString());
            }
        }
    }
}

